/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import visad.CommonUnit;
import visad.Real;
import visad.RealType;
import visad.Unit;

public class NavigatedDisplayCursorReadout
extends JPanel {
    private NavigatedDisplay navDisplay;
    private Real latitude;
    private Real longitude;
    private Real altitude;
    private PropertyChangeListener latitudeChangeListener;
    private PropertyChangeListener longitudeChangeListener;
    private PropertyChangeListener altitudeChangeListener;
    private JLabel valueDisplay;
    private boolean myOwnLabel = true;
    private boolean active = true;
    private DecimalFormat formatter = new DecimalFormat("##0.0");
    private String formatPattern = "##0.0";

    protected NavigatedDisplayCursorReadout() {
    }

    public NavigatedDisplayCursorReadout(NavigatedDisplay navDisplay) {
        this(navDisplay, new JLabel());
        this.myOwnLabel = true;
        this.add(this.valueDisplay);
    }

    public NavigatedDisplayCursorReadout(NavigatedDisplay navDisplay, JLabel label) {
        this.navDisplay = navDisplay;
        this.setLayout(new FlowLayout(0));
        if (label != null) {
            this.myOwnLabel = true;
            Font lblFont = label.getFont();
            Font monoFont = new Font("Monospaced", lblFont.getStyle(), lblFont.getSize());
            label.setFont(monoFont);
        } else {
            this.myOwnLabel = false;
        }
        this.valueDisplay = label;
        this.latitudeChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Real lat = (Real)event.getNewValue();
                try {
                    double latVal = lat.getValue(CommonUnit.degree);
                    if (latVal > 90.0 || latVal < -90.0) {
                        latVal = Math.min(Math.max(latVal, -90.0), 90.0);
                        lat = new Real(RealType.Latitude, latVal);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                NavigatedDisplayCursorReadout.this.latitude = lat;
                NavigatedDisplayCursorReadout.this.setLabelText();
            }
        };
        this.longitudeChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Real lon = (Real)event.getNewValue();
                try {
                    lon = new Real(RealType.Longitude, Misc.normalizeLongitude(lon.getValue(CommonUnit.degree)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                NavigatedDisplayCursorReadout.this.longitude = lon;
                NavigatedDisplayCursorReadout.this.setLabelText();
            }
        };
        this.altitudeChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Real alt = (Real)event.getNewValue();
                try {
                    Unit u = NavigatedDisplayCursorReadout.this.navDisplay.getVerticalRangeUnit();
                    alt = new Real(RealType.Altitude, alt.getValue(u), u);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                NavigatedDisplayCursorReadout.this.altitude = alt;
                NavigatedDisplayCursorReadout.this.setLabelText();
            }
        };
        this.setNavigatedDisplay(navDisplay);
    }

    public void destroy() {
        this.removeListeners();
        this.latitudeChangeListener = null;
        this.longitudeChangeListener = null;
        this.altitudeChangeListener = null;
    }

    private void removeListeners() {
        if (this.navDisplay != null) {
            this.navDisplay.removePropertyChangeListener(this.latitudeChangeListener);
            this.navDisplay.removePropertyChangeListener(this.longitudeChangeListener);
            this.navDisplay.removePropertyChangeListener(this.altitudeChangeListener);
        }
    }

    public void setNavigatedDisplay(NavigatedDisplay navDisplay) {
        NavigatedDisplay oldNavDisplay = this.navDisplay;
        this.removeListeners();
        this.navDisplay = navDisplay;
        this.navDisplay.addPropertyChangeListener("cursorLatitude", this.latitudeChangeListener);
        this.navDisplay.addPropertyChangeListener("cursorLongitude", this.longitudeChangeListener);
        this.navDisplay.addPropertyChangeListener("cursorAltitude", this.altitudeChangeListener);
    }

    public void setValueDisplay(JLabel label) {
        this.valueDisplay = label;
    }

    protected JLabel getValueDisplay() {
        return this.valueDisplay;
    }

    public void setActive(boolean value) {
        this.active = value;
        JLabel label = this.getValueDisplay();
        if (!this.active && label != null) {
            label.setText(" ");
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public void setFormatPattern(String pattern) {
        this.formatter.applyPattern(pattern);
        this.formatPattern = pattern;
        this.setLabelText();
    }

    private String pad(String s) {
        s = StringUtil.padRight(s, 7);
        return s;
    }

    private String format(double v) {
        if (v != v) {
            return this.pad("NA");
        }
        String s = this.formatter.format(v);
        if (v >= 0.0) {
            s = " " + s;
        }
        return this.pad(s);
    }

    private void setLabelText() {
        if (!this.active) {
            return;
        }
        String SPACE = " ";
        StringBuffer buf = new StringBuffer();
        buf.append("Latitude: ");
        if (this.latitude != null) {
            try {
                buf.append(this.format(this.latitude.getValue(CommonUnit.degree)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        buf.append(SPACE);
        buf.append("Longitude: ");
        if (this.longitude != null) {
            try {
                buf.append(this.format(this.longitude.getValue(CommonUnit.degree)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.navDisplay.getDisplayMode() == 0) {
            buf.append(SPACE);
            buf.append("Altitude: ");
            if (this.altitude != null) {
                if (Double.isNaN(this.altitude.getValue())) {
                    buf.append(this.pad("NA"));
                } else {
                    try {
                        String altText = this.formatter.format(this.altitude.getValue()) + " " + this.altitude.getUnit().toString();
                        buf.append(this.pad(altText));
                    }
                    catch (Exception altText) {
                        // empty catch block
                    }
                }
            }
        }
        String text = buf.toString();
        JLabel label = this.getValueDisplay();
        if (label != null) {
            label.setText(text);
            if (this.myOwnLabel) {
                FontMetrics fm = label.getFontMetrics(label.getFont());
                label.setPreferredSize(new Dimension(fm.stringWidth(text), fm.getHeight()));
            }
        }
    }
}

