/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplayToolBar;
import ucar.visad.ProjectionCoordinateSystem;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.RubberBandBox;
import ucar.visad.display.ScalarMapSet;
import ucar.visad.quantities.GeopotentialAltitude;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.DisplayRealType;
import visad.DisplayRenderer;
import visad.MouseBehavior;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.ScalarMap;
import visad.Unit;
import visad.VisADException;
import visad.VisADRay;
import visad.georef.EarthLocation;
import visad.georef.MapProjection;
import visad.java2d.DisplayRendererJ2D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;

public abstract class NavigatedDisplay
extends DisplayMaster {
    public static final int BOTTOM_VIEW = 0;
    public static String BOTTOM_VIEW_NAME = "Bottom";
    public static double CLIP_BACK_DEFAULT = 1000.0;
    public static double CLIP_BACK_PERSPECTIVE = 10.0;
    public static double CLIP_FRONT_DEFAULT = -1000.0;
    public static double CLIP_FRONT_PERSPECTIVE = 0.1;
    public static final String CURSOR_ALTITUDE = "cursorAltitude";
    public static final String CURSOR_LATITUDE = "cursorLatitude";
    public static final String CURSOR_LONGITUDE = "cursorLongitude";
    public static final int EAST_VIEW = 2;
    public static String EAST_VIEW_NAME = "East";
    public static final int MODE_2D = 1;
    public static final int MODE_2Din3D = 2;
    public static final int MODE_3D = 0;
    public static final int NORTH_VIEW = 1;
    public static String NORTH_VIEW_NAME = "North";
    public static final int SOUTH_VIEW = 4;
    public static String SOUTH_VIEW_NAME = "South";
    public static final int TOP_VIEW = 3;
    public static String TOP_VIEW_NAME = "Top";
    public static final int WEST_VIEW = 5;
    public static String WEST_VIEW_NAME = "West";
    int animationTimeStamp = 0;
    private double clipDistanceBack = CLIP_BACK_DEFAULT;
    private double clipDistanceFront = CLIP_FRONT_DEFAULT;
    private boolean autoRotate = false;
    private long rotateDelay = 50L;
    private int rotateTimeStamp = 0;
    private double rotateXMultiplier = 0.0;
    private double rotateYMultiplier = -1.0;
    private double rotateZMultiplier = 0.0;
    private boolean isPerspective = true;
    private boolean animationVisible = true;
    private RubberBandBox rubberBandBox = null;
    private boolean isAnimating = false;
    private boolean clipping = false;
    private boolean verticalRangeVisible = true;
    private boolean box;
    private volatile Real cursorAltitude;
    private volatile Real cursorLatitude;
    private volatile Real cursorLongitude;
    private int myMode;
    private NavigatedDisplayToolBar navToolBar;

    protected NavigatedDisplay() {
    }

    protected NavigatedDisplay(DisplayImpl display) throws VisADException, RemoteException {
        this.init(display);
    }

    protected void init(DisplayImpl display) throws VisADException, RemoteException {
        super.init(display, 1);
        DisplayRenderer displayRenderer = display.getDisplayRenderer();
        this.myMode = displayRenderer instanceof DisplayRendererJ2D ? 1 : (displayRenderer instanceof TwoDDisplayRendererJ3D ? 2 : 0);
        displayRenderer.setCursorStringOn(false);
    }

    protected void initializeClass() throws VisADException, RemoteException {
        DisplayImpl display = (DisplayImpl)this.getDisplay();
        display.enableEvent(16);
        display.enableEvent(17);
        display.enableEvent(21);
        display.enableEvent(18);
        display.enableEvent(1);
        display.enableEvent(22);
        display.enableEvent(23);
        this.addDisplayListener(new DisplayListener(){

            @Override
            public void displayChanged(DisplayEvent event) {
                int id = event.getId();
                try {
                    if (id == 4) {
                        NavigatedDisplay.this.cursorMoved();
                    } else if (id == 21) {
                        NavigatedDisplay.this.pointerMoved(event.getX(), event.getY());
                    } else if (id == 18) {
                        int mods = event.getInputEvent().getModifiers();
                        int button2 = 20;
                        int button3 = 24;
                        if ((mods & 8) == 8 || (mods & button2) == button2) {
                            NavigatedDisplay.this.cursorMoved();
                        } else {
                            NavigatedDisplay.this.pointerMoved(event.getX(), event.getY());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setPolygonOffsetFactor(int offset) throws VisADException, RemoteException {
        this.getDisplay().getGraphicsModeControl().setPolygonOffsetFactor(offset);
    }

    public void setPolygonOffset(int offset) throws VisADException, RemoteException {
        this.getDisplay().getGraphicsModeControl().setPolygonOffset(offset);
    }

    public void setRotationMultiplierMatrix(double rotx, double roty, double rotz) {
        this.rotateXMultiplier = rotx;
        this.rotateYMultiplier = roty;
        this.rotateZMultiplier = rotz;
    }

    public String getTopViewName() {
        return TOP_VIEW_NAME;
    }

    public String getBottomViewName() {
        return BOTTOM_VIEW_NAME;
    }

    public String getNorthViewName() {
        return NORTH_VIEW_NAME;
    }

    public String getEastViewName() {
        return EAST_VIEW_NAME;
    }

    public String getSouthViewName() {
        return SOUTH_VIEW_NAME;
    }

    public String getWestViewName() {
        return WEST_VIEW_NAME;
    }

    public double[] getSpatialCoordinatesFromScreen(int screenX, int screenY) {
        return this.getSpatialCoordinatesFromScreen(screenX, screenY, Double.NaN);
    }

    public double[] getSpatialCoordinatesFromScreen(int screenX, int screenY, double zDepth) {
        return this.getRayPositionAtZ(this.getRay(screenX, screenY), zDepth);
    }

    public double[] getRayDirection(int screenX, int screenY) {
        return this.getRay((int)screenX, (int)screenY).vector;
    }

    public VisADRay getRay(int screenX, int screenY) {
        return this.getDisplay().getDisplayRenderer().getMouseBehavior().findRay(screenX, screenY);
    }

    public int[] getScreenCoordinates(double[] position) {
        return this.getDisplay().getDisplayRenderer().getMouseBehavior().getScreenCoords(position);
    }

    public int getDisplayMode() {
        return this.myMode;
    }

    public void setCursorStringOn(boolean on) {
        this.getDisplay().getDisplayRenderer().setCursorStringOn(on);
    }

    public void setAnimationStringOn(boolean visible) {
        this.setAnimationStringVisible(visible);
    }

    public boolean getAnimationStringOn() {
        return this.getAnimationStringVisible();
    }

    public abstract DisplayRealType getDisplayLatitudeType();

    public abstract DisplayRealType getDisplayLongitudeType();

    public abstract DisplayRealType getDisplayAltitudeType();

    public void enableClipping(boolean clip) {
        this.clipping = clip;
    }

    public boolean isClippingEnabled() {
        return this.clipping;
    }

    public void setMapProjection(ProjectionImpl projection) throws VisADException, RemoteException {
        this.setMapProjection(new ProjectionCoordinateSystem(projection));
    }

    public abstract void setMapProjection(MapProjection var1) throws VisADException, RemoteException;

    public void setMapArea(ProjectionRect mapArea) throws VisADException, RemoteException {
    }

    protected abstract ScalarMap getAltitudeMap();

    public void addVerticalMap(RealType verticalType) throws VisADException, RemoteException {
    }

    public void removeVerticalMap(RealType verticalType) throws VisADException, RemoteException {
    }

    public abstract void setView(int var1);

    public void setView(String view) {
        if ((view = view.toLowerCase()).equals("bottom")) {
            this.setView(0);
        } else if (view.equals("north")) {
            this.setView(1);
        } else if (view.equals("east")) {
            this.setView(2);
        } else if (view.equals("top")) {
            this.setView(3);
        } else if (view.equals("south")) {
            this.setView(4);
        } else if (view.equals("west")) {
            this.setView(5);
        }
    }

    public void setPerspectiveView(boolean perspective) {
        this.isPerspective = perspective;
    }

    public boolean isPerspectiveView() {
        return this.isPerspective;
    }

    public void setRubberBandBox(RubberBandBox box) {
        this.rubberBandBox = box;
    }

    public RubberBandBox getRubberBandBox() {
        return this.rubberBandBox;
    }

    public void enableRubberBanding(boolean on) throws VisADException, RemoteException {
        RubberBandBox box = this.getRubberBandBox();
        if (box == null) {
            return;
        }
        if (on) {
            if (this.indexOf(box) == -1) {
                this.addDisplayable(box);
            }
        } else {
            boolean bl = this.removeDisplayable(box);
        }
    }

    public void setVerticalRangeUnit(Unit newUnit) throws VisADException, RemoteException {
        ScalarMap vertMap = this.getAltitudeMap();
        if (vertMap != null && newUnit != null && !Misc.equals(this.getVerticalRangeUnit(), newUnit)) {
            vertMap.setOverrideUnit(newUnit);
        }
    }

    public Unit getVerticalRangeUnit() {
        ScalarMap vertMap = this.getAltitudeMap();
        return vertMap == null ? null : (vertMap.getOverrideUnit() == null ? ((RealType)vertMap.getScalar()).getDefaultUnit() : vertMap.getOverrideUnit());
    }

    public void setVerticalRange(double min, double max) throws VisADException, RemoteException {
        double[] vertRange;
        ScalarMap vertMap = this.getAltitudeMap();
        if (vertMap != null && ((vertRange = this.getVerticalRange())[0] != min || vertRange[1] != max)) {
            vertMap.setRange(min, max);
        }
    }

    public double[] getVerticalRange() {
        double[] dArray;
        ScalarMap vertMap = this.getAltitudeMap();
        if (vertMap != null) {
            dArray = vertMap.getRange();
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.0;
            dArray = dArray2;
            dArray2[1] = 0.0;
        }
        return dArray;
    }

    @Override
    public void setForeground(Color color) {
        try {
            if (this.getRubberBandBox() != null) {
                this.getRubberBandBox().setColor(color);
            }
            super.setForeground(color);
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setBoxVisible(boolean on) throws VisADException, RemoteException {
        this.getDisplay().getDisplayRenderer().setBoxOn(on);
        this.box = on;
    }

    public boolean getBoxVisible() {
        return this.box;
    }

    public void setScalesVisible(boolean on) throws VisADException, RemoteException {
        this.getDisplay().getGraphicsModeControl().setScaleEnable(on);
    }

    public boolean getScalesVisible() {
        return this.getDisplay().getGraphicsModeControl().getScaleEnable();
    }

    public EarthLocation getCenterPoint() {
        return this.getEarthLocation(new double[]{0.0, 0.0, 0.0});
    }

    public EarthLocation getEarthLocation(RealTuple xyz) {
        EarthLocation el = null;
        try {
            el = this.getEarthLocation(new double[]{((Real)xyz.getComponent(0)).getValue(), ((Real)xyz.getComponent(1)).getValue(), ((Real)xyz.getComponent(2)).getValue()});
        }
        catch (VisADException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return el;
    }

    public EarthLocation getEarthLocation(double[] xyz) {
        return this.getEarthLocation(xyz[0], xyz[1], xyz[2]);
    }

    public EarthLocation getEarthLocation(double x, double y, double z) {
        return this.getEarthLocation(x, y, z, true);
    }

    public abstract EarthLocation getEarthLocation(double var1, double var3, double var5, boolean var7);

    public abstract RealTuple getSpatialCoordinates(EarthLocation var1);

    public double[] getSpatialCoordinates(EarthLocation el, double[] xyz) throws VisADException, RemoteException {
        return this.getSpatialCoordinates(el, xyz, el.getAltitude().getValue(CommonUnit.meter));
    }

    public abstract double[] getSpatialCoordinates(EarthLocation var1, double[] var2, double var3) throws VisADException, RemoteException;

    protected float getScaledValue(ScalarMap map, float value) {
        return map != null ? map.inverseScaleValues(new float[]{value}, false)[0] : 0.0f;
    }

    protected void setCursorLatitude(Real latitude) throws VisADException, RemoteException {
        Real oldLatitude = this.cursorLatitude;
        this.cursorLatitude = latitude;
        this.firePropertyChange(CURSOR_LATITUDE, oldLatitude, this.cursorLatitude);
    }

    public Real getCursorLatitude() {
        return this.cursorLatitude;
    }

    protected void setCursorLongitude(Real longitude) throws VisADException, RemoteException {
        Real oldLongitude = this.cursorLongitude;
        this.cursorLongitude = longitude;
        this.firePropertyChange(CURSOR_LONGITUDE, oldLongitude, this.cursorLongitude);
    }

    public Real getCursorLongitude() {
        return this.cursorLongitude;
    }

    protected void setCursorAltitude(Real altitude) throws VisADException, RemoteException {
        Real oldAltitude = this.cursorAltitude;
        this.cursorAltitude = altitude;
        this.firePropertyChange(CURSOR_ALTITUDE, oldAltitude, this.cursorAltitude);
    }

    public Real getCursorAltitude() {
        return this.cursorAltitude;
    }

    public boolean getIsAnimating() {
        return this.isAnimating;
    }

    public void animateMatrix(double[] to) {
        this.animateMatrix(++this.animationTimeStamp, this.getProjectionMatrix(), to, null);
    }

    public void animateMatrix(double[] to, long sleepTime) {
        this.animateMatrix(++this.animationTimeStamp, this.getProjectionMatrix(), to, null, sleepTime);
    }

    public void animateMatrix(int myTimeStamp, double[] from, double[] to, EarthLocation finalLocation) {
        this.animateMatrix(myTimeStamp, from, to, finalLocation, 50L);
    }

    public void applyRotation(Point3d p) {
        double[] trans = new double[]{0.0, 0.0, 0.0};
        double[] rot = new double[]{0.0, 0.0, 0.0};
        double[] scale = new double[]{0.0, 0.0, 0.0};
        MouseBehavior mouseBehavior = this.getMouseBehavior();
        mouseBehavior.instance_unmake_matrix(rot, scale, trans, this.getProjectionMatrix());
        double[] t = mouseBehavior.make_matrix(rot[0], rot[1], rot[2], 1.0, 1.0, 1.0, 0.0, 0.0, 0.0);
        Transform3D transform = new Transform3D(t);
        transform.invert();
        transform.transform(p);
    }

    public void animateMatrix(int myTimeStamp, double[] from, double[] to, EarthLocation finalLocation, long sleepTime) {
        double[] lastGoodMatrix = from;
        try {
            this.setAutoRotate(false);
            double[] finalMatrix = to;
            double[] tmp = new double[from.length];
            int numSteps = 20;
            this.isAnimating = true;
            double[] lastMatrix = null;
            double[] trans1 = new double[]{0.0, 0.0, 0.0};
            double[] rot1 = new double[]{0.0, 0.0, 0.0};
            double[] scale1 = new double[]{0.0, 0.0, 0.0};
            double[] trans2 = new double[]{0.0, 0.0, 0.0};
            double[] rot2 = new double[]{0.0, 0.0, 0.0};
            double[] scale2 = new double[]{0.0, 0.0, 0.0};
            double[] trans = new double[]{0.0, 0.0, 0.0};
            double[] rot = new double[]{0.0, 0.0, 0.0};
            double[] scale = new double[]{0.0, 0.0, 0.0};
            MouseBehavior mouseBehavior = this.getMouseBehavior();
            mouseBehavior.instance_unmake_matrix(rot1, scale1, trans1, from);
            mouseBehavior.instance_unmake_matrix(rot2, scale2, trans2, to);
            Transform3D t1 = new Transform3D(from);
            Transform3D t2 = new Transform3D(to);
            Rectangle bounds = this.getScreenBounds();
            int[] ptsx = new int[]{0, bounds.width / 2, bounds.width};
            int[] ptsy = new int[]{0, bounds.height / 2, bounds.height};
            double maxDistance = 0.0;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    double[] screenLoc = this.getSpatialCoordinatesFromScreen(ptsx[i], ptsx[j]);
                    Point3d p1 = new Point3d(screenLoc[0], screenLoc[1], screenLoc[2]);
                    Point3d p2 = new Point3d(screenLoc[0], screenLoc[1], screenLoc[2]);
                    t1.transform(p1);
                    t2.transform(p2);
                    double distance = p1.distance(p2);
                    if (!(distance > maxDistance)) continue;
                    maxDistance = distance;
                }
            }
            if ((maxDistance = Math.min(maxDistance, 10.0)) > 0.0) {
                numSteps = (int)((double)numSteps * maxDistance) + 1;
            }
            numSteps = Math.min(numSteps, 100);
            Quat4d q1 = new Quat4d();
            Quat4d q2 = new Quat4d();
            t1.get(q1);
            t2.get(q2);
            boolean ask = true;
            for (int step = 1; step <= numSteps; ++step) {
                if (myTimeStamp != this.animationTimeStamp) {
                    this.isAnimating = false;
                    return;
                }
                if (step == numSteps) {
                    try {
                        this.setProjectionMatrix(finalMatrix);
                    }
                    catch (Exception exc) {
                        this.setProjectionMatrix(lastGoodMatrix);
                    }
                    this.isAnimating = false;
                    if (finalLocation != null) {
                        this.center(finalLocation);
                    }
                    return;
                }
                double percent = (double)step / (double)numSteps;
                this.isAnimating = true;
                Quat4d q3 = new Quat4d();
                q3.interpolate(q1, q2, percent);
                Transform3D t3 = new Transform3D();
                t3.set(q3);
                double[] tmpRot = new double[16];
                t3.get(tmpRot);
                this.getMouseBehavior().instance_unmake_matrix(rot, scale, trans, tmpRot);
                tmp = mouseBehavior.make_matrix(rot[0], rot[1], rot[2], this.interp(scale1, scale2, 0, percent), this.interp(scale1, scale2, 1, percent), this.interp(scale1, scale2, 2, percent), this.interp(trans1, trans2, 0, percent), this.interp(trans1, trans2, 1, percent), this.interp(trans1, trans2, 2, percent));
                double[] currentMatrix = this.getProjectionMatrix();
                if (lastMatrix != null && !Misc.arraysEquals(lastMatrix, currentMatrix)) {
                    this.isAnimating = false;
                    return;
                }
                boolean ok = true;
                try {
                    Transform3D testt = new Transform3D(tmp);
                    testt.invert();
                }
                catch (Exception exc) {
                    this.setProjectionMatrix(lastGoodMatrix);
                    return;
                }
                if (ok) {
                    try {
                        this.setProjectionMatrix(tmp);
                        lastGoodMatrix = tmp;
                    }
                    catch (Exception exc) {
                        System.err.println("EXC:" + exc);
                        this.setProjectionMatrix(lastGoodMatrix);
                    }
                }
                lastMatrix = this.getProjectionMatrix();
                Misc.sleep(sleepTime);
            }
        }
        catch (Exception exp) {
            System.out.println("Error  animating matrix:" + exp);
        }
    }

    private double interp(double d1, double d2, double percent) {
        return d1 + percent * (d2 - d1);
    }

    private double interp(Vector3d a1, Vector3d a2, int index, double percent) {
        if (index == 0) {
            return a1.x + percent * (a2.x - a1.x);
        }
        if (index == 1) {
            return a1.y + percent * (a2.y - a1.y);
        }
        return a1.z + percent * (a2.z - a1.z);
    }

    private double interp(double[] a1, double[] a2, int index, double percent) {
        return a1[index] + percent * (a2[index] - a1[index]);
    }

    public double[] getScreenCenter() throws VisADException, RemoteException {
        Rectangle screenBounds = this.getScreenBounds();
        return this.getSpatialCoordinatesFromScreen(screenBounds.width / 2, screenBounds.height / 2);
    }

    public List<TwoFacedObject> getScreenCoordinates() throws VisADException, RemoteException {
        ArrayList<TwoFacedObject> l = new ArrayList<TwoFacedObject>();
        l.add(new TwoFacedObject((Object)"Center", this.getScreenCenter()));
        l.add(new TwoFacedObject((Object)"Upper Left", this.getScreenUpperLeft()));
        l.add(new TwoFacedObject((Object)"Upper Right", this.getScreenUpperRight()));
        l.add(new TwoFacedObject((Object)"Lower Left", this.getScreenLowerLeft()));
        l.add(new TwoFacedObject((Object)"Lower Right", this.getScreenLowerRight()));
        return l;
    }

    public List<TwoFacedObject> getScreenSidesCoordinates() throws VisADException, RemoteException {
        ArrayList<TwoFacedObject> l = new ArrayList<TwoFacedObject>();
        l.add(new TwoFacedObject((Object)"Center", this.getScreenCenter()));
        l.add(new TwoFacedObject((Object)"Center Top", this.getScreenCenterTop()));
        l.add(new TwoFacedObject((Object)"Center Bottom", this.getScreenCenterBottom()));
        l.add(new TwoFacedObject((Object)"Center Left", this.getScreenCenterLeft()));
        l.add(new TwoFacedObject((Object)"Center Right", this.getScreenCenterRight()));
        return l;
    }

    public double[] getScreenUpperLeft() throws VisADException, RemoteException {
        return this.getSpatialCoordinatesFromScreen(0, 0);
    }

    public double[] getScreenUpperRight() throws VisADException, RemoteException {
        Rectangle screenBounds = this.getScreenBounds();
        return this.getSpatialCoordinatesFromScreen(screenBounds.width, 0);
    }

    public double[] getScreenLowerLeft() throws VisADException, RemoteException {
        Rectangle screenBounds = this.getScreenBounds();
        return this.getSpatialCoordinatesFromScreen(0, screenBounds.height);
    }

    public double[] getScreenLowerRight() throws VisADException, RemoteException {
        Rectangle screenBounds = this.getScreenBounds();
        return this.getSpatialCoordinatesFromScreen(screenBounds.width, screenBounds.height);
    }

    public double[] getScreenCenterTop() throws VisADException, RemoteException {
        Rectangle screenBounds = this.getScreenBounds();
        return this.getSpatialCoordinatesFromScreen(screenBounds.width / 2, 0);
    }

    public double[] getScreenCenterBottom() throws VisADException, RemoteException {
        Rectangle screenBounds = this.getScreenBounds();
        return this.getSpatialCoordinatesFromScreen(screenBounds.width / 2, screenBounds.height);
    }

    public double[] getScreenCenterLeft() throws VisADException, RemoteException {
        Rectangle screenBounds = this.getScreenBounds();
        return this.getSpatialCoordinatesFromScreen(0, screenBounds.height / 2);
    }

    public double[] getScreenCenterRight() throws VisADException, RemoteException {
        Rectangle screenBounds = this.getScreenBounds();
        return this.getSpatialCoordinatesFromScreen(screenBounds.width, screenBounds.height / 2);
    }

    public Rectangle2D.Double getLatLonBox() throws VisADException, RemoteException {
        return this.getLatLonBox(true, true);
    }

    public Rectangle2D.Double getLatLonBox(boolean padSamples, boolean normalizeLon) throws VisADException, RemoteException {
        double wwidth;
        double tmp;
        double right;
        double left;
        Rectangle b = this.getScreenBounds();
        double pad = padSamples ? 0.1 : 0.0;
        double[] xs = new double[]{(double)b.width * -pad, (double)b.width * 0.0, (double)b.width * 0.1, (double)b.width * 0.2, (double)b.width * 0.3, (double)b.width * 0.4, (double)b.width * 0.5, (double)b.width * 0.6, (double)b.width * 0.7, (double)b.width * 0.8, (double)b.width * 0.9, (double)b.width * 1.0, (double)b.width * (1.0 + pad)};
        double[] ys = new double[]{0.0 - (double)b.height * pad, 0.0, (double)b.height * 0.2, (double)b.height * 0.4, (double)b.height * 0.6, (double)b.height * 0.8, b.height * 1, (double)b.height + (double)b.height * pad};
        double[] rangeXE = new double[]{Double.NaN, Double.NaN};
        double[] rangeXW = new double[]{Double.NaN, Double.NaN};
        double[] rangeY = new double[]{Double.NaN, Double.NaN};
        for (int yidx = 0; yidx < ys.length; ++yidx) {
            for (int xidx = 0; xidx < xs.length; ++xidx) {
                this.findMinMaxFromScreen((int)xs[xidx], (int)ys[yidx], rangeXE, rangeXW, rangeY, normalizeLon);
            }
        }
        for (int xidx = 0; xidx < 100; ++xidx) {
            double percent = (double)xidx / 100.0;
            this.findMinMaxFromScreen((int)((double)b.width * percent), b.height / 2, rangeXE, rangeXW, rangeY, normalizeLon);
        }
        double[] rangeXE0 = new double[]{Double.NaN, Double.NaN};
        double[] rangeXW0 = new double[]{Double.NaN, Double.NaN};
        double[] rangeY0 = new double[]{Double.NaN, Double.NaN};
        int jj = 1;
        int ii = 1;
        while (rangeXE0[0] != rangeXE0[0] && rangeXW0[0] != rangeXW0[0] || rangeY0[1] > 90.0) {
            this.findMinMaxFromScreen((int)xs[ii], (int)ys[jj], rangeXE0, rangeXW0, rangeY0, normalizeLon);
            if (++jj == ys.length && ii < xs.length) {
                jj = 0;
                ++ii;
            }
            if (ii != xs.length) continue;
        }
        if (rangeXE[0] == rangeXE[0] && rangeXW[0] == rangeXW[0]) {
            if (rangeXW0[0] == rangeXW0[0]) {
                left = rangeXW[0];
                right = rangeXE[1];
            } else {
                left = rangeXE0[0];
                right = rangeXW[1];
            }
        } else if (rangeXE[0] == rangeXE[0]) {
            left = rangeXE[0];
            right = rangeXE[1];
        } else {
            left = rangeXW[0];
            right = rangeXW[1];
        }
        double top = rangeY[1];
        double bottom = rangeY[0];
        if ((left >= 0.0 && right >= 0.0 || left <= 0.0 && right <= 0.0) && left > right) {
            tmp = left;
            left = right;
            right = tmp;
        }
        if (top < bottom) {
            tmp = top;
            top = bottom;
            bottom = tmp;
        }
        double width = right - left;
        double height = top - bottom;
        left -= width * 0.02;
        right += width * 0.02;
        if (left <= -180.0) {
            left = -179.9;
        }
        if ((wwidth = right - left) >= 360.0) {
            wwidth = 359.9;
        }
        return new Rectangle2D.Double(left, bottom, wwidth, top - bottom);
    }

    public EarthLocation screenToEarthLocation(int x, int y) throws VisADException {
        double[] pt = this.getSpatialCoordinatesFromScreen(x, y, -1.0);
        return this.getEarthLocation(pt);
    }

    private void findMinMaxFromScreen(int x, int y, double[] rangeXE, double[] rangeXW, double[] rangeY, boolean normalizeLon) throws VisADException {
        EarthLocation el = this.screenToEarthLocation(x, y);
        double tmpx = el.getLongitude().getValue(CommonUnit.degree);
        if (tmpx != tmpx) {
            return;
        }
        double tmpy = el.getLatitude().getValue(CommonUnit.degree);
        if (tmpy != tmpy) {
            return;
        }
        if (normalizeLon) {
            tmpx = LatLonPointImpl.lonNormal(tmpx);
        }
        if (tmpx > 0.0) {
            if (rangeXE[0] != rangeXE[0] || tmpx < rangeXE[0]) {
                rangeXE[0] = tmpx;
            }
            if (rangeXE[1] != rangeXE[1] || tmpx > rangeXE[1]) {
                rangeXE[1] = tmpx;
            }
        } else {
            if (rangeXW[0] != rangeXW[0] || tmpx < rangeXW[0]) {
                rangeXW[0] = tmpx;
            }
            if (rangeXW[1] != rangeXW[1] || tmpx > rangeXW[1]) {
                rangeXW[1] = tmpx;
            }
        }
        if (rangeY[0] != rangeY[0] || tmpy < rangeY[0]) {
            rangeY[0] = tmpy;
        }
        if (rangeY[1] != rangeY[1] || tmpy > rangeY[1]) {
            rangeY[1] = tmpy;
        }
    }

    public LatLonRect getLatLonRect() throws VisADException, RemoteException {
        Rectangle b = this.getScreenBounds();
        double[] xs = new double[]{0.0 - (double)b.width * 0.1, 0.0, (double)b.width * 0.25, (double)b.width * 0.5, b.width * 1, (double)b.width + (double)b.width * 0.1};
        double[] ys = new double[]{0.0 - (double)b.height * 0.1, 0.0, (double)b.height * 0.25, (double)b.height * 0.5, b.height * 1, (double)b.height + (double)b.height * 0.1};
        double left = 180.0;
        double right = -180.0;
        double top = -90.0;
        double bottom = 90.0;
        double[] tpt = this.getSpatialCoordinatesFromScreen(0, 0, -1.0);
        for (int yidx = 0; yidx < ys.length; ++yidx) {
            for (int xidx = 0; xidx < xs.length; ++xidx) {
                double tmpy;
                double[] pt = this.getSpatialCoordinatesFromScreen((int)xs[xidx], (int)ys[yidx], -1.0);
                EarthLocation el = this.getEarthLocation(pt);
                double tmpx = el.getLongitude().getValue(CommonUnit.degree);
                if (Double.isNaN(tmpx) || Double.isNaN(tmpy = el.getLatitude().getValue(CommonUnit.degree))) continue;
                if (yidx == 0 || tmpx < left) {
                    left = tmpx;
                }
                if (yidx == 0 || tmpx > right) {
                    right = tmpx;
                }
                if (yidx == 0 || tmpy < bottom) {
                    bottom = tmpy;
                }
                if (yidx != 0 && !(tmpy > top)) continue;
                top = tmpy;
            }
        }
        if ((left >= 0.0 && right >= 0.0 || left <= 0.0 && right <= 0.0) && left > right) {
            double tmp = left;
            left = right;
            right = tmp;
        }
        if (top < bottom) {
            double tmp = top;
            top = bottom;
            bottom = tmp;
        }
        LatLonPointImpl llp1 = new LatLonPointImpl(bottom, left);
        LatLonPointImpl llp2 = new LatLonPointImpl(top, right);
        return new LatLonRect(llp1, llp2);
    }

    public Rectangle2D.Double getVisadBox() throws VisADException, RemoteException {
        Rectangle b = this.getScreenBounds();
        double[] xs = new double[]{0.0, (double)b.width * 0.25, (double)b.width * 0.5, b.width * 1};
        double[] ys = new double[]{0.0, (double)b.height * 0.25, (double)b.height * 0.5, b.height * 1};
        double left = 0.0;
        double right = 0.0;
        double top = 0.0;
        double bottom = 0.0;
        for (int yidx = 0; yidx < ys.length; ++yidx) {
            for (int xidx = 0; xidx < xs.length; ++xidx) {
                double[] pt = this.getSpatialCoordinatesFromScreen((int)xs[xidx], (int)ys[yidx], -1.0);
                if (pt[0] == pt[0]) {
                    if (yidx == 0 || pt[0] < left) {
                        left = pt[0];
                    }
                    if (yidx == 0 || pt[0] > right) {
                        right = pt[0];
                    }
                }
                if (pt[1] != pt[1]) continue;
                if (yidx == 0 || pt[1] < bottom) {
                    bottom = pt[1];
                }
                if (yidx != 0 && !(pt[1] > top)) continue;
                top = pt[1];
            }
        }
        if (left > right) {
            double tmp = left;
            left = right;
            right = tmp;
        }
        if (top < bottom) {
            double tmp = top;
            bottom = top = bottom;
        }
        left = Math.max(left, -180.0);
        right = Math.min(right, 180.0);
        top = Math.min(top, 90.0);
        bottom = Math.max(bottom, -90.0);
        Rectangle2D.Double box = new Rectangle2D.Double(left, bottom, right - left, top - bottom);
        return box;
    }

    public void center(double x, double y) {
        this.center(x, y, false);
    }

    public void center(double x, double y, boolean animated) {
        Rectangle screenBounds = this.getScreenBounds();
        if (x != x || y != y) {
            return;
        }
        this.moveToScreen(x, y, (int)(screenBounds.getWidth() / 2.0), (int)(screenBounds.getHeight() / 2.0), animated);
    }

    public void moveToScreen(double x, double y, int sx, int sy, int times) {
        this.moveToScreen(x, y, sx, sy);
    }

    public void moveToScreen(double x, double y, int sx, int sy) {
        this.moveToScreen(x, y, sx, sy, false);
    }

    public void moveToScreen(double x, double y, int sx, int sy, boolean animated) {
        try {
            double[] currentMatrix = this.getProjectionMatrix();
            double[] trans = new double[]{0.0, 0.0, 0.0};
            double[] rot = new double[]{0.0, 0.0, 0.0};
            double[] scale = new double[]{0.0, 0.0, 0.0};
            double[] centerXY = this.getSpatialCoordinatesFromScreen(sx, sy);
            this.getMouseBehavior().instance_unmake_matrix(rot, scale, trans, currentMatrix);
            double[] translateMatrix = this.getMouseBehavior().make_translate(scale[0] * (centerXY[0] - x), scale[1] * (centerXY[1] - y));
            currentMatrix = this.getMouseBehavior().multiply_matrix(translateMatrix, currentMatrix);
            if (!animated) {
                this.setProjectionMatrix(currentMatrix);
            } else {
                final double[] to = currentMatrix;
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        NavigatedDisplay.this.animateMatrix(++NavigatedDisplay.this.animationTimeStamp, NavigatedDisplay.this.getProjectionMatrix(), to, null);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public View getView() {
        DisplayRendererJ3D rend = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        return rend.getView();
    }

    public void center(EarthLocation el) throws VisADException, RemoteException {
        this.center(el, false);
    }

    public void center(EarthLocation el, boolean animated) throws VisADException, RemoteException {
        this.centerAndZoom(el, animated, 1.0);
    }

    public void centerAndZoom(EarthLocation el, boolean animated, double zoomFactor) throws VisADException, RemoteException {
        this.centerAndZoom(el, null, zoomFactor, animated, true);
    }

    public void centerAndZoom(final EarthLocation el, Real altitude, double zoomFactor, boolean animated, boolean northUp) throws VisADException, RemoteException {
        if (zoomFactor == 0.0 || zoomFactor != zoomFactor) {
            zoomFactor = 1.0;
        }
        if (el.getLongitude().isMissing() || el.getLatitude().isMissing()) {
            return;
        }
        try {
            Rectangle screenBounds = this.getScreenBounds();
            MouseBehavior mouseBehavior = this.getMouseBehavior();
            double[] currentMatrix = this.getProjectionMatrix();
            double[] trans = new double[]{0.0, 0.0, 0.0};
            double[] rot = new double[]{0.0, 0.0, 0.0};
            double[] scale = new double[]{0.0};
            double[] xy = this.getSpatialCoordinates(el, null);
            double[] centerXY = this.getSpatialCoordinatesFromScreen(screenBounds.width / 2, screenBounds.height / 2);
            mouseBehavior.instance_unmake_matrix(rot, scale, trans, currentMatrix);
            double[] translateMatrix = mouseBehavior.make_translate(scale[0] * (centerXY[0] - xy[0]), scale[0] * (centerXY[1] - xy[1]));
            currentMatrix = mouseBehavior.multiply_matrix(translateMatrix, currentMatrix);
            if (!animated) {
                this.setProjectionMatrix(currentMatrix);
                this.zoom(zoomFactor);
            } else {
                double[] scaleMatrix = mouseBehavior.make_matrix(0.0, 0.0, 0.0, zoomFactor, 0.0, 0.0, 0.0);
                final double[] to = currentMatrix = mouseBehavior.multiply_matrix(scaleMatrix, currentMatrix);
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        NavigatedDisplay.this.animateMatrix(++NavigatedDisplay.this.animationTimeStamp, NavigatedDisplay.this.getProjectionMatrix(), to, el);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public double[] getRotation() {
        double[] currentMatrix = this.getProjectionMatrix();
        double[] trans = new double[]{0.0, 0.0, 0.0};
        double[] rot = new double[]{0.0, 0.0, 0.0};
        double[] scale = new double[]{0.0, 0.0, 0.0};
        this.getMouseBehavior().instance_unmake_matrix(rot, scale, trans, currentMatrix);
        return rot;
    }

    public void rotateView(double azimuth, double decAngle) {
        this.rotateView(this.getProjectionMatrix(), azimuth, decAngle);
    }

    public void rotateView(double[] matrix, double azimuth, double decAngle) {
        if (this.getDisplayMode() != 0) {
            return;
        }
        double zAngle = 180.0 - azimuth;
        try {
            double[] origMatrix = matrix == null ? this.getProjectionMatrix() : matrix;
            double[] aziMatrix = this.getDisplay().make_matrix(0.0, 0.0, zAngle, 1.0, 0.0, 0.0, 0.0);
            double[] combo = this.getDisplay().multiply_matrix(aziMatrix, origMatrix);
            double[] decMatrix = this.getDisplay().make_matrix(decAngle, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
            double[] combo2 = this.getDisplay().multiply_matrix(decMatrix, combo);
            this.setProjectionMatrix(combo2);
        }
        catch (Exception exp) {
            System.out.println("  rotate view got " + exp);
        }
    }

    public NavigatedDisplayToolBar getNavigationToolBar() {
        return this.getNavigationToolBar(0, false);
    }

    public NavigatedDisplayToolBar getNavigationToolBar(int orientation, boolean floatable) {
        if (this.getDestroyed()) {
            return null;
        }
        if (this.navToolBar == null) {
            this.navToolBar = new NavigatedDisplayToolBar(this, orientation, floatable);
        }
        return this.navToolBar;
    }

    @Override
    public void destroy() {
        if (this.navToolBar != null) {
            this.navToolBar.destroy();
            this.navToolBar = null;
        }
        super.destroy();
    }

    protected void cursorMoved() throws VisADException, RemoteException {
    }

    protected void pointerMoved(int x, int y) throws VisADException, RemoteException {
    }

    protected void updateLocation(EarthLocation el) throws VisADException, RemoteException {
        if (el == null) {
            return;
        }
        this.setCursorLatitude(el.getLatitude());
        this.setCursorLongitude(el.getLongitude());
        if (this.getDisplayMode() == 0) {
            this.setCursorAltitude(el.getAltitude());
        }
    }

    public double[] getRayPositionAtZ(VisADRay ray, double zValue) {
        if (Double.isNaN(zValue) || zValue == ray.position[2]) {
            return ray.position;
        }
        if (ray.vector[2] == 0.0) {
            return ray.position;
        }
        double r = (zValue - ray.position[2]) / ray.vector[2];
        return new double[]{ray.position[0] + r * ray.vector[0], ray.position[1] + r * ray.vector[1], zValue};
    }

    public CoordinateSystem getDisplayCoordinateSystem() {
        return null;
    }

    protected void setVerticalMapUnit(ScalarMap vertMap, Unit u) throws VisADException, RemoteException {
        if (Unit.canConvert(((RealType)vertMap.getScalar()).getDefaultUnit(), GeopotentialAltitude.getGeopotentialMeter())) {
            vertMap.setOverrideUnit(GeopotentialAltitude.getGeopotentialUnit(u));
        } else {
            vertMap.setOverrideUnit(u);
        }
    }

    public void setRotateDelay(long millis) {
        this.rotateDelay = millis;
        if (this.rotateDelay < 1L) {
            this.rotateDelay = 1L;
        }
    }

    public void rotateFaster() {
        this.setRotateDelay(this.rotateDelay / 2L);
    }

    public void rotateSlower() {
        this.setRotateDelay(this.rotateDelay * 2L);
    }

    public void setAutoRotate(boolean rotate) {
        this.autoRotate = rotate;
        if (this.autoRotate) {
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    NavigatedDisplay.this.doRotate(++NavigatedDisplay.this.rotateTimeStamp);
                }
            });
        }
    }

    public void resetScaleTranslate() throws VisADException, RemoteException {
        this.getDisplay().getProjectionControl().resetProjection();
    }

    private void doRotate(int myTimeStamp) {
        double[] lastMatrix = null;
        while (this.autoRotate && myTimeStamp == this.rotateTimeStamp) {
            try {
                double[] currentMatrix = this.getProjectionMatrix();
                if (lastMatrix != null && !Misc.arraysEquals(lastMatrix, currentMatrix)) {
                    this.setAutoRotate(false);
                    return;
                }
                this.rotate();
                lastMatrix = this.getProjectionMatrix();
                Thread.sleep(this.rotateDelay);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public boolean getAutoRotate() {
        return this.autoRotate;
    }

    private void rotate() throws VisADException, RemoteException {
        DisplayImpl display = (DisplayImpl)this.getDisplay();
        double[] myMatrix = this.getProjectionMatrix();
        double scale = this.getScale();
        double[] transA = new double[]{0.0, 0.0, 0.0};
        double[] rotA = new double[]{0.0, 0.0, 0.0};
        double[] scaleA = new double[]{0.0, 0.0, 0.0};
        MouseBehavior mouseBehavior = this.getMouseBehavior();
        DisplayRenderer displayRenderer = display.getDisplayRenderer();
        mouseBehavior.instance_unmake_matrix(rotA, scaleA, transA, myMatrix);
        double[] t2 = null;
        if (displayRenderer.getRotateAboutCenter()) {
            myMatrix = mouseBehavior.multiply_matrix(mouseBehavior.make_translate(-transA[0], -transA[1], -transA[2]), myMatrix);
            t2 = mouseBehavior.make_translate(transA[0], transA[1], transA[2]);
        }
        double[] t1 = display.make_matrix(this.rotateXMultiplier / scale, this.rotateYMultiplier / scale, this.rotateZMultiplier / scale, 1.0, 0.0, 0.0, 0.0);
        t1 = mouseBehavior.multiply_matrix(t1, myMatrix);
        if (t2 != null) {
            t1 = mouseBehavior.multiply_matrix(t2, t1);
        }
        this.setProjectionMatrix(t1);
    }

    public void setClipDistanceBack(double value) {
        this.clipDistanceBack = value;
    }

    public double getClipDistanceBack() {
        return this.clipDistanceBack;
    }

    public void setClipDistanceFront(double value) {
        this.clipDistanceFront = value;
    }

    public double getClipDistanceFront() {
        return this.clipDistanceFront;
    }

    public void setVerticalRangeVisible(boolean visible) {
        this.verticalRangeVisible = visible;
    }

    public boolean getVerticalRangeVisible() {
        return this.verticalRangeVisible;
    }

    protected class VerticalMapSet
    extends ScalarMapSet {
        protected VerticalMapSet() {
        }

        public void setVerticalUnit(Unit newUnit) throws VisADException, RemoteException {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                ScalarMap vertMap = (ScalarMap)iter.next();
                if (vertMap == null || newUnit == null) continue;
                NavigatedDisplay.this.setVerticalMapUnit(vertMap, newUnit);
                if (Unit.canConvert(((RealType)vertMap.getScalar()).getDefaultUnit(), GeopotentialAltitude.getGeopotentialMeter())) {
                    vertMap.setOverrideUnit(GeopotentialAltitude.getGeopotentialUnit(newUnit));
                    continue;
                }
                vertMap.setOverrideUnit(newUnit);
            }
        }

        public void setVerticalRange(double min, double max) throws VisADException, RemoteException {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                ScalarMap vertMap = (ScalarMap)iter.next();
                vertMap.setRange(min, max);
            }
        }
    }
}

