/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.Dimension;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.util.LogUtil;
import ucar.unidata.view.geoloc.MapProjectionDisplay;
import ucar.visad.ProjectionCoordinateSystem;
import ucar.visad.display.DisplayUtil;
import ucar.visad.display.RubberBandBox;
import visad.ActionImpl;
import visad.KeyboardBehavior;
import visad.RealType;
import visad.VisADException;
import visad.georef.MapProjection;
import visad.java3d.DefaultDisplayRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.KeyboardBehaviorJ3D;
import visad.java3d.ProjectionControlJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;

public class MapProjectionDisplayJ3D
extends MapProjectionDisplay {
    private static Object INSTANCE_MUTEX = new Object();
    private boolean isPerspective = true;
    private boolean canDoStereo = false;
    private static GraphicsConfiguration defaultConfig = MapProjectionDisplayJ3D.makeConfig();

    public MapProjectionDisplayJ3D() throws VisADException, RemoteException {
        this(0);
    }

    public MapProjectionDisplayJ3D(int mode) throws VisADException, RemoteException {
        this((MapProjection)null, mode);
    }

    public MapProjectionDisplayJ3D(ProjectionImpl projection, int mode) throws VisADException, RemoteException {
        this(projection == null ? (MapProjection)null : new ProjectionCoordinateSystem(projection), mode);
    }

    public MapProjectionDisplayJ3D(MapProjection projection, int mode) throws VisADException, RemoteException {
        this(projection, mode, false, null);
    }

    public MapProjectionDisplayJ3D(MapProjection projection, int mode, boolean offscreen, Dimension dimension) throws VisADException, RemoteException {
        this(projection, mode, offscreen, dimension, null);
    }

    public MapProjectionDisplayJ3D(MapProjection projection, int mode, boolean offscreen, Dimension dimension, GraphicsDevice screen) throws VisADException, RemoteException {
        DisplayRendererJ3D renderer;
        if (mode != 0 && mode != 2) {
            throw new VisADException("Illegal mode: " + mode);
        }
        if (projection == null) {
            projection = MapProjectionDisplayJ3D.makeDefaultMapProjection();
        }
        if (offscreen) {
            if (dimension == null) {
                dimension = new Dimension(600, 400);
            }
            this.setOffscreenDimension(dimension);
        }
        DisplayImplJ3D displayImpl = null;
        int api = offscreen ? 2 : 1;
        boolean useStereo = mode == 0 && System.getProperty("idv.enableStereo", "false").equals("true");
        GraphicsConfiguration config = DisplayUtil.getPreferredConfig(screen, true, useStereo);
        DisplayRendererJ3D displayRendererJ3D = renderer = mode == 0 ? new DefaultDisplayRendererJ3D() : new TwoDDisplayRendererJ3D();
        if (offscreen) {
            displayImpl = new DisplayImplJ3D("Navigated Display", renderer, dimension.width, dimension.height);
        } else {
            if (config == null) {
                LogUtil.userErrorMessage("Could not create a graphics configuration.\nPlease contact Unidata user support or see the FAQ");
                System.exit(1);
            }
            displayImpl = new DisplayImplJ3D("Navigated Display", renderer, api, config);
        }
        super.init(projection, displayImpl);
    }

    @Override
    protected void initializeClass() throws VisADException, RemoteException {
        super.initializeClass();
        if (this.getDisplayMode() == 2) {
            this.setBoxVisible(false);
        }
        try {
            DisplayRendererJ3D rend = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
            rend.setRotateAboutCenter(true);
            this.canDoStereo = this.getDisplayMode() == 0 && rend.getCanvas().getStereoAvailable();
            this.setPerspectiveView(this.canDoStereo);
            this.checkClipDistance();
            this.setEyePosition(0.004);
            KeyboardBehaviorJ3D behavior = new KeyboardBehaviorJ3D(rend);
            rend.addKeyboardBehavior(behavior);
            this.setKeyboardBehavior(behavior);
            RubberBandBox rubberBandBox = new RubberBandBox(RealType.XAxis, RealType.YAxis, 1);
            rubberBandBox.addAction(new ActionImpl("RBB Action"){

                @Override
                public void doAction() throws VisADException, RemoteException {
                    RubberBandBox box = MapProjectionDisplayJ3D.this.getRubberBandBox();
                    if (box == null || box.getBounds() == null) {
                        return;
                    }
                    MapProjectionDisplayJ3D.this.setMapRegion(box.getBounds());
                }
            });
            this.setRubberBandBox(rubberBandBox);
            this.enableRubberBanding(true);
            this.setPolygonOffsetFactor(1);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void addKeyboardBehavior(KeyboardBehavior behavior) {
        DisplayRendererJ3D rend = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        KeyboardBehaviorWrapper3D beh = new KeyboardBehaviorWrapper3D(rend, behavior);
        rend.addKeyboardBehavior(beh);
    }

    @Override
    public void enableClipping(boolean clip) {
        DisplayRendererJ3D dr = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        try {
            dr.setClip(0, clip, 1.0f, 0.0f, 0.0f, -1.01f);
            dr.setClip(1, clip, -1.0f, 0.0f, 0.0f, -1.01f);
            dr.setClip(2, clip, 0.0f, 1.0f, 0.0f, -1.01f);
            dr.setClip(3, clip, 0.0f, -1.0f, 0.0f, -1.01f);
            dr.setClip(4, clip, 0.0f, 0.0f, 1.0f, -1.01f);
            dr.setClip(5, clip, 0.0f, 0.0f, -1.0f, -1.01f);
        }
        catch (VisADException ve) {
            System.err.println("Couldn't set clipping " + ve);
        }
        super.enableClipping(clip);
    }

    @Override
    public View getView() {
        DisplayRendererJ3D rend = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        return rend.getView();
    }

    @Override
    public void setPerspectiveView(boolean perspectiveView) {
        if (this.getDisplayMode() != 0) {
            return;
        }
        if (perspectiveView == this.isPerspectiveView()) {
            return;
        }
        try {
            this.getDisplay().getGraphicsModeControl().setProjectionPolicy(perspectiveView ? 1 : 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setPerspectiveView(perspectiveView);
        this.checkClipDistance();
    }

    @Override
    public boolean isPerspectiveView() {
        return this.getDisplayMode() == 0 ? super.isPerspectiveView() : false;
    }

    @Override
    public void setView(int view) {
        super.setView(view);
        try {
            ProjectionControlJ3D projControl = (ProjectionControlJ3D)this.getDisplay().getProjectionControl();
            switch (view) {
                case 0: {
                    projControl.setOrthoView(5);
                    break;
                }
                case 1: {
                    projControl.setOrthoView(2);
                    break;
                }
                case 2: {
                    projControl.setOrthoView(0);
                    break;
                }
                case 3: {
                    projControl.setOrthoView(4);
                    break;
                }
                case 4: {
                    projControl.setOrthoView(3);
                    break;
                }
                case 5: {
                    projControl.setOrthoView(1);
                    break;
                }
                default: {
                    projControl.setOrthoView(15);
                    break;
                }
            }
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public boolean getStereoAvailable() {
        return this.canDoStereo;
    }

    private static GraphicsConfiguration makeConfig() {
        try {
            GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice d = e.getDefaultScreenDevice();
            GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
            if (System.getProperty("idv.enableStereo", "false").equals("true")) {
                template.setStereo(2);
            }
            GraphicsConfiguration c = d.getBestConfiguration((GraphicsConfigTemplate)template);
            return c;
        }
        catch (HeadlessException he) {
            return null;
        }
    }

    @Override
    public void setEyePosition(double position) {
        DisplayRendererJ3D rend = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        PhysicalBody myBody = rend.getView().getPhysicalBody();
        myBody.setLeftEyePosition(new Point3d(-position, 0.0, 0.0));
        myBody.setRightEyePosition(new Point3d(position, 0.0, 0.0));
    }

    @Override
    public void setClipDistanceFront(double value) {
        super.setClipDistanceFront(value);
        this.checkClipDistance();
    }

    @Override
    public void setClipDistanceBack(double value) {
        super.setClipDistanceBack(value);
        this.checkClipDistance();
    }

    public void checkClipDistance() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (this.isPerspectiveView()) {
            view.setFrontClipDistance(CLIP_FRONT_PERSPECTIVE);
            view.setBackClipDistance(CLIP_BACK_PERSPECTIVE);
        } else {
            view.setFrontClipDistance(this.getClipDistanceFront());
            view.setBackClipDistance(this.getClipDistanceBack());
        }
    }

    static class KeyboardBehaviorWrapper3D
    extends KeyboardBehaviorJ3D {
        KeyboardBehavior behavior;

        public KeyboardBehaviorWrapper3D(DisplayRendererJ3D rend, KeyboardBehavior behavior) {
            super(rend);
            this.behavior = behavior;
        }

        @Override
        public void mapKeyToFunction(int function, int keycode, int modifiers) {
            if (this.behavior != null) {
                this.behavior.mapKeyToFunction(function, keycode, modifiers);
            }
        }

        @Override
        public void processKeyEvent(KeyEvent event) {
            this.behavior.processKeyEvent(event);
        }

        @Override
        public void execFunction(int function) {
            this.behavior.execFunction(function);
        }
    }
}

