/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.ui.FontSelector;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.view.geoloc.CoordinateFormat;
import ucar.unidata.view.geoloc.LatLonAxisScaleInfo;
import ucar.unidata.view.geoloc.MapProjectionDisplayJ2D;
import ucar.unidata.view.geoloc.MapProjectionDisplayJ3D;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.view.geoloc.NavigatedDisplayCursorReadout;
import ucar.unidata.view.geoloc.NavigatedDisplayToolBar;
import ucar.unidata.view.geoloc.ProjectionManager;
import ucar.unidata.view.geoloc.RangeAndBearingReadout;
import ucar.unidata.view.geoloc.VertScaleInfo;
import ucar.unidata.view.geoloc.ViewpointControl;
import ucar.visad.GeoUtils;
import ucar.visad.ProjectionCoordinateSystem;
import ucar.visad.display.MapLines;
import ucar.visad.display.ScalarMapSet;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.GeopotentialAltitude;
import visad.AxisScale;
import visad.CachingCoordinateSystem;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.Gridded2DSet;
import visad.InverseLinearScaledCS;
import visad.KeyboardBehavior;
import visad.MathType;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.SetType;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.VisADRay;
import visad.data.mcidas.AREACoordinateSystem;
import visad.data.mcidas.BaseMapAdapter;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.MapProjection;
import visad.georef.TrivialMapProjection;
import visad.jmet.GRIBCoordinateSystem;
import visad.util.Util;

public abstract class MapProjectionDisplay
extends NavigatedDisplay {
    public static final String CURSOR_BEARING = "cursorBearing";
    public static final String CURSOR_RANGE = "cursorRange";
    private static int instance = 0;
    private static Object INSTANCE_MUTEX = new Object();
    private static LogUtil.LogCategory log_ = LogUtil.getLogInstance(MapProjectionDisplay.class.getName());
    public static boolean force2D = false;
    public static RealType CURSOR_RANGE_TYPE = RealType.getRealType("Cursor_Range", CommonUnits.KILOMETER);
    public static RealType CURSOR_BEARING_TYPE = RealType.getRealType("Cursor_Bearing", CommonUnit.degree);
    private ScalarMap altitudeMap = null;
    private Unit[] csUnits = null;
    private AxisScale latScale = null;
    private ScalarMap latitudeMap = null;
    private AxisScale lonScale = null;
    private ScalarMap longitudeMap = null;
    private double maxVerticalRange = 16000.0;
    private double minVerticalRange = 0.0;
    private AxisScale verticalScale = null;
    private ScalarMap xMap = null;
    private ScalarMap yMap = null;
    private ScalarMap zMap = null;
    private Unit verticalRangeUnit = CommonUnit.meter;
    private RealType verticalParameter = RealType.Altitude;
    private NavigatedDisplay.VerticalMapSet verticalMapSet = new NavigatedDisplay.VerticalMapSet(this);
    private boolean use360 = true;
    DecimalFormat labelFormat = new DecimalFormat("####0.0");
    private boolean init = false;
    private LatLonPointImpl cursorLLP = new LatLonPointImpl();
    private LatLonPointImpl centerLLP = new LatLonPointImpl();
    private boolean adjustLons = false;
    private CoordinateSystem coordinateSystem;
    private volatile Real cursorBearing;
    private volatile Real cursorRange;
    private DisplayRealType displayAltitudeType;
    private DisplayRealType displayLatitudeType;
    private DisplayRealType displayLongitudeType;
    private DisplayTupleType displayTupleType;
    private LatLonAxisScaleInfo latScaleInfo;
    private LatLonAxisScaleInfo lonScaleInfo;
    private VertScaleInfo vertScaleInfo;
    private MapProjection mapProjection;

    protected MapProjectionDisplay() {
    }

    protected MapProjectionDisplay(MapProjection projection, DisplayImpl display) throws VisADException, RemoteException {
        super(display);
        this.setMapProjection(projection);
        this.initializeClass();
    }

    protected void init(MapProjection projection, DisplayImpl display) throws VisADException, RemoteException {
        super.init(display);
        this.setMapProjection(projection);
        this.initializeClass();
    }

    @Override
    protected void initializeClass() throws VisADException, RemoteException {
        super.initializeClass();
        this.setDisplayTypes();
    }

    public static MapProjectionDisplay getInstance(int mode) throws VisADException, RemoteException {
        return MapProjectionDisplay.getInstance(null, mode);
    }

    public static MapProjectionDisplay getInstance(MapProjection p, int mode) throws VisADException, RemoteException {
        return MapProjectionDisplay.getInstance(p, mode, false, null);
    }

    public static MapProjectionDisplay getInstance(MapProjection p, int mode, boolean offscreen, Dimension dimension) throws VisADException, RemoteException {
        return MapProjectionDisplay.getInstance(p, mode, offscreen, dimension, null);
    }

    public static MapProjectionDisplay getInstance(MapProjection p, int mode, boolean offscreen, Dimension dimension, GraphicsDevice screen) throws VisADException, RemoteException {
        if (p == null) {
            Trace.call1("MapProjectionDisplay.getInstance:makeProjection");
            p = MapProjectionDisplay.makeDefaultMapProjection();
            Trace.call2("MapProjectionDisplay.getInstance:makeProjection");
        }
        if (!(mode != 0 && mode != 2 || force2D)) {
            Trace.call1("MapProjectionDisplay.getInstance:new MapProjectionDisplayJ3D");
            MapProjectionDisplayJ3D mpd = new MapProjectionDisplayJ3D(p, mode, offscreen, dimension, screen);
            Trace.call2("MapProjectionDisplay.getInstance:new MapProjectionDisplayJ3D");
            return mpd;
        }
        return new MapProjectionDisplayJ2D(p);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public abstract void addKeyboardBehavior(KeyboardBehavior var1);

    private void makeLatScales() throws VisADException, RemoteException {
        this.setDisplayInactive();
        if (this.latScale != null) {
            this.latScale.setVisible(this.getLatScaleInfo().isVisible());
            this.latScale.setLabelRelief(this.getLatScaleInfo().isLabelRelief());
            this.updateLatScale(this.latScale);
        }
        this.setDisplayActive();
    }

    private double calcLatBase() {
        double[] dArray;
        double[] xRange = this.xMap.getRange();
        double[] yRange = this.yMap.getRange();
        if (this.zMap != null) {
            dArray = this.zMap.getRange();
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.0;
            dArray = dArray2;
            dArray2[1] = 0.0;
        }
        double[] zRange = dArray;
        EarthLocation el = this.getEarthLocation(xRange[0], yRange[0], zRange[0]);
        double base = el.getLatitude().getValue();
        double DELTA = (xRange[1] - xRange[0]) / 100.0;
        if (Double.isNaN(base)) {
            block0: for (double y = yRange[0]; y < yRange[1]; y += DELTA) {
                for (double x = xRange[0]; x < xRange[1]; x += DELTA) {
                    el = this.getEarthLocation(x, y, zRange[0]);
                    base = el.getLatitude().getValue();
                    if (!Double.isNaN(base)) break block0;
                }
            }
        }
        return base;
    }

    private double calcLatTop() {
        double[] dArray;
        double LAT_MAX = 90.0;
        double[] xRange = this.xMap.getRange();
        double[] yRange = this.yMap.getRange();
        if (this.zMap != null) {
            dArray = this.zMap.getRange();
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.0;
            dArray = dArray2;
            dArray2[1] = 0.0;
        }
        double[] zRange = dArray;
        EarthLocation el = this.getEarthLocation(xRange[0], yRange[1], zRange[0]);
        double top = el.getLatitude().getValue();
        double DELTA = (xRange[1] - xRange[0]) / 100.0;
        if (Double.isNaN(top)) {
            block0: for (double y = yRange[1]; y > yRange[0]; y -= DELTA) {
                for (double x = xRange[0]; x < xRange[1]; x += DELTA) {
                    el = this.getEarthLocation(x, y, zRange[0]);
                    top = el.getLatitude().getValue();
                    if (!Double.isNaN(top)) break block0;
                }
            }
        }
        return top > 90.0 ? 90.0 : top;
    }

    private double calcLonBase() {
        double[] dArray;
        double[] xRange = this.xMap.getRange();
        double[] yRange = this.yMap.getRange();
        if (this.zMap != null) {
            dArray = this.zMap.getRange();
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.0;
            dArray = dArray2;
            dArray2[1] = 0.0;
        }
        double[] zRange = dArray;
        EarthLocation el = this.getEarthLocation(xRange[0], yRange[0], zRange[0]);
        double base = el.getLongitude().getValue();
        double DELTA = (xRange[1] - xRange[0]) / 100.0;
        if (Double.isNaN(base)) {
            block0: for (double x = xRange[0]; x < xRange[1]; x += DELTA) {
                for (double y = yRange[0]; y < yRange[1]; y += DELTA) {
                    el = this.getEarthLocation(x, y, zRange[0]);
                    base = el.getLongitude().getValue();
                    if (!Double.isNaN(base)) break block0;
                }
            }
        }
        return base;
    }

    private double calcLonTop() {
        double[] dArray;
        double[] xRange = this.xMap.getRange();
        double[] yRange = this.yMap.getRange();
        if (this.zMap != null) {
            dArray = this.zMap.getRange();
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.0;
            dArray = dArray2;
            dArray2[1] = 0.0;
        }
        double[] zRange = dArray;
        EarthLocation el = this.getEarthLocation(xRange[1], yRange[1], zRange[0]);
        double top = el.getLongitude().getValue();
        double DELTA = (xRange[1] - xRange[0]) / 100.0;
        if (Double.isNaN(top)) {
            block0: for (double x = xRange[1]; x > xRange[0]; x -= DELTA) {
                for (double y = yRange[1]; y > yRange[0]; y -= DELTA) {
                    el = this.getEarthLocation(x, y, zRange[0]);
                    top = el.getLongitude().getValue();
                    if (!Double.isNaN(top)) break block0;
                }
            }
        }
        return top;
    }

    private void makeLonScales() throws VisADException, RemoteException {
        this.setDisplayInactive();
        if (this.lonScale != null) {
            this.lonScale.setVisible(this.getLonScaleInfo().isVisible());
            this.lonScale.setLabelRelief(this.getLonScaleInfo().isLabelRelief());
            if (this.isSouthPole()) {
                this.updateSouthPoleLonScale(this.lonScale);
            } else {
                this.updateLonScale(this.lonScale);
            }
        }
        this.setDisplayActive();
    }

    private boolean isSouthPole() {
        double[] dArray;
        double[] xRange = this.xMap.getRange();
        double[] yRange = this.yMap.getRange();
        if (this.zMap != null) {
            dArray = this.zMap.getRange();
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.0;
            dArray = dArray2;
            dArray2[1] = 0.0;
        }
        double[] zRange = dArray;
        EarthLocation ll = this.getEarthLocation(xRange[0], yRange[0], zRange[0]);
        EarthLocation lr = this.getEarthLocation(xRange[1], yRange[0], zRange[0]);
        EarthLocation ur = this.getEarthLocation(xRange[1], yRange[1], zRange[0]);
        EarthLocation ul = this.getEarthLocation(xRange[0], yRange[1], zRange[0]);
        return ll.getLongitude().getValue() < ul.getLongitude().getValue() && ul.getLongitude().getValue() < ur.getLongitude().getValue() && ur.getLongitude().getValue() < lr.getLongitude().getValue();
    }

    private void updateLatScale(AxisScale scale) throws VisADException, RemoteException {
        int LAT_MIN = -90;
        int LAT_MAX = 90;
        double DELTA = 1.0E-4;
        double bottomLat = this.calcLatBase();
        double topLat = this.calcLatTop();
        Hashtable<Double, String> labelTable = new Hashtable<Double, String>();
        double base = this.getLatScaleInfo().getBaseLabel();
        ArrayList<Double> majorTicks = new ArrayList<Double>();
        int minorTickInc = this.getLatScaleInfo().getMinorDivision();
        ArrayList<Double> minorTicks = new ArrayList<Double>();
        double inc = this.getLatScaleInfo().getIncrement();
        if (base < -90.0 || base > 90.0) {
            base = bottomLat;
        }
        block0: for (double i = base; i < topLat; i += inc / (double)minorTickInc) {
            if (i < bottomLat) continue;
            EarthLocationTuple elt = new EarthLocationTuple(i, this.calcLonBase(), 0.0);
            double[] values = this.newtonLat(elt, 0);
            for (int j = 0; j < values.length; ++j) {
                if (Double.isNaN(values[j])) continue block0;
            }
            Double d = MapProjectionDisplay.round(values[1], 3, 4);
            double mm = (i - base) % inc;
            if (mm < 1.0E-4 || mm > inc - 1.0E-4) {
                majorTicks.add(d);
                labelTable.put(d, CoordinateFormat.formatLatitude(i, this.latScaleInfo.getCoordFormat()));
                continue;
            }
            minorTicks.add(d);
        }
        this.finalizeAxis(scale, this.getLatScaleInfo().getLabel(), labelTable, majorTicks, minorTicks, this.getLatScaleInfo().getFont());
    }

    private void updateLonScale(AxisScale scale) throws VisADException, RemoteException {
        double rightLon;
        int MAX_LON = 360;
        int MIN_LON = -180;
        double DELTA = 1.0E-4;
        double leftLon = this.calcLonBase();
        boolean isMeridianCross = leftLon > (rightLon = this.calcLonTop());
        Hashtable<Double, String> labelTable = new Hashtable<Double, String>();
        double base = this.getLonScaleInfo().getBaseLabel();
        ArrayList<Double> majorTicks = new ArrayList<Double>();
        int minorTickInc = this.getLonScaleInfo().getMinorDivision();
        ArrayList<Double> minorTicks = new ArrayList<Double>();
        double inc = this.getLonScaleInfo().getIncrement();
        LinkedList<Double> increment = new LinkedList<Double>();
        if (rightLon - base > 360.0) {
            base += 360.0;
        }
        double d = leftLon = isMeridianCross ? leftLon - 360.0 : leftLon;
        if (base < -180.0 || base > 360.0) {
            base = leftLon;
        }
        for (double i = base; i < rightLon; i += inc / (double)minorTickInc) {
            if (i < leftLon) continue;
            increment.add(i);
        }
        block1: for (Double i : increment) {
            EarthLocationTuple elt = new EarthLocationTuple(this.calcLatBase(), i, 0.0);
            double[] values = this.newtonLon(elt, 0);
            for (int j = 0; j < values.length; ++j) {
                if (Double.isNaN(values[j])) continue block1;
            }
            Double d2 = MapProjectionDisplay.round(values[0], 3, 4);
            double mm = (i - base) % inc;
            if (mm < 1.0E-4 || mm > inc - 1.0E-4) {
                majorTicks.add(d2);
                labelTable.put(d2, CoordinateFormat.formatLongitude(i, this.lonScaleInfo.getCoordFormat(), this.lonScaleInfo.isUse360()));
                continue;
            }
            minorTicks.add(d2);
        }
        this.finalizeAxis(scale, this.getLonScaleInfo().getLabel(), labelTable, majorTicks, minorTicks, this.getLonScaleInfo().getFont());
    }

    private void updateSouthPoleLonScale(AxisScale scale) throws VisADException, RemoteException {
        int MAX_LON = 360;
        int MIN_LON = -180;
        double DELTA = 1.0E-4;
        double leftLon = this.calcLonBase();
        double rightLon = this.calcLonTop() - 360.0;
        double bottomLat = this.calcLatBase();
        Hashtable<Double, String> labelTable = new Hashtable<Double, String>();
        double base = this.getLonScaleInfo().getBaseLabel();
        ArrayList<Double> majorTicks = new ArrayList<Double>();
        int minorTickInc = this.getLonScaleInfo().getMinorDivision();
        ArrayList<Double> minorTicks = new ArrayList<Double>();
        double inc = this.getLonScaleInfo().getIncrement();
        LinkedList<Double> increment = new LinkedList<Double>();
        if (base < -180.0 || base > 360.0) {
            base = leftLon;
        }
        for (double i = base; i > rightLon; i -= inc / (double)minorTickInc) {
            if (i > leftLon) continue;
            increment.add(i);
        }
        for (Double i : increment) {
            EarthLocationTuple elt = new EarthLocationTuple(bottomLat, i, 0.0);
            double[] values = this.newtonLon(elt, 0);
            Double d = new Double(values[0]);
            double mm = (base - i) % inc;
            if (mm < 1.0E-4 || mm > inc - 1.0E-4) {
                majorTicks.add(d);
                labelTable.put(d, CoordinateFormat.formatLongitude(i, this.lonScaleInfo.getCoordFormat(), this.lonScaleInfo.isUse360()));
                continue;
            }
            minorTicks.add(d);
        }
        this.finalizeAxis(scale, this.getLonScaleInfo().getLabel(), labelTable, majorTicks, minorTicks, this.getLonScaleInfo().getFont());
    }

    private void finalizeAxis(AxisScale scale, String title, Hashtable<? extends Double, ? extends String> labelTable, List<? extends Double> majorTicks, List<? extends Double> minorTicks, Font axisFont) throws VisADException {
        int i;
        double[] mjt = new double[majorTicks.size()];
        double[] mnt = new double[minorTicks.size()];
        for (i = 0; i < mjt.length; ++i) {
            mjt[i] = majorTicks.get(i);
        }
        for (i = 0; i < mnt.length; ++i) {
            mnt[i] = minorTicks.get(i);
        }
        scale.setAutoComputeTicks(false);
        scale.setSnapToBox(true);
        scale.setMajorTicks(mjt);
        scale.setMinorTicks(mnt);
        scale.setTitle(title);
        scale.setLabelTable(labelTable);
        scale.setTicksVisible(true);
        scale.setMajorTickSpacing(0.0);
        scale.setMinorTickSpacing(0.0);
        if (axisFont != null && axisFont.getName().equals(FontSelector.DEFAULT_FONT.getName())) {
            scale.setFont((Font)null);
            scale.setLabelSize(axisFont.getSize());
        } else {
            scale.setFont(axisFont);
        }
    }

    private double[] newtonLat(EarthLocationTuple elt, int cnt) throws RemoteException, VisADException {
        double DELTA = 0.02;
        double DELTA2 = 0.001;
        int MAX_CNT = 10;
        double[] values = this.getSpatialCoordinates(elt).getValues();
        values[0] = -1.0;
        EarthLocation el = this.getEarthLocation(values);
        while (Double.isNaN(el.getLatitude().getValue())) {
            values[0] = values[0] + 0.001;
            el = this.getEarthLocation(values);
            if (!(values[0] > 1.0)) continue;
            return new double[]{Double.NaN, Double.NaN, Double.NaN};
        }
        double diff = elt.getLatitude().getValue() - el.getLatitude().getValue();
        if (Math.abs(diff) < 0.02 || cnt > 10) {
            return this.getSpatialCoordinates(el).getValues();
        }
        EarthLocationTuple t = new EarthLocationTuple(el.getLatitude().getValue() + diff, el.getLongitude().getValue(), 0.0);
        return this.newtonLat(t, ++cnt);
    }

    private double[] newtonLon(EarthLocationTuple elt, int cnt) throws RemoteException, VisADException {
        double DELTA = 0.02;
        double DELTA2 = 0.001;
        int MAX_CNT = 10;
        double[] values = this.getSpatialCoordinates(elt).getValues();
        values[1] = -1.0;
        EarthLocation el = this.getEarthLocation(values);
        while (Double.isNaN(el.getLatitude().getValue())) {
            values[1] = values[1] + 0.001;
            el = this.getEarthLocation(values);
            if (!(values[1] > 1.0)) continue;
            return new double[]{Double.NaN, Double.NaN, Double.NaN};
        }
        double diff = el.getLongitude().getValue() - elt.getLongitude().getValue();
        if (Math.abs(diff) < 0.02 || cnt > 10) {
            return this.getSpatialCoordinates(elt).getValues();
        }
        EarthLocationTuple t = new EarthLocationTuple(el.getLatitude().getValue(), el.getLongitude().getValue() - diff, 0.0);
        return this.newtonLon(t, ++cnt);
    }

    private void updateVertScale(AxisScale scale, String title, double[] maxmin, double bottom, double top) throws VisADException, RemoteException {
        scale.setVisible(this.getVerticalRangeVisible());
        scale.setSnapToBox(true);
        scale.setTitle(this.getVertScaleInfo().getLabel());
        ArrayList<Double> majorTicks = new ArrayList<Double>();
        int minorIncrement = this.getVertScaleInfo().getMinorDivision();
        ArrayList<Double> minorTicks = new ArrayList<Double>();
        double majorIncrement = this.getVertScaleInfo().getMajorIncrement();
        Hashtable<Double, String> labelTable = new Hashtable<Double, String>();
        labelTable.put(new Double(maxmin[0]), this.labelFormat.format(bottom));
        labelTable.put(new Double(maxmin[1]), this.labelFormat.format(top));
        scale.setLabelTable(labelTable);
        scale.setTickBase(maxmin[0]);
        int majorCount = 0;
        double prevMap = maxmin[0];
        double tmpIncr = 0.0;
        double rangeMap = 0.0;
        for (double i = bottom; i < top; i += majorIncrement) {
            if (i < bottom) continue;
            rangeMap = maxmin[0] + (maxmin[1] - maxmin[0]) / (top - bottom) * (i - bottom);
            majorTicks.add(rangeMap);
            labelTable.put(rangeMap, this.labelFormat.format(bottom + (double)majorCount * majorIncrement));
            ++majorCount;
            if (minorIncrement > 1) {
                tmpIncr = Math.abs(rangeMap - prevMap) / (double)minorIncrement;
                if (top != majorIncrement) {
                    for (int j = 0; j < minorIncrement; ++j) {
                        minorTicks.add(prevMap + tmpIncr * (double)j);
                    }
                }
            }
            prevMap = rangeMap;
        }
        if (top % majorIncrement < 1.0E-4) {
            majorTicks.add(maxmin[1]);
            labelTable.put(maxmin[1], this.labelFormat.format(top));
            if (minorIncrement > 1 && majorCount > 0) {
                tmpIncr = Math.abs(maxmin[1] - prevMap) / (double)minorIncrement;
                for (int j = 1; j < minorIncrement; ++j) {
                    minorTicks.add(prevMap + tmpIncr * (double)j);
                }
            }
        }
        this.finalizeAxis(scale, this.getVertScaleInfo().getLabel(), labelTable, majorTicks, minorTicks, this.getVertScaleInfo().getFont());
    }

    private void makeVerticalScale() throws VisADException, RemoteException {
        if (this.verticalScale == null) {
            return;
        }
        this.setDisplayInactive();
        double[] zRange = this.zMap.getRange();
        String title = this.verticalParameter.getName() + "(" + this.verticalRangeUnit.getIdentifier() + ")";
        this.updateVertScale(this.verticalScale, title, zRange, this.minVerticalRange, this.maxVerticalRange);
        this.setDisplayActive();
    }

    private void setSpatialScalarMaps() throws VisADException, RemoteException {
        this.setDisplayInactive();
        ScalarMapSet mapSet = new ScalarMapSet();
        if (this.latitudeMap != null) {
            this.removeScalarMap(this.latitudeMap);
        }
        this.latitudeMap = new ScalarMap(RealType.Latitude, this.displayLatitudeType);
        mapSet.add(this.latitudeMap);
        this.latitudeMap.setRangeByUnits();
        this.latitudeMap.setScaleEnable(true);
        if (this.longitudeMap != null) {
            this.removeScalarMap(this.longitudeMap);
        }
        this.longitudeMap = new ScalarMap(RealType.Longitude, this.displayLongitudeType);
        mapSet.add(this.longitudeMap);
        this.longitudeMap.setRangeByUnits();
        this.longitudeMap.setScaleEnable(true);
        if (this.getDisplayMode() == 0) {
            ScalarMapSet newVertMaps = new ScalarMapSet();
            if (this.verticalMapSet.size() > 0) {
                Iterator iter = this.verticalMapSet.iterator();
                while (iter.hasNext()) {
                    ScalarType r = ((ScalarMap)iter.next()).getScalar();
                    ScalarMap newMap = new ScalarMap(r, this.displayAltitudeType);
                    newMap.setScaleEnable(true);
                    if (r.equals(RealType.Altitude)) {
                        this.altitudeMap = newMap;
                    }
                    newVertMaps.add(newMap);
                }
            } else {
                this.altitudeMap = new ScalarMap(RealType.Altitude, this.displayAltitudeType);
                this.altitudeMap.setScaleEnable(true);
                newVertMaps.add(this.altitudeMap);
            }
            this.removeScalarMaps(this.verticalMapSet);
            this.verticalMapSet.clear();
            this.verticalMapSet.add(newVertMaps);
            this.setVerticalRange(this.minVerticalRange, this.maxVerticalRange);
            this.setVerticalRangeUnit(this.verticalRangeUnit);
            mapSet.add(this.verticalMapSet);
        }
        if (!this.init) {
            this.xMap = new ScalarMap(RealType.XAxis, Display.XAxis);
            this.xMap.setRange(-1.0, 1.0);
            mapSet.add(this.xMap);
            this.xMap.setScaleEnable(true);
            this.lonScale = this.xMap.getAxisScale();
            this.yMap = new ScalarMap(RealType.YAxis, Display.YAxis);
            this.yMap.setRange(-1.0, 1.0);
            mapSet.add(this.yMap);
            this.yMap.setScaleEnable(true);
            this.latScale = this.yMap.getAxisScale();
            if (this.getDisplayMode() == 0) {
                this.zMap = new ScalarMap(RealType.ZAxis, Display.ZAxis);
                this.zMap.setRange(-1.0, 1.0);
                mapSet.add(this.zMap);
                this.zMap.setScaleEnable(true);
                this.verticalScale = this.zMap.getAxisScale();
            }
            this.init = true;
        }
        this.addScalarMaps(mapSet);
        this.setDisplayActive();
    }

    @Override
    public void addVerticalMap(RealType newVertType) throws VisADException, RemoteException {
        if (this.getDisplayMode() == 0) {
            Unit u = newVertType.getDefaultUnit();
            if (!Unit.canConvert(u, CommonUnit.meter) && !Unit.canConvert(u, GeopotentialAltitude.getGeopotentialMeter())) {
                throw new VisADException("Unable to handle units of " + newVertType);
            }
            ScalarMap newMap = new ScalarMap(newVertType, this.getDisplayAltitudeType());
            this.setVerticalMapUnit(newMap, this.verticalRangeUnit);
            newMap.setRange(this.minVerticalRange, this.maxVerticalRange);
            this.verticalMapSet.add(newMap);
            this.addScalarMaps(this.verticalMapSet);
        }
    }

    @Override
    public void removeVerticalMap(RealType vertType) throws VisADException, RemoteException {
        if (this.getDisplayMode() == 0) {
            ScalarMapSet sms = new ScalarMapSet();
            Iterator iter = this.verticalMapSet.iterator();
            while (iter.hasNext()) {
                ScalarMap s = (ScalarMap)iter.next();
                if (!((RealType)s.getScalar()).equals(vertType)) continue;
                sms.add(s);
            }
            if (sms.size() != 0) {
                this.verticalMapSet.remove(sms);
                this.removeScalarMaps(sms);
            }
        }
    }

    @Override
    public void setVerticalRangeUnit(Unit newUnit) throws VisADException, RemoteException {
        super.setVerticalRangeUnit(newUnit);
        if (newUnit != null && Unit.canConvert(newUnit, CommonUnit.meter)) {
            this.verticalMapSet.setVerticalUnit(newUnit);
            this.verticalRangeUnit = newUnit;
        }
        this.makeVerticalScale();
    }

    public void setLatScaleInfo(LatLonAxisScaleInfo axisScaleInfo) throws RemoteException, VisADException {
        this.latScaleInfo = axisScaleInfo;
        this.makeLatScales();
    }

    public void setLonScaleInfo(LatLonAxisScaleInfo axisScaleInfo) throws RemoteException, VisADException {
        this.lonScaleInfo = axisScaleInfo;
        this.makeLonScales();
    }

    public LatLonAxisScaleInfo getLatScaleInfo() {
        if (this.latScaleInfo == null) {
            LatLonAxisScaleInfo lsi;
            this.latScaleInfo = lsi = new LatLonAxisScaleInfo();
            lsi.setLabel("Latitude");
            lsi.setIncrement(10.0);
            lsi.setMinorDivision(1);
            lsi.setVisible(true);
            lsi.setCoordFormat(LatLonAxisScaleInfo.COORD_FORMATS[0]);
            lsi.setUse360(this.latScaleInfo.isUse360());
            double base = this.calcLatBase();
            double end = this.calcLatTop();
            double inc = Math.abs(end - base) / 10.0;
            lsi.setIncrement(this.makeIncrementNice(inc));
            base = Math.floor(base / 10.0) * 10.0;
            base = base < -90.0 ? -90.0 : base;
            base = base > 90.0 ? 90.0 : base;
            this.latScaleInfo.setBaseLabel(base);
        }
        return this.latScaleInfo;
    }

    public VertScaleInfo getVertScaleInfo() {
        if (this.vertScaleInfo == null) {
            this.vertScaleInfo = new VertScaleInfo(this.minVerticalRange, this.maxVerticalRange);
            this.vertScaleInfo.setVisible(true);
            this.vertScaleInfo.setMajorIncrement((this.maxVerticalRange - this.minVerticalRange) / 4.0);
        }
        return this.vertScaleInfo;
    }

    public void setVertScaleInfo(VertScaleInfo vertScaleInfo) throws RemoteException, VisADException {
        this.vertScaleInfo = vertScaleInfo;
        this.makeVerticalScale();
    }

    private double makeIncrementNice(double inc) {
        double[] niceNums = new double[]{0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0};
        for (int i = 0; i < niceNums.length; ++i) {
            if (!(inc < niceNums[i])) continue;
            return niceNums[i];
        }
        return 10.0;
    }

    public LatLonAxisScaleInfo getLonScaleInfo() {
        if (this.lonScaleInfo == null) {
            LatLonAxisScaleInfo lsi;
            this.lonScaleInfo = lsi = new LatLonAxisScaleInfo();
            lsi.setLabel("Longitude");
            lsi.setMinorDivision(1);
            lsi.setVisible(true);
            lsi.setCoordFormat(LatLonAxisScaleInfo.COORD_FORMATS[0]);
            lsi.setUse360(false);
            double base = this.calcLonBase();
            double end = this.calcLonTop();
            double inc = this.isSouthPole() ? Math.abs(end - 360.0 - base) / 10.0 : Math.abs(end - (base > end ? base - 360.0 : base)) / 10.0;
            lsi.setIncrement(this.makeIncrementNice(inc));
            base = Math.floor(base / 10.0) * 10.0;
            base = base < -180.0 ? -180.0 : base;
            base = base > 180.0 ? base - 360.0 : base;
            this.lonScaleInfo.setBaseLabel(this.isSouthPole() ? Math.floor(base) : Math.ceil(base));
        }
        return this.lonScaleInfo;
    }

    private static double round(double unrounded, int precision, int roundingMode) {
        BigDecimal bd = new BigDecimal(unrounded);
        BigDecimal rounded = bd.setScale(precision, roundingMode);
        return rounded.doubleValue();
    }

    @Override
    public void setVerticalRange(double min, double max) throws VisADException, RemoteException {
        super.setVerticalRange(min, max);
        this.verticalMapSet.setVerticalRange(min, max);
        this.minVerticalRange = min;
        this.maxVerticalRange = max;
        this.makeVerticalScale();
    }

    @Override
    public double[] getVerticalRange() {
        double[] dArray;
        ScalarMap vertMap = this.getAltitudeMap();
        if (vertMap != null) {
            dArray = vertMap.getRange();
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = this.minVerticalRange;
            dArray = dArray2;
            dArray2[1] = this.maxVerticalRange;
        }
        return dArray;
    }

    protected void setCursorRange(Real range) throws VisADException, RemoteException {
        Real oldRange = this.cursorRange;
        this.cursorRange = range;
        this.firePropertyChange(CURSOR_RANGE, oldRange, this.cursorRange);
    }

    public Real getCursorRange() {
        return this.cursorRange;
    }

    protected void setCursorBearing(Real bearing) throws VisADException, RemoteException {
        Real oldBearing = this.cursorBearing;
        this.cursorBearing = bearing;
        this.firePropertyChange(CURSOR_BEARING, oldBearing, this.cursorBearing);
    }

    public Real getCursorBearing() {
        return this.cursorBearing;
    }

    @Override
    public void setView(int view) {
        if (this.getDisplayMode() != 0) {
            return;
        }
    }

    @Override
    public DisplayRealType getDisplayLatitudeType() {
        return this.displayLatitudeType;
    }

    @Override
    public DisplayRealType getDisplayLongitudeType() {
        return this.displayLongitudeType;
    }

    @Override
    public DisplayRealType getDisplayAltitudeType() {
        return this.displayAltitudeType;
    }

    @Override
    protected ScalarMap getAltitudeMap() {
        return this.altitudeMap;
    }

    @Override
    public void setMapProjection(ProjectionImpl projection) throws VisADException, RemoteException {
        this.setMapProjection(new ProjectionCoordinateSystem(projection), true);
    }

    @Override
    public void setMapProjection(MapProjection mapProjection) throws VisADException, RemoteException {
        this.setMapProjection(mapProjection, true);
    }

    public void setMapProjection(MapProjection mapProjection, boolean resetDisplayProjMatrix) throws VisADException, RemoteException {
        if (mapProjection.equals(this.mapProjection)) {
            return;
        }
        this.mapProjection = mapProjection;
        this.coordinateSystem = this.makeCoordinateSystem(mapProjection);
        this.latScaleInfo = null;
        this.lonScaleInfo = null;
        this.resetMapParameters(resetDisplayProjMatrix);
        EarthLocation el = this.getEarthLocation(0.0, 0.0, 0.0);
        this.centerLLP.set(el.getLatitude().getValue(CommonUnit.degree), el.getLongitude().getValue(CommonUnit.degree));
    }

    public MapProjection getMapProjection() {
        return this.mapProjection;
    }

    @Override
    public void setMapArea(ProjectionRect mapArea) throws VisADException, RemoteException {
        if (this.coordinateSystem == null) {
            throw new VisADException("Navigation hasn't been set yet");
        }
        MapProjection project = ((MapProjection3DAdapter)this.coordinateSystem).getMapProjection();
        ProjectionPoint ppMax = mapArea.getMaxPoint();
        ProjectionPoint ppMin = mapArea.getMinPoint();
        float[][] values = new float[2][2];
        values[0][0] = (float)ppMax.getY();
        values[0][1] = (float)ppMin.getY();
        values[1][0] = (float)ppMax.getX();
        values[1][1] = (float)ppMin.getX();
        Gridded2DSet region = new Gridded2DSet((MathType)RealTupleType.LatitudeLongitudeTuple, values, 2);
        this.setMapRegion(region);
    }

    public void setMapRegion(Gridded2DSet region) throws VisADException, RemoteException {
        Gridded2DSet xyRegion;
        if (region == null) {
            throw new VisADException("Region can't be null");
        }
        if (region.isMissing()) {
            return;
        }
        RealTupleType regionType = ((SetType)region.getType()).getDomain();
        if (regionType.equals(RealTupleType.SpatialCartesian2DTuple)) {
            xyRegion = region;
        } else if (regionType.equals(RealTupleType.SpatialEarth2DTuple) || regionType.equals(RealTupleType.LatitudeLongitudeTuple)) {
            int latIndex = regionType.equals(RealTupleType.LatitudeLongitudeTuple) ? 0 : 1;
            int lonIndex = latIndex == 0 ? 1 : 0;
            float[][] values = region.getSamples(true);
            float[][] xy = new float[3][values[0].length];
            xy[0] = values[latIndex];
            xy[1] = values[lonIndex];
            xy = this.coordinateSystem.toReference(xy);
            values[0] = xy[0];
            values[1] = xy[1];
            xyRegion = new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, values, 2);
        } else {
            throw new VisADException("Invalid domain for region " + regionType);
        }
        Dimension d = this.getComponent().getSize();
        if (d.width == 0 || d.height == 0) {
            JPanel jp = (JPanel)this.getComponent();
            d = jp.getComponent(0).getSize();
        }
        int componentCenterX = d.width / 2;
        int componentCenterY = d.height / 2;
        MouseBehavior behavior = this.getDisplay().getDisplayRenderer().getMouseBehavior();
        ProjectionControl proj = this.getDisplay().getProjectionControl();
        double[] aspect = this.getDisplayAspect();
        double[] center_ray = behavior.findRay((int)componentCenterX, (int)componentCenterY).position;
        double[] center_ray_x = behavior.findRay((int)(componentCenterX + 1), (int)componentCenterY).position;
        double[] center_ray_y = behavior.findRay((int)componentCenterX, (int)(componentCenterY + 1)).position;
        double[] tstart = proj.getMatrix();
        double[] rot = new double[3];
        double[] scale = new double[3];
        double[] trans = new double[3];
        behavior.instance_unmake_matrix(rot, scale, trans, tstart);
        double stx = scale[0];
        double sty = scale[1];
        double[] trot = behavior.make_matrix(rot[0], rot[1], rot[2], scale[0], scale[1], scale[2], 0.0, 0.0, 0.0);
        double[] xmat = behavior.make_translate(center_ray_x[0] - center_ray[0], center_ray_x[1] - center_ray[1], center_ray_x[2] - center_ray[2]);
        double[] ymat = behavior.make_translate(center_ray_y[0] - center_ray[0], center_ray_y[1] - center_ray[1], center_ray_y[2] - center_ray[2]);
        double[] xmatmul = behavior.multiply_matrix(trot, xmat);
        double[] ymatmul = behavior.multiply_matrix(trot, ymat);
        behavior.instance_unmake_matrix(rot, scale, trans, xmatmul);
        double xmul = trans[0];
        behavior.instance_unmake_matrix(rot, scale, trans, ymatmul);
        double ymul = trans[1];
        if (Math.abs(xmul) > 0.0 && Math.abs(ymul) > 0.0) {
            float[] lows = xyRegion.getLow();
            float[] highs = xyRegion.getHi();
            float boxCenterDisplayX = (highs[0] + lows[0]) / 2.0f;
            float boxCenterDisplayY = (highs[1] + lows[1]) / 2.0f;
            int boxWidth = (int)Math.abs((double)(highs[0] - lows[0]) / xmul * stx);
            int boxHeight = (int)Math.abs((double)(highs[1] - lows[1]) / ymul * sty);
            if (boxWidth > 5 && boxHeight > 5) {
                int boxCenterX = componentCenterX + (int)(((double)boxCenterDisplayX - center_ray[0]) / xmul);
                int boxCenterY = componentCenterY - (int)(((double)boxCenterDisplayY - center_ray[1]) / ymul);
                double transx = (double)(componentCenterX - boxCenterX) * xmul * stx;
                double transy = (double)(componentCenterY - boxCenterY) * ymul * sty;
                double zoom = boxWidth / boxHeight >= d.width / d.height ? d.getWidth() / (double)boxWidth : d.getHeight() / (double)boxHeight;
                this.translate(transx, -transy);
                this.zoom(zoom);
            }
        }
    }

    public float[] scaleVerticalValues(float[] altValues) {
        if (this.getAltitudeMap() == null) {
            return altValues;
        }
        return this.getAltitudeMap().scaleValues(altValues, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDisplayTypes() throws VisADException, RemoteException {
        if (this.coordinateSystem == null) {
            System.out.println("coordSys == null");
            this.displayLatitudeType = Display.YAxis;
            this.displayLongitudeType = Display.XAxis;
            this.displayAltitudeType = Display.ZAxis;
            this.displayTupleType = Display.DisplaySpatialCartesianTuple;
        } else {
            int myInstance;
            Object object = INSTANCE_MUTEX;
            synchronized (object) {
                myInstance = instance++;
            }
            double minLon = -360.0;
            double maxLon = 360.0;
            double centerLon = 0.0;
            MapProjection mp = ((MapProjection3DAdapter)this.coordinateSystem).getMapProjection();
            boolean isLatLon = false;
            this.adjustLons = true;
            if (mp instanceof ProjectionCoordinateSystem) {
                ProjectionImpl proj = ((ProjectionCoordinateSystem)mp).getProjection();
                if (proj instanceof LatLonProjection) {
                    Rectangle2D r2d2 = mp.getDefaultMapArea();
                    minLon = r2d2.getX();
                    maxLon = minLon + r2d2.getWidth();
                    centerLon = minLon + r2d2.getWidth() / 2.0;
                    isLatLon = true;
                }
            } else if (mp instanceof TrivialMapProjection) {
                Rectangle2D r2d2 = mp.getDefaultMapArea();
                minLon = r2d2.getX();
                maxLon = minLon + r2d2.getWidth();
                centerLon = minLon + r2d2.getWidth() / 2.0;
            } else if (mp instanceof AREACoordinateSystem) {
                this.adjustLons = false;
            } else if (mp instanceof GRIBCoordinateSystem) {
                this.adjustLons = false;
            }
            boolean bl = this.use360 = !(minLon >= -185.0) || !(maxLon <= 185.0);
            if (isLatLon && !this.use360 || !mp.isXYOrder() || minLon > -360.0 && minLon < 0.0 && maxLon > 180.0) {
                this.adjustLons = false;
            }
            this.displayLatitudeType = new DisplayRealType("ProjectionLat" + myInstance, true, -90.0, 90.0, 0.0, CommonUnit.degree);
            this.displayLongitudeType = new DisplayRealType("ProjectionLon" + myInstance, true, minLon, maxLon, centerLon, CommonUnit.degree);
            double defaultZ = this.getDisplayMode() != 0 ? 0.0 : -1.0;
            this.displayAltitudeType = new DisplayRealType("ProjectionAlt" + myInstance, true, -1.0, 1.0, defaultZ, null);
            this.displayTupleType = new DisplayTupleType(new DisplayRealType[]{this.displayLatitudeType, this.displayLongitudeType, this.displayAltitudeType}, this.coordinateSystem);
        }
        this.setSpatialScalarMaps();
    }

    private CoordinateSystem makeCoordinateSystem(MapProjection mapProjection) throws VisADException {
        if (mapProjection == null) {
            throw new VisADException("MapProjection can't be null");
        }
        MapProjection3DAdapter cs = new MapProjection3DAdapter(mapProjection);
        this.csUnits = cs.getCoordinateSystemUnits();
        return cs;
    }

    @Override
    protected void cursorMoved() throws VisADException, RemoteException {
        double[] c = this.getDisplay().getDisplayRenderer().getCursor();
        this.updateLocation(this.getEarthLocation(this.getDisplay().getDisplayRenderer().getCursor()));
    }

    @Override
    protected void updateLocation(EarthLocation el) throws VisADException, RemoteException {
        super.updateLocation(el);
        this.cursorLLP.set(el.getLatitude().getValue(CommonUnit.degree), el.getLongitude().getValue(CommonUnit.degree));
        Bearing workBearing = Bearing.calculateBearing(this.centerLLP, this.cursorLLP);
        this.setCursorRange(new Real(CURSOR_RANGE_TYPE, workBearing.getDistance()));
        this.setCursorBearing(new Real(CURSOR_BEARING_TYPE, workBearing.getAngle()));
    }

    @Override
    protected void pointerMoved(int x, int y) throws UnitException, VisADException, RemoteException {
        VisADRay ray = this.getRay(x, y);
        EarthLocation el = this.getEarthLocation(ray.position[0], ray.position[1], ray.position[2]);
        this.updateLocation(el);
    }

    @Override
    public EarthLocation getEarthLocation(double x, double y, double z, boolean setZToZeroIfOverhead) {
        EarthLocationTuple value = null;
        try {
            float[][] numbers = this.coordinateSystem.fromReference(new float[][]{{(float)x}, {(float)y}, {(float)z}});
            Real lat = new Real(RealType.Latitude, this.getScaledValue(this.latitudeMap, numbers[0][0]), this.csUnits[0]);
            Real lon = new Real(RealType.Longitude, this.getScaledValue(this.longitudeMap, numbers[1][0]), this.csUnits[1]);
            Real alt = null;
            alt = this.getDisplayMode() == 0 ? (setZToZeroIfOverhead && Arrays.equals(this.getProjectionMatrix(), this.getSavedProjectionMatrix()) ? new Real(RealType.Altitude, this.altitudeMap.getRange()[0], this.getVerticalRangeUnit()) : new Real(RealType.Altitude, (double)this.getScaledValue(this.altitudeMap, numbers[2][0]))) : new Real(RealType.Altitude, 0.0);
            value = new EarthLocationTuple(lat, lon, alt);
        }
        catch (VisADException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public RealTuple getSpatialCoordinates(EarthLocation el) {
        if (el == null) {
            throw new NullPointerException("MapProjectionDisplay.getSpatialCoorindate():  null input EarthLocation");
        }
        RealTuple spatialLoc = null;
        try {
            double[] xyz = this.getSpatialCoordinates(el, null);
            spatialLoc = new RealTuple(RealTupleType.SpatialCartesian3DTuple, xyz);
        }
        catch (VisADException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return spatialLoc;
    }

    @Override
    public double[] getSpatialCoordinates(EarthLocation el, double[] xyz, double altitude) throws VisADException, RemoteException {
        float[] altValues = this.altitudeMap != null && el.getAltitude() != null && !Double.isNaN(altitude) ? this.altitudeMap.scaleValues(new double[]{altitude}) : new float[]{0.0f};
        float[][] temp = this.coordinateSystem.toReference(new float[][]{this.latitudeMap.scaleValues(new double[]{el.getLatitude().getValue(CommonUnit.degree)}), this.longitudeMap.scaleValues(new double[]{el.getLongitude().getValue(CommonUnit.degree)}), altValues});
        if (xyz == null) {
            xyz = new double[]{temp[0][0], temp[1][0], temp[2][0]};
        }
        return xyz;
    }

    private void resetMapParameters() throws VisADException, RemoteException {
        this.resetMapParameters(true);
    }

    private void resetMapParameters(boolean resetDisplayProjMatrix) throws VisADException, RemoteException {
        this.setDisplayInactive();
        this.setDisplayTypes();
        if (resetDisplayProjMatrix) {
            this.resetProjection();
            this.setAspect();
        }
        this.makeLatScales();
        this.makeLonScales();
        this.setDisplayActive();
    }

    private void setAspect() {
        Rectangle2D mapArea = this.mapProjection.getDefaultMapArea();
        double ratio = mapArea.getWidth() / mapArea.getHeight();
        double[] myaspect = this.getDisplayAspect();
        try {
            if (ratio == 1.0) {
                double[] dArray;
                if (this.getDisplayMode() != 1) {
                    double[] dArray2 = new double[3];
                    dArray2[0] = 1.0;
                    dArray2[1] = 1.0;
                    dArray = dArray2;
                    dArray2[2] = myaspect[2];
                } else {
                    double[] dArray3 = new double[2];
                    dArray3[0] = 1.0;
                    dArray = dArray3;
                    dArray3[1] = 1.0;
                }
                this.setDisplayAspect(dArray);
            } else {
                double[] dArray;
                if (this.getDisplayMode() != 1) {
                    double[] dArray4 = new double[3];
                    dArray4[0] = ratio;
                    dArray4[1] = 1.0;
                    dArray = dArray4;
                    dArray4[2] = myaspect[2];
                } else {
                    double[] dArray5 = new double[2];
                    dArray5[0] = ratio;
                    dArray = dArray5;
                    dArray5[1] = 1.0;
                }
                this.setDisplayAspect(dArray);
            }
        }
        catch (Exception excp) {
            System.out.println("MapProjectionDisplay.setDisplayAspect() got exception: " + excp);
        }
    }

    protected static MapProjection makeDefaultMapProjection() throws VisADException {
        return new ProjectionCoordinateSystem(new LatLonProjection("Default Projection", new ProjectionRect(-180.0, -180.0, 180.0, 180.0)));
    }

    @Override
    public CoordinateSystem getDisplayCoordinateSystem() {
        return this.coordinateSystem;
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        final MapProjectionDisplay navDisplay = args.length > 0 && Util.canDoJava3D() ? MapProjectionDisplay.getInstance(0) : (Util.canDoJava3D() ? MapProjectionDisplay.getInstance(2) : MapProjectionDisplay.getInstance(1));
        DisplayImpl display = (DisplayImpl)navDisplay.getDisplay();
        navDisplay.setBackground(Color.white);
        navDisplay.setForeground(Color.black);
        MapLines mapLines = new MapLines("maplines");
        URL mapSource = navDisplay.getClass().getResource("/auxdata/maps/OUTLSUPW");
        try {
            BaseMapAdapter mapAdapter = new BaseMapAdapter(mapSource);
            mapLines.setMapLines(mapAdapter.getData());
            mapLines.setColor(Color.black);
            navDisplay.addDisplayable(mapLines);
        }
        catch (Exception excp) {
            System.out.println("Can't open map file " + mapSource);
            System.out.println(excp);
        }
        JPanel panel = new JPanel(new GridLayout(1, 0));
        JButton pushme = new JButton("Map Projection Manager");
        panel.add(pushme);
        frame.getContentPane().add((Component)panel, "North");
        ViewpointControl vpc = new ViewpointControl(navDisplay);
        panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(navDisplay.getComponent(), "Center");
        panel.add((Component)(navDisplay.getDisplayMode() == 0 ? GuiUtils.topCenterBottom(vpc.getToolBar(1), new NavigatedDisplayToolBar(navDisplay, 1), GuiUtils.filler()) : new NavigatedDisplayToolBar(navDisplay, 1)), "West");
        JPanel readout = new JPanel();
        readout.add(new NavigatedDisplayCursorReadout(navDisplay));
        readout.add(new RangeAndBearingReadout(navDisplay));
        panel.add((Component)readout, "South");
        navDisplay.draw();
        frame.getContentPane().add((Component)panel, "Center");
        if (navDisplay.getDisplayMode() == 0) {
            JMenuBar mb = new JMenuBar();
            mb.add(vpc.getMenu());
            frame.setJMenuBar(mb);
        }
        System.out.println("Using rectilinear projection");
        final ProjectionManager pm = new ProjectionManager();
        pm.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("ProjectionImpl")) {
                    try {
                        navDisplay.setMapProjection((ProjectionImpl)e.getNewValue());
                    }
                    catch (Exception exp) {
                        System.out.println(exp);
                    }
                }
            }
        });
        pushme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pm.show();
            }
        });
        navDisplay.getDisplay().getGraphicsModeControl().setScaleEnable(true);
        frame.pack();
        frame.setVisible(true);
    }

    protected class MapProjection3DAdapter
    extends CoordinateSystem
    implements InverseLinearScaledCS {
        private final int latIndex;
        private final int lonIndex;
        private final MapProjection mapProjection;
        private final double offsetX;
        private final double offsetY;
        private final double scaleX;
        private final double scaleY;
        private CoordinateSystem theCoordinateSystem;
        private final int xIndex;
        private final int yIndex;

        public MapProjection3DAdapter(MapProjection mapProjection) throws VisADException {
            super(Display.DisplaySpatialCartesianTuple, new Unit[]{CommonUnit.degree, CommonUnit.degree, null});
            this.mapProjection = mapProjection;
            this.theCoordinateSystem = new CachingCoordinateSystem(this.mapProjection);
            this.latIndex = mapProjection.getLatitudeIndex();
            this.lonIndex = mapProjection.getLongitudeIndex();
            if (mapProjection.isXYOrder()) {
                this.xIndex = 0;
                this.yIndex = 1;
            } else {
                this.xIndex = 1;
                this.yIndex = 0;
            }
            Rectangle2D bounds = mapProjection.getDefaultMapArea();
            this.scaleX = bounds.getWidth() / 2.0;
            this.scaleY = bounds.getHeight() / 2.0;
            this.offsetX = bounds.getX() + this.scaleX;
            this.offsetY = bounds.getY() + this.scaleY;
        }

        @Override
        public double[][] toReference(double[][] latlonalt) throws VisADException {
            if (latlonalt == null || latlonalt[0].length < 1) {
                return latlonalt;
            }
            int numpoints = latlonalt[0].length;
            this.call1("toReference(d)", numpoints);
            Object t2 = new double[2][];
            t2[this.latIndex] = latlonalt[0];
            t2[this.lonIndex] = latlonalt[1];
            if (MapProjectionDisplay.this.adjustLons) {
                double[] dArray = t2[this.lonIndex] = MapProjectionDisplay.this.use360 ? GeoUtils.normalizeLongitude360(latlonalt[1]) : GeoUtils.normalizeLongitude(latlonalt[1]);
            }
            if ((t2 = (Object)this.theCoordinateSystem.fromReference((double[][])t2)) == null) {
                throw new VisADException("MapProjection.toReference: Can't do (lat,lon) to (x,y) transformation");
            }
            double[] t2x = t2[this.xIndex];
            double[] t2y = t2[this.yIndex];
            for (int i = 0; i < numpoints; ++i) {
                double y;
                double x;
                if (Double.isNaN(t2x[i]) || Double.isNaN(t2y[i])) {
                    x = Double.NaN;
                    y = Double.NaN;
                } else {
                    x = (t2x[i] - this.offsetX) / this.scaleX;
                    y = (t2y[i] - this.offsetY) / this.scaleY;
                }
                latlonalt[0][i] = x;
                latlonalt[1][i] = y;
            }
            this.call2("toReference(d)", numpoints);
            return latlonalt;
        }

        void call1(String msg, int numpoints) {
            if (numpoints > 10000) {
                Trace.call1("MapProjectionDisplay." + msg, " numpoints = " + numpoints);
            }
        }

        void call2(String msg, int numpoints) {
            if (numpoints > 10000) {
                Trace.call2("MapProjectionDisplay." + msg);
            }
        }

        @Override
        public float[][] toReference(float[][] latlonalt) throws VisADException {
            if (latlonalt == null || latlonalt[0].length < 1) {
                return latlonalt;
            }
            int numpoints = latlonalt[0].length;
            this.call1("toReference(f)", numpoints);
            Object t2 = new float[2][];
            t2[this.latIndex] = latlonalt[0];
            t2[this.lonIndex] = latlonalt[1];
            if (MapProjectionDisplay.this.adjustLons) {
                float[] fArray = t2[this.lonIndex] = MapProjectionDisplay.this.use360 ? GeoUtils.normalizeLongitude360(latlonalt[1]) : GeoUtils.normalizeLongitude(latlonalt[1]);
            }
            if ((t2 = (Object)this.theCoordinateSystem.fromReference((float[][])t2)) == null) {
                throw new VisADException("MapProjection.toReference: Can't do (lat,lon) to (x,y) transformation");
            }
            float[] t2ax = t2[this.xIndex];
            float[] t2ay = t2[this.yIndex];
            for (int i = 0; i < numpoints; ++i) {
                float y;
                float x;
                float t2x = t2ax[i];
                float t2y = t2ay[i];
                if (t2x != t2x || t2y != t2y) {
                    x = Float.NaN;
                    y = Float.NaN;
                } else {
                    x = (float)(((double)t2x - this.offsetX) / this.scaleX);
                    y = (float)(((double)t2y - this.offsetY) / this.scaleY);
                }
                latlonalt[0][i] = x;
                latlonalt[1][i] = y;
            }
            this.call2("toReference(f)", numpoints);
            return latlonalt;
        }

        @Override
        public double[][] fromReference(double[][] xyz) throws VisADException {
            if (xyz == null || xyz[0].length < 1) {
                return xyz;
            }
            int numpoints = xyz[0].length;
            this.call1("fromReference(d)", numpoints);
            for (int i = 0; i < numpoints; ++i) {
                if (Double.isNaN(xyz[0][i]) || Double.isNaN(xyz[0][i])) continue;
                xyz[0][i] = xyz[0][i] * this.scaleX + this.offsetX;
                xyz[1][i] = xyz[1][i] * this.scaleY + this.offsetY;
            }
            Object t2 = new double[][]{xyz[this.xIndex], xyz[this.yIndex]};
            if ((t2 = (Object)this.theCoordinateSystem.toReference((double[][])t2)) == null) {
                throw new VisADException("MapProjection.toReference: Can't do (x,y) to (lat,lon) transformation");
            }
            xyz[0] = t2[this.latIndex];
            xyz[1] = t2[this.lonIndex];
            if (MapProjectionDisplay.this.adjustLons) {
                xyz[1] = MapProjectionDisplay.this.use360 ? GeoUtils.normalizeLongitude360(t2[this.lonIndex]) : GeoUtils.normalizeLongitude(t2[this.lonIndex]);
            }
            this.call2("fromReference(d)", numpoints);
            return xyz;
        }

        @Override
        public float[][] fromReference(float[][] xyz) throws VisADException {
            if (xyz == null || xyz[0].length < 1) {
                return xyz;
            }
            int numpoints = xyz[0].length;
            this.call1("fromReference(f)", numpoints);
            for (int i = 0; i < numpoints; ++i) {
                if (Float.isNaN(xyz[0][i]) || Float.isNaN(xyz[0][i])) continue;
                xyz[0][i] = (float)((double)xyz[0][i] * this.scaleX + this.offsetX);
                xyz[1][i] = (float)((double)xyz[1][i] * this.scaleY + this.offsetY);
            }
            Object t2 = new float[][]{xyz[this.xIndex], xyz[this.yIndex]};
            if ((t2 = (Object)this.theCoordinateSystem.toReference((float[][])t2)) == null) {
                throw new VisADException("MapProjection.toReference: Can't do (x,y) to (lat,lon) transformation");
            }
            xyz[0] = t2[this.latIndex];
            xyz[1] = t2[this.lonIndex];
            if (MapProjectionDisplay.this.adjustLons) {
                xyz[1] = MapProjectionDisplay.this.use360 ? GeoUtils.normalizeLongitude360(t2[this.lonIndex]) : GeoUtils.normalizeLongitude(t2[this.lonIndex]);
            }
            this.call2("fromReference(f)", numpoints);
            return xyz;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof MapProjection3DAdapter)) {
                return false;
            }
            MapProjection3DAdapter that = (MapProjection3DAdapter)obj;
            return that.mapProjection.equals(this.mapProjection);
        }

        public MapProjection getMapProjection() {
            return this.mapProjection;
        }

        @Override
        public double[] getScale() {
            return new double[]{this.scaleX, this.scaleY};
        }

        @Override
        public double[] getOffset() {
            return new double[]{this.offsetX, this.offsetY};
        }

        @Override
        public CoordinateSystem getInvertedCoordinateSystem() {
            return this.mapProjection;
        }
    }
}

