/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import ucar.unidata.ui.FontSelector;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.view.geoloc.LatLonAxisScaleInfo;
import ucar.unidata.view.geoloc.MapProjectionDisplay;

public class LatLonScalePanel
extends JPanel
implements ActionListener {
    private JComboBox coordFormat;
    private JTextField latBaseLabel;
    private JTextField latIncrement;
    private JTextField latLabel;
    private JSpinner latMinorSpinner;
    private LatLonAxisScaleInfo latScaleInfo;
    private JTextField lonBaseLabel;
    private JTextField lonIncrement;
    private JTextField lonLabel;
    private JSpinner lonMinorSpinner;
    private LatLonAxisScaleInfo lonScaleInfo;
    private MapProjectionDisplay mpDisplay;
    JFrame parent;
    private JCheckBox xVisible;
    private JCheckBox yVisible;
    private JCheckBox use360;
    private FontSelector fontSelector;
    private JCheckBox labelRelief;

    public LatLonScalePanel(MapProjectionDisplay mpDisplay) {
        this.mpDisplay = mpDisplay;
        this.parent = GuiUtils.getFrame(mpDisplay.getComponent());
        this.latScaleInfo = mpDisplay.getLatScaleInfo();
        this.lonScaleInfo = mpDisplay.getLonScaleInfo();
        this.doMakeContents();
    }

    protected void doMakeContents() {
        this.setLayout(new BorderLayout());
        GuiUtils.tmpInsets = new Insets(5, 5, 0, 0);
        this.fontSelector = new FontSelector(0, false, false);
        Component[] componentArray = new Component[10];
        componentArray[0] = GuiUtils.rLabel("Label: ");
        this.latLabel = new JTextField();
        componentArray[1] = this.latLabel;
        componentArray[2] = GuiUtils.rLabel("Base (-90 90): ");
        this.latBaseLabel = new JTextField();
        componentArray[3] = this.latBaseLabel;
        componentArray[4] = GuiUtils.rLabel("Major Increment: ");
        this.latIncrement = new JTextField();
        componentArray[5] = this.latIncrement;
        componentArray[6] = GuiUtils.rLabel("Minor Division: ");
        this.latMinorSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 10, 1));
        componentArray[7] = this.latMinorSpinner;
        componentArray[8] = GuiUtils.rLabel("Visible: ");
        this.yVisible = new JCheckBox("", true);
        componentArray[9] = this.yVisible;
        JPanel latPanel = GuiUtils.doLayout(componentArray, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        Component[] componentArray2 = new Component[10];
        componentArray2[0] = GuiUtils.rLabel("Label: ");
        this.lonLabel = new JTextField();
        componentArray2[1] = this.lonLabel;
        componentArray2[2] = GuiUtils.rLabel("Base (-180 180): ");
        this.lonBaseLabel = new JTextField();
        componentArray2[3] = this.lonBaseLabel;
        componentArray2[4] = GuiUtils.rLabel("Major Increment: ");
        this.lonIncrement = new JTextField();
        componentArray2[5] = this.lonIncrement;
        componentArray2[6] = GuiUtils.rLabel("Minor Division: ");
        this.lonMinorSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 10, 1));
        componentArray2[7] = this.lonMinorSpinner;
        componentArray2[8] = GuiUtils.rLabel("Visible: ");
        this.xVisible = new JCheckBox("", true);
        componentArray2[9] = this.xVisible;
        JPanel lonPanel = GuiUtils.doLayout(componentArray2, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        latPanel.setBorder(BorderFactory.createTitledBorder("Latitude"));
        lonPanel.setBorder(BorderFactory.createTitledBorder("Longitude"));
        JPanel fontPanel = GuiUtils.doLayout(new Component[]{GuiUtils.left(this.fontSelector.getComponent())}, 1, GuiUtils.WT_N, GuiUtils.WT_N);
        fontPanel.setBorder(BorderFactory.createTitledBorder("Font"));
        Component[] componentArray3 = new Component[4];
        componentArray3[0] = GuiUtils.rLabel("Format: ");
        componentArray3[1] = this.coordFormat = new JComboBox<String>(LatLonAxisScaleInfo.COORD_FORMATS);
        componentArray3[2] = GuiUtils.rLabel(" 0-360 Longitude");
        this.use360 = new JCheckBox("", false);
        componentArray3[3] = this.use360;
        JPanel formatPanel = GuiUtils.doLayout(componentArray3, 4, GuiUtils.WT_NY, GuiUtils.WT_N);
        Component[] componentArray4 = new Component[2];
        componentArray4[0] = GuiUtils.rLabel("Axis label relief:");
        this.labelRelief = new JCheckBox("", true);
        componentArray4[1] = this.labelRelief;
        JPanel reliefPanel = GuiUtils.doLayout(componentArray4, 4, GuiUtils.WT_NY, GuiUtils.WT_N);
        this.coordFormat.setEditable(true);
        this.coordFormat.setEnabled(true);
        JPanel latLonPanel = GuiUtils.doLayout(new Component[]{latPanel, lonPanel}, 1, GuiUtils.WT_NY, GuiUtils.WT_N);
        JPanel pnl = GuiUtils.doLayout(new Component[]{latLonPanel, GuiUtils.filler()}, 2, GuiUtils.WT_YY, GuiUtils.WT_N);
        List<Component> pnls = Arrays.asList(GuiUtils.left(pnl), GuiUtils.left(reliefPanel), GuiUtils.left(formatPanel), GuiUtils.left(fontPanel));
        this.add("Center", GuiUtils.doLayout(pnls, 1, 5, 5));
        if (this.latScaleInfo != null) {
            this.populateLatScaleInfo();
        }
        if (this.lonScaleInfo != null) {
            this.populateLonScaleInfo();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_OK)) {
            if (!this.doApply()) {
                return;
            }
            this.setVisible(false);
        } else if (cmd.equals(GuiUtils.CMD_APPLY)) {
            this.doApply();
        } else if (cmd.equals(GuiUtils.CMD_CANCEL)) {
            this.setVisible(false);
        }
    }

    private void populateLatScaleInfo() {
        this.latLabel.setText(this.latScaleInfo.getLabel());
        this.latBaseLabel.setText(Misc.format(this.latScaleInfo.getBaseLabel()));
        this.latIncrement.setText(Misc.format(this.latScaleInfo.getIncrement()));
        this.latMinorSpinner.setValue(this.latScaleInfo.getMinorDivision());
        this.yVisible.setSelected(this.latScaleInfo.isVisible());
        this.coordFormat.setSelectedItem(this.latScaleInfo.getCoordFormat());
        this.use360.setSelected(this.latScaleInfo.isUse360());
        this.labelRelief.setSelected(this.latScaleInfo.isLabelRelief());
        this.fontSelector.setFont(this.latScaleInfo.getFont());
    }

    private void populateLonScaleInfo() {
        this.lonLabel.setText(this.lonScaleInfo.getLabel());
        this.lonBaseLabel.setText(Misc.format(this.lonScaleInfo.getBaseLabel()));
        this.lonIncrement.setText(Misc.format(this.lonScaleInfo.getIncrement()));
        this.lonMinorSpinner.setValue(this.lonScaleInfo.getMinorDivision());
        this.xVisible.setSelected(this.lonScaleInfo.isVisible());
        this.coordFormat.setSelectedItem(this.lonScaleInfo.getCoordFormat());
        this.use360.setSelected(this.lonScaleInfo.isUse360());
        this.labelRelief.setSelected(this.lonScaleInfo.isLabelRelief());
        this.fontSelector.setFont(this.lonScaleInfo.getFont());
    }

    public boolean doApply() {
        LatLonAxisScaleInfo newLatInfo = new LatLonAxisScaleInfo();
        newLatInfo.setLabel(this.latLabel.getText());
        newLatInfo.setBaseLabel(Misc.parseNumber(this.latBaseLabel.getText()));
        newLatInfo.setIncrement(Misc.parseNumber(this.latIncrement.getText()));
        newLatInfo.setMinorDivision(Integer.valueOf(this.latMinorSpinner.getValue().toString()));
        newLatInfo.setVisible(this.yVisible.isSelected());
        newLatInfo.setCoordFormat(this.coordFormat.getSelectedItem() + "");
        newLatInfo.setFont(this.fontSelector.getFont());
        newLatInfo.setUse360(this.use360.isSelected());
        newLatInfo.setLabelRelief(this.labelRelief.isSelected());
        if (!newLatInfo.equals(this.latScaleInfo)) {
            this.latScaleInfo = newLatInfo;
        }
        LatLonAxisScaleInfo newLonInfo = new LatLonAxisScaleInfo();
        newLonInfo.setLabel(this.lonLabel.getText());
        newLonInfo.setBaseLabel(Misc.parseNumber(this.lonBaseLabel.getText()));
        newLonInfo.setIncrement(Misc.parseNumber(this.lonIncrement.getText()));
        newLonInfo.setMinorDivision(Integer.valueOf(this.lonMinorSpinner.getValue().toString()));
        newLonInfo.setVisible(this.xVisible.isSelected());
        newLonInfo.setCoordFormat(this.coordFormat.getSelectedItem() + "");
        newLonInfo.setFont(this.fontSelector.getFont());
        newLonInfo.setUse360(this.use360.isSelected());
        newLonInfo.setLabelRelief(this.labelRelief.isSelected());
        if (!newLonInfo.equals(this.lonScaleInfo)) {
            this.lonScaleInfo = newLonInfo;
        }
        this.mpDisplay.setDisplayInactive();
        try {
            this.mpDisplay.setLatScaleInfo(this.latScaleInfo);
            this.mpDisplay.setLonScaleInfo(this.lonScaleInfo);
            this.mpDisplay.setDisplayActive();
        }
        catch (Exception e) {
            LogUtil.userMessage("An error has occurred:" + e);
            return false;
        }
        return true;
    }

    public void setLatScaleInfo(LatLonAxisScaleInfo latScaleInfo) {
        this.latScaleInfo = latScaleInfo;
    }

    public void setLonScaleInfo(LatLonAxisScaleInfo lonScaleInfo) {
        this.lonScaleInfo = lonScaleInfo;
    }

    public boolean isLonVisible() {
        return this.xVisible.isSelected();
    }

    public boolean isLatVisible() {
        return this.yVisible.isSelected();
    }
}

