/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.util.ListenerManager;
import ucar.unidata.util.Msg;
import ucar.unidata.view.geoloc.NewProjectionEvent;
import ucar.unidata.view.geoloc.NewProjectionListener;
import ucar.unidata.view.geoloc.ProjectionManager;

public class JTableProjection
extends JTable {
    private ProjectionTableModel model = null;
    private boolean debug = false;
    private ListenerManager lm;
    private ProjectionManager projectionManager;
    boolean ignoreEvents = false;

    public JTableProjection(ProjectionManager manager, List list) {
        this.projectionManager = manager;
        this.model = new ProjectionTableModel(list);
        this.init();
        this.setToolTipText("<html>" + Msg.msg("Double-click to edit") + ";" + Msg.msg("Delete key to delete") + "</html>");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    JTableProjection.this.deleteSelected();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                if (e.getClickCount() > 1) {
                    JTableProjection.this.projectionManager.doEdit();
                }
            }
        });
    }

    public void setProjections(List list) {
        this.model = new ProjectionTableModel(list);
        this.setModel(this.model);
    }

    public JComponent getTopPanel() {
        JButton exportBtn = new JButton("Export");
        exportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JTableProjection.this.projectionManager.doExport();
            }
        });
        return exportBtn;
    }

    private void init() {
        this.setModel(this.model);
        this.setAutoResizeMode(2);
        this.setPreferredScrollableViewportSize(new Dimension(400, 200));
        this.getTableHeader().setReorderingAllowed(true);
        this.model.adjustColumns(this.getColumnModel());
        this.setSelectionMode(0);
        this.setCurrentProjection((ProjectionImpl)this.model.getProjections().get(0));
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JTableProjection.this.lm.sendEvent(new NewProjectionEvent(this, JTableProjection.this.getSelected()));
                }
            }
        });
        this.lm = new ListenerManager("ucar.unidata.view.geoloc.NewProjectionListener", "ucar.unidata.view.geoloc.NewProjectionEvent", "actionPerformed");
    }

    public List getProjections() {
        return this.model.getProjections();
    }

    public void addProjection(ProjectionImpl proj) {
        int rowno = this.model.addProjection(proj);
        this.setRowSelectionInterval(rowno, rowno);
    }

    public void replaceProjection(ProjectionImpl proj) {
        int rowno = this.model.replaceProjection(proj);
        this.setRowSelectionInterval(rowno, rowno);
    }

    public boolean contains(ProjectionImpl proj) {
        return this.model.search(proj) >= 0;
    }

    public boolean contains(String id) {
        return this.model.search(id) >= 0;
    }

    public ProjectionImpl getSelected() {
        List list = this.getProjections();
        int selectedRow = this.getSelectedRow();
        if (0 > selectedRow || list.size() <= selectedRow) {
            return null;
        }
        return (ProjectionImpl)list.get(selectedRow);
    }

    public void deleteSelected() {
        List list = this.getProjections();
        int selectedRow = this.getSelectedRow();
        if (selectedRow < 0 || selectedRow >= list.size()) {
            return;
        }
        this.model.deleteRow(selectedRow);
        list = this.getProjections();
        if (--selectedRow < 0) {
            selectedRow = 0;
        }
        if (selectedRow >= 0 && selectedRow < list.size()) {
            this.setRowSelectionInterval(selectedRow, selectedRow);
        }
        this.lm.sendEvent(new NewProjectionEvent(this, this.getSelected()));
        this.repaint();
    }

    public boolean isEmpty() {
        return this.model.getRowCount() == 0;
    }

    public void setMapArea(ProjectionRect bb) {
        int selectedRow = this.getSelectedRow();
        if (0 > selectedRow) {
            return;
        }
        this.model.setMapArea(selectedRow, bb);
        if (this.debug) {
            System.out.println(" PTsetMapArea = " + bb + " on " + selectedRow);
        }
    }

    public void setCurrentProjection(ProjectionImpl proj) {
        int row = this.model.search(proj);
        if (0 <= row) {
            if (this.debug) {
                System.out.println(" PTsetCurrentProjection found = " + row);
            }
            this.setRowSelectionInterval(row, row);
        } else {
            if (this.debug) {
                System.out.println(" PTsetCurrentProjection not found = " + row);
            }
            this.clearSelection();
        }
    }

    public void addNewProjectionListener(NewProjectionListener l) {
        this.lm.addListener(l);
    }

    public void removeNewProjectionListener(NewProjectionListener l) {
        this.lm.removeListener(l);
    }

    private class ProjectionTableModel
    extends AbstractTableModel {
        final int COLIDX_NAME = 0;
        final int COLIDX_CLASS = 1;
        final int COLIDX_PARAMS = 2;
        final int COLIDX_AREA = 3;
        private String[] COLNAMES = new String[]{"Name", "Type", "Parameters", "Default Zoom"};
        private List projections;

        ProjectionTableModel(List list) {
            if (list == null) {
                list = new ArrayList();
            }
            this.projections = list;
        }

        @Override
        public int getRowCount() {
            return this.projections.size();
        }

        @Override
        public int getColumnCount() {
            return this.COLNAMES.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.COLNAMES[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            ProjectionImpl proj = (ProjectionImpl)this.projections.get(row);
            switch (col) {
                case 0: {
                    return proj.getName();
                }
                case 1: {
                    return proj.getProjectionTypeLabel();
                }
                case 2: {
                    return proj.paramsToString();
                }
                case 3: {
                    return proj.getDefaultMapArea();
                }
            }
            return "error";
        }

        public List getProjections() {
            return this.projections;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ProjectionImpl proj = (ProjectionImpl)this.projections.get(rowIndex);
            if (columnIndex == 0) {
                proj.setName(aValue.toString());
            }
        }

        int addProjection(ProjectionImpl proj) {
            this.projections.add(proj);
            int count = this.projections.size() - 1;
            this.fireTableRowsInserted(count, count);
            return count;
        }

        int replaceProjection(ProjectionImpl proj) {
            int rowno = this.search(proj);
            if (rowno < 0) {
                return -1;
            }
            this.projections.set(rowno, proj);
            return rowno;
        }

        void adjustColumns(TableColumnModel colModel) {
            for (int i = 0; i < this.COLNAMES.length; ++i) {
                colModel.getColumn(i).setMinWidth(50);
                colModel.getColumn(i).setPreferredWidth(100);
            }
        }

        void deleteRow(int row) {
            int len = this.projections.size();
            if (row >= len) {
                return;
            }
            this.projections.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        int search(ProjectionImpl proj) {
            for (int row = 0; row < this.projections.size(); ++row) {
                ProjectionImpl test = (ProjectionImpl)this.projections.get(row);
                if (!proj.getName().equals(test.getName())) continue;
                return row;
            }
            return -1;
        }

        int search(String projName) {
            for (int row = 0; row < this.projections.size(); ++row) {
                ProjectionImpl test = (ProjectionImpl)this.projections.get(row);
                if (!projName.equals(test.getName())) continue;
                return row;
            }
            return -1;
        }

        void setMapArea(int row, ProjectionRect bb) {
            int len = this.projections.size();
            if (row >= len) {
                return;
            }
            ProjectionImpl proj = (ProjectionImpl)this.projections.get(row);
            proj.getDefaultMapArea().setRect(bb);
            this.fireTableRowsUpdated(row, row);
        }
    }
}

