/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.view.geoloc.VertScaleDialog;
import ucar.unidata.view.geoloc.VertScaleInfo;
import ucar.unidata.view.geoloc.ViewpointControl;
import visad.CommonUnit;
import visad.VisADException;

public class GlobeScaleDialog
extends VertScaleDialog {
    private JTextField valueFld;
    private JSlider vexSlider;
    private boolean ignoreUIEvents = false;
    private static final double EARTH_RADIUS = 6371229.0;

    public GlobeScaleDialog(JFrame parent, ViewpointControl control) {
        this(parent, control, null);
    }

    public GlobeScaleDialog(JFrame parent, ViewpointControl control, VertScaleInfo transfer) {
        super(parent, control, transfer);
    }

    @Override
    protected void doMakeContents() {
        this.setLayout(new BorderLayout());
        GuiUtils.tmpInsets = new Insets(5, 5, 0, 0);
        this.valueFld = new JTextField("   ", 6);
        this.valueFld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (GlobeScaleDialog.this.ignoreUIEvents) {
                    return;
                }
                try {
                    double vex = Misc.parseNumber(GlobeScaleDialog.this.valueFld.getText().trim());
                    GlobeScaleDialog.this.vexSlider.setValue((int)vex);
                }
                catch (NumberFormatException nfe) {
                    LogUtil.userMessage("Incorrect format: " + GlobeScaleDialog.this.valueFld.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.vexSlider = new JSlider(0, 1, 1000, 40);
        this.vexSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ae) {
                if (GlobeScaleDialog.this.ignoreUIEvents) {
                    return;
                }
                int vex = GlobeScaleDialog.this.vexSlider.getValue();
                GlobeScaleDialog.this.adjustSliderLabel(vex);
            }
        });
        JPanel p1 = GuiUtils.doLayout(new Component[]{this.vexSlider, this.valueFld}, 2, GuiUtils.WT_YN, GuiUtils.WT_N);
        p1.setBorder(BorderFactory.createTitledBorder("Vertical Exaggeration"));
        this.add("Center", GuiUtils.inset((Component)p1, 5));
        this.vertScaleInfo = this.vertScaleInfo;
        if (this.vertScaleInfo != null) {
            double radius = Math.abs(this.vertScaleInfo.minVertRange);
            if (this.vertScaleInfo.unit != null) {
                try {
                    radius = CommonUnit.meter.toThis(radius, this.vertScaleInfo.unit);
                }
                catch (VisADException ve) {
                    LogUtil.userMessage("Incompatible units for range " + this.vertScaleInfo.unit);
                }
            }
            this.setWidgetValues(this.radiusToVex(radius));
        }
    }

    private int radiusToVex(double radius) {
        if (radius == 0.0) {
            radius = 6371229.0;
        }
        if (radius < 0.0) {
            radius = Math.abs(radius);
        }
        return (int)(6371229.0 / radius);
    }

    private double vexToRadius(int vex) {
        if (vex <= 1) {
            vex = 1;
        }
        return 6371229.0 / (double)vex;
    }

    @Override
    public void showDialog(VertScaleInfo vertScaleInfo) {
        if (this.dialog == null) {
            JPanel buttons = GuiUtils.makeApplyOkCancelButtons(this);
            this.add("South", buttons);
            this.dialog = new JDialog(this.parent, "Set Vertical Exaggeration", false);
            this.dialog.getContentPane().add("Center", this);
            this.dialog.setSize(240, 100);
            this.dialog.pack();
            this.dialog.setLocation(100, 100);
        }
        this.vertScaleInfo = vertScaleInfo;
        this.setWidgetValues(this.radiusToVex(Math.abs(vertScaleInfo.maxVertRange)));
        this.dialog.setVisible(true);
    }

    @Override
    public boolean doApply() {
        int exagg;
        try {
            exagg = (int)Misc.parseNumber(this.valueFld.getText());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        double maxValue = this.vexToRadius(exagg);
        double minValue = -maxValue;
        VertScaleInfo newTransfer = new VertScaleInfo(minValue, maxValue, CommonUnit.meter);
        if (!Misc.equals(newTransfer, this.vertScaleInfo)) {
            this.vertScaleInfo = newTransfer;
            try {
                this.control.applyVerticalScale(this.vertScaleInfo);
            }
            catch (Exception exc) {
                LogUtil.userMessage("An error has occurred:" + exc);
                return false;
            }
        }
        return true;
    }

    private void adjustSliderLabel(int vex) {
        String value = Misc.format(vex);
        boolean lastIgnore = this.ignoreUIEvents;
        this.ignoreUIEvents = true;
        this.valueFld.setText(value);
        this.ignoreUIEvents = lastIgnore;
    }

    private void setWidgetValues(int vex) {
        this.vexSlider.setValue(vex);
        this.adjustSliderLabel(vex);
    }
}

