/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.view.geoloc.NavigatedDisplayCursorReadout;
import ucar.unidata.view.geoloc.NavigatedDisplayToolBar;
import ucar.unidata.view.geoloc.ProjectionManager;
import ucar.unidata.view.geoloc.ViewpointControl;
import ucar.visad.display.DisplayUtil;
import ucar.visad.display.Grid2DDisplayable;
import ucar.visad.display.MapLines;
import ucar.visad.display.RubberBandBox;
import ucar.visad.display.ScalarMapSet;
import ucar.visad.quantities.GeopotentialAltitude;
import visad.ActionImpl;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.FlatField;
import visad.FunctionType;
import visad.KeyboardBehavior;
import visad.MouseBehavior;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.VisADRay;
import visad.data.mcidas.BaseMapAdapter;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.MapProjection;
import visad.java3d.DefaultDisplayRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.KeyboardBehaviorJ3D;
import visad.java3d.ProjectionControlJ3D;

public class GlobeDisplay
extends NavigatedDisplay {
    public static String BOTTOM_VIEW_NAME = "Southern Hemisphere";
    public static String NORTH_VIEW_NAME = "Western Hemisphere";
    public static String EAST_VIEW_NAME = "Pacific Region";
    public static String TOP_VIEW_NAME = "Northern Hemisphere";
    public static String SOUTH_VIEW_NAME = "Eastern Hemisphere";
    public static String WEST_VIEW_NAME = "Atlantic Region";
    private ScalarMap latitudeMap = null;
    private ScalarMap longitudeMap = null;
    private ScalarMap altitudeMap = null;
    private double altitudeMin = -159000.0;
    private double altitudeMax = 159000.0;
    private boolean init = false;
    private CoordinateSystem coordinateSystem = Display.DisplaySphericalCoordSys;
    private Unit[] csUnits = null;
    private RealType verticalParameter = RealType.Altitude;
    private Real surface = new Real(RealType.Altitude, 0.0);
    private int view = 4;
    private boolean canDoStereo = false;
    private NavigatedDisplay.VerticalMapSet verticalMapSet = new NavigatedDisplay.VerticalMapSet(this);
    public static final double EARTH_RADIUS = 6371229.0;
    private static GraphicsConfiguration defaultConfig = GlobeDisplay.makeConfig();

    public GlobeDisplay() throws VisADException, RemoteException {
        this(false, null, null);
    }

    public GlobeDisplay(boolean offscreen, Dimension dimension, GraphicsDevice screen) throws VisADException, RemoteException {
        if (offscreen) {
            if (dimension == null) {
                dimension = new Dimension(600, 400);
            }
            this.setOffscreenDimension(dimension);
        }
        DisplayImplJ3D displayImpl = null;
        int api = offscreen ? 2 : 1;
        boolean useStereo = System.getProperty("idv.enableStereo", "false").equals("true");
        GraphicsConfiguration config = DisplayUtil.getPreferredConfig(screen, true, useStereo);
        DefaultDisplayRendererJ3D renderer = new DefaultDisplayRendererJ3D();
        renderer.setScaleRotation(true);
        renderer.setRotateAboutCenter(true);
        if (offscreen) {
            displayImpl = new DisplayImplJ3D("Globe Display", (DisplayRendererJ3D)renderer, dimension.width, dimension.height);
        } else {
            if (config == null) {
                LogUtil.userErrorMessage("Could not create a graphics configuration.\nPlease contact Unidata user support or see the FAQ");
                System.exit(1);
            }
            displayImpl = new DisplayImplJ3D("Globe Display", (DisplayRendererJ3D)renderer, api, config);
        }
        super.init(displayImpl);
        this.setBoxVisible(false);
        this.setSpatialScalarMaps();
        this.initializeClass();
    }

    @Override
    protected void initializeClass() throws VisADException, RemoteException {
        super.initializeClass();
        this.csUnits = this.coordinateSystem.getCoordinateSystemUnits();
        DisplayRendererJ3D rend = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        this.canDoStereo = rend.getCanvas().getStereoAvailable();
        this.setPerspectiveView(this.canDoStereo);
        this.checkClipDistance();
        this.setEyePosition(0.004);
        KeyboardBehaviorJ3D behavior = new KeyboardBehaviorJ3D(rend);
        rend.addKeyboardBehavior(behavior);
        this.setKeyboardBehavior(behavior);
        RubberBandBox rubberBandBox = new RubberBandBox(RealType.Latitude, RealType.Longitude, 1);
        rubberBandBox.addAction(new ActionImpl("RBB Action"){

            @Override
            public void doAction() throws VisADException, RemoteException {
                RubberBandBox box = GlobeDisplay.this.getRubberBandBox();
                if (box == null || box.getBounds() == null) {
                    return;
                }
                float[][] samples = box.getBounds().getSamples();
                if (samples == null) {
                    return;
                }
                ProjectionRect rect = new ProjectionRect(samples[1][0], samples[0][0], samples[1][1], samples[0][1]);
                GlobeDisplay.this.setMapArea(rect);
            }
        });
        this.setRubberBandBox(rubberBandBox);
        this.enableRubberBanding(true);
        this.setPolygonOffsetFactor(1);
    }

    @Override
    public String getTopViewName() {
        return TOP_VIEW_NAME;
    }

    @Override
    public String getBottomViewName() {
        return BOTTOM_VIEW_NAME;
    }

    @Override
    public String getNorthViewName() {
        return NORTH_VIEW_NAME;
    }

    @Override
    public String getEastViewName() {
        return EAST_VIEW_NAME;
    }

    @Override
    public String getSouthViewName() {
        return SOUTH_VIEW_NAME;
    }

    @Override
    public String getWestViewName() {
        return WEST_VIEW_NAME;
    }

    @Override
    public void addKeyboardBehavior(KeyboardBehavior behavior) {
        DisplayRendererJ3D rend = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        KeyboardBehaviorWrapper3D beh = new KeyboardBehaviorWrapper3D(rend, behavior);
        rend.addKeyboardBehavior(beh);
    }

    @Override
    protected void cursorMoved() throws VisADException, RemoteException {
        this.updateLocation(this.getEarthLocation(this.getDisplay().getDisplayRenderer().getCursor()));
    }

    @Override
    public EarthLocation screenToEarthLocation(int x, int y) throws VisADException {
        double[] xyz = this.getSpatialCoordinatesFromScreen(x, y, Double.NaN);
        EarthLocation el = this.getEarthLocation(xyz);
        return el;
    }

    @Override
    protected void pointerMoved(int x, int y) throws UnitException, VisADException, RemoteException {
        double[] xyz = this.getSpatialCoordinatesFromScreen(x, y, Double.NaN);
        EarthLocation el = this.getEarthLocation(xyz);
        double[] xyz2 = new double[3];
        xyz2 = this.getSpatialCoordinates(el, xyz2);
        this.setCursorLatitude(el.getLatitude());
        this.setCursorLongitude(el.getLongitude());
        this.setCursorAltitude(this.surface);
    }

    private void setSpatialScalarMaps() throws VisADException, RemoteException {
        if (!this.init) {
            this.setDisplayInactive();
            ScalarMapSet mapSet = new ScalarMapSet();
            this.latitudeMap = new ScalarMap(RealType.Latitude, Display.Latitude);
            mapSet.add(this.latitudeMap);
            this.latitudeMap.setRange(-90.0, 90.0);
            this.latitudeMap.setScaleEnable(false);
            this.longitudeMap = new ScalarMap(RealType.Longitude, Display.Longitude);
            mapSet.add(this.longitudeMap);
            this.longitudeMap.setRange(-180.0, 180.0);
            this.longitudeMap.setScaleEnable(false);
            this.altitudeMap = new ScalarMap(RealType.Altitude, Display.Radius);
            this.setVerticalRange(this.altitudeMin, this.altitudeMax);
            mapSet.add(this.altitudeMap);
            this.altitudeMap.setScaleEnable(false);
            ScalarMap xMap = new ScalarMap(RealType.XAxis, Display.XAxis);
            xMap.setRange(-1.0, 1.0);
            xMap.setScaleEnable(false);
            mapSet.add(xMap);
            ScalarMap yMap = new ScalarMap(RealType.YAxis, Display.YAxis);
            yMap.setRange(-1.0, 1.0);
            yMap.setScaleEnable(false);
            mapSet.add(yMap);
            ScalarMap zMap = new ScalarMap(RealType.ZAxis, Display.ZAxis);
            zMap.setRange(-1.0, 1.0);
            zMap.setScaleEnable(false);
            mapSet.add(zMap);
            this.init = true;
            this.addScalarMaps(mapSet);
            this.setDisplayActive();
        }
    }

    @Override
    public void setMapArea(ProjectionRect mapArea) throws VisADException, RemoteException {
        double centerLat = mapArea.getY() + mapArea.getHeight() / 2.0;
        double centerLon = mapArea.getX() + mapArea.getWidth() / 2.0;
        this.centerAndZoom(new EarthLocationTuple(centerLat, centerLon, 0.0), true, 2.0);
    }

    @Override
    public void setMapProjection(MapProjection mapProjection) throws VisADException, RemoteException {
    }

    @Override
    public DisplayRealType getDisplayLatitudeType() {
        return Display.Latitude;
    }

    @Override
    public DisplayRealType getDisplayLongitudeType() {
        return Display.Longitude;
    }

    @Override
    public DisplayRealType getDisplayAltitudeType() {
        return Display.Radius;
    }

    public DisplayTupleType getDisplayTupleType() {
        return Display.DisplaySpatialSphericalTuple;
    }

    @Override
    protected ScalarMap getAltitudeMap() {
        return this.altitudeMap;
    }

    protected void cursorChange() throws VisADException, RemoteException {
        this.setCursorLatitude(this.getCursorValue(RealType.Latitude, 0));
        this.setCursorLongitude(this.getCursorValue(RealType.Longitude, 1));
        Real fakeAltitude = this.getCursorValue(RealType.Radius, 2);
        double realValue = fakeAltitude.getValue() * (this.altitudeMax - this.altitudeMin) / 2.0 + this.altitudeMin;
        this.setCursorAltitude(new Real(RealType.Altitude, realValue));
    }

    @Override
    public void resetScaleTranslate() throws VisADException, RemoteException {
        double[] myMatrix = this.getProjectionMatrix();
        double[] trans = new double[]{0.0, 0.0, 0.0};
        double[] rot = new double[]{0.0, 0.0, 0.0};
        double[] rot2 = new double[]{0.0, 0.0, 0.0};
        double[] scale = new double[]{0.0, 0.0, 0.0};
        MouseBehavior mouseBehavior = this.getMouseBehavior();
        double[] saved = this.getDisplay().getProjectionControl().getSavedProjectionMatrix();
        mouseBehavior.instance_unmake_matrix(rot, scale, trans, myMatrix);
        mouseBehavior.instance_unmake_matrix(rot2, scale, trans, saved);
        double[] t = mouseBehavior.make_matrix(rot[0], rot[1], rot[2], scale[0], scale[1], scale[2], trans[0], trans[1], trans[2]);
        this.setProjectionMatrix(t);
    }

    @Override
    public void setView(int view) {
        try {
            ProjectionControlJ3D projControl = (ProjectionControlJ3D)this.getDisplay().getProjectionControl();
            switch (view) {
                case 0: {
                    projControl.setOrthoView(5);
                    break;
                }
                case 1: {
                    projControl.setOrthoView(2);
                    break;
                }
                case 2: {
                    projControl.setOrthoView(0);
                    break;
                }
                case 3: {
                    projControl.setOrthoView(4);
                    break;
                }
                case 4: {
                    projControl.setOrthoView(3);
                    break;
                }
                case 5: {
                    projControl.setOrthoView(1);
                    break;
                }
                default: {
                    projControl.setOrthoView(15);
                }
            }
            this.view = view;
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void enableClipping(boolean clip) {
        DisplayRendererJ3D dr = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        try {
            dr.setClip(0, clip, 1.0f, 0.0f, 0.0f, -1.01f);
            dr.setClip(1, clip, -1.0f, 0.0f, 0.0f, -1.01f);
            dr.setClip(2, clip, 0.0f, 1.0f, 0.0f, -1.01f);
            dr.setClip(3, clip, 0.0f, -1.0f, 0.0f, -1.01f);
            dr.setClip(4, clip, 0.0f, 0.0f, 1.0f, -1.01f);
            dr.setClip(5, clip, 0.0f, 0.0f, -1.0f, -1.01f);
        }
        catch (VisADException ve) {
            System.err.println("Couldn't set clipping " + ve);
        }
        super.enableClipping(clip);
    }

    @Override
    public View getView() {
        if (this.getDisplay() == null) {
            return null;
        }
        DisplayRendererJ3D rend = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        return rend.getView();
    }

    @Override
    public void setPerspectiveView(boolean perspectiveView) {
        if (perspectiveView == this.isPerspectiveView()) {
            return;
        }
        try {
            this.getDisplay().getGraphicsModeControl().setProjectionPolicy(perspectiveView ? 1 : 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setPerspectiveView(perspectiveView);
        this.checkClipDistance();
    }

    @Override
    public EarthLocation getEarthLocation(double x, double y, double z, boolean setZToZeroIfOverhead) {
        EarthLocationTuple value = null;
        try {
            float[][] numbers = Set.doubleToFloat(this.coordinateSystem.fromReference(new double[][]{{x}, {y}, {z}}));
            Real lat = new Real(RealType.Latitude, this.getScaledValue(this.latitudeMap, numbers[0][0]), this.csUnits[0]);
            Real lon = new Real(RealType.Longitude, this.getScaledValue(this.longitudeMap, numbers[1][0]), this.csUnits[1]);
            Real alt = new Real(RealType.Altitude, (double)this.getScaledValue(this.altitudeMap, numbers[2][0]));
            value = new EarthLocationTuple(lat, lon, alt);
        }
        catch (VisADException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public void centerAndZoom(EarthLocation el, Real altitude, double zoomFactor, boolean animated, boolean northUp) throws VisADException, RemoteException {
        if (zoomFactor == 0.0 || zoomFactor != zoomFactor) {
            zoomFactor = 1.0;
        }
        if (el.getLongitude().isMissing() || el.getLatitude().isMissing()) {
            return;
        }
        MouseBehavior mouseBehavior = this.getMouseBehavior();
        double[] currentMatrix = this.getProjectionMatrix();
        double[] trans = new double[]{0.0, 0.0, 0.0};
        double[] scale = new double[]{0.0, 0.0, 0.0};
        double[] scaletmp = new double[]{0.0, 0.0, 0.0};
        double[] rot1 = new double[]{0.0, 0.0, 0.0};
        double[] rot2 = new double[]{0.0, 0.0, 0.0};
        this.getMouseBehavior().instance_unmake_matrix(rot2, scale, trans, currentMatrix);
        double[] xy = this.getSpatialCoordinates(el, null);
        Transform3D t = new Transform3D();
        double[] xxx = this.getMouseBehavior().make_matrix(rot2[0], rot2[1], rot2[2], 1.0, 0.0, 0.0, 0.0);
        Transform3D t2 = new Transform3D(xxx);
        Vector3d upVector = new Vector3d(0.0, 0.0, (double)(northUp ? 1 : -1));
        t.lookAt(new Point3d(xy[0], xy[1], xy[2]), new Point3d(0.0, 0.0, 0.0), upVector);
        double[] m = new double[16];
        t.get(m);
        this.getMouseBehavior().instance_unmake_matrix(rot1, scaletmp, trans, m);
        if (zoomFactor != zoomFactor) {
            zoomFactor = 1.0;
        }
        m = this.getMouseBehavior().make_matrix(rot1[0], rot1[1], rot1[2], zoomFactor * scale[0], zoomFactor * scale[1], zoomFactor * scale[2], trans[0], trans[1], trans[2]);
        if (!animated) {
            this.setProjectionMatrix(m);
        } else {
            final double[] to = m;
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    GlobeDisplay.this.animateMatrix(++GlobeDisplay.this.animationTimeStamp, GlobeDisplay.this.getProjectionMatrix(), to, null);
                }
            });
        }
    }

    @Override
    public double[] getSpatialCoordinatesFromScreen(int x, int y, double zDepth) {
        try {
            VisADRay ray = this.getDisplay().getDisplayRenderer().getMouseBehavior().findRay(x, y);
            double x1 = ray.position[0];
            double x2 = ray.position[1];
            double x3 = ray.position[2];
            Vector v = this.getDisplay().getRenderers();
            if (!v.isEmpty()) {
                double[] direction;
                double[] origin;
                DataRenderer rend = (DataRenderer)v.get(0);
                float r = rend.findRayManifoldIntersection(true, origin = ray.position, direction = ray.vector, Display.DisplaySpatialSphericalTuple, 2, 1.0f);
                if (r != r) {
                    x1 = Double.NaN;
                    x2 = Double.NaN;
                    x3 = Double.NaN;
                } else {
                    float[][] xx = new float[][]{{(float)(origin[0] + (double)r * direction[0])}, {(float)(origin[1] + (double)r * direction[1])}, {(float)(origin[2] + (double)r * direction[2])}};
                    x1 = xx[0][0];
                    x2 = xx[1][0];
                    x3 = xx[2][0];
                }
            }
            return new double[]{x1, x2, zDepth == zDepth ? zDepth : x3};
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public RealTuple getSpatialCoordinates(EarthLocation el) {
        if (el == null) {
            throw new NullPointerException("MapProjectionDisplay.getSpatialCoorindate():  null input EarthLocation");
        }
        RealTuple spatialLoc = null;
        try {
            float[][] temp = this.coordinateSystem.toReference(new float[][]{this.latitudeMap.scaleValues(new double[]{el.getLatitude().getValue(CommonUnit.degree)}), this.longitudeMap.scaleValues(new double[]{el.getLongitude().getValue(CommonUnit.degree)}), this.altitudeMap.scaleValues(new double[]{el.getAltitude().getValue(CommonUnit.meter)})});
            double[] xyz = new double[]{temp[0][0], temp[1][0], temp[2][0]};
            spatialLoc = new RealTuple(RealTupleType.SpatialCartesian3DTuple, xyz);
        }
        catch (VisADException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return spatialLoc;
    }

    @Override
    public double[] getSpatialCoordinates(EarthLocation el, double[] xyz, double altitude) throws VisADException, RemoteException {
        float[][] temp = this.coordinateSystem.toReference(new float[][]{this.latitudeMap.scaleValues(new double[]{el.getLatitude().getValue(CommonUnit.degree)}), this.longitudeMap.scaleValues(new double[]{el.getLongitude().getValue(CommonUnit.degree)}), this.altitudeMap.scaleValues(new double[]{altitude})});
        if (xyz == null) {
            xyz = new double[]{temp[0][0], temp[1][0], temp[2][0]};
        }
        return xyz;
    }

    private Real getCursorValue(RealType realType, int index) {
        double[] cursor = this.getDisplay().getDisplayRenderer().getCursor();
        Real value = null;
        try {
            value = new Real(realType, this.coordinateSystem.fromReference(new double[][]{{cursor[0]}, {cursor[1]}, {cursor[2]}})[index][0], this.csUnits[index]);
        }
        catch (VisADException e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public void addVerticalMap(RealType newVertType) throws VisADException, RemoteException {
        Unit u = newVertType.getDefaultUnit();
        if (!Unit.canConvert(u, CommonUnit.meter) && !Unit.canConvert(u, GeopotentialAltitude.getGeopotentialMeter())) {
            throw new VisADException("Unable to handle units of " + newVertType);
        }
        ScalarMap newMap = new ScalarMap(newVertType, this.getDisplayAltitudeType());
        this.setVerticalMapUnit(newMap, this.getVerticalRangeUnit());
        double[] range = this.getVerticalRange();
        newMap.setRange(range[0], range[1]);
        this.verticalMapSet.add(newMap);
        this.addScalarMaps(this.verticalMapSet);
    }

    @Override
    public void removeVerticalMap(RealType vertType) throws VisADException, RemoteException {
        ScalarMapSet sms = new ScalarMapSet();
        Iterator iter = this.verticalMapSet.iterator();
        while (iter.hasNext()) {
            ScalarMap s = (ScalarMap)iter.next();
            if (!((RealType)s.getScalar()).equals(vertType)) continue;
            sms.add(s);
        }
        if (sms.size() != 0) {
            this.verticalMapSet.remove(sms);
            this.removeScalarMaps(sms);
        }
    }

    @Override
    public void setVerticalRangeUnit(Unit newUnit) throws VisADException, RemoteException {
        super.setVerticalRangeUnit(newUnit);
        if (newUnit != null && Unit.canConvert(newUnit, CommonUnit.meter)) {
            this.verticalMapSet.setVerticalUnit(newUnit);
        }
    }

    @Override
    public void setVerticalRange(double min, double max) throws VisADException, RemoteException {
        super.setVerticalRange(min, max);
        this.verticalMapSet.setVerticalRange(min, max);
    }

    @Override
    public boolean getStereoAvailable() {
        return this.canDoStereo;
    }

    private static GraphicsConfiguration makeConfig() {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
        if (System.getProperty("idv.enableStereo", "false").equals("true")) {
            template.setStereo(2);
        }
        GraphicsConfiguration c = d.getBestConfiguration((GraphicsConfigTemplate)template);
        return c;
    }

    @Override
    public void setEyePosition(double position) {
        DisplayRendererJ3D rend = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        PhysicalBody myBody = rend.getView().getPhysicalBody();
        myBody.setLeftEyePosition(new Point3d(-position, 0.0, 0.0));
        myBody.setRightEyePosition(new Point3d(position, 0.0, 0.0));
    }

    @Override
    public Rectangle2D.Double getLatLonBox() throws VisADException, RemoteException {
        Rectangle b = this.getScreenBounds();
        EarthLocation el1 = this.screenToEarthLocation(b.width / 2, 0);
        EarthLocation el2 = this.screenToEarthLocation(b.width / 2, b.height);
        EarthLocation el3 = this.screenToEarthLocation(0, b.height / 2);
        EarthLocation el4 = this.screenToEarthLocation(b.width, b.height / 2);
        if (el1 == null || el2 == null || el3 == null || el4 == null) {
            return new Rectangle2D.Double(-180.0, -90.0, 360.0, 180.0);
        }
        double[] v = new double[]{el1.getLatitude().getValue(), el2.getLatitude().getValue(), el3.getLatitude().getValue(), el4.getLatitude().getValue()};
        if (!(v[0] != 0.0 && v[0] == v[0] || v[1] != 0.0 && v[1] == v[1] || v[2] != 0.0 && v[2] == v[2] || v[3] != 0.0 && v[3] == v[3])) {
            return new Rectangle2D.Double(-180.0, -90.0, 360.0, 180.0);
        }
        return super.getLatLonBox();
    }

    @Override
    public CoordinateSystem getDisplayCoordinateSystem() {
        return this.coordinateSystem;
    }

    public EarthLocation getViewPointEarthLocation() {
        double[] viewPointXYZCoords = new double[]{0.0, 0.0, this.getZViewOffSet()};
        return this.whereIsTransformedXYZPoint(viewPointXYZCoords);
    }

    private EarthLocation whereIsTransformedXYZPoint(double[] xyzCoords) {
        Transform3D currentTransform = new Transform3D(this.getProjectionMatrix());
        currentTransform.invert();
        Point3d point3d = new Point3d(xyzCoords[0], xyzCoords[1], xyzCoords[2]);
        currentTransform.transform(point3d);
        return this.getEarthLocation(new double[]{point3d.x, point3d.y, point3d.z});
    }

    private double getZViewOffSet() {
        DisplayRendererJ3D rend = (DisplayRendererJ3D)this.getDisplay().getDisplayRenderer();
        View thisView = rend.getView();
        Transform3D t3d = new Transform3D();
        TransformGroup viewTrans = rend.getViewTrans();
        double[] vtMatrix = new double[16];
        viewTrans.getTransform(t3d);
        t3d.get(vtMatrix);
        return vtMatrix[11];
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        final GlobeDisplay navDisplay = new GlobeDisplay();
        if (args.length == 0) {
            MapLines mapLines = new MapLines("maplines");
            URL mapSource = navDisplay.getClass().getResource("/auxdata/maps/OUTLSUPW");
            try {
                BaseMapAdapter mapAdapter = new BaseMapAdapter(mapSource);
                mapLines.setMapLines(mapAdapter.getData());
                mapLines.setColor(Color.black);
                mapLines.addConstantMap(new ConstantMap(1.005, Display.Radius));
                navDisplay.addDisplayable(mapLines);
            }
            catch (Exception excp) {
                System.out.println("Can't open map file " + mapSource);
                System.out.println(excp);
            }
            Grid2DDisplayable sphere = new Grid2DDisplayable("sphere", false);
            FlatField sff = FlatField.makeField1(new FunctionType(RealTupleType.SpatialEarth2DTuple, RealType.getRealType("value")), 0.0, 360.0, 360, -90.0, 90.0, 180);
            sphere.setData(sff);
            navDisplay.addDisplayable(sphere);
        } else {
            navDisplay.enableRubberBanding(false);
            navDisplay.setBoxVisible(true);
        }
        JPanel panel = new JPanel(new GridLayout(1, 0));
        JButton pushme = new JButton("Map Projection Manager");
        panel.add(pushme);
        frame.getContentPane().add((Component)panel, "North");
        ViewpointControl vpc = new ViewpointControl(navDisplay);
        panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(navDisplay.getComponent(), "Center");
        JPanel comp = GuiUtils.topCenterBottom(vpc.getToolBar(1), new NavigatedDisplayToolBar(navDisplay, 1), GuiUtils.filler());
        panel.add((Component)comp, "West");
        panel.add((Component)new NavigatedDisplayCursorReadout(navDisplay), "South");
        navDisplay.draw();
        frame.getContentPane().add((Component)panel, "Center");
        if (navDisplay.getDisplayMode() == 0) {
            JMenuBar mb = new JMenuBar();
            mb.add(vpc.getMenu());
            frame.setJMenuBar(mb);
        }
        final ProjectionManager pm = new ProjectionManager();
        pm.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("ProjectionImpl")) {
                    try {
                        navDisplay.setMapProjection((ProjectionImpl)e.getNewValue());
                    }
                    catch (Exception exp) {
                        System.out.println(exp);
                    }
                }
            }
        });
        pushme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pm.show();
            }
        });
        navDisplay.getDisplay().getGraphicsModeControl().setScaleEnable(true);
        JCheckBox rotate = new JCheckBox("Rotate Display", false);
        rotate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                navDisplay.setAutoRotate(((JCheckBox)e.getSource()).isSelected());
            }
        });
        JButton vpWhere = new JButton("Where am I?");
        vpWhere.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("You are at " + navDisplay.getViewPointEarthLocation());
            }
        });
        JPanel p2 = new JPanel();
        p2.add(rotate);
        p2.add(vpWhere);
        frame.getContentPane().add("South", p2);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void setClipDistanceFront(double value) {
        super.setClipDistanceFront(value);
        this.checkClipDistance();
    }

    public void checkClipDistance() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        if (this.isPerspectiveView()) {
            view.setFrontClipDistance(CLIP_FRONT_PERSPECTIVE);
        } else {
            view.setFrontClipDistance(this.getClipDistanceFront());
        }
    }

    static class KeyboardBehaviorWrapper3D
    extends KeyboardBehaviorJ3D {
        KeyboardBehavior behavior;

        public KeyboardBehaviorWrapper3D(DisplayRendererJ3D rend, KeyboardBehavior behavior) {
            super(rend);
            this.behavior = behavior;
        }

        @Override
        public void mapKeyToFunction(int function, int keycode, int modifiers) {
            if (this.behavior != null) {
                this.behavior.mapKeyToFunction(function, keycode, modifiers);
            }
        }

        @Override
        public void processKeyEvent(KeyEvent event) {
            this.behavior.processKeyEvent(event);
        }

        @Override
        public void execFunction(int function) {
            this.behavior.execFunction(function);
        }
    }
}

