/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.geoloc;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoordinateFormat {
    public static final Format EMPTY_FORMAT = new EmptyFormat();
    private static final Pattern DEGREE_PATTERN = Pattern.compile("DD(\\.d+)?(:|\\s*)");
    private static final Pattern MINUTE_PATTERN = Pattern.compile("MM(\\.m+)?('|:|\\s*)");
    private static final Pattern SECOND_PATTERN = Pattern.compile("SS(\\.s+)?(\"|:|\\s*)");
    private static final Pattern CARDINALITY_PATTERN = Pattern.compile("H\\s*$");
    private static final Map<String, DegMinSec> DMS_ENUM_MAP = CoordinateFormat.enumMapifer(DegMinSec.class);

    private static String accuracy(int accuracy) {
        if (accuracy == 0) {
            return "00";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < accuracy; ++i) {
            sb.append("0");
        }
        return "00." + sb.toString();
    }

    public static String convert(double coord, Format degF, Format minF, Format secF, Cardinality card) {
        double coordAbs = Math.abs(coord);
        double minutes = (coordAbs - (double)((int)coordAbs)) * 60.0;
        double seconds = (minutes - (double)((int)minutes)) * 60.0;
        return (coord < 0.0 ? "-" : "") + degF.format(coordAbs) + minF.format(minutes) + secF.format(seconds) + (Object)((Object)card);
    }

    public static String formatLatitude(double value, String format) {
        Cardinality c;
        Matcher matcherCardinality = CARDINALITY_PATTERN.matcher(format);
        if (value == 0.0) {
            c = Cardinality.NONE;
        } else if (matcherCardinality.find()) {
            c = value > 0.0 ? Cardinality.NORTH : Cardinality.SOUTH;
            value = Math.abs(value);
        } else {
            c = Cardinality.NONE;
        }
        Iterator<Format> i = CoordinateFormat.tokenize(format).iterator();
        return CoordinateFormat.convert(value, i.next(), i.next(), i.next(), c);
    }

    public static String formatLongitude(double value, String format, boolean use360) {
        Cardinality c;
        Matcher matcherCardinality = CARDINALITY_PATTERN.matcher(format);
        if (value == 0.0) {
            c = Cardinality.NONE;
        } else if (use360) {
            value = value < 0.0 ? value + 360.0 : value;
            c = Cardinality.NONE;
        } else if (matcherCardinality.find()) {
            value = value > 180.0 ? value - 360.0 : value;
            c = value > 0.0 ? Cardinality.EAST : Cardinality.WEST;
            value = Math.abs(value);
        } else {
            value = value > 180.0 ? value - 360.0 : value;
            c = Cardinality.NONE;
        }
        Iterator<Format> i = CoordinateFormat.tokenize(format).iterator();
        return CoordinateFormat.convert(value, i.next(), i.next(), i.next(), c);
    }

    private static List<Format> tokenize(String tokens) {
        DegMinSec dms;
        int accuracy;
        String group;
        LinkedList<Format> l = new LinkedList<Format>();
        Matcher degreeMathcher = DEGREE_PATTERN.matcher(tokens);
        Matcher matcherMinute = MINUTE_PATTERN.matcher(tokens);
        Matcher matcherSecond = SECOND_PATTERN.matcher(tokens);
        boolean hasMinute = matcherMinute.find();
        boolean hasSecond = matcherSecond.find();
        if (degreeMathcher.find()) {
            group = degreeMathcher.group().trim();
            accuracy = group.length() - group.replaceAll("d", "").length();
            dms = DMS_ENUM_MAP.get(group.replaceAll("DD(\\.d+)?", ""));
            dms = dms.equals((Object)DegMinSec.NONE) && hasMinute ? DegMinSec.EMPTY : dms;
            l.add(accuracy == 0 && hasMinute ? new FloorCoordFormat(dms) : new DecimalCoordFormat(accuracy, dms));
        } else {
            l.add(EMPTY_FORMAT);
        }
        if (hasMinute) {
            group = matcherMinute.group().trim();
            accuracy = group.length() - group.replaceAll("m", "").length();
            dms = DMS_ENUM_MAP.get(group.replaceAll("MM(\\.m+)?", ""));
            dms = dms.equals((Object)DegMinSec.NONE) && hasSecond ? DegMinSec.EMPTY : dms;
            l.add(accuracy == 0 && hasSecond ? new FloorCoordFormat(dms) : new DecimalCoordFormat(accuracy, dms));
        } else {
            l.add(EMPTY_FORMAT);
        }
        if (hasSecond) {
            group = matcherSecond.group().trim();
            int charCount = group.length() - group.replaceAll("s", "").length();
            dms = DMS_ENUM_MAP.get(group.replaceAll("SS(\\.s+)?", ""));
            l.add(new DecimalCoordFormat(charCount, dms));
        } else {
            l.add(EMPTY_FORMAT);
        }
        return l;
    }

    private static <E extends Enum<E>> Map<String, E> enumMapifer(Class<E> clazz) {
        HashMap<String, Enum> map = new HashMap<String, Enum>();
        for (Enum e : (Enum[])clazz.getEnumConstants()) {
            map.put(e.toString(), e);
        }
        return Collections.unmodifiableMap(map);
    }

    public static class FloorCoordFormat
    implements Format {
        private final DegMinSec degminsec;

        public FloorCoordFormat(DegMinSec degminsec) {
            this.degminsec = degminsec;
        }

        @Override
        public String format(double number) {
            String d = this.degminsec.equals((Object)DegMinSec.MINUTE) ? (Object)((Object)this.degminsec) + "'" : (Object)((Object)this.degminsec) + "";
            DecimalFormat formatter = new DecimalFormat(CoordinateFormat.accuracy(0) + d);
            return formatter.format((int)number);
        }
    }

    private static class EmptyFormat
    implements Format {
        private EmptyFormat() {
        }

        @Override
        public String format(double number) {
            return "";
        }
    }

    public static class DecimalCoordFormat
    implements Format {
        private final int accuracy;
        private final DegMinSec degminsec;

        public DecimalCoordFormat(int accuracy, DegMinSec degminsec) {
            this.accuracy = accuracy;
            this.degminsec = degminsec;
        }

        @Override
        public String format(double number) {
            String d = this.degminsec.equals((Object)DegMinSec.MINUTE) ? (Object)((Object)this.degminsec) + "'" : (Object)((Object)this.degminsec) + "";
            DecimalFormat formatter = new DecimalFormat(CoordinateFormat.accuracy(this.accuracy) + d);
            return formatter.format(number);
        }
    }

    public static interface Format {
        public String format(double var1);
    }

    public static enum DegMinSec {
        DEGREE(" "),
        MINUTE("'"),
        SECOND("\""),
        COLON(":"),
        NONE(""),
        EMPTY(" ");

        private final String dms;

        private DegMinSec(String dms) {
            this.dms = dms;
        }

        public String toString() {
            return this.dms;
        }
    }

    public static enum Cardinality {
        NORTH("N"),
        SOUTH("S"),
        EAST("E"),
        WEST("W"),
        NONE("");

        private final String cardinality;

        private Cardinality(String cardinality) {
            this.cardinality = cardinality;
        }

        public String toString() {
            return this.cardinality;
        }
    }
}

