/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Hashtable;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.gis.GisFeatureRenderer;
import ucar.unidata.gis.mcidasmap.McidasMap;
import ucar.unidata.gis.shapefile.EsriShapefileRenderer;
import ucar.unidata.util.Debug;
import ucar.unidata.util.IOUtil;
import ucar.unidata.view.CompositeRenderer;
import ucar.unidata.view.Renderer;
import ucar.unidata.view.geoloc.NavigatedPanel;
import ucar.unidata.view.geoloc.NewMapAreaEvent;
import ucar.unidata.view.geoloc.NewMapAreaListener;

public class NPController {
    private NavigatedPanel navigatedPanel;
    private Renderer mainRenderer = null;
    private ProjectionImpl project;
    private AffineTransform atI = new AffineTransform();
    private boolean eventOk = true;
    private boolean debug = false;
    CompositeRenderer compositeRenderer;
    Hashtable renderers = new Hashtable();

    public NPController() {
        this.navigatedPanel = new NavigatedPanel();
        this.compositeRenderer = new CompositeRenderer();
        this.mainRenderer = this.compositeRenderer;
        this.project = this.navigatedPanel.getProjectionImpl();
        this.mainRenderer.setProjection(this.project);
        this.navigatedPanel.addNewMapAreaListener(new NewMapAreaListener(){

            @Override
            public void actionPerformed(NewMapAreaEvent e) {
                if (Debug.isSet("event.NewMapArea")) {
                    System.out.println("Controller got NewMapAreaEvent " + NPController.this.navigatedPanel.getMapArea());
                }
                if (NPController.this.eventOk && NPController.this.project.isLatLon()) {
                    ProjectionRect box = NPController.this.navigatedPanel.getMapArea();
                    LatLonProjection llproj = (LatLonProjection)NPController.this.project;
                    double center = llproj.getCenterLon();
                    double lonBeg = LatLonPointImpl.lonNormal(box.getMinX(), center);
                    double lonEnd = lonBeg + box.getMaxX() - box.getMinX();
                    boolean showShift = Debug.isSet("projection.LatLonShift");
                    if (showShift) {
                        System.out.println("projection.LatLonShift: min,max = " + box.getMinX() + " " + box.getMaxX() + " beg,end= " + lonBeg + " " + lonEnd + " center = " + center);
                    }
                    if (lonBeg < center - 180.0 || lonEnd > center + 180.0) {
                        double wx0 = box.getX() + box.getWidth() / 2.0;
                        llproj.setCenterLon(wx0);
                        double newWx0 = llproj.getCenterLon();
                        NPController.this.navigatedPanel.setWorldCenterX(newWx0);
                        if (showShift) {
                            System.out.println("projection.LatLonShift: shift center to " + wx0 + "->" + newWx0);
                        }
                        NPController.this.mainRenderer.setProjection(NPController.this.project);
                    }
                }
                NPController.this.draw(true);
            }
        });
    }

    public void removeMap(String mapPath) {
        Renderer renderer = (Renderer)this.renderers.get(mapPath);
        if (renderer != null) {
            this.compositeRenderer.removeRenderer(renderer);
            this.draw(true);
        }
    }

    public void addMap(String mapPath, Color c) {
        GisFeatureRenderer mapRenderer = null;
        try {
            mapRenderer = EsriShapefileRenderer.factory(IOUtil.getInputStream(mapPath, this.getClass()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mapRenderer == null) {
            mapRenderer = new McidasMap(mapPath);
        }
        if (mapRenderer != null) {
            mapRenderer.setProjection(this.navigatedPanel.getProjectionImpl());
            mapRenderer.setColor(c);
            this.compositeRenderer.addRenderer(mapRenderer);
            this.renderers.put(mapPath, mapRenderer);
            this.draw(true);
        }
    }

    public NavigatedPanel getNavigatedPanel() {
        return this.navigatedPanel;
    }

    public void setRenderer(Renderer r) {
        this.mainRenderer = r;
        this.mainRenderer.setProjection(this.project);
        this.draw(true);
    }

    public void setProjectionImpl(ProjectionImpl p) {
        this.project = p;
        this.mainRenderer.setProjection(p);
        this.eventOk = false;
        this.navigatedPanel.setProjectionImpl(p);
        this.navigatedPanel.setSelectedRegion(p.getDefaultMapArea());
        this.navigatedPanel.zoom(0.8);
        this.eventOk = true;
        this.draw(true);
    }

    private void draw(boolean complete) {
        if (this.mainRenderer == null || this.project == null) {
            return;
        }
        long tstart = System.currentTimeMillis();
        Graphics2D gNP = this.navigatedPanel.getBufferedImageGraphics();
        if (gNP == null) {
            return;
        }
        gNP.setBackground(this.navigatedPanel.getBackgroundColor());
        gNP.fill(gNP.getClipBounds());
        this.mainRenderer.draw(gNP, this.atI);
        gNP.dispose();
        if (this.debug) {
            long tend = System.currentTimeMillis();
            System.out.println("NPController draw time = " + (double)(tend - tstart) / 1000.0 + " secs");
        }
        this.navigatedPanel.repaint();
    }
}

