/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.view.Renderer;

public class CompositeRenderer
implements Renderer {
    ArrayList renderers = new ArrayList();

    public void addRenderer(Renderer r) {
        this.renderers.add(r);
    }

    public void removeRenderer(Renderer r) {
        this.renderers.remove(r);
    }

    @Override
    public void draw(Graphics2D g, AffineTransform pixelAT) {
        for (int i = 0; i < this.renderers.size(); ++i) {
            ((Renderer)this.renderers.get(i)).draw(g, pixelAT);
        }
    }

    @Override
    public void setProjection(ProjectionImpl project) {
        for (int i = 0; i < this.renderers.size(); ++i) {
            ((Renderer)this.renderers.get(i)).setProjection(project);
        }
    }

    @Override
    public void setColor(Color color) {
        for (int i = 0; i < this.renderers.size(); ++i) {
            ((Renderer)this.renderers.get(i)).setColor(color);
        }
    }

    @Override
    public Color getColor() {
        return ((Renderer)this.renderers.get(0)).getColor();
    }

    @Override
    public LatLonRect getPreferredArea() {
        return ((Renderer)this.renderers.get(0)).getPreferredArea();
    }
}

