/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.gis.WmsSelection;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;

public class WmsUtil {
    public static final String TAG_ABSTRACT = "Abstract";
    public static final String TAG_DIMENSION = "Dimension";
    public static final String TAG_LAYER = "Layer";
    public static final String TAG_LATLONBOUNDINGBOX = "LatLonBoundingBox";
    public static final String TAG_BOUNDINGBOX = "BoundingBox";
    public static final String TAG_SRS = "SRS";
    public static final String TAG_NAME = "Name";
    public static final String TAG_CRS = "CRS";
    public static final String TAG_TITLE = "Title";
    public static final String TAG_STYLE = "Style";
    public static final String TAG_CAPABILITY = "Capability";
    public static final String TAG_WMS1 = "WMT_MS_Capabilities";
    public static final String TAG_WMS2 = "WMS_Capabilities";
    public static final String ATTR_FIXEDWIDTH = "fixedWidth";
    public static final String ATTR_OPAQUE = "opaque";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_FIXEDHEIGHT = "fixedHeight";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_NOSUBSETS = "noSubsets";
    public static final String ATTR_MINX = "minx";
    public static final String ATTR_MAXX = "maxx";
    public static final String ATTR_MINY = "miny";
    public static final String ATTR_MAXY = "maxy";
    public static final String VALUE_TIME = "time";

    public static List<WmsSelection> processNode(Element root, List selectedNodes, String[] message, boolean mergeLayers) {
        String url;
        boolean doGet;
        Element formatNode;
        int i;
        String format = null;
        Element getMapNode = XmlUtil.findDescendantFromPath(root, "Capability.Request.GetMap");
        if (getMapNode == null) {
            getMapNode = XmlUtil.findDescendantFromPath(root, "Capability.Request.Map");
        }
        if (getMapNode == null) {
            message[0] = "No 'GetMap' section found";
            return null;
        }
        Element httpNode = XmlUtil.findDescendantFromPath(getMapNode, "DCPType.HTTP");
        if (httpNode == null) {
            message[0] = "No 'HTTP' section found";
            return null;
        }
        List formatNodes = XmlUtil.findChildren(getMapNode, "Format");
        Hashtable<String, String> formatMap = new Hashtable<String, String>();
        ArrayList<String> formats = new ArrayList<String>();
        for (i = 0; i < formatNodes.size() && format == null; ++i) {
            formatNode = (Element)formatNodes.get(i);
            String content = XmlUtil.getChildText(formatNode).toLowerCase();
            formats.add(content);
            formatMap.put(content, content);
        }
        if (format == null) {
            format = (String)formatMap.get("image/png; mode=24bit");
        }
        if (format == null) {
            format = (String)formatMap.get("image/png");
        }
        if (format == null) {
            format = (String)formatMap.get("image/jpeg");
        }
        if (format == null) {
            format = (String)formatMap.get("image/gif");
        }
        if (format == null) {
            for (i = 0; i < formatNodes.size() && format == null; ++i) {
                formatNode = (Element)formatNodes.get(i);
                if (XmlUtil.findChildren(formatNode, "PNG").size() > 0) {
                    format = "PNG";
                    break;
                }
                if (XmlUtil.findChildren(formatNode, "JPEG").size() > 0) {
                    format = "JPEG";
                    break;
                }
                if (XmlUtil.findChildren(formatNode, "GIF").size() <= 0) continue;
                format = "GIF";
                break;
            }
        }
        if (format == null) {
            message[0] = "No compatible image format found";
            return null;
        }
        Element getNode = XmlUtil.findDescendantFromPath(httpNode, "Get.OnlineResource");
        if (getNode == null) {
            getNode = XmlUtil.findDescendantFromPath(httpNode, "Get");
        }
        Element postNode = XmlUtil.findDescendantFromPath(httpNode, "Post.OnlineResource");
        if (getNode == null && postNode == null) {
            message[0] = "No 'Get' or 'Post'  section found";
            return null;
        }
        boolean bl = doGet = getNode != null;
        if (getNode == null) {
            getNode = postNode;
        }
        if ((url = XmlUtil.getAttribute((Node)getNode, "xlink:href", (String)null)) == null) {
            url = XmlUtil.getAttribute((Node)getNode, "onlineResource", (String)null);
        }
        if (url == null) {
            message[0] = "No 'href'  attribute found";
            return null;
        }
        double minx = -180.0;
        double maxx = 180.0;
        double miny = -90.0;
        double maxy = 90.0;
        int opaque = 0;
        int fixedWidth = -1;
        int fixedHeight = -1;
        boolean allowSubsets = true;
        String srsString = null;
        String error = null;
        String iconPath = null;
        List<String> timeList = null;
        String version = XmlUtil.getAttribute(root, ATTR_VERSION);
        ArrayList<WmsSelection> infos = new ArrayList<WmsSelection>();
        WmsSelection wmsSelection = null;
        for (int i2 = 0; i2 < selectedNodes.size(); ++i2) {
            Element styleNameNode;
            Element timeDimension;
            Element iconElement;
            Element styleNode;
            Element selectedNode = (Element)selectedNodes.get(i2);
            if (!WmsUtil.isLoadable(selectedNode)) continue;
            String title = WmsUtil.getLabel(selectedNode);
            Element layerNode = selectedNode;
            if (layerNode.getTagName().equals(TAG_STYLE)) {
                styleNode = layerNode;
                layerNode = (Element)layerNode.getParentNode();
            } else {
                styleNode = XmlUtil.findChild(layerNode, TAG_STYLE);
            }
            if (styleNode == null) {
                styleNode = layerNode;
            }
            if ((iconElement = XmlUtil.findDescendantFromPath(styleNode, "LegendURL.OnlineResource")) != null) {
                iconPath = XmlUtil.getAttribute((Node)iconElement, "xlink:href", (String)null);
            }
            if ((timeDimension = XmlUtil.findElement(styleNode, TAG_DIMENSION, ATTR_NAME, VALUE_TIME)) != null) {
                String timeText = XmlUtil.getChildText(timeDimension);
                timeList = StringUtil.split(timeText, "/");
            }
            if ((styleNameNode = XmlUtil.findChild(styleNode, TAG_NAME)) == null) {
                error = "No Name element found in Style element";
                System.err.println(XmlUtil.toString(styleNode).substring(0, 300));
                break;
            }
            Element nameNode = XmlUtil.getElement(layerNode, TAG_NAME);
            if (nameNode == null && (nameNode = XmlUtil.getElement(layerNode, TAG_TITLE)) == null) {
                error = "No name node found";
                break;
            }
            String style = XmlUtil.getChildText(styleNameNode);
            String layer = XmlUtil.getChildText(nameNode);
            List srsNodes = XmlUtil.findChildrenRecurseUp(layerNode, TAG_SRS);
            block3: for (int srsIdx = 0; srsIdx < srsNodes.size() && srsString == null; ++srsIdx) {
                String content = XmlUtil.getChildText((Element)srsNodes.get(srsIdx));
                if (content == null) continue;
                List<String> srsTokens = StringUtil.split(content, " ", true, true);
                if (srsTokens.size() == 0) {
                    srsString = "EPSG:4326";
                }
                for (int srsTokenIdx = 0; srsTokenIdx < srsTokens.size(); ++srsTokenIdx) {
                    String token = srsTokens.get(srsTokenIdx);
                    if (!token.equalsIgnoreCase("EPSG:4326")) continue;
                    srsString = token;
                    continue block3;
                }
            }
            if (srsString == null) {
                List crsNodes = XmlUtil.findChildrenRecurseUp(layerNode, TAG_CRS);
                block5: for (int crsIdx = 0; crsIdx < crsNodes.size() && srsString == null; ++crsIdx) {
                    String content = XmlUtil.getChildText((Element)crsNodes.get(crsIdx));
                    if (content == null) continue;
                    List<String> crsTokens = StringUtil.split(content, " ", true, true);
                    for (int crsTokenIdx = 0; crsTokenIdx < crsTokens.size(); ++crsTokenIdx) {
                        String token = crsTokens.get(crsTokenIdx);
                        if (!token.equalsIgnoreCase("CRS:84")) continue;
                        srsString = token;
                        continue block5;
                    }
                }
            }
            if (srsString == null) {
                error = "No compatible SRS found";
                break;
            }
            Element bboxNode = WmsUtil.findBbox(layerNode);
            if (bboxNode == null) {
                error = "No bbox node found";
                break;
            }
            minx = XmlUtil.getAttribute((Node)bboxNode, ATTR_MINX, minx);
            maxx = XmlUtil.getAttribute((Node)bboxNode, ATTR_MAXX, maxx);
            miny = XmlUtil.getAttribute((Node)bboxNode, ATTR_MINY, miny);
            maxy = XmlUtil.getAttribute((Node)bboxNode, ATTR_MAXY, maxy);
            opaque = XmlUtil.getAttribute((Node)layerNode, ATTR_OPAQUE, 0);
            fixedWidth = XmlUtil.getAttribute((Node)layerNode, ATTR_FIXEDWIDTH, -1);
            fixedHeight = XmlUtil.getAttribute((Node)layerNode, ATTR_FIXEDHEIGHT, -1);
            boolean bl2 = allowSubsets = XmlUtil.getAttribute((Node)layerNode, ATTR_NOSUBSETS, 0) != 1;
            if (!mergeLayers) {
                wmsSelection = null;
            }
            if (wmsSelection == null) {
                wmsSelection = new WmsSelection(url, layer, title, srsString, format, version, new GeoLocationInfo(maxy, minx, miny, maxx));
                Element abstractNode = XmlUtil.getElement(layerNode, TAG_ABSTRACT);
                if (abstractNode != null) {
                    String text = XmlUtil.getChildText(abstractNode);
                    wmsSelection.setDescription(text);
                }
                wmsSelection.setTimeList(timeList);
                wmsSelection.setLegendIcon(iconPath);
                wmsSelection.setAllowSubsets(allowSubsets);
                wmsSelection.setFixedWidth(fixedWidth);
                wmsSelection.setFixedHeight(fixedHeight);
                wmsSelection.setOpaque(opaque);
                infos.add(wmsSelection);
                continue;
            }
            wmsSelection.appendLayer(layer, new GeoLocationInfo(miny, maxx, maxy, minx));
        }
        if (error != null) {
            message[0] = error;
            return null;
        }
        if (infos.size() == 0) {
            message[0] = "None of the selected items are loadable";
            return null;
        }
        return infos;
    }

    public static String getLabel(Element node) {
        String tag = node.getTagName();
        String label = null;
        if (tag.equals(TAG_LAYER) || tag.equals(TAG_STYLE)) {
            label = XmlUtil.getGrandChildText(node, TAG_TITLE);
            return label;
        }
        return XmlUtil.getLocalName(node);
    }

    public static boolean isLoadable(Element node) {
        if (node.getTagName().equals(TAG_STYLE)) {
            return true;
        }
        return true;
    }

    public static Element findBbox(Element node) {
        Element bboxNode = XmlUtil.findChildRecurseUp(node, TAG_LATLONBOUNDINGBOX);
        if (bboxNode == null) {
            bboxNode = XmlUtil.findChildRecurseUp(node, TAG_BOUNDINGBOX);
        }
        return bboxNode;
    }
}

