/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.unidata.util.HtmlUtil;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;

public class WikiUtil {
    private Hashtable properties;
    private List categoryLinks = new ArrayList();
    private List floatBoxes = new ArrayList();
    private boolean makeHeadings = true;
    private boolean replaceNewlineWithP = true;

    public WikiUtil() {
    }

    public WikiUtil(Hashtable properties) {
        this.properties = properties;
    }

    public void removeProperty(Object key) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.remove(key);
    }

    public void putProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(key, value);
    }

    public void addCategoryLink(String link) {
        this.categoryLinks.add(link);
    }

    public Object getProperty(Object key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public String getInfoBox(String property) {
        StringBuffer sb = new StringBuffer();
        List<String> toks = StringUtil.split(property, "\n", true, true);
        String firstLine = toks.get(0);
        toks.remove(0);
        sb.append(HtmlUtil.open("table"));
        String title = "";
        for (String line : toks) {
            String[] toks2 = StringUtil.split(line, "=", 2);
            if (toks2 == null) continue;
            String name = toks2[0].trim();
            if (name.startsWith("|")) {
                name = name.substring(1).trim();
            }
            if (name.equals("name")) {
                title = toks2[1].trim();
                continue;
            }
            if (toks2[1].trim().length() <= 0) continue;
            sb.append(HtmlUtil.rowTop(HtmlUtil.col(name, HtmlUtil.cssClass("wiki-infobox-entry-title")) + HtmlUtil.col(toks2[1], HtmlUtil.cssClass("wiki-infobox-entry"))));
        }
        sb.append(HtmlUtil.close("table"));
        String div = HtmlUtil.makeShowHideBlock(title, sb.toString(), true, HtmlUtil.cssClass("wiki-infobox-title"), HtmlUtil.cssClass("wiki-infobox"));
        div = this.wikify(div, null);
        this.floatBoxes.add(div);
        return "";
    }

    public String getPropertyValue(String property) {
        if (property.startsWith("Infobox")) {
            return this.getInfoBox(property);
        }
        return null;
    }

    public String wikify(String s, WikiPageHandler handler) {
        int idx3;
        int idx2;
        int idx1;
        s = s.replace("\\\\[", "_BRACKETOPEN_");
        if (this.getReplaceNewlineWithP()) {
            s = s.replaceAll("\r\n\r\n", "\n<p>\n");
        }
        s = s.replaceAll("'''''([^']+)'''''", "<b><i>$1</i></b>");
        s = s.replaceAll("'''([^']+)'''", "<b>$1</b>");
        s = s.replaceAll("''([^']+)''", "<i>$1</i>");
        Pattern pattern = Pattern.compile("\\[\\[([^\\]|]+)\\|?([^\\]]*)\\]\\]");
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            String link;
            String name = matcher.group(1);
            String label = matcher.group(2);
            int start = matcher.start(0);
            int end = matcher.end(0);
            if (handler == null) {
                if (label.trim().length() == 0) {
                    label = name;
                }
                link = "<a href=\"" + name + "\">" + label + "</a>";
            } else {
                link = handler.getWikiLink(this, name, label);
            }
            s = s.substring(0, start) + link + s.substring(end);
            matcher = pattern.matcher(s);
        }
        int cnt = 0;
        pattern = Pattern.compile("\\[([^\\]]+)\\]");
        matcher = pattern.matcher(s);
        while (matcher.find()) {
            String name = matcher.group(1).trim();
            int idx = name.indexOf(" ");
            int start = matcher.start(0);
            int end = matcher.end(0);
            if (idx > 0) {
                String label = name.substring(idx);
                name = name.substring(0, idx);
                String ahref = "<a title=\"" + name + "\" class=\"wiki-link-external\" target=\"externalpage\" href=\"" + name + "\">";
                s = s.substring(0, start) + ahref + label + "</a>" + s.substring(end);
            } else {
                String ahref = "<a title=\"" + name + "\" class=\"wiki-link-external\" target=\"externalpage\" href=\"" + name + "\">";
                s = s.substring(0, start) + ahref + "_BRACKETOPEN_" + ++cnt + "_BRACKETCLOSE_</a>" + s.substring(end);
            }
            matcher = pattern.matcher(s);
        }
        ArrayList<Object[]> headings = new ArrayList<Object[]>();
        pattern = Pattern.compile("(?m)^\\s*(==+)([^=]+)(==+)\\s*$");
        matcher = pattern.matcher(s);
        while (matcher.find()) {
            String prefix = matcher.group(1).trim();
            String label = matcher.group(2).trim();
            int start = matcher.start(0);
            int end = matcher.end(0);
            int level = prefix.length();
            String value = "<a name=\"" + label + "\"></a><div class=\"wiki-h" + level + "\">" + label + "</div>";
            headings.add(new Object[]{new Integer(level), label});
            s = s.substring(0, start) + value + s.substring(end);
            matcher = pattern.matcher(s);
        }
        int ulCnt = 0;
        int olCnt = 0;
        StringBuffer buff = new StringBuffer();
        for (String line : StringUtil.split(s, "\n", false, false)) {
            String tline = line.trim();
            if (tline.equals("----")) {
                buff.append("<hr>");
                buff.append("\n");
                continue;
            }
            int starCnt = 0;
            while (tline.startsWith("*")) {
                tline = tline.substring(1);
                ++starCnt;
            }
            if (starCnt > 0) {
                if (starCnt > ulCnt) {
                    while (starCnt > ulCnt) {
                        buff.append("<ul>\n");
                        ++ulCnt;
                    }
                } else {
                    while (starCnt < ulCnt && ulCnt > 0) {
                        buff.append("</ul>\n");
                        --ulCnt;
                    }
                }
                buff.append("<li> ");
                buff.append(tline);
                buff.append("</li> ");
                buff.append("\n");
                continue;
            }
            while (ulCnt > 0) {
                buff.append("</ul>\n");
                --ulCnt;
            }
            int hashCnt = 0;
            while (tline.startsWith("#")) {
                tline = tline.substring(1);
                ++hashCnt;
            }
            if (hashCnt > 0) {
                if (hashCnt > olCnt) {
                    while (hashCnt > olCnt) {
                        buff.append("<ol>\n");
                        ++olCnt;
                    }
                } else {
                    while (hashCnt < olCnt && olCnt > 0) {
                        buff.append("</ol>\n");
                        --olCnt;
                    }
                }
                buff.append("<li> ");
                buff.append(tline);
                buff.append("\n");
                continue;
            }
            while (olCnt > 0) {
                buff.append("</ol>\n");
                --olCnt;
            }
            buff.append(line);
            buff.append("\n");
        }
        while (ulCnt > 0) {
            buff.append("</ul>\n");
            --ulCnt;
        }
        while (olCnt > 0) {
            buff.append("</ol>\n");
            --olCnt;
        }
        s = buff.toString();
        StringBuffer sb = new StringBuffer();
        int baseIdx = 0;
        while (true) {
            if ((idx1 = s.indexOf("{{", baseIdx)) < 0) {
                sb.append(s.substring(baseIdx));
                break;
            }
            idx2 = s.indexOf("}}", idx1);
            if (idx2 <= idx1) {
                sb.append(s.substring(baseIdx));
                break;
            }
            sb.append(s.substring(baseIdx, idx1));
            String property = s.substring(idx1 + 2, idx2);
            baseIdx = idx2 + 2;
            String value = null;
            if (handler != null) {
                value = handler.getWikiPropertyValue(this, property);
            }
            if (value == null) {
                value = "Unknown property:" + property;
            }
            sb.append(value);
        }
        s = sb.toString();
        sb = new StringBuffer();
        while ((idx1 = s.indexOf("<block")) >= 0 && (idx2 = s.indexOf(">", idx1)) >= 0 && (idx3 = s.indexOf("</block>", idx2)) >= 0) {
            String first = s.substring(0, idx1);
            String attrs = s.substring(idx1 + 6, idx2);
            String inner = s.substring(idx2 + 1, idx3);
            Hashtable props = StringUtil.parseHtmlProperties(attrs);
            boolean open = Misc.getProperty(props, "open", true);
            String title = Misc.getProperty(props, "title", "");
            sb.append(first);
            sb.append(HtmlUtil.makeShowHideBlock(title, inner, open, HtmlUtil.cssClass("wiki-blockheader"), HtmlUtil.cssClass("wiki-block")));
            s = s.substring(idx3 + "</block>".length());
        }
        sb.append(s);
        s = sb.toString();
        s = s.replace("_BRACKETOPEN_", "[");
        s = s.replace("_BRACKETCLOSE_", "]");
        if (this.getMakeHeadings() && headings.size() >= 4) {
            StringBuffer toc = new StringBuffer();
            WikiUtil.makeHeadings(headings, toc, -1, "");
            String block = HtmlUtil.makeShowHideBlock("Contents", toc.toString(), true, HtmlUtil.cssClass("wiki-tocheader"), HtmlUtil.cssClass("wiki-toc"));
            this.floatBoxes.add(block);
            String blocks = "<table class=\"wiki-toc-wrapper\" align=\"right\" width=\"30%\"><tr><td>" + StringUtil.join("<br>", this.floatBoxes) + "</td></tr></table>";
            s = blocks + s;
        }
        if (this.categoryLinks.size() > 0) {
            s = s + HtmlUtil.div("<b>Categories:</b> " + StringUtil.join("&nbsp;|&nbsp; ", this.categoryLinks), HtmlUtil.cssClass("wiki-categories"));
        }
        return s;
    }

    private static void makeHeadings(List headings, StringBuffer toc, int parentLevel, String parentPrefix) {
        int cnt = 0;
        int currentLevel = -1;
        String prefix = "";
        while (headings.size() > 0) {
            Object[] pair = (Object[])headings.get(0);
            int level = (Integer)pair[0];
            if (level > currentLevel && currentLevel >= 0) {
                WikiUtil.makeHeadings(headings, toc, currentLevel, prefix);
                continue;
            }
            if (level < currentLevel && parentLevel >= 0) {
                return;
            }
            headings.remove(0);
            String label = (String)pair[1];
            prefix = parentPrefix.length() > 0 ? parentPrefix + "." + cnt : "" + ++cnt;
            toc.append(StringUtil.repeat("&nbsp;&nbsp;", level - 1));
            toc.append("<a href=\"#" + label + "\">");
            toc.append(prefix);
            toc.append(HtmlUtil.space(1));
            toc.append(label);
            toc.append("</a><br>\n");
            currentLevel = level;
        }
    }

    public static void main(String[] args) {
        try {
            String contents = IOUtil.readContents(new File(args[0]));
            contents = new WikiUtil().wikify(contents, null);
            System.out.println("\ncontents:" + contents);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void setMakeHeadings(boolean value) {
        this.makeHeadings = value;
    }

    public boolean getMakeHeadings() {
        return this.makeHeadings;
    }

    public void setReplaceNewlineWithP(boolean value) {
        this.replaceNewlineWithP = value;
    }

    public boolean getReplaceNewlineWithP() {
        return this.replaceNewlineWithP;
    }

    public static interface WikiPageHandler {
        public String getWikiLink(WikiUtil var1, String var2, String var3);

        public String getWikiPropertyValue(WikiUtil var1, String var2);
    }
}

