/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;

public class Utils {
    public static int JGREG = 588829;
    public static double HALFSECOND = 0.5;

    public static Appendable append(Appendable sb, String s) {
        try {
            sb.append(s);
            return sb;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static boolean stringDefined(String s) {
        return s != null && s.trim().length() != 0;
    }

    public static double modifiedJulianToJulian(double modifiedJulian) {
        return modifiedJulian + 2400000.5;
    }

    public static double toJulian(int[] ymd) {
        int year = ymd[0];
        int month = ymd[1];
        int day = ymd[2];
        int julianYear = year;
        if (year < 0) {
            ++julianYear;
        }
        int julianMonth = month;
        if (month > 2) {
            ++julianMonth;
        } else {
            --julianYear;
            julianMonth += 13;
        }
        double julian = Math.floor(365.25 * (double)julianYear) + Math.floor(30.6001 * (double)julianMonth) + (double)day + 1720995.0;
        if (day + 31 * (month + 12 * year) >= JGREG) {
            int ja = (int)(0.01 * (double)julianYear);
            julian += (double)(2 - ja) + 0.25 * (double)ja;
        }
        return Math.floor(julian);
    }

    public static int[] fromJulian(double injulian) {
        return Utils.fromJulian(injulian, new int[3]);
    }

    public static int[] fromJulian(double injulian, int[] src) {
        double julian = injulian + HALFSECOND / 86400.0;
        int ja = (int)julian;
        if (ja >= JGREG) {
            int jalpha = (int)(((double)(ja - 1867216) - 0.25) / 36524.25);
            ja = ja + 1 + jalpha - jalpha / 4;
        }
        int jb = ja + 1524;
        int jc = (int)(6680.0 + ((double)(jb - 2439870) - 122.1) / 365.25);
        int jd = 365 * jc + jc / 4;
        int je = (int)((double)(jb - jd) / 30.6001);
        int day = jb - jd - (int)(30.6001 * (double)je);
        int month = je - 1;
        if (month > 12) {
            month -= 12;
        }
        int year = jc - 4715;
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            // empty if block
        }
        src[0] = --year;
        src[1] = month;
        src[2] = day;
        return src;
    }

    public static void testJulian(String[] args) {
        System.out.println("Julian date for May 23, 1968 : " + Utils.toJulian(new int[]{1968, 5, 23}));
        int[] results = Utils.fromJulian(Utils.toJulian(new int[]{1968, 5, 23}));
        System.out.println("... back to calendar : " + results[0] + " " + results[1] + " " + results[2]);
        Calendar today = Calendar.getInstance();
        double todayJulian = Utils.toJulian(new int[]{today.get(1), today.get(2) + 1, today.get(5)});
        System.out.println("Julian date for today : " + todayJulian);
        results = Utils.fromJulian(todayJulian);
        System.out.println("... back to calendar : " + results[0] + " " + results[1] + " " + results[2]);
        double date1 = Utils.toJulian(new int[]{2005, 1, 1});
        double date2 = Utils.toJulian(new int[]{2005, 1, 31});
        System.out.println("Between 2005-01-01 and 2005-01-31 : " + (date2 - date1) + " days");
    }

    public static String getArticle(String s) {
        if ((s = s.toLowerCase()).startsWith("a") || s.startsWith("e") || s.startsWith("i") || s.startsWith("o") || s.startsWith("u")) {
            return "an";
        }
        return "a";
    }

    public static Date extractDate(String s) {
        try {
            String yyyy = "\\d\\d\\d\\d";
            String str = StringUtil.findPattern(s, "(" + yyyy + "-\\d\\d-\\d\\d)");
            if (str != null) {
                return DateUtil.parse(str);
            }
            str = StringUtil.findPattern(s, "(" + yyyy + "\\d\\d\\d\\d-\\d\\d\\d\\d\\d\\d)");
            if (str != null) {
                try {
                    return new SimpleDateFormat("yyyyMMdd-HHmmss").parse(str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((str = StringUtil.findPattern(s, "(" + yyyy + "\\d\\d\\d\\d-\\d\\d\\d\\d)")) != null) {
                try {
                    return new SimpleDateFormat("yyyyMMdd-HHmm").parse(str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((str = StringUtil.findPattern(s, "[^\\d]*(" + yyyy + "\\d\\d\\d\\d)[^\\d]+")) != null) {
                try {
                    return new SimpleDateFormat("yyyyMMdd").parse(str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (Exception exc) {
            System.err.println("Utils.extractDate:" + exc);
            return null;
        }
    }

    public static Constructor findConstructor(Class c, Class[] paramTypes) {
        int i;
        ArrayList allCtors = new ArrayList();
        Constructor<?>[] constructors = c.getConstructors();
        if (constructors.length == 0) {
            System.err.println("*** Could not find any constructors for class:" + c.getName());
            return null;
        }
        for (i = 0; i < constructors.length; ++i) {
            if (!Utils.typesMatch(constructors[i].getParameterTypes(), paramTypes)) continue;
            allCtors.add(constructors[i]);
        }
        if (allCtors.size() > 1) {
            throw new IllegalArgumentException("More than one constructors matched for class:" + c.getName());
        }
        if (allCtors.size() == 1) {
            return (Constructor)allCtors.get(0);
        }
        for (i = 0; i < constructors.length; ++i) {
            Class<?>[] formals = constructors[i].getParameterTypes();
            for (int j = 0; j < formals.length; ++j) {
                System.err.println("param " + j + "  " + formals[j].getName() + " " + paramTypes[j].getName());
            }
        }
        return null;
    }

    public static boolean typesMatch(Class[] formals, Class[] actuals) {
        if (formals.length != actuals.length) {
            return false;
        }
        for (int j = 0; j < formals.length; ++j) {
            if (actuals[j] == null || formals[j].isAssignableFrom(actuals[j])) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String pattern = ".*l(.)(.)(\\d\\d\\d)(\\d\\d\\d)(\\d\\d\\d\\d)(\\d\\d\\d)(...)(\\d\\d)\\.hdf$";
        for (String a : args) {
            System.err.println("file:" + a + " " + a.toLowerCase().matches(pattern));
        }
    }

    public static String[] findPatterns(String s, String regexp) throws Exception {
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(s);
        if (!matcher.find()) {
            return null;
        }
        String[] results = new String[matcher.groupCount()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = matcher.group(i + 1);
        }
        return results;
    }

    public static Date findDate(String source, String[] datePatterns, String[] dateFormats) throws Exception {
        for (int dateFormatIdx = 0; dateFormatIdx < datePatterns.length; ++dateFormatIdx) {
            String dttm = StringUtil.findPattern(source, datePatterns[dateFormatIdx]);
            if (dttm == null) continue;
            dttm = dttm.replaceAll(" _ ", " ");
            dttm = dttm.replaceAll(" / ", "/");
            return Utils.makeDateFormat(dateFormats[dateFormatIdx]).parse(dttm);
        }
        return null;
    }

    public static SimpleDateFormat makeDateFormat(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf;
    }

    public static int getYear(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return cal.get(2);
    }

    public static String removeNonAscii(String s) {
        s = s.replaceAll("[^\r\n\\x20-\\x7E]+", "_");
        return s;
    }

    public static String getAttributeOrTag(Element node, String attrOrTag, String dflt) throws Exception {
        String attrValue = XmlUtil.getAttribute((Node)node, attrOrTag, (String)null);
        if (attrValue == null) {
            attrValue = XmlUtil.getGrandChildText(node, attrOrTag, dflt);
        }
        return attrValue;
    }

    public static boolean getAttributeOrTag(Element node, String attrOrTag, boolean dflt) throws Exception {
        String attrValue = Utils.getAttributeOrTag(node, attrOrTag, null);
        if (attrValue == null) {
            return dflt;
        }
        return attrValue.equals("true");
    }

    public static int getAttributeOrTag(Element node, String attrOrTag, int dflt) throws Exception {
        String attrValue = Utils.getAttributeOrTag(node, attrOrTag, null);
        if (attrValue == null) {
            return dflt;
        }
        return new Integer(attrValue);
    }

    public static double getAttributeOrTag(Element node, String attrOrTag, double dflt) throws Exception {
        String attrValue = Utils.getAttributeOrTag(node, attrOrTag, null);
        if (attrValue == null) {
            return dflt;
        }
        return new Double(attrValue);
    }

    public static String makeProperties(Hashtable properties) {
        StringBuffer sb = new StringBuffer();
        List keyList = new ArrayList<String>();
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            keyList.add((String)keys.nextElement());
        }
        keyList = Misc.sort(keyList);
        for (String key : keyList) {
            String value = (String)properties.get(key);
            sb.append(key);
            sb.append("=");
            sb.append(value);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static Hashtable<String, String> makeMap(String ... args) {
        Hashtable<String, String> map = new Hashtable<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            map.put(args[i], args[i + 1]);
        }
        return map;
    }

    public static Hashtable getProperties(String s) {
        Hashtable<String, String> p = new Hashtable<String, String>();
        for (String line : StringUtil.split(s, "\n", true, true)) {
            if (line.startsWith("#")) continue;
            List<String> toks = StringUtil.splitUpTo(line, "=", 2);
            if (toks.size() == 2) {
                p.put(toks.get(0), toks.get(1));
                continue;
            }
            if (toks.size() != 2) continue;
            p.put(toks.get(0), "");
        }
        return p;
    }

    public static String hexEncode(String s) {
        byte[] chars = s.getBytes();
        StringBuffer sb = new StringBuffer();
        for (byte c : chars) {
            sb.append("\\x");
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isImage(String path) {
        if (path == null) {
            return false;
        }
        if ((path = path.toLowerCase()).endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".gif") || path.endsWith(".png") || path.endsWith(".bmp")) {
            return true;
        }
        return path.startsWith("http") && path.indexOf("format=image") >= 0;
    }

    public static File[] sortFilesOnSize(File[] files, boolean ascending) {
        int i;
        ArrayList<IOUtil.FileWrapper> sorted = new ArrayList<IOUtil.FileWrapper>();
        for (i = 0; i < files.length; ++i) {
            sorted.add(new IOUtil.FileWrapper(files[i], ascending));
        }
        Collections.sort(sorted, new FileSizeCompare(ascending));
        for (i = 0; i < files.length; ++i) {
            files[i] = ((IOUtil.FileWrapper)sorted.get(i)).getFile();
        }
        return files;
    }

    public static String extractPatternNames(String filePatternString, List<String> patternNames) {
        ArrayList<String> names = new ArrayList<String>();
        String tmp = filePatternString;
        StringBuffer pattern = new StringBuffer();
        boolean gotAttributeInPattern = false;
        while (true) {
            int openParenIdx;
            if ((openParenIdx = tmp.indexOf("(")) < 0) {
                pattern.append(tmp);
                break;
            }
            int closeParenIdx = tmp.indexOf(")");
            if (closeParenIdx < openParenIdx) {
                pattern.append(tmp);
                break;
            }
            int colonIdx = tmp.indexOf(":");
            if (colonIdx < 0) {
                pattern.append(tmp);
                break;
            }
            if (closeParenIdx < colonIdx) {
                pattern.append(tmp.substring(0, closeParenIdx + 1));
                names.add("");
                tmp = tmp.substring(closeParenIdx + 1);
                continue;
            }
            pattern.append(tmp.substring(0, openParenIdx + 1));
            String name = tmp.substring(openParenIdx + 1, colonIdx);
            names.add(name);
            gotAttributeInPattern = true;
            pattern.append(tmp.substring(colonIdx + 1, closeParenIdx + 1));
            tmp = tmp.substring(closeParenIdx + 1);
        }
        if (!gotAttributeInPattern) {
            pattern = new StringBuffer(filePatternString);
            names = new ArrayList();
        }
        patternNames.addAll(names);
        return pattern.toString();
    }

    public static Image readImage(String file) {
        if (file == null) {
            return null;
        }
        try {
            InputStream is = IOUtil.getInputStream(file, Utils.class);
            if (is != null) {
                byte[] bytes = IOUtil.readBytes(is);
                Image image = Toolkit.getDefaultToolkit().createImage(bytes);
                image = ImageUtils.waitOnImage(image);
                return image;
            }
            System.err.println("Could not read image:" + file);
        }
        catch (Exception exc) {
            System.err.println(exc + " getting image:  " + file);
            return null;
        }
        return null;
    }

    public static double decodeLatLon(String latlon) {
        latlon = latlon.trim();
        int dirIndex = -1;
        int southOrWest = 1;
        double value = Double.NaN;
        if (latlon.indexOf("S") > 0) {
            southOrWest = -1;
            dirIndex = latlon.indexOf("S");
        } else if (latlon.indexOf("W") > 0) {
            southOrWest = -1;
            dirIndex = latlon.indexOf("W");
        } else if (latlon.indexOf("N") > 0) {
            dirIndex = latlon.indexOf("N");
        } else if (latlon.endsWith("E")) {
            dirIndex = latlon.lastIndexOf("E");
        }
        if (dirIndex > 0) {
            latlon = latlon.substring(0, dirIndex).trim();
        }
        if (latlon.indexOf("-") == 0) {
            southOrWest *= -1;
            latlon = latlon.substring(latlon.indexOf("-") + 1).trim();
        }
        if (latlon.indexOf(":") >= 0) {
            int firstIdx = latlon.indexOf(":");
            String hours = latlon.substring(0, firstIdx);
            String minutes = latlon.substring(firstIdx + 1);
            String seconds = "";
            if (minutes.indexOf(":") >= 0) {
                firstIdx = minutes.indexOf(":");
                String temp = minutes.substring(0, firstIdx);
                seconds = minutes.substring(firstIdx + 1);
                minutes = temp;
            }
            try {
                double d = value = hours.equals("") ? 0.0 : Double.parseDouble(hours);
                if (!minutes.equals("")) {
                    value += Double.parseDouble(minutes) / 60.0;
                }
                if (!seconds.equals("")) {
                    value += Double.parseDouble(seconds) / 3600.0;
                }
            }
            catch (NumberFormatException nfe) {
                value = Double.NaN;
            }
        } else {
            try {
                value = Double.parseDouble(latlon);
            }
            catch (NumberFormatException nfe) {
                value = Double.NaN;
            }
        }
        return value * (double)southOrWest;
    }

    public static Object safeGet(List list, int index) {
        if (list == null || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    private static class FileSizeCompare
    implements Comparator<IOUtil.FileWrapper> {
        private boolean ascending;

        public FileSizeCompare(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public int compare(IOUtil.FileWrapper o1, IOUtil.FileWrapper o2) {
            int result = o1.length() < o2.length() ? -1 : (o1.length() > o2.length() ? 1 : o1.getFile().compareTo(o1.getFile()));
            if (!this.ascending || result == 0) {
                return result;
            }
            return -result;
        }
    }
}

