/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;

public class Trace {
    private static Hashtable counters = new Hashtable();
    private static List counterList = new ArrayList();
    private static final Object MUTEX = new Object();
    public static boolean displayMsg = false;
    private static boolean showLineNumber = false;
    private static Hashtable accumTable = new Hashtable();
    private static Hashtable accumCntTable = new Hashtable();
    private static Hashtable accum1Table = new Hashtable();
    private static List accumList = new ArrayList();
    private static Hashtable ticks = new Hashtable();
    private static Hashtable mems = new Hashtable();
    private static Hashtable tabs = new Hashtable();
    private static Hashtable traceMsgs = new Hashtable();
    private static String lastThreadName = "";
    private static long initMemory = 0L;
    public static long lastMemory = 0L;
    public static long lastTime = 0L;
    static StringBuffer ts = new StringBuffer();
    static StringBuffer ms = new StringBuffer();
    static StringBuffer tms = new StringBuffer();
    static StringBuffer prefix = new StringBuffer();
    public static StringBuffer buff = new StringBuffer();
    private static List notThese = new ArrayList();
    private static List onlyThese = new ArrayList();

    public static List getNotThese() {
        return notThese;
    }

    public static List getOnlyThese() {
        return onlyThese;
    }

    public static void addNot(String pattern) {
        notThese.add(pattern);
    }

    public static void addOnly(String pattern) {
        onlyThese.add(pattern);
    }

    public static void removeOnly(String pattern) {
        onlyThese.remove(pattern);
    }

    public static void clearOnly() {
        onlyThese = new ArrayList();
    }

    static StringBuffer getBuffer() {
        Thread t = Thread.currentThread();
        StringBuffer sb = (StringBuffer)traceMsgs.get(t);
        if (sb == null) {
            sb = new StringBuffer();
            traceMsgs.put(t, sb);
        }
        return sb;
    }

    static Integer getTab() {
        Thread t = Thread.currentThread();
        Integer tab = (Integer)tabs.get(t);
        if (tab == null) {
            tab = new Integer(0);
            tabs.put(t, tab);
        }
        return tab;
    }

    static int getCurrentTab() {
        return Trace.getTab();
    }

    public static void setShowLineNumbers(boolean v) {
        showLineNumber = v;
    }

    public static void startTrace() {
        displayMsg = true;
        initMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static void stopTrace() {
        displayMsg = false;
    }

    public static boolean traceActive() {
        return displayMsg;
    }

    public static void deltaCurrentTab(int delta) {
        if (!displayMsg) {
            return;
        }
        int v = Trace.getCurrentTab();
        tabs.put(Thread.currentThread(), new Integer(v + delta));
    }

    public static String[] changeFilters() {
        String notTheseStr = StringUtil.join("\n", notThese);
        String onlyTheseStr = StringUtil.join("\n", onlyThese);
        JTextArea notTheseFld = new JTextArea(notTheseStr, 10, 50);
        JTextArea onlyTheseFld = new JTextArea(onlyTheseStr, 10, 50);
        JPanel contents = GuiUtils.vbox(new JLabel("Not these:"), GuiUtils.makeScrollPane(notTheseFld, 100, 50), new JLabel("Only these:"), GuiUtils.makeScrollPane(onlyTheseFld, 100, 50));
        if (!GuiUtils.showOkCancelDialog(null, "Trace filters", contents = GuiUtils.inset((Component)contents, 5), null)) {
            return null;
        }
        Trace.setFilters(notTheseFld.getText().trim(), onlyTheseFld.getText().trim());
        return new String[]{notTheseFld.getText().trim(), onlyTheseFld.getText().trim()};
    }

    public static void setFilters(String notTheseText, String onlyTheseText) {
        if (notTheseText != null) {
            notThese = StringUtil.split(notTheseText, "\n", true, true);
        }
        if (onlyTheseText != null) {
            onlyThese = StringUtil.split(onlyTheseText, "\n", true, true);
        }
    }

    private static boolean ok(String msg) {
        if (notThese.size() > 0 && StringUtil.findMatch(msg, notThese, null) != null) {
            return false;
        }
        return onlyThese.size() <= 0 || StringUtil.findMatch(msg, onlyThese, null) != null;
    }

    public static void call1(String m) {
        Trace.call1(m, "", true);
    }

    public static void call1(String m, boolean print) {
        Trace.call1(m, "", print);
    }

    public static void call1(String m, String extra) {
        Trace.call1(m, extra, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void call1(String m, String extra, boolean print) {
        if (!displayMsg) {
            return;
        }
        if (!Trace.ok(m)) {
            return;
        }
        Object object = MUTEX;
        synchronized (object) {
            if (print) {
                Trace.writeTrace(">" + m + " " + extra);
            }
            Trace.deltaCurrentTab(1);
            ticks.put(m, new Long(System.currentTimeMillis()));
            mems.put(m, new Long(Misc.usedMemory()));
        }
    }

    public static void call2(String m) {
        Trace.call2(m, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void call2(String m, String extra) {
        if (!displayMsg) {
            return;
        }
        if (!Trace.ok(m)) {
            return;
        }
        Object object = MUTEX;
        synchronized (object) {
            Trace.deltaCurrentTab(-1);
            long now = System.currentTimeMillis();
            Long lastTime = (Long)ticks.get(m);
            Long lastMemory = (Long)mems.get(m);
            if (lastTime != null && lastMemory != null) {
                long memDiff = Misc.usedMemory() - lastMemory;
                long then = lastTime;
                Trace.writeTrace("<" + m + " ms: " + (now - then) + " " + extra);
                ticks.remove(m);
                mems.remove(m);
            } else {
                Trace.writeTrace(m + " NO LAST TIME");
            }
        }
    }

    public static void clearMsgs() {
        tabs = new Hashtable();
        traceMsgs = new Hashtable();
    }

    public static void printMsgs() {
        Enumeration keys = traceMsgs.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            System.out.println(key);
            System.out.println(traceMsgs.get(key));
        }
        Trace.clearMsgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void before(String m) {
        if (!displayMsg) {
            return;
        }
        Object object = MUTEX;
        synchronized (object) {
            Trace.writeTrace(m);
            Trace.deltaCurrentTab(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void after(String m) {
        if (!displayMsg) {
            return;
        }
        Object object = MUTEX;
        synchronized (object) {
            Trace.deltaCurrentTab(-1);
            Trace.writeTrace(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void msg(String m) {
        if (!displayMsg) {
            return;
        }
        if (!Trace.ok(m)) {
            return;
        }
        Object object = MUTEX;
        synchronized (object) {
            Trace.writeTrace(m);
        }
    }

    private static void writeTrace(String msg) {
        Thread t;
        String crntThreadName;
        String suff = "";
        if (showLineNumber) {
            List<String> trace = StringUtil.split(LogUtil.getStackTrace(), "\n", true, true);
            for (int i = 0; i < trace.size(); ++i) {
                String line = trace.get(i);
                if (line.indexOf("(") < 0 || line.indexOf("LogUtil.getStackTrace") >= 0 || line.indexOf("Trace.java") >= 0 || line.indexOf("Method") >= 0) continue;
                line = line.substring(line.indexOf("(") + 1, line.length() - 1);
                suff = "   " + line;
                break;
            }
        }
        if (!(crntThreadName = (t = Thread.currentThread()).getName()).equals(lastThreadName)) {
            System.out.println("Thread:" + crntThreadName);
            lastThreadName = crntThreadName;
        }
        Trace.printTabs(null);
        System.out.print(msg + suff + "\n");
        LogUtil.consoleMessage(msg);
    }

    private static void printTabs(StringBuffer sb) {
        if (!displayMsg) {
            return;
        }
        int tabs = Trace.getCurrentTab();
        long usedMemory2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        if (initMemory == 0L) {
            initMemory = usedMemory2;
        }
        long currentTime = System.currentTimeMillis();
        ts.setLength(0);
        ms.setLength(0);
        tms.setLength(0);
        prefix.setLength(0);
        ts.append(currentTime - lastTime);
        while (ts.length() < 4) {
            ts.append(" ");
        }
        ms.append((int)((double)(usedMemory2 - lastMemory) / 1000.0));
        while (ms.length() < 5) {
            ms.append(" ");
        }
        if (lastTime == 0L) {
            prefix.append("S   D     T");
        } else {
            prefix.append(ts.toString());
            prefix.append(" ");
            prefix.append(ms.toString());
            prefix.append(" ");
        }
        while (prefix.length() < 10) {
            prefix.append(" ");
        }
        System.out.print(prefix.toString());
        if (sb != null) {
            sb.append(prefix.toString());
        }
        for (int i = 0; i < tabs; ++i) {
            if (sb != null) {
                sb.append("  ");
            }
            System.out.print("  ");
        }
        lastTime = currentTime;
        lastMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static void accum1(String name) {
        if (!displayMsg) {
            return;
        }
        Long l = new Long(System.nanoTime());
        accum1Table.put(name, l);
    }

    public static void accum2(String name) {
        if (!displayMsg) {
            return;
        }
        long time = System.nanoTime();
        Long l = (Long)accum1Table.get(name);
        if (l == null) {
            Trace.msg("Cannot find accum:" + name);
            return;
        }
        long delta = time - l;
        Long total = (Long)accumTable.get(name);
        if (total == null) {
            total = new Long(delta);
            accumList.add(name);
        } else {
            total = new Long(total + delta);
        }
        Integer cnt = (Integer)accumCntTable.get(name);
        cnt = cnt == null ? new Integer(1) : new Integer(cnt + 1);
        accumCntTable.put(name, cnt);
        accumTable.put(name, total);
    }

    public static void printAccum() {
        for (int i = 0; i < accumList.size(); ++i) {
            String name = (String)accumList.get(i);
            Long total = (Long)accumTable.get(name);
            Integer cnt = (Integer)accumCntTable.get(name);
            long nanos = total;
            Trace.msg(name + " Time:" + nanos / 1000000L + " count:" + cnt);
        }
        accumList = new ArrayList();
        accum1Table = new Hashtable();
        accumCntTable = new Hashtable();
        accumTable = new Hashtable();
    }

    public static void count(String name) {
        Integer i = (Integer)counters.get(name);
        if (i == null) {
            i = new Integer(0);
            counters.put(name, i);
            counterList.add(name);
        }
        i = new Integer(i + 1);
        counters.put(name, i);
    }

    public static void printAndClearCount() {
        for (int i = 0; i < counterList.size(); ++i) {
            String name = (String)counterList.get(i);
            Integer theCount = (Integer)counters.get(name);
            System.out.println("Count:" + name + "=" + theCount);
        }
        counterList = new ArrayList();
        counters = new Hashtable();
    }
}

