/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import ucar.unidata.util.Timestamp;
import ucar.unidata.util.UTCCalendar;

public class TimestampFormat
extends Format {
    private static final UTCCalendar utcCal_ = new UTCCalendar();
    public static final String isoTimeFmtPattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private DateFormat delegate_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer isoformat(Timestamp ts, StringBuffer buf, FieldPosition fp) {
        if (fp == null) {
            fp = new FieldPosition(0);
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        UTCCalendar uTCCalendar = utcCal_;
        synchronized (uTCCalendar) {
            utcCal_.setTime(ts);
            nf.setMinimumIntegerDigits(4);
            nf.format(utcCal_.get(1), buf, fp);
            buf.append("-");
            nf.setMinimumIntegerDigits(2);
            nf.format(utcCal_.get(2) + 1, buf, fp);
            buf.append("-");
            nf.format(utcCal_.get(5), buf, fp);
            buf.append("T");
            nf.format(utcCal_.get(11), buf, fp);
            buf.append(":");
            nf.format(utcCal_.get(12), buf, fp);
            buf.append(":");
            nf.format(utcCal_.get(13), buf, fp);
            buf.append(".");
            nf.setMinimumIntegerDigits(3);
            nf.format(utcCal_.get(14), buf, fp);
            buf.append("Z");
        }
        return buf;
    }

    public static String isoformat(Timestamp ts) {
        return TimestampFormat.isoformat(ts, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public static int domOff(int dom, Calendar ref) {
        int fwddiff;
        if (dom < 1 || dom > 31) {
            return 0;
        }
        int rdom = ref.get(5);
        int diff = dom - rdom;
        if (diff > 0) {
            ref.add(2, -1);
            int revdiff = ref.getActualMaximum(5) - diff;
            ref.add(2, 1);
            if (diff >= revdiff) {
                return -revdiff;
            }
        } else if (diff < 0 && (fwddiff = ref.getActualMaximum(5) + diff) < -diff) {
            return fwddiff;
        }
        return diff;
    }

    private static int hodOff(int hod, Calendar ref) {
        int fwddiff;
        if (hod < 0 || hod > 23) {
            return 0;
        }
        int rhod = ref.get(11);
        int diff = hod - rhod;
        if (diff > 0) {
            int revdiff = 24 - diff;
            if (diff >= revdiff) {
                return -revdiff;
            }
        } else if (diff < 0 && (fwddiff = 24 + diff) < -diff) {
            return fwddiff;
        }
        return diff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp computeTimestamp(String ddhhmm, Timestamp ref) throws ParseException {
        int dd = -1;
        int hh = -1;
        int mm = -1;
        int begin = 0;
        if (ddhhmm.length() > 5 && ((dd = Integer.parseInt(ddhhmm.substring(begin, begin + 2))) < 1 || dd > 31)) {
            throw new ParseException("No day of month \"" + ddhhmm + "\"", begin);
        }
        if ((hh = Integer.parseInt(ddhhmm.substring(begin += 2, begin + 2))) < 0 || hh > 24) {
            throw new ParseException("No hour \"" + ddhhmm + "\"", begin);
        }
        if ((mm = Integer.parseInt(ddhhmm.substring(begin += 2, begin + 2))) < 0 || mm > 60) {
            throw new ParseException("No minutes \"" + ddhhmm + "\"", begin);
        }
        UTCCalendar uTCCalendar = utcCal_;
        synchronized (uTCCalendar) {
            utcCal_.setTime(ref);
            utcCal_.set(14, 0);
            utcCal_.set(13, 0);
            if (dd > 0) {
                int off = TimestampFormat.domOff(dd, utcCal_);
                utcCal_.set(12, mm);
                utcCal_.set(11, hh);
                if (off != 0) {
                    utcCal_.add(5, off);
                }
            } else {
                int off = TimestampFormat.hodOff(hh, utcCal_);
                utcCal_.set(12, mm);
                if (off != 0) {
                    utcCal_.add(11, off);
                }
            }
            return utcCal_.getTimestamp();
        }
    }

    public TimestampFormat() {
    }

    public TimestampFormat(DateFormat delegate) {
        this.setDelegate(delegate);
    }

    public TimestampFormat(DateFormat delegate, Calendar cal) {
        this.setDelegate(delegate);
        this.delegate_.setCalendar(cal);
    }

    public void setDelegate(DateFormat delegate) {
        this.delegate_ = delegate;
    }

    public DateFormat getDelegate() {
        return this.delegate_;
    }

    public StringBuffer format(Timestamp ts, StringBuffer buf, FieldPosition fp) {
        if (this.delegate_ == null) {
            return TimestampFormat.isoformat(ts, buf, fp);
        }
        return this.delegate_.format(new Date(ts.getMillis()), buf, fp);
    }

    @Override
    public StringBuffer format(Object ts, StringBuffer buf, FieldPosition pos) {
        return this.format((Timestamp)ts, buf, pos);
    }

    public Timestamp parse(String source, ParsePosition status) {
        if (this.delegate_ == null) {
            return null;
        }
        Date dt = this.delegate_.parse(source, status);
        if (dt == null) {
            return null;
        }
        return new Timestamp(dt);
    }

    public Timestamp parse(String source) throws ParseException {
        ParsePosition status = new ParsePosition(0);
        try {
            Timestamp ret = this.parse(source, status);
            if (status.getIndex() == 0) {
                throw new ParseException("Unparseable \"" + source + "\"", status.getErrorIndex());
            }
            return ret;
        }
        catch (NullPointerException npe) {
            throw new ParseException("Unparseable \"" + source + "\"", status.getErrorIndex());
        }
    }

    @Override
    public Object parseObject(String source, ParsePosition status) {
        return this.parse(source, status);
    }

    public static void test0(String[] args) {
        String pattern = isoTimeFmtPattern;
        if (args.length > 0) {
            pattern = args[args.length - 1];
        }
        TimestampFormat fmt = new TimestampFormat(new SimpleDateFormat(pattern), utcCal_);
        try {
            BufferedReader brdr = new BufferedReader(new InputStreamReader(System.in));
            String line = brdr.readLine();
            while (line != null) {
                try {
                    Timestamp ts = fmt.parse(line);
                    System.out.println(fmt.format(ts));
                    System.out.println(ts);
                }
                catch (ParseException pe) {
                    System.err.println("java.text.ParseException: " + pe.getMessage() + " at pos " + pe.getErrorOffset());
                }
                line = brdr.readLine();
            }
        }
        catch (Exception ee) {
            ee.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }

    public static void tdomOff(String[] args) {
        TimestampFormat fmt = new TimestampFormat(new SimpleDateFormat(isoTimeFmtPattern), utcCal_);
        try {
            BufferedReader brdr = new BufferedReader(new InputStreamReader(System.in));
            UTCCalendar ref = new UTCCalendar();
            String line = brdr.readLine();
            while (line != null) {
                try {
                    ref.setTime(fmt.parse(line));
                    line = brdr.readLine();
                    if (line == null) break;
                    int dom = Integer.parseInt(line);
                    int off = TimestampFormat.domOff(dom, ref);
                    System.out.println("off " + Integer.toString(off));
                    ref.add(5, off);
                    System.out.println(ref.getTimestamp());
                }
                catch (ParseException pe) {
                    System.err.println("java.text.ParseException: " + pe.getMessage() + " at pos " + pe.getErrorOffset());
                }
                line = brdr.readLine();
            }
        }
        catch (Exception ee) {
            ee.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }

    public static void testHodOff(String[] args) {
        try {
            UTCCalendar ref = new UTCCalendar();
            ref.setTime(Integer.MAX_VALUE);
            ref.set(14, 0);
            ref.set(13, 0);
            ref.set(12, 0);
            for (int rhod = 0; rhod < 24; ++rhod) {
                ref.set(11, rhod);
                for (int hod = 0; hod < 24; ++hod) {
                    int off = TimestampFormat.hodOff(hod, ref);
                    System.out.println(Integer.toString(hod) + " " + Integer.toString(rhod) + " " + Integer.toString(off));
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            UTCCalendar ref = new UTCCalendar();
            ref.setTime(Integer.MAX_VALUE);
            ref.set(14, 0);
            ref.set(13, 0);
            ref.set(12, 0);
            ref.set(10, 0);
            for (int mm = 0; mm < 50; ++mm) {
                for (int rdom = 1; rdom < 32; ++rdom) {
                    ref.set(5, rdom);
                    for (int dom = 1; dom < 32; ++dom) {
                        int off = TimestampFormat.domOff(dom, ref);
                        System.out.println(Integer.toString(dom) + " " + Integer.toString(rdom) + " " + Integer.toString(off));
                    }
                }
                System.out.println("###");
                ref.add(2, 1);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }
}

