/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import ucar.unidata.util.TimestampFormat;

public class Timestamp
implements Comparable,
Serializable {
    public static final Timestamp NONE = new Timestamp(Long.MIN_VALUE);
    protected final long millis_;

    public Timestamp(long millis) {
        this.millis_ = millis;
    }

    public Timestamp() {
        this.millis_ = System.currentTimeMillis();
    }

    public Timestamp(Date date) {
        this.millis_ = date.getTime();
    }

    public Timestamp(int secsPrior) {
        this.millis_ = System.currentTimeMillis() - (long)(secsPrior * 1000);
    }

    public long getMillis() {
        return this.millis_;
    }

    public StringBuffer format(StringBuffer buf) {
        return TimestampFormat.isoformat(this, buf, null);
    }

    public int hashCode() {
        return (int)(this.millis_ ^ this.millis_ >> 32);
    }

    public boolean equals(Object oo) {
        if (oo != null && oo instanceof Timestamp) {
            return this.millis_ == ((Timestamp)oo).millis_;
        }
        return false;
    }

    public String toString() {
        return this.format(new StringBuffer()).toString();
    }

    public int compareTo(Timestamp ts) {
        return this.millis_ < ts.millis_ ? -1 : (this.millis_ > ts.millis_ ? 1 : 0);
    }

    public int compareTo(Object oo) {
        return this.compareTo((Timestamp)oo);
    }

    public static void main(String[] args) {
        try {
            Timestamp crash = new Timestamp(Long.MAX_VALUE);
            System.out.println("End Epoch: " + crash);
            Timestamp zed = new Timestamp(0);
            System.out.println("Begin Epoch:    " + zed);
            Timestamp now = new Timestamp();
            System.out.println("now:            " + now);
            Timestamp big = new Timestamp(Integer.MAX_VALUE);
            System.out.println("sometime:       " + big);
            TimestampFormat fmt = new TimestampFormat(new SimpleDateFormat());
            System.out.println("sometime: " + fmt.format(big));
            SimpleDateFormat fmt1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            fmt1.setTimeZone(TimeZone.getTimeZone("GMT"));
            fmt.setDelegate(fmt1);
            System.out.println("sometime:       " + fmt.format(big));
        }
        catch (Exception ee) {
            ee.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }
}

