/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.unidata.util.IOUtil;

public class TemporaryDir {
    private File dir;
    private long currentDirTime = 0L;
    private int maxFiles = -1;
    private long maxSize = -1L;
    private long maxAge = -1L;
    private boolean touched = false;

    public TemporaryDir(String dir) {
        this(new File(dir));
    }

    public TemporaryDir(File dir) {
        this.dir = dir;
    }

    public TemporaryDir(File dir, int maxFiles, long maxSize, long maxAge) {
        this(dir);
        this.maxFiles = maxFiles;
        this.maxSize = maxSize;
        this.maxAge = maxAge;
    }

    public boolean haveChanged() {
        return this.currentDirTime != this.dir.lastModified();
    }

    public String toString() {
        return this.dir.toString();
    }

    public List<File> findFilesToScour() {
        int i;
        ArrayList<File> results = new ArrayList<File>();
        long t1 = System.currentTimeMillis();
        List<File> allFiles = IOUtil.getFiles(this.dir, true);
        long t2 = System.currentTimeMillis();
        long t3 = System.currentTimeMillis();
        IOUtil.FileWrapper[] files = IOUtil.sortFilesOnAge(IOUtil.FileWrapper.toArray(allFiles, false));
        long t4 = System.currentTimeMillis();
        long now = new Date().getTime();
        long totalSize = 0L;
        int numFiles = 0;
        for (i = 0; i < files.length; ++i) {
            ++numFiles;
        }
        if (this.maxSize > 0L) {
            for (i = 0; i < files.length; ++i) {
                totalSize += files[i].length();
            }
        }
        if (files.length > 0) {
            // empty if block
        }
        for (i = 0; i < files.length; ++i) {
            long lastModified;
            long age;
            boolean shouldScour = false;
            if (this.maxSize > 0L && totalSize > this.maxSize) {
                shouldScour = true;
            }
            if (this.maxAge > 0L && (age = now - (lastModified = files[i].lastModified())) > this.maxAge) {
                shouldScour = true;
            }
            if (this.maxFiles > 0 && numFiles > this.maxFiles) {
                shouldScour = true;
            }
            if (!shouldScour) break;
            long fileSize = files[i].length();
            results.add(files[i].getFile());
            totalSize -= files[i].length();
            --numFiles;
        }
        if (results.size() > 0) {
            // empty if block
        }
        this.currentDirTime = this.dir.lastModified();
        return results;
    }

    public File getDir() {
        return this.dir;
    }

    public void setMaxFiles(int value) {
        this.maxFiles = value;
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public void setMaxSize(long value) {
        this.maxSize = value;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxAge(long value) {
        this.maxAge = value;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setTouched(boolean value) {
        this.touched = value;
    }

    public boolean getTouched() {
        return this.touched;
    }
}

