/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;

public class SocketConnection
implements Runnable {
    private Socket socket;
    private DataOutputStream out;
    private DataInputStream in;
    private boolean running = false;

    public SocketConnection(Socket socket) throws IOException {
        this.socket = socket;
        this.out = new DataOutputStream(socket.getOutputStream());
        this.in = new DataInputStream(socket.getInputStream());
    }

    public void write(String message) throws IOException {
        this.out.writeInt(message.length());
        this.out.write(message.getBytes());
    }

    public void initConnection() {
    }

    @Override
    public void run() {
        try {
            this.initConnection();
            this.running = true;
            byte[] buffer = new byte[1000];
            while (this.running) {
                int length = this.in.readInt();
                if (this.running) {
                    if (length > 1000000) {
                        throw new IllegalArgumentException("Bad length read:" + length);
                    }
                    int total = 0;
                    if (buffer.length < length) {
                        buffer = new byte[length];
                    }
                    while (total < length) {
                        int howMany = this.in.read(buffer, total, length - total);
                        if (!this.running) break;
                        if (howMany <= 0) {
                            this.logError("read " + howMany + "  bytes");
                            break;
                        }
                        total += howMany;
                    }
                    if (this.running && total == length) {
                        String s = new String(buffer, 0, length);
                        this.handleMessage(s);
                        continue;
                    }
                }
                break;
            }
        }
        catch (EOFException buffer) {
        }
        catch (IOException ioe) {
            this.logMessage("Got exception: " + ioe);
        }
        this.connectionClosed();
    }

    public void close() {
        this.running = false;
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void connectionClosed() {
        this.logMessage("Connection closed");
    }

    public void logError(String message) {
        System.err.println(message);
    }

    public void logMessage(String message) {
        System.err.println(message);
    }

    public void handleMessage(String s) {
        System.err.println("read:" + s);
    }
}

