/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import ucar.unidata.util.Debug;
import ucar.unidata.util.PersistentStore;
import ucar.unidata.util.Resource;

public class SerializedObjectStore
implements PersistentStore {
    private String coreFilename;
    private String siteFilename;
    private String userFilename;
    private boolean debug = false;
    private boolean debugShowSystemProperties = false;
    private boolean permissionReadDisk = true;
    protected boolean debugShowHash = false;
    protected boolean showGet = false;
    protected boolean showPut = false;
    protected boolean debugWhichRead = false;
    protected HashMap hash = new HashMap();

    protected SerializedObjectStore() {
    }

    public SerializedObjectStore(String systemName, String appName, String storeName) {
        String path;
        File f;
        this.coreFilename = new String("/auxdata/config/" + appName + "/" + storeName + ".ser");
        this.readConfigFile(true, this.coreFilename);
        String siteHome = this.getProperty(systemName + ".home");
        if (null == siteHome) {
            siteHome = ".";
        }
        if (this.debug) {
            System.out.println(systemName + "home = " + siteHome);
        }
        this.siteFilename = new String(siteHome + "/config/" + appName + "/" + storeName + ".ser");
        this.readConfigFile(false, this.siteFilename);
        if (!this.permissionReadDisk) {
            return;
        }
        String userHome = this.getProperty("user.home");
        if (null == userHome) {
            userHome = ".";
        }
        if (this.debug) {
            System.out.println("user home = " + userHome);
        }
        if (this.debug) {
            System.out.println("java.class.path = " + this.getProperty("java.class.path"));
        }
        if (!(f = new File(path = userHome + File.separator + "." + systemName)).exists()) {
            if (!f.mkdir()) {
                System.out.println("Configure failed to make directory " + path);
            } else if (this.debug) {
                System.out.println("Configure made directory " + f.getPath());
            }
        }
        if (!(f = new File(path = path + File.separator + appName)).exists()) {
            if (!f.mkdir()) {
                System.out.println("Configure failed to make directory " + path);
            } else if (this.debug) {
                System.out.println("Configure made directory " + f.getPath());
            }
        }
        this.userFilename = new String(f.getPath() + File.separator + storeName + ".ser");
        this.readConfigFile(false, this.userFilename);
    }

    @Override
    public Object get(Object key) {
        Object val = this.hash.get(key);
        if (this.showGet || Debug.isSet("util.ObjectStore")) {
            System.out.print("util.ObjectStoreGet key= " + key + " value= " + val);
            if (val != null) {
                System.out.println(" " + val.getClass().getName());
            }
            System.out.println();
        }
        return val;
    }

    public boolean get(Object key, boolean dflt) {
        Boolean b = (Boolean)this.get(key);
        return b != null ? b : dflt;
    }

    @Override
    public void put(Object key, Object value) {
        if (this.showPut || Debug.isSet("util.ObjectStore")) {
            System.out.print("util.ObjectStorePut key= " + key + " value= " + value);
            if (value != null) {
                System.out.println(" " + value.getClass().getName());
            }
            System.out.println();
        }
        if (!(key instanceof Serializable)) {
            throw new IllegalArgumentException("SerializedObjectStore.put non-serializable object " + key);
        }
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException("SerializedObjectStore.put non-serializable object " + value);
        }
        this.hash.put(key, value);
    }

    @Override
    public void save() {
        this.writeConfigData(this.userFilename, this.hash);
    }

    private String getProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            System.out.println("ObjectStore: not allowed to get Property " + key);
            return null;
        }
    }

    protected void readConfigFile(boolean isCore, String filename) {
        ObjectInputStream in;
        if (this.debugWhichRead) {
            System.out.println("ObjectStore try to open " + filename);
        }
        try {
            if (isCore) {
                InputStream ins = Resource.getFileResource(null, filename);
                if (null == ins) {
                    if (this.debugWhichRead) {
                        System.out.println("    getFileResource failed on " + filename);
                    }
                    return;
                }
                in = new ObjectInputStream(ins);
            } else {
                in = new ObjectInputStream(new FileInputStream(filename));
            }
        }
        catch (FileNotFoundException e) {
            if (this.debugWhichRead) {
                System.out.println("    FileNotFound on " + filename);
            }
            return;
        }
        catch (IOException e) {
            if (this.debugWhichRead) {
                System.out.println("ObjectInputStream open failed on " + filename);
                System.out.println("   exception = " + e);
            }
            return;
        }
        catch (SecurityException e) {
            System.out.println("ObjectStore: not allowed to read disk");
            this.permissionReadDisk = false;
            return;
        }
        if (this.readObjectsFromStream(in)) {
            if (this.debugWhichRead) {
                System.out.println("   success on " + filename);
            }
        } else if (this.debugWhichRead) {
            System.out.println("ObjectStore readConfigFile failed on " + filename);
        }
        try {
            in.close();
        }
        catch (IOException e) {
            System.out.println("ObjectStore readConfigData failed to close " + filename);
            System.out.println("   exception = " + e);
        }
    }

    protected boolean readObjectsFromStream(ObjectInputStream in) {
        if (this.debugShowHash) {
            System.out.println("ObjectStore store ");
        }
        try {
            while (true) {
                Object key = in.readObject();
                Object value = in.readObject();
                this.hash.put(key, value);
                if (!this.debugShowHash) continue;
                System.out.println("  " + key + " == " + this.hash.get(key));
            }
        }
        catch (EOFException key) {
        }
        catch (IOException e) {
            System.out.println("readObjectsFromStream IOException " + e);
        }
        catch (ClassNotFoundException e) {
            System.out.println("readObjectsFromStream ClassNotFoundException " + e);
        }
        return true;
    }

    private void writeConfigData(String filename, HashMap hm) {
        ObjectOutputStream out;
        if (this.debugShowHash) {
            System.out.println("saveConfigData Hash " + this.userFilename);
        }
        if (null == filename) {
            return;
        }
        try {
            out = new ObjectOutputStream(new FileOutputStream(filename));
        }
        catch (IOException e) {
            System.out.println("ObjectStore writeConfigData failed to open " + filename);
            System.out.println("   exception = " + e);
            return;
        }
        this.writeObjectsToStream(out);
        if (this.debug) {
            System.out.println("Configure saved data in " + filename);
        }
    }

    protected void writeObjectsToStream(ObjectOutputStream out) {
        if (null == this.hash) {
            return;
        }
        Set keys = this.hash.keySet();
        if (null == keys) {
            return;
        }
        for (Object key : keys) {
            try {
                out.writeObject(key);
                out.writeObject(this.hash.get(key));
                if (!this.debugShowHash) continue;
                System.out.println("  " + key + " == " + this.hash.get(key));
            }
            catch (IOException e) {
                System.out.println("ObjectStore writeObjectsToStream failed to write " + key);
                System.out.println("   exception = " + e);
            }
        }
        try {
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.println("ObjectStore writeObjectsToStream failed to close ");
            System.out.println("   exception = " + e);
        }
    }

    protected void printHashMap(HashMap hm) {
        if (null == hm) {
            return;
        }
        Set keys = hm.keySet();
        if (null == keys) {
            return;
        }
        for (Object key : keys) {
            System.out.println("  " + key + " == " + hm.get(key));
        }
    }
}

