/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.NamedObject;
import ucar.unidata.util.ResourceCollection;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlUtil;

public abstract class ResourceManager {
    public static final String PROP_RESOURCECHANGE = "prop.resourcechange";
    public static final String PROP_RESOURCEREMOVE = "prop.resourceremove";
    public static final LogUtil LU = null;
    public static LogUtil.LogCategory log_ = LogUtil.getLogInstance(ResourceManager.class.getName());
    protected Hashtable nameToObject = new Hashtable();
    protected List usersList = new ArrayList();
    protected String writablePath;
    protected List listOfResourceLists = new ArrayList();
    protected List resources = new ArrayList();
    private FileManager fileChooser;
    private int resourceTimestamp = 0;
    private XmlEncoder xmlEncoder;
    private PropertyChangeSupport propertyListeners;

    public ResourceManager() {
    }

    public ResourceManager(XmlEncoder xmlEncoder) {
        this.xmlEncoder = xmlEncoder;
    }

    public void init(ResourceCollection resources) {
        boolean gotUsers = false;
        try {
            for (int i = 0; i < resources.size(); ++i) {
                Object newObject;
                Object object;
                boolean writable;
                boolean bl = writable = this.writablePath == null && resources.isWritableResource(i);
                if (writable) {
                    this.writablePath = resources.get(i).toString();
                }
                if ((object = this.initResource(resources, i)) == null || (newObject = this.processObject(object)) == null) continue;
                if (newObject instanceof NamedObject) {
                    newObject = Misc.newList(newObject);
                } else if (!(newObject instanceof List)) {
                    throw new IllegalArgumentException("Resource must be a NamedObject or a List:" + newObject.getClass().getName());
                }
                if (writable) {
                    this.usersList = (List)newObject;
                    gotUsers = true;
                }
                this.listOfResourceLists.add(newObject);
            }
        }
        catch (Throwable exc) {
            System.err.println("Error handling resources:" + resources);
            exc.printStackTrace();
        }
        if (!gotUsers) {
            this.listOfResourceLists.add(0, this.usersList);
        }
        this.initDone();
    }

    protected Object initResource(ResourceCollection resources, int index) {
        String xml = resources.read(index);
        if (xml == null) {
            return null;
        }
        return this.toObject(xml, (String)resources.get(index));
    }

    public NamedObject getDefault() {
        if (this.resources.size() > 0) {
            return (NamedObject)this.resources.get(0);
        }
        return null;
    }

    public int getResourceTimestamp() {
        return this.resourceTimestamp;
    }

    protected void reloadResources() {
        ++this.resourceTimestamp;
        this.resources = new ArrayList();
        this.nameToObject = new Hashtable();
        for (int i = 0; i < this.listOfResourceLists.size(); ++i) {
            List newResources = (List)this.listOfResourceLists.get(i);
            for (int ctIdx = 0; ctIdx < newResources.size(); ++ctIdx) {
                NamedObject ct = (NamedObject)newResources.get(ctIdx);
                if (this.nameToObject.get(ct.getName()) != null) continue;
                this.nameToObject.put(ct.getName(), ct);
                this.resources.add(ct);
            }
        }
    }

    public boolean resourceExists(String name) {
        return this.nameToObject.get(name) != null;
    }

    protected void initDone() {
        this.reloadResources();
    }

    protected Object processObject(Object o) {
        return o;
    }

    public String getTitle() {
        return "Resource";
    }

    public int getUsersIndex(NamedObject object) {
        for (int i = 0; i < this.usersList.size(); ++i) {
            if (!((NamedObject)this.usersList.get(i)).getName().equals(object.getName())) continue;
            return i;
        }
        return -1;
    }

    public NamedObject getObject(String name) {
        return (NamedObject)this.nameToObject.get(name);
    }

    public List getResources() {
        return this.resources;
    }

    public boolean isUsers(NamedObject object) {
        return this.getUsersIndex(object) >= 0;
    }

    public void removeUsers(NamedObject object) {
        this.usersList.remove(object);
        this.reloadResources();
        this.writeUsers();
        this.firePropertyChange(PROP_RESOURCEREMOVE, object, null);
    }

    public void addUsers(NamedObject object) {
        int index = this.getUsersIndex(object);
        if (index >= 0) {
            this.usersList.set(index, object);
        } else {
            this.usersList.add(object);
        }
        this.reloadResources();
        this.writeUsers();
        this.firePropertyChange(PROP_RESOURCECHANGE, null, object);
    }

    protected XmlEncoder getEncoder() {
        if (this.xmlEncoder == null) {
            this.xmlEncoder = new XmlEncoder();
        }
        return this.xmlEncoder;
    }

    private void writeUsers() {
        if (this.writablePath != null) {
            try {
                IOUtil.writeFile(this.writablePath, this.getEncoder().toXml(this.usersList));
            }
            catch (Exception exc) {
                LogUtil.printException(log_, "Writing resource file", exc);
            }
        }
    }

    public List getWriteFileFilters() {
        return this.getFileFilters();
    }

    public List getReadFileFilters() {
        return this.getFileFilters();
    }

    public List getFileFilters() {
        return null;
    }

    public String getFileSuffix() {
        return null;
    }

    public void doExport(NamedObject object) {
        String file = FileManager.getWriteFile(this.getTitle() + " export", this.getWriteFileFilters(), this.getFileSuffix());
        if (file == null) {
            return;
        }
        this.doExport(object, file);
    }

    protected String getExportContents(NamedObject object, String file) {
        return this.getEncoder().toXml(object);
    }

    public void doExport(NamedObject object, String file) {
        String contents = this.getExportContents(object, file);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(contents.getBytes());
            fos.close();
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Exporting resource", exc);
        }
    }

    public NamedObject doImport(Object o, boolean forceUnique) {
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            List list = (List)o;
            NamedObject first = null;
            for (int i = 0; i < list.size(); ++i) {
                NamedObject obj = this.doImport(list.get(i), forceUnique);
                if (first != null) continue;
                first = obj;
            }
            return first;
        }
        if (o instanceof NamedObject) {
            if (forceUnique) {
                NamedObject nobj = (NamedObject)o;
                String name = nobj.getName();
                for (int cnt = 1; this.resourceExists(nobj.getName()) && cnt < 100; ++cnt) {
                    nobj.setName(name + "_" + cnt);
                }
            }
            this.addUsers((NamedObject)o);
            return (NamedObject)o;
        }
        return null;
    }

    public NamedObject doImport() {
        return this.doImport(false);
    }

    public NamedObject doImport(boolean makeUnique) {
        String file = FileManager.getReadFile(this.getTitle() + " import", this.getReadFileFilters());
        if (file == null) {
            return null;
        }
        try {
            String xml = IOUtil.readContents(file, ResourceManager.class);
            if (xml == null) {
                return null;
            }
            Object o = this.getEncoder().toObject(xml);
            return this.doImport(o, makeUnique);
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Error reading file:" + file, exc);
            return null;
        }
    }

    public String doNew(Component component) {
        return this.doNew(component, "New");
    }

    public String doNew(Component component, String label) {
        return this.doNew(component, label, "", null);
    }

    public String doNew(Component component, String label, String initName, String tooltip) {
        String newName;
        JTextField field = new JTextField(initName, 20);
        if (tooltip != null) {
            field.setToolTipText(tooltip);
        }
        JPanel contents = GuiUtils.inset((Component)GuiUtils.label(this.getTitle() + " Name: ", field), 4);
        while (true) {
            if (!GuiUtils.showOkCancelDialog(null, label + " " + this.getTitle(), contents, component, Misc.newList(field))) {
                return null;
            }
            newName = field.getText().trim();
            if (newName.equals("")) {
                LogUtil.userMessage("The name cannot be blank");
                continue;
            }
            List<String> toks = StringUtil.split(newName, ">", true, true);
            if (!this.hasUsers(newName = StringUtil.join(">", toks))) {
                return newName;
            }
            int result = GuiUtils.showYesNoCancelDialog(null, "A resource with name " + newName + " exists.  Do you want to overwrite?", this.getTitle());
            if (result == 2) {
                return null;
            }
            if (result == 0) break;
        }
        return newName;
    }

    public String doSaveAs(NamedObject o, Component component) {
        String newName;
        String originalName = o.getName();
        JTextField field = new JTextField(o.getName(), 20);
        JPanel contents = GuiUtils.inset((Component)GuiUtils.label(this.getTitle() + " name: ", field), 4);
        while (true) {
            if (!GuiUtils.showOkCancelDialog(null, "Save", contents, component, Misc.newList(field))) {
                return null;
            }
            newName = field.getText().trim();
            if (!newName.equals("")) break;
            LogUtil.userMessage("The name cannot be blank");
        }
        if (!newName.equals(originalName) && this.hasUsers(newName) && !GuiUtils.askYesNo(this.getTitle() + " exists", "A resource with name " + newName + " exists.  Do you want to overwrite?")) {
            return null;
        }
        return newName;
    }

    public boolean hasUsers(String name) {
        return this.getUsersObject(name) != null;
    }

    public NamedObject getUsersObject(String name) {
        for (int i = 0; i < this.usersList.size(); ++i) {
            if (!((NamedObject)this.usersList.get(i)).getName().equals(name)) continue;
            return (NamedObject)this.usersList.get(i);
        }
        return null;
    }

    public Object toObject(String xml, String filename) {
        return this.toObject(xml);
    }

    public Object toObject(String xml) {
        try {
            Element root = XmlUtil.getRoot(xml);
            return this.getEncoder().toObject(root);
        }
        catch (Exception exc) {
            if (this.shouldWeIgnoreThisXml(xml)) {
                return null;
            }
            exc.printStackTrace();
            return null;
        }
    }

    protected boolean shouldWeIgnoreThisXml(String xml) {
        return Misc.isHtml(xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyChangeSupport getPropertyListeners() {
        if (this.propertyListeners == null) {
            ResourceManager resourceManager = this;
            synchronized (resourceManager) {
                if (this.propertyListeners == null) {
                    this.propertyListeners = new PropertyChangeSupport(this);
                }
            }
        }
        return this.propertyListeners;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyListeners().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        if (this.propertyListeners != null) {
            this.propertyListeners.firePropertyChange(event);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners != null) {
            this.propertyListeners.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

