/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;

public class ResourceCollection {
    protected String id;
    protected String description;
    private List resources;
    private Hashtable cache = new Hashtable();
    protected Hashtable idToPath = new Hashtable();
    protected Hashtable pathToId = new Hashtable();
    protected Resource writableResource;
    protected int writableIndex = -1;
    private boolean canLoadMore = true;

    public ResourceCollection(String id) {
        this(id, id);
    }

    public ResourceCollection(String id, String description) {
        this.id = id;
        this.description = description;
        this.resources = new ArrayList();
    }

    public ResourceCollection(String id, List resources) {
        this(id, resources.size() > 0 ? resources.get(0).toString() : (String)null, resources);
    }

    public ResourceCollection(String id, String writable, List resources) {
        this.id = id;
        this.resources = this.convertResources(resources);
        if (writable != null) {
            this.writableResource = new Resource(writable);
            this.writableIndex = resources.indexOf(this.writableResource);
        }
    }

    public ResourceCollection(String id, ResourceCollection that) {
        this.id = id;
        this.resources = new ArrayList(that.resources);
    }

    public boolean contains(String path) {
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!this.resources.get(i).toString().equals(path)) continue;
            return true;
        }
        return false;
    }

    private List convertResources(List rs) {
        if (rs.size() > 0 && rs.get(0) instanceof String) {
            ArrayList<Resource> tmp = new ArrayList<Resource>();
            for (int i = 0; i < rs.size(); ++i) {
                tmp.add(new Resource(rs.get(i).toString()));
            }
            rs = tmp;
        }
        return rs;
    }

    public void setIdForPath(String id, String path) {
        if (this.idToPath.get(id) == null) {
            this.idToPath.put(id, path);
            this.pathToId.put(path, id);
        }
    }

    public String getPathFromId(String id) {
        return (String)this.idToPath.get(id);
    }

    public String getResourceId(int idx) {
        String path = (String)this.get(idx);
        if (path == null) {
            return null;
        }
        return (String)this.pathToId.get(path);
    }

    public boolean getCanLoadMore() {
        return this.canLoadMore;
    }

    public void setCanLoadMore(boolean lm) {
        this.canLoadMore = lm;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isValid(int i) {
        return this.read(i) != null;
    }

    public String getLabel(int resourceIdx) {
        Resource resource = (Resource)this.resources.get(resourceIdx);
        return resource.label;
    }

    public String getProperty(String name, int resourceIdx) {
        Resource resource = (Resource)this.resources.get(resourceIdx);
        return resource.getProperty(name);
    }

    public String getShortName(int resourceIdx) {
        String label = this.getLabel(resourceIdx);
        if (label != null) {
            return label;
        }
        String path = this.get(resourceIdx).toString();
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            System.err.println("decoding error:" + uee);
        }
        String tail = IOUtil.getFileTail(path);
        if (tail.endsWith(".xml")) {
            tail = IOUtil.stripExtension(tail);
        }
        return "..." + IOUtil.getFileTail(IOUtil.getFileRoot(path)) + "/" + tail;
    }

    public void addLabels(Hashtable labelMap) {
    }

    public void addResources(List rs) {
        rs = this.convertResources(rs);
        if (this.resources.size() == 0) {
            this.resources.addAll(rs);
        } else {
            this.resources.addAll(1, rs);
        }
        this.checkWritable();
    }

    private void checkWritable() {
        if (this.writableResource == null && this.resources.size() > 0) {
            this.writableResource = new Resource(this.resources.get(0).toString());
            this.writableIndex = 0;
        }
    }

    public void removeResource(int index) {
        this.resources.remove(index);
    }

    public void addResource(String resource) {
        this.addResource(new Resource(resource));
    }

    public void addResource(Resource resource) {
        this.resources.add(resource);
        this.checkWritable();
    }

    public void addResourceAtStart(String resourcePath) {
        this.addResourceAtStart(resourcePath, null);
    }

    public void addResourceAtStart(String resourcePath, String label) {
        this.addResourceAtStart(new Resource(resourcePath, label, null));
    }

    public void addResourceAtStart(Resource resource) {
        if (this.resources.size() == 0) {
            this.resources.add(resource);
        } else {
            this.resources.add(1, resource);
        }
        this.checkWritable();
    }

    public int size() {
        return this.resources.size();
    }

    public boolean isWritable(int i) {
        try {
            File f = new File(this.get(i).toString());
            return f.canWrite();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isHttp(String resource) {
        return resource.trim().startsWith("http://");
    }

    public boolean isHttp(int i) {
        return this.isHttp(this.get(i).toString());
    }

    public Object get(int i) {
        Resource resource = (Resource)this.resources.get(i);
        return resource.path;
    }

    public boolean isWritableResource(int i) {
        if (this.writableResource == null) {
            return false;
        }
        return this.writableIndex == i;
    }

    public String readWritableResource() {
        return this.read(this.writableIndex);
    }

    public void writeWritableResource(String contents) throws FileNotFoundException, IOException {
        IOUtil.writeFile(this.getWritable(), contents);
        if (this.writableIndex >= 0) {
            this.cache.put(this.get(this.writableIndex), contents);
        }
    }

    protected String read(Resource resource, boolean lookAtCache) {
        String result = null;
        if (resource == null) {
            throw new IllegalArgumentException("Null resource provided");
        }
        try {
            Object cached;
            if (lookAtCache && (cached = this.cache.get(resource)) != null) {
                if (!(cached instanceof String)) {
                    return null;
                }
                return (String)cached;
            }
            result = IOUtil.readContents(resource.path, this.getClass());
            if (result != null && this.isHttp(resource.path) && Misc.isHtml(result)) {
                result = null;
            }
            if (resource.properties != null) {
                ArrayList<String> patterns = new ArrayList<String>();
                ArrayList values = new ArrayList();
                Enumeration keys = resource.properties.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    patterns.add("${" + key + "}");
                    values.add(resource.properties.get(key));
                }
                result = Misc.replaceList(result, patterns, values);
            }
            this.cache.put(resource, result);
        }
        catch (Exception exc) {
            if (LogUtil.getDebugMode()) {
                LogUtil.consoleMessage("Warning: failed to read " + this.id + ": " + resource + "\n");
            }
            this.cache.put(resource, new Boolean(false));
        }
        return result;
    }

    public String read(int i, boolean lookAtCache) {
        return this.read((Resource)this.resources.get(i), lookAtCache);
    }

    public String read(int i) {
        return this.read(i, true);
    }

    public List getResources() {
        return this.resources;
    }

    public void removeWritable() {
        String writableResource = this.getWritable();
        if (writableResource == null) {
            return;
        }
        this.cache.remove(writableResource);
        try {
            new File(writableResource).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearCache() {
        this.cache = new Hashtable();
    }

    public void deleteAllFiles() {
        for (int i = 0; i < this.size(); ++i) {
            String file = (String)this.get(i);
            try {
                new File(file).delete();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void removeAll() {
        this.cache = new Hashtable();
        this.resources = new ArrayList();
        this.idToPath = new Hashtable();
        this.pathToId = new Hashtable();
    }

    public String getWritable() {
        if (this.writableResource != null) {
            return this.writableResource.toString();
        }
        return null;
    }

    public boolean hasWritableResource() {
        return this.writableResource != null && this.writableResource.toString().trim().length() > 0;
    }

    public String toString() {
        return " ResourceCollection:" + this.resources;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getDescription() {
        return this.description;
    }

    public static class Resource {
        String path;
        String label;
        Hashtable properties;

        public Resource(String path) {
            this(path, null, null);
        }

        public Resource(String path, String label, Hashtable properties) {
            this.path = path;
            this.label = label;
            this.properties = properties;
        }

        public String getProperty(String name) {
            if (this.properties == null) {
                return null;
            }
            return (String)this.properties.get(name);
        }

        public String toString() {
            return this.path;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Resource)) {
                return false;
            }
            Resource that = (Resource)obj;
            return Misc.equals(this.path, that.path);
        }
    }
}

