/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.Serializable;
import ucar.unidata.util.Misc;

public class Range
implements Serializable {
    private String name;
    public double min;
    public double max;

    public Range() {
        this.min = 0.0;
        this.max = 1.0;
    }

    public Range(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public Range(double min, double max, String name) {
        this(min, max);
        this.name = name;
    }

    public Range(double[] a) {
        this(a[0], a[1]);
    }

    public Range(Range r) {
        if (r != null) {
            this.min = r.min;
            this.max = r.max;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        return this.min == other.min && this.max == other.max;
    }

    public void set(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public String formatMin() {
        return Misc.format(this.min);
    }

    public String formatMid() {
        return Misc.format(this.getMid());
    }

    public String formatMax() {
        return Misc.format(this.max);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMin(double v) {
        this.min = v;
    }

    public void setMax(double v) {
        this.max = v;
    }

    public int getSpanInt() {
        return (int)this.getSpan();
    }

    public int getMinInt() {
        return (int)this.min;
    }

    public int getMaxInt() {
        return (int)this.max;
    }

    public void setMin(int v) {
        this.min = v;
    }

    public void setMax(int v) {
        this.max = v;
    }

    public double[] asArray() {
        return new double[]{this.min, this.max};
    }

    public float[] asFloatArray() {
        return new float[]{(float)this.min, (float)this.max};
    }

    public double span() {
        return this.max - this.min;
    }

    public double getSpan() {
        return this.span();
    }

    public double getAbsSpan() {
        return Math.abs(this.span());
    }

    public double getMid() {
        return this.min + this.span() / 2.0;
    }

    public int getMidInt() {
        return (int)(this.min + this.span() / 2.0);
    }

    public double getValueOfPercent(double percent) {
        return this.getMin() + this.getSpan() * percent;
    }

    public double getPercent(double v) {
        return (v - this.min) / this.span();
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return (this.name != null ? this.name + " " : "") + this.min + "/" + this.max;
    }
}

