/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PersistentStore;
import ucar.unidata.util.StringUtil;

public class PreferenceList {
    List list;
    Object chosen;
    String chosenId;
    String listId;
    PersistentStore store;
    List boxes = new ArrayList();
    boolean fireEventOnBoxAction = false;
    private boolean ignoreBoxAction = false;

    public PreferenceList() {
        this(new ArrayList());
    }

    public PreferenceList(List list) {
        this(list, null, "", "", null);
    }

    public PreferenceList(List list, Object chosen, String listId, String chosenId, PersistentStore store) {
        this.list = list;
        this.chosen = chosen;
        this.chosenId = chosenId;
        this.listId = listId;
        this.store = store;
        if (list == null) {
            list = new ArrayList();
        }
    }

    public JComboBox createComboBox(String actionName, ActionListener listener) {
        return this.createComboBox(actionName, listener, false);
    }

    public JComboBox createComboBox(final String actionName, final ActionListener listener, final boolean fireEventOnBoxAction) {
        final JComboBox<String> box = new JComboBox<String>(StringUtil.listToStringArray(this.list));
        this.boxes.add(box);
        if (this.chosen != null && this.list.contains(this.chosen)) {
            box.setSelectedItem(this.chosen);
        } else if (this.list.size() > 0) {
            box.setSelectedIndex(0);
        }
        box.setEditable(true);
        if (fireEventOnBoxAction) {
            box.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PreferenceList.this.ignoreBoxAction) {
                        return;
                    }
                    PreferenceList.this.handleBoxAction(e, box, actionName, listener);
                }
            });
        }
        box.getEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferenceList.this.handleBoxEdit(e, box, actionName, listener, !fireEventOnBoxAction);
            }
        });
        return box;
    }

    private synchronized void handleBoxEdit(ActionEvent e, JComboBox box, String actionName, ActionListener listener, boolean fireEvent) {
        String selection = e.getActionCommand().trim();
        if (selection.length() == 0) {
            int index = box.getSelectedIndex();
            if (index >= 0) {
                this.list.remove(index);
                this.stateChanged();
                if (this.list.size() > 0) {
                    this.ignoreBoxAction = true;
                    box.setSelectedItem(this.list.get(0));
                    this.ignoreBoxAction = false;
                }
                this.writeState();
            }
            return;
        }
        this.ignoreBoxAction = true;
        box.setSelectedItem(selection);
        this.ignoreBoxAction = false;
        if (fireEvent) {
            listener.actionPerformed(new ActionEvent(box, 1, actionName));
        }
    }

    private boolean checkIfInList(JComboBox box, String selection) {
        List boxList = GuiUtils.getItems(box);
        boolean inList = boxList.contains(selection);
        if (!inList) {
            this.list.add(selection);
            this.stateChanged();
            this.ignoreBoxAction = true;
            box.setSelectedItem(selection);
            this.ignoreBoxAction = false;
        }
        return inList;
    }

    private synchronized void handleBoxAction(ActionEvent e, JComboBox box, String actionName, ActionListener listener) {
        this.chosen = box.getSelectedItem();
        listener.actionPerformed(new ActionEvent(box, 1, actionName));
    }

    public void saveState(JComboBox box) {
        this.chosen = box.getSelectedItem();
        if (this.chosen != null) {
            this.checkIfInList(box, this.chosen.toString());
            this.writeState();
        }
    }

    private void writeState() {
        if (this.store == null) {
            return;
        }
        boolean doWrite = false;
        if (!Misc.equals(this.chosen, this.store.get(this.chosenId))) {
            doWrite = true;
            this.store.put(this.chosenId, this.chosen);
        }
        if (!Misc.equals(this.list, this.store.get(this.listId))) {
            doWrite = true;
            this.store.put(this.listId, this.list);
        }
        if (doWrite) {
            this.store.save();
        }
    }

    private void stateChanged() {
        this.ignoreBoxAction = true;
        for (int i = 0; i < this.boxes.size(); ++i) {
            JComboBox box = (JComboBox)this.boxes.get(i);
            Object selected = box.getSelectedItem();
            GuiUtils.setListData(box, this.list);
            if (selected == null) continue;
            if (this.list.contains(selected)) {
                box.setSelectedItem(selected);
                continue;
            }
            if (this.list.size() > 0) {
                box.setSelectedItem(this.list.get(0));
                continue;
            }
            box.setSelectedItem("");
        }
        this.ignoreBoxAction = false;
    }
}

