/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class Pool<KeyType, ValueType> {
    private Object MUTEX = new Object();
    private Hashtable<KeyType, List<ValueType>> cache = new Hashtable();
    private List<KeyType> keys = new ArrayList<KeyType>();
    private int maxSize = 100;
    private int size = 0;

    public Pool(int size) {
        this.maxSize = size;
    }

    public Object getMutex() {
        return this.MUTEX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(KeyType key) {
        if (key == null) {
            return false;
        }
        Object object = this.getMutex();
        synchronized (object) {
            List<ValueType> list = this.cache.get(key);
            return list != null && list.size() > 0;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueType get(KeyType key) {
        if (key == null) {
            return null;
        }
        Object object = this.getMutex();
        synchronized (object) {
            List<ValueType> list = this.cache.get(key);
            if (list != null && list.size() > 0) {
                --this.size;
                ValueType value = this.getFromPool(list);
                if (list.size() == 0) {
                    this.cache.remove(key);
                    this.keys.remove(key);
                }
                return value;
            }
        }
        return this.createValue(key);
    }

    protected ValueType getFromPool(List<ValueType> list) {
        return list.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsOrCreate(KeyType key) {
        if (key == null) {
            return false;
        }
        Object object = this.getMutex();
        synchronized (object) {
            if (this.contains(key)) {
                return true;
            }
        }
        ValueType value = this.createValue(key);
        if (value == null) {
            return false;
        }
        this.put(key, value);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(KeyType key, ValueType value) {
        if (key == null) {
            return;
        }
        ArrayList<Object> keysToRemove = null;
        Object object = this.getMutex();
        synchronized (object) {
            while (this.size >= this.maxSize - 1) {
                for (Object keyToCheck : this.keys) {
                    List<ValueType> listToCheck = this.cache.get(keyToCheck);
                    while (listToCheck != null && listToCheck.size() > 0) {
                        ValueType valueToRemove = listToCheck.remove(0);
                        this.removeValue(key, valueToRemove);
                        --this.size;
                        if (this.size >= this.maxSize) continue;
                        break;
                    }
                    if (listToCheck.size() != 0) continue;
                    if (keysToRemove == null) {
                        keysToRemove = new ArrayList<Object>();
                    }
                    keysToRemove.add(keyToCheck);
                }
            }
            if (keysToRemove != null) {
                for (Object keyToRemove : keysToRemove) {
                    this.cache.remove(keyToRemove);
                    this.keys.remove(keyToRemove);
                }
            }
            this.keys.remove(key);
            this.keys.add(key);
            List<ValueType> list = this.cache.get(key);
            if (list == null || list.size() == 0) {
                list = new ArrayList<ValueType>();
                this.cache.put(key, list);
            }
            list.add(value);
            ++this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStats(StringBuffer sb) {
        Object object = this.getMutex();
        synchronized (object) {
            sb.append("Cache size:" + this.cache.size());
            sb.append("\n");
            Enumeration<KeyType> keys = this.cache.keys();
            while (keys.hasMoreElements()) {
                KeyType key = keys.nextElement();
                sb.append(key + " #:" + this.cache.get(key).size());
                sb.append("\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.getMutex();
        synchronized (object) {
            Enumeration<KeyType> keys = this.cache.keys();
            while (keys.hasMoreElements()) {
                KeyType key = keys.nextElement();
                for (ValueType value : this.cache.get(key)) {
                    this.removeValue(key, value);
                }
            }
            this.size = 0;
            this.cache = new Hashtable();
            this.keys = new ArrayList<KeyType>();
        }
    }

    public int getSize() {
        return this.size;
    }

    protected ValueType createValue(KeyType key) {
        return null;
    }

    protected void removeValue(KeyType key, ValueType object) {
    }
}

