/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.TwoFacedObject;

public class PollingInfo
implements Cloneable {
    public static final int MODE_NONEWFILES = 0;
    public static final int MODE_COUNT = 1;
    public static final int MODE_RELDATERANGE = 2;
    public static final int MODE_ABSDATERANGE = 3;
    public static final int[] MODES = new int[]{1, 2, 3};
    public static final String[] MODELABELS = new String[]{"Last N Files in Directory", "Date Range from Youngest File", "Date Range from Now"};
    private int mode = 0;
    private String name;
    private boolean forFiles = true;
    private long interval = 600000L;
    private List filePaths = new ArrayList();
    private String filePattern;
    private boolean isActive = false;
    private boolean isHiddenOk = true;
    private int fileCount = 0;
    private long dateRange = 3600000L;
    private JCheckBox activeWidget;
    private JTextField patternWidget;
    private JTextField intervalWidget;
    private JTextField filePathWidget;
    JRadioButton fileCountButton;
    JRadioButton dateRangeButton;
    private JComboBox fileCountWidget;
    private JTextField dateRangeWidget;
    private JCheckBox hiddenWidget;
    private JTextField nameWidget;

    public PollingInfo() {
    }

    public PollingInfo cloneMe() {
        try {
            PollingInfo newPollingInfo = (PollingInfo)this.clone();
            newPollingInfo.initFromCloning();
            return newPollingInfo;
        }
        catch (CloneNotSupportedException exc) {
            throw new IllegalStateException("Bad clone:" + exc);
        }
    }

    private void initFromCloning() {
        this.activeWidget = null;
        this.patternWidget = null;
        this.intervalWidget = null;
        this.filePathWidget = null;
        this.fileCountButton = null;
        this.dateRangeButton = null;
        this.fileCountWidget = null;
        this.dateRangeWidget = null;
        this.hiddenWidget = null;
        this.nameWidget = null;
    }

    public PollingInfo(boolean isActive) {
        this.isActive = isActive;
    }

    public PollingInfo(long interval, boolean isActive) {
        this(isActive);
        this.interval = interval;
    }

    public PollingInfo(String filePath, long interval, String filePattern, boolean isActive) {
        this(filePath, interval, filePattern, isActive, true);
    }

    public PollingInfo(String filePath, long interval, String filePattern, boolean isActive, boolean isHiddenOk) {
        this(interval, isActive);
        if (filePath != null) {
            this.filePaths.add(filePath);
        }
        this.filePattern = filePattern;
        this.isHiddenOk = isHiddenOk;
    }

    public void setDontLookForNewFiles() {
        this.mode = 0;
    }

    public boolean doILookForNewFiles() {
        return this.mode != 0;
    }

    public void getPropertyComponents(List comps, boolean includeName, boolean includeFileCount) {
        JButton directoryBtn = new JButton("Select");
        boolean isFile = false;
        if (this.getFile() != null) {
            File f = new File(this.getFile());
            isFile = f.isFile();
        }
        GuiUtils.setupFileChooser(directoryBtn, this.getFilePathWidget(), !isFile);
        if (isFile) {
            comps.add(GuiUtils.rLabel("File: "));
        } else {
            comps.add(GuiUtils.rLabel("Directory: "));
        }
        comps.add(GuiUtils.left(GuiUtils.centerRight(GuiUtils.wrap(this.getFilePathWidget()), GuiUtils.inset((Component)directoryBtn, new Insets(0, 5, 0, 0)))));
        if (includeName) {
            comps.add(GuiUtils.rLabel("Name: "));
            comps.add(GuiUtils.left(this.getNameWidget()));
        }
        comps.add(GuiUtils.rLabel("File Pattern:"));
        comps.add(GuiUtils.left(GuiUtils.hbox((Component)GuiUtils.wrap(GuiUtils.hbox(this.getPatternWidget(), this.getHiddenWidget())), GuiUtils.makeButton("Verify", this, "checkPattern"))));
        if (includeFileCount) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    PollingInfo.this.checkModeEnabled();
                }
            };
            comps.add(GuiUtils.rLabel("Files:"));
            this.fileCountButton = new JRadioButton("", this.mode == 1);
            this.dateRangeButton = new JRadioButton("All files in last:", this.mode == 3);
            this.fileCountButton.addActionListener(actionListener);
            this.dateRangeButton.addActionListener(actionListener);
            ButtonGroup bg = GuiUtils.buttonGroup(this.fileCountButton, this.dateRangeButton);
            ArrayList<JComponent> modeComps = new ArrayList<JComponent>();
            modeComps.add(this.fileCountButton);
            modeComps.add(this.getFileCountWidget());
            modeComps.add(new JLabel("  "));
            modeComps.add(this.dateRangeButton);
            modeComps.add(this.getDateRangeWidget());
            modeComps.add(new JLabel(" minutes"));
            this.checkModeEnabled();
            comps.add(GuiUtils.left(GuiUtils.hbox(modeComps)));
        }
        comps.add(GuiUtils.rLabel("Polling:"));
        comps.add(GuiUtils.left(GuiUtils.hbox((Component)this.getActiveWidget(), (Component)GuiUtils.lLabel("     Check every: "), (Component)GuiUtils.wrap(this.getIntervalWidget()), GuiUtils.lLabel(" minutes"))));
    }

    private void checkModeEnabled() {
        this.getDateRangeWidget().setEnabled(!this.fileCountButton.isSelected());
        this.getFileCountWidget().setEnabled(this.fileCountButton.isSelected());
    }

    public void checkPattern() {
        String pattern = this.getPatternWidget().getText().trim();
        File dir = new File(this.getFilePathWidget().getText().trim());
        File[] list = dir.listFiles(new PatternFileFilter(pattern, false, this.getHiddenWidget().isSelected()));
        StringBuffer sb = new StringBuffer("<html>");
        if (list == null || list.length == 0) {
            sb.append("<h3><center><font color=\"red\">No files match the pattern</font></center></h3>");
            sb.append("Pattern: " + pattern + "<br>");
            list = dir.listFiles();
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    if (i == 0) {
                        sb.append("<hr>Example Files:<br>");
                    }
                    if (i > 20) {
                        sb.append("&nbsp;&nbsp;...<br>\n");
                        break;
                    }
                    sb.append("&nbsp;&nbsp;" + list[i] + "<br>\n");
                }
            }
        } else {
            for (int i = 0; i < list.length; ++i) {
                if (i == 0) {
                    sb.append("<h3><center>Files that match</center></h3>\n");
                }
                if (i > 20) {
                    sb.append("&nbsp;&nbsp;...<br>\n");
                    break;
                }
                sb.append("&nbsp;&nbsp;" + list[i] + "<br>\n");
            }
        }
        sb.append("</html>");
        GuiUtils.showDialog("Sample files", GuiUtils.inset((Component)new JLabel(sb.toString()), 5));
    }

    public JCheckBox getHiddenWidget() {
        if (this.hiddenWidget == null) {
            this.hiddenWidget = new JCheckBox("Include Hidden Files", this.isHiddenOk);
        }
        return this.hiddenWidget;
    }

    public JCheckBox getActiveWidget() {
        if (this.activeWidget == null) {
            this.activeWidget = new JCheckBox("Active", this.isActive);
        }
        return this.activeWidget;
    }

    public JTextField getPatternWidget() {
        if (this.patternWidget == null) {
            this.patternWidget = new JTextField(this.filePattern != null ? this.filePattern : "", 10);
        }
        return this.patternWidget;
    }

    public JTextField getIntervalWidget() {
        if (this.intervalWidget == null) {
            this.intervalWidget = new JTextField("" + (double)this.interval / 60000.0, 5);
        }
        return this.intervalWidget;
    }

    public JTextField getFilePathWidget() {
        if (this.filePathWidget == null) {
            String filePath = this.getFile();
            this.filePathWidget = new JTextField(filePath != null ? filePath : "", 30);
        }
        return this.filePathWidget;
    }

    public JTextField getNameWidget() {
        if (this.nameWidget == null) {
            this.nameWidget = new JTextField(this.name != null ? this.name : "", 30);
        }
        return this.nameWidget;
    }

    public JTextField getDateRangeWidget() {
        if (this.dateRangeWidget == null) {
            this.dateRangeWidget = new JTextField("" + this.dateRange / 60000L, 5);
        }
        return this.dateRangeWidget;
    }

    public JComboBox getFileCountWidget() {
        int[] values = new int[]{Integer.MAX_VALUE, 1, 2, 3, 4, 5, 6, 8, 10, 15, 20};
        return this.getFileCountWidget(values);
    }

    public JComboBox getFileCountWidget(int[] values) {
        if (this.fileCountWidget == null) {
            TwoFacedObject selected = null;
            Vector<TwoFacedObject> items = new Vector<TwoFacedObject>();
            for (int i = 0; i < values.length; ++i) {
                String label = values[i] == Integer.MAX_VALUE ? "All Files" : (values[i] == 0 ? "Use Selected File" : (values[i] == 1 ? "Use Most Recent File" : "Use Most Recent " + values[i] + " Files"));
                TwoFacedObject tfo = new TwoFacedObject((Object)label, new Integer(values[i]));
                if (values[i] == this.fileCount) {
                    selected = tfo;
                }
                items.add(tfo);
            }
            this.fileCountWidget = new JComboBox(items);
            if (selected == null) {
                selected = new TwoFacedObject((Object)("Use Most Recent " + this.fileCount + " Files"), new Integer(this.fileCount));
            }
            this.fileCountWidget.setSelectedItem(selected);
        }
        return this.fileCountWidget;
    }

    public boolean isADirectory() {
        if (this.filePaths.size() == 1) {
            File f = new File(this.filePaths.get(0).toString());
            return f.isDirectory();
        }
        return false;
    }

    public boolean hasFiles() {
        return this.filePaths.size() > 0;
    }

    public boolean applyProperties() {
        if (this.dateRangeButton != null) {
            this.mode = this.dateRangeButton.isSelected() ? 3 : 1;
        }
        this.isHiddenOk = this.getHiddenWidget().isSelected();
        this.fileCount = (Integer)((TwoFacedObject)this.getFileCountWidget().getSelectedItem()).getId();
        this.setFilePath(this.getFilePathWidget().getText().trim());
        this.setFilePattern(this.getPatternWidget().getText().trim());
        this.setName(this.getNameWidget().getText().trim());
        this.setIsActive(this.getActiveWidget().isSelected());
        try {
            this.setInterval((long)(new Double(this.getIntervalWidget().getText().trim()) * 60000.0));
        }
        catch (NumberFormatException nfe) {
            LogUtil.userErrorMessage("Bad number format:" + this.getIntervalWidget().getText());
            return false;
        }
        try {
            this.setDateRange((long)(new Double(this.getDateRangeWidget().getText().trim()) * 60000.0));
        }
        catch (NumberFormatException nfe) {
            LogUtil.userErrorMessage("Bad number format:" + this.getDateRangeWidget().getText());
            return false;
        }
        return true;
    }

    public List getFiles() {
        File[] list;
        ArrayList<String> files = new ArrayList<String>();
        String filePath = this.getFile();
        File file = new File(filePath);
        if (!file.isDirectory() || !this.doILookForNewFiles()) {
            if (file.exists()) {
                files.add(file.toString());
            }
            return files;
        }
        String pattern = this.filePattern;
        if (pattern == null) {
            pattern = ".*";
        }
        if ((list = file.listFiles(new PatternFileFilter(pattern, false, this.isHiddenOk))) == null) {
            return files;
        }
        if ((list = IOUtil.getNormalFiles(list)).length == 0) {
            return files;
        }
        if (list.length == 1) {
            files.add(list[0].toString());
            return files;
        }
        list = IOUtil.sortFilesOnAge(list, true);
        if (this.mode == 1) {
            for (int i = 0; i < list.length && files.size() < this.fileCount; ++i) {
                files.add(0, list[i].toString());
            }
        } else {
            long endDate = this.mode == 3 ? Misc.getCurrentTime() : list[0].lastModified();
            long startDate = endDate - this.dateRange;
            for (int i = 0; i < list.length && list[i].lastModified() >= startDate; ++i) {
                files.add(0, list[i].toString());
            }
        }
        return files;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long newValue) {
        this.interval = newValue;
    }

    public String getFile() {
        if (this.filePaths.size() > 0) {
            return (String)this.filePaths.get(0);
        }
        return null;
    }

    public void setFilePath(String newValue) {
        this.filePaths = Misc.newList(newValue);
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public boolean hasName() {
        return this.name != null && this.name.trim().length() > 0;
    }

    public boolean hasFilePattern() {
        return this.filePattern != null && this.filePattern.trim().length() > 0;
    }

    public void setFilePattern(String newValue) {
        this.filePattern = newValue;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean newValue) {
        this.isActive = newValue;
    }

    public boolean getIsHiddenOk() {
        return this.isHiddenOk;
    }

    public void setIsHiddenOk(boolean newValue) {
        this.isHiddenOk = newValue;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Interval: ");
        buf.append(this.interval);
        buf.append(" ms, paths: ");
        buf.append(this.filePaths);
        buf.append(", pattern: ");
        buf.append(this.filePattern);
        buf.append(", active: ");
        buf.append(this.isActive);
        buf.append(", hidden OK?: ");
        buf.append(this.isHiddenOk);
        return buf.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PollingInfo)) {
            return false;
        }
        PollingInfo that = (PollingInfo)object;
        return this.interval == that.interval && this.fileCount == that.fileCount && this.forFiles == that.forFiles && this.isActive == that.isActive && this.isHiddenOk == that.isHiddenOk && Misc.equals(this.filePattern, that.filePattern) && Misc.equals(this.filePaths, that.filePaths);
    }

    public void setForFiles(boolean value) {
        this.forFiles = value;
    }

    public boolean getForFiles() {
        return this.forFiles;
    }

    public void setMode(int value) {
        this.mode = value;
    }

    public int getMode() {
        return this.mode;
    }

    public void setFileCount(int value) {
        this.fileCount = value;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public void setDateRange(long value) {
        this.dateRange = value;
    }

    public long getDateRange() {
        return this.dateRange;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("Usage: PollingInfo <file> <filepattern>");
        }
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setFilePaths(List value) {
        this.filePaths = value;
    }

    public List getFilePaths() {
        return this.filePaths;
    }
}

