/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.event.ActionListener;
import ucar.unidata.util.Misc;

public abstract class Poller
implements Runnable {
    public static boolean debug = false;
    protected ActionListener listener;
    protected long interval;
    protected boolean running = true;

    public Poller(long interval) {
        this.interval = interval;
    }

    public Poller(ActionListener listener, long interval) {
        this(interval);
        this.listener = listener;
    }

    public void init() {
        Misc.run(this);
    }

    @Override
    public void run() {
        if (debug) {
            System.err.println("Poller.run interval=" + this.interval);
        }
        int subTime = 5000;
        while (this.running) {
            long timeSlept;
            for (timeSlept = 0L; timeSlept < this.interval - (long)subTime && this.running; timeSlept += (long)subTime) {
                Misc.sleep(subTime);
            }
            if (this.running && timeSlept < this.interval) {
                Misc.sleep(this.interval - timeSlept);
            }
            if (!this.running) break;
            if (debug) {
                // empty if block
            }
            this.doPoll();
        }
        this.listener = null;
    }

    protected abstract void doPoll();

    public void stopRunning() {
        if (debug) {
            System.err.println("Poller.stopRunning");
        }
        this.listener = null;
        this.running = false;
    }

    public long getInterval() {
        return this.interval;
    }
}

