/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.WrapperException;

public class PluginClassLoader
extends ClassLoader {
    public static final String PLUGIN_PROTOCOL = "idvresource";
    private Hashtable loadedClasses = new Hashtable();
    private JarFile myJarFile;
    private String jarFilePath;
    Hashtable canonicalNames = new Hashtable();
    private URLStreamHandler urlStreamHandler;
    private List entryNames = new ArrayList();
    private ClassLoader parent;

    public PluginClassLoader(String jarFilePath, ClassLoader parent) throws IOException {
        super(parent);
        this.jarFilePath = jarFilePath;
        this.parent = parent;
        this.myJarFile = new JarFile(jarFilePath);
        this.urlStreamHandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                return PluginClassLoader.this.openURLConnection(u);
            }
        };
        List entries = Misc.toList(this.myJarFile.entries());
        for (int i = 0; i < entries.size(); ++i) {
            JarEntry entry = (JarEntry)entries.get(i);
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (name.endsWith(".class")) {
                try {
                    Class clazz = this.loadClassFromJar(entry.getName());
                }
                catch (LinkageError jlle) {
                    this.handleError("Error loading plugin class:" + entry.getName(), jlle);
                }
                continue;
            }
            this.defineResource(entry);
            this.entryNames.add(entry.getName());
        }
    }

    public String toString() {
        return this.jarFilePath;
    }

    protected void handleError(String msg, Throwable exc) {
        throw new WrapperException(msg, exc);
    }

    public void closeJar() {
        try {
            if (this.myJarFile != null) {
                this.myJarFile.close();
            }
            this.myJarFile = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List getEntryNames() {
        return this.entryNames;
    }

    private URLConnection openURLConnection(final URL u) throws IOException {
        return new URLConnection(u){

            @Override
            public void connect() throws IOException {
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return PluginClassLoader.this.getResourceAsStream(u.getFile());
            }
        };
    }

    private JarFile getJarFile() {
        if (this.myJarFile == null) {
            try {
                this.myJarFile = new JarFile(this.jarFilePath);
            }
            catch (Exception exc) {
                System.err.println("caught exception:" + exc);
                throw new WrapperException("Opening jar file:" + this.jarFilePath, exc);
            }
        }
        return this.myJarFile;
    }

    private Class loadClassFromJar(String entryName) {
        try {
            JarEntry jarEntry = this.getJarFile().getJarEntry(entryName);
            Class c = (Class)this.loadedClasses.get(jarEntry.getName());
            if (c != null) {
                return c;
            }
            InputStream is = this.getJarFile().getInputStream(jarEntry);
            byte[] bytes = IOUtil.readBytes(is);
            is.close();
            c = this.loadClass(bytes);
            this.loadedClasses.put(c.getName(), c);
            this.loadedClasses.put(jarEntry.getName(), c);
            this.checkClass(c);
            return c;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new IllegalArgumentException("Could not load class:" + entryName + "\n" + exc);
        }
    }

    protected void checkClass(Class c) throws Exception {
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class c = (Class)this.loadedClasses.get(name);
        if (c != null) {
            return c;
        }
        String fileName = StringUtil.replace(name, ".", "/");
        fileName = fileName + ".class";
        JarEntry jarEntry = this.getJarFile().getJarEntry(fileName);
        if (jarEntry != null) {
            return this.loadClassFromJar(jarEntry.getName());
        }
        return super.loadClass(name);
    }

    public Class getClassFromPlugin(String name) {
        return (Class)this.loadedClasses.get(name);
    }

    protected String defineResource(JarEntry jarEntry) {
        String entryName = jarEntry.getName();
        String name = jarEntry.getName();
        this.canonicalNames.put("/" + name, entryName);
        this.canonicalNames.put(this.jarFilePath + "!" + name, entryName);
        name = "/" + name;
        this.canonicalNames.put(this.jarFilePath + "!" + name, entryName);
        String path = "idvresource:" + this.jarFilePath + "!" + name;
        this.canonicalNames.put(path, entryName);
        this.canonicalNames.put("idvresource:" + name, entryName);
        return path;
    }

    private String getCanonicalName(String resource) {
        return (String)this.canonicalNames.get(resource);
    }

    @Override
    public URL getResource(String resource) {
        String name = this.getCanonicalName(resource);
        if (resource.indexOf("testitout") >= 0) {
            // empty if block
        }
        if (name == null) {
            return super.getResource(resource);
        }
        try {
            return new URL(PLUGIN_PROTOCOL, "", -1, resource, this.urlStreamHandler);
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    public InputStream getResourceAsStream(String resource) {
        String jarEntryName = this.getCanonicalName(resource);
        if (jarEntryName != null) {
            try {
                JarFile jarFile = this.getJarFile();
                return jarFile.getInputStream(jarFile.getJarEntry(jarEntryName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Class loadClass(byte[] bytes) {
        Permissions pc = new Permissions();
        ((PermissionCollection)pc).add(new AllPermission());
        CodeSource codeSource = new CodeSource((URL)null, (Certificate[])null);
        ProtectionDomain pd = new ProtectionDomain(codeSource, pc);
        return this.defineClass(null, bytes, 0, bytes.length, pd);
    }
}

