/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import ucar.unidata.util.StringUtil;

public class PatternFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter,
FilenameFilter {
    public static final Object NULL_OBJECT_ID = null;
    private String desc;
    private String preferredSuffix;
    private ArrayList patterns = new ArrayList();
    private Object id;
    private String thePattern;
    private boolean directoriesOk = true;
    private boolean hiddenOk = true;

    public PatternFileFilter(String patternsString, String description) {
        this(patternsString, NULL_OBJECT_ID, description, null);
    }

    public PatternFileFilter(String patternsString, String description, String suffix) {
        this(patternsString, NULL_OBJECT_ID, description, suffix);
    }

    public PatternFileFilter(String patternsString) {
        this(patternsString, true);
    }

    public PatternFileFilter(String patternsString, boolean dirsOk) {
        this(patternsString, dirsOk, true);
    }

    public PatternFileFilter(String patternsString, boolean dirsOk, boolean hiddenOk) {
        this(patternsString, NULL_OBJECT_ID, "", null);
        this.hiddenOk = hiddenOk;
        this.directoriesOk = dirsOk;
    }

    public PatternFileFilter(String patternsString, Object id, String description) {
        this(patternsString, id, description, null);
    }

    public PatternFileFilter(String patternsString, Object id, String description, String suffix) {
        this.thePattern = patternsString;
        this.preferredSuffix = suffix;
        this.desc = description;
        this.id = id;
        List<String> list = StringUtil.split(patternsString, ",");
        for (int i = 0; i < list.size(); ++i) {
            this.patterns.add(Pattern.compile(list.get(i), 2));
        }
    }

    public static List createFilters(String filterString) {
        ArrayList<PatternFileFilter> filters = new ArrayList<PatternFileFilter>();
        StringTokenizer tok = new StringTokenizer(filterString, ";");
        while (tok.hasMoreTokens()) {
            String v = tok.nextToken();
            int index = v.indexOf(":");
            if (index < 0) {
                filters.add(new PatternFileFilter(v.trim(), v));
                continue;
            }
            String pattern = v.substring(0, index);
            String desc = v.substring(index + 1);
            filters.add(new PatternFileFilter(pattern.trim(), desc));
        }
        return filters;
    }

    public Object getId() {
        return this.id;
    }

    public String toString() {
        return "PATTERN<" + this.thePattern + ">" + " desc(" + this.desc + ")";
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return this.directoriesOk;
        }
        if ((file.isHidden() || file.getName().startsWith(".")) && !this.hiddenOk) {
            return false;
        }
        String name = file.getName();
        return this.match(name);
    }

    @Override
    public boolean accept(File dir, String name) {
        return this.match(name);
    }

    public boolean match(String name) {
        try {
            for (int i = 0; i < this.patterns.size(); ++i) {
                Pattern p = (Pattern)this.patterns.get(i);
                if (!p.matcher(name).find()) continue;
                return true;
            }
            return false;
        }
        catch (Exception exc) {
            return false;
        }
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public void setPreferredSuffix(String value) {
        this.preferredSuffix = value;
    }

    public String getPreferredSuffix() {
        return this.preferredSuffix;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("usage: pattern strings");
            return;
        }
        PatternFileFilter filter = new PatternFileFilter(args[0]);
        for (int i = 1; i < args.length; ++i) {
            System.err.println(args[i] + (filter.match(args[i]) ? "  MATCH" : "  NO MATCH"));
        }
    }
}

