/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;

public final class NaiveTrustProvider
extends Provider {
    private static final String TRUST_PROVIDER_ALG = "NaiveTrustAlgorithm";
    private static final String TRUST_PROVIDER_ID = "NaiveTrustProvider";

    public NaiveTrustProvider() {
        super(TRUST_PROVIDER_ID, 0.1, "NaiveTrustProvider (provides all secure socket factories by ignoring problems in the chain of certificate trust)");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                NaiveTrustProvider.this.put("TrustManagerFactory." + NaiveTrustManagerFactory.getAlgorithm(), NaiveTrustManagerFactory.class.getName());
                return null;
            }
        });
    }

    public static void setAlwaysTrust(boolean enableNaiveTrustProvider) {
        if (enableNaiveTrustProvider) {
            Provider registered = Security.getProvider(TRUST_PROVIDER_ID);
            if (null == registered) {
                Security.insertProviderAt(new NaiveTrustProvider(), 1);
                Security.setProperty("ssl.TrustManagerFactory.algorithm", TRUST_PROVIDER_ALG);
            }
        } else {
            throw new UnsupportedOperationException("Disable Naive trust provider not yet implemented");
        }
    }

    private static class NaiveTrustManager
    implements X509TrustManager {
        private NaiveTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] cert, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] cert, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    public static final class NaiveTrustManagerFactory
    extends TrustManagerFactorySpi {
        @Override
        protected void engineInit(ManagerFactoryParameters mgrparams) {
        }

        @Override
        protected void engineInit(KeyStore keystore) {
        }

        @Override
        protected TrustManager[] engineGetTrustManagers() {
            return new TrustManager[]{new NaiveTrustManager()};
        }

        public static String getAlgorithm() {
            return NaiveTrustProvider.TRUST_PROVIDER_ALG;
        }
    }
}

