/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ResourceCollection;
import ucar.unidata.util.StringUtil;

public class Msg {
    private static Hashtable dontComponents = new Hashtable();
    private static Hashtable dontRecurseComponents = new Hashtable();
    private static boolean enabled = false;
    private static Properties messages;
    private static boolean showNoMsg;
    private static boolean debug;
    private static Hashtable seenMsgs;
    private static OutputStream seenStream;
    static List stack;

    public static void setShowDebug(boolean b) {
        showNoMsg = b;
        if (b) {
            enabled = true;
        }
    }

    public static void init(ResourceCollection rc) {
        for (int i = rc.size() - 1; i >= 0; --i) {
            InputStream is = null;
            try {
                is = IOUtil.getInputStream((String)rc.get(i), Msg.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (is == null) continue;
            if (messages == null) {
                messages = new Properties();
            }
            try {
                messages.load(is);
                is.close();
                continue;
            }
            catch (Exception exc) {
                System.err.println("Loading msgs:" + exc);
            }
        }
        if (messages == null) {
            enabled = false;
            return;
        }
        boolean bl = enabled = seenStream != null || showNoMsg || messages.size() > 0;
        if (enabled) {
            Msg.initStatics();
        }
    }

    public static void recordMessages(File file) {
        if (messages == null) {
            messages = new Properties();
        }
        enabled = true;
        if (seenMsgs != null) {
            return;
        }
        try {
            Properties existing = null;
            if (file.exists() && GuiUtils.showYesNoDialog(null, "The file: " + file + " exists. Do you want to merge these already defined messages?", "File exists")) {
                existing = Misc.readProperties(file.toString(), null, Msg.class);
            }
            seenMsgs = new Hashtable();
            seenStream = new FileOutputStream(file);
            if (existing != null) {
                Enumeration<Object> keys = existing.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = (String)existing.get(key);
                    seenMsgs.put(key, key);
                    seenStream.write((key + "=" + value + "\n").getBytes());
                    seenStream.flush();
                }
            }
        }
        catch (Exception exc) {
            System.err.println("Error in Msg.recordMessages:" + file);
            exc.printStackTrace();
        }
    }

    public static void initStatics() {
        if (messages == null) {
            return;
        }
    }

    public static String msg(String original) {
        if (!enabled) {
            return original;
        }
        return Msg._msg(original, original);
    }

    public static String msg(String original, String param1) {
        if (enabled) {
            original = Msg.msg(original);
        }
        return StringUtil.replace(original, "${param1}", param1);
    }

    public static String msg(String original, String param1, String param2) {
        if (enabled) {
            original = Msg.msg(original);
        }
        original = StringUtil.replace(original, "${param1}", param1);
        original = StringUtil.replace(original, "${param2}", param2);
        return original;
    }

    private static void write(String original) {
        if (seenMsgs != null) {
            String trimmed = original.trim();
            String name = Msg.getKey(trimmed = StringUtil.replace(trimmed, "=", ""));
            if (name.length() > 0 && seenMsgs.get(name) == null) {
                seenMsgs.put(name, name);
                try {
                    seenStream.write((name + "=" + trimmed + "\n").getBytes());
                    seenStream.flush();
                }
                catch (Exception exc) {
                    System.err.println("Error writing messages");
                    exc.printStackTrace();
                    seenMsgs = null;
                    seenStream = null;
                }
            }
        }
    }

    private static String getKey(String name) {
        name = StringUtil.replace(name, " ", "_");
        name = StringUtil.replace(name, ":", "");
        name = StringUtil.replace(name, "...", "");
        name = name.trim();
        return name;
    }

    private static String _msg(String original, String dflt) {
        String name;
        String tmp;
        if (showNoMsg) {
            if (dflt != null) {
                if (dflt.trim().length() > 0 && !dflt.startsWith("NO-")) {
                    dflt = "NO-" + dflt;
                }
            } else if (original != null && original.trim().length() > 0 && !original.startsWith("NO-")) {
                dflt = "NO-" + original;
            }
        }
        if (!enabled || original == null || messages == null) {
            return dflt;
        }
        if (debug) {
            System.err.println("msg: original: <" + original + ">");
        }
        if ((tmp = (String)messages.get(name = Msg.getKey(original))) != null) {
            if (debug) {
                System.err.println("msg: got it:" + tmp);
            }
            return tmp;
        }
        if (original.startsWith("<html>")) {
            return dflt;
        }
        String trimmed = original.trim();
        if (trimmed.endsWith(":")) {
            if (debug) {
                System.err.println("msg-1:got ':'");
            }
            String substring = trimmed.substring(0, trimmed.length() - 1);
            if (tmp == null) {
                Msg.write(substring);
                return dflt;
            }
            int index = 0;
            tmp = tmp + ":";
            while (original.startsWith(" ", index)) {
                tmp = " " + tmp;
                ++index;
            }
            while (original.endsWith(" ")) {
                tmp = tmp + " ";
                original = original.substring(0, original.length() - 2);
            }
            return tmp + ":";
        }
        if (original.endsWith("...")) {
            String substring = original.substring(0, original.length() - 3);
            if (tmp == null) {
                Msg.write(substring);
                return dflt;
            }
            return tmp + "...";
        }
        Msg.write(original);
        return dflt;
    }

    public static void addDontComponent(Component comp) {
        dontComponents.put(comp, comp);
    }

    public static void addDontRecurseComponent(Component comp) {
        dontRecurseComponents.put(comp, comp);
    }

    public static void translateTree(Component comp) {
        if (!enabled || messages == null) {
            return;
        }
        Msg.translateTree(comp, true, false);
    }

    public static void translateTree(Component comp, boolean doTabTitles) {
        if (!enabled || messages == null) {
            return;
        }
        Msg.translateTree(comp, doTabTitles, false);
    }

    public static void translateTree(Component comp, boolean doTabTitles, boolean debug) {
        int i;
        String tt;
        if (comp == null || !enabled || messages == null) {
            return;
        }
        if (dontComponents.get(comp) != null) {
            return;
        }
        if (comp instanceof SkipPanel) {
            return;
        }
        if (debug) {
            System.err.println("comp:" + comp.getClass().getName());
        }
        if (comp instanceof JComponent && (tt = ((JComponent)comp).getToolTipText()) != null && (tt = Msg._msg(tt, null)) != null) {
            ((JComponent)comp).setToolTipText(tt);
        }
        if (comp instanceof JTabbedPane && doTabTitles) {
            JTabbedPane tab = (JTabbedPane)comp;
            for (i = 0; i < tab.getTabCount(); ++i) {
                String title = Msg._msg(tab.getTitleAt(i), null);
                if (title == null) continue;
                tab.setTitleAt(i, title);
            }
        }
        if (comp instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)comp;
            String msg = Msg._msg(mi.getText(), null);
            if (msg != null) {
                int keyCode;
                mi.setText(msg);
                String mnemonic = Msg._msg("mnemonic_" + msg, null);
                if (mnemonic == null || (keyCode = GuiUtils.charToKeyCode(mnemonic)) != -1) {
                    // empty if block
                }
            }
            if (comp instanceof JMenu && dontRecurseComponents.get(comp) == null) {
                JMenu menu = (JMenu)comp;
                for (int i2 = 0; i2 < menu.getItemCount(); ++i2) {
                    Msg.translateTree(menu.getItem(i2), doTabTitles, debug);
                }
            }
            return;
        }
        if (comp instanceof JLabel) {
            String msg;
            JLabel label = (JLabel)comp;
            String lblText = label.getText();
            if (lblText != null && (msg = Msg._msg(lblText, null)) != null) {
                ((JLabel)comp).setText(msg);
            }
            return;
        }
        if (comp instanceof AbstractButton) {
            AbstractButton btn = (AbstractButton)comp;
            String msg = Msg._msg(btn.getText(), null);
            if (msg != null) {
                ((AbstractButton)comp).setText(msg);
            }
            return;
        }
        if (!(comp instanceof Container) || comp instanceof JTree || comp instanceof JTable || comp instanceof JList) {
            return;
        }
        if (dontRecurseComponents.get(comp) != null) {
            return;
        }
        Container c = (Container)comp;
        for (i = 0; i < c.getComponentCount(); ++i) {
            Component child = c.getComponent(i);
            Msg.translateTree(child, doTabTitles, debug);
        }
    }

    static {
        showNoMsg = false;
        debug = false;
        stack = new ArrayList();
    }

    public static class SkipPanel
    extends JPanel {
        public SkipPanel(LayoutManager layout) {
            super(layout);
        }

        public SkipPanel(Component comp) {
            this.setLayout(new BorderLayout());
            this.add("Center", comp);
        }
    }
}

