/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.unidata.util.ContourInfo;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.PluginClassLoader;
import ucar.unidata.util.PrototypeManager;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;

public class Misc {
    private static PrototypeManager prototypeManager;
    public static boolean debug;
    private static List<ClassLoader> classLoaders;
    private static long overrideCurrentTime;
    public static final String MISSING = "missing";
    public static final String NaN = "NaN";
    private static String baseTime;
    private static int objectCount;
    static DecimalFormat formatter;
    static DecimalFormat format0;
    static DecimalFormat format1;
    static DecimalFormat format2;
    static DecimalFormat format3;
    static DecimalFormat format4;
    static DecimalFormat format5;
    static DecimalFormat format6;
    static DecimalFormat format7;

    public static void setPrototypeManager(PrototypeManager prototypeManager) {
        if (Misc.prototypeManager != null) {
            throw new IllegalStateException("Only allow one prototype manager");
        }
        Misc.prototypeManager = prototypeManager;
    }

    public static PrototypeManager getPrototypeManager() {
        return prototypeManager;
    }

    public static long getCurrentTime() {
        if (overrideCurrentTime != -1L) {
            return overrideCurrentTime;
        }
        return System.currentTimeMillis();
    }

    public static void setCurrentTime(Date date) {
        overrideCurrentTime = date.getTime();
    }

    public static double toDouble(Object o) {
        if (o instanceof Double) {
            return (Double)o;
        }
        return Double.parseDouble(o.toString());
    }

    public static String formatLatitude(double value, String format) {
        return Misc.formatLatOrLon(value, format, true, false);
    }

    public static String formatLongitude(double value, String format, boolean use360) {
        return Misc.formatLatOrLon(value, format, false, use360);
    }

    public static String formatLatOrLon(double value, String format, boolean isLatitude, boolean use360) {
        if (Double.isNaN(value)) {
            return NaN;
        }
        String formatted = format;
        if (!isLatitude) {
            double tval = value;
            if (use360) {
                while (tval < 0.0 || tval > 361.0) {
                    tval = 180.0 + Math.IEEEremainder(tval - 180.0, 360.0);
                }
            } else if (!use360) {
                tval = Misc.normalizeLongitude(tval);
            }
            value = tval;
        }
        double pvalue = Math.abs(value);
        int j = (int)(3600.0 * pvalue);
        int idegrees = j / 3600;
        double decidegrees = pvalue - (double)((int)pvalue);
        double dminutes = decidegrees * 60.0;
        int minutes = (int)dminutes;
        double deciminutes = dminutes - (double)minutes;
        double dseconds = deciminutes * 60.0;
        int seconds = (int)dseconds;
        double deciseconds = dseconds - (double)seconds;
        formatted = Misc.replaceDecimalPortion(formatted, "d", decidegrees);
        formatted = Misc.replaceDecimalPortion(formatted, "m", deciminutes);
        formatted = Misc.replaceDecimalPortion(formatted, "s", deciseconds);
        formatted = formatted.replaceAll("DD", String.valueOf(idegrees));
        formatted = formatted.replaceAll("MM", StringUtil.padZero(minutes, 2));
        formatted = formatted.replaceAll("SS", StringUtil.padZero(format.contains("s") ? seconds : (int)Math.round(dseconds), 2));
        if (format.indexOf("H") >= 0) {
            formatted = use360 ? formatted.replace("H", "") : (Math.abs(value) == 180.0 ? formatted.replace("H", "") : (value < 0.0 ? formatted.replace("H", isLatitude ? "S" : "W") : (value > 0.0 ? formatted.replace("H", isLatitude ? "N" : "E") : formatted.replace("H", ""))));
        } else if (value < 0.0 && !use360) {
            formatted = "-" + formatted;
        }
        return formatted.trim();
    }

    private static String replaceDecimalPortion(String format, String letter, double decimalValue) {
        block0: {
            Matcher matcher = Pattern.compile(letter + "+").matcher(format);
            if (!matcher.find()) break block0;
            int numChars = matcher.end() - matcher.start();
            String valueStr = String.valueOf(Math.round(decimalValue * Math.pow(10.0, numChars)));
            valueStr = StringUtil.padRight(valueStr, numChars, "0");
            format = matcher.replaceFirst(valueStr);
        }
        return format;
    }

    public static double decodeLatLon(String latlon) {
        latlon = latlon.trim();
        int dirIndex = -1;
        int southOrWest = 1;
        double value = Double.NaN;
        if (latlon.indexOf("S") > 0) {
            southOrWest = -1;
            dirIndex = latlon.indexOf("S");
        } else if (latlon.indexOf("W") > 0) {
            southOrWest = -1;
            dirIndex = latlon.indexOf("W");
        } else if (latlon.indexOf("N") > 0) {
            dirIndex = latlon.indexOf("N");
        } else if (latlon.endsWith("E")) {
            dirIndex = latlon.lastIndexOf("E");
        }
        if (dirIndex > 0) {
            latlon = latlon.substring(0, dirIndex).trim();
        }
        if (latlon.indexOf("-") == 0) {
            southOrWest *= -1;
            latlon = latlon.substring(latlon.indexOf("-") + 1).trim();
        }
        if (latlon.indexOf(":") >= 0) {
            int firstIdx = latlon.indexOf(":");
            String hours = latlon.substring(0, firstIdx);
            String minutes = latlon.substring(firstIdx + 1);
            String seconds = "";
            if (minutes.indexOf(":") >= 0) {
                firstIdx = minutes.indexOf(":");
                String temp = minutes.substring(0, firstIdx);
                seconds = minutes.substring(firstIdx + 1);
                minutes = temp;
            }
            try {
                double d = value = hours.equals("") ? 0.0 : Double.parseDouble(hours);
                if (!minutes.equals("")) {
                    value += Double.parseDouble(minutes) / 60.0;
                }
                if (!seconds.equals("")) {
                    value += Double.parseDouble(seconds) / 3600.0;
                }
            }
            catch (NumberFormatException nfe) {
                value = Double.NaN;
            }
        } else {
            try {
                value = Misc.parseNumber(latlon);
            }
            catch (NumberFormatException nfe) {
                value = Double.NaN;
            }
        }
        return value * (double)southOrWest;
    }

    public static List reverseList(List l) {
        ArrayList l2 = new ArrayList();
        for (Object o : l) {
            l2.add(0, o);
        }
        return l2;
    }

    public static Object[] reverseArray(Object[] fromArray, Object[] toArray) {
        if (toArray == null) {
            toArray = new Object[fromArray.length];
        }
        for (int i = 0; i < fromArray.length; ++i) {
            toArray[i] = fromArray[fromArray.length - i - 1];
        }
        return toArray;
    }

    public static String getClassName(Class c) {
        String f = c.getName();
        int idx = f.lastIndexOf(".");
        if (idx < 0) {
            return f;
        }
        return f.substring(idx + 1);
    }

    public static void propertySet(Object object, String name, String value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Misc.propertySet(object, name, value, false);
    }

    public static boolean propertySet(Object object, String name, String value, boolean ignoreError) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return Misc.setProperty(object, name, (Object)value, ignoreError);
    }

    public static String getSetterMethod(String prop) {
        return "set" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
    }

    public static boolean setProperty(Object object, String name, Object objectValue, boolean ignoreError) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Method method = Misc.findMethod(object.getClass(), methodName, new Class[]{null});
        if (method == null) {
            if (!ignoreError) {
                System.err.println("could not find method:" + methodName + ": on class:" + object.getClass().getName());
            }
            return false;
        }
        return Misc.setProperty(object, method, objectValue, ignoreError);
    }

    public static boolean setProperty(Object object, Method method, Object objectValue, boolean ignoreError) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (method == null) {
            if (!ignoreError) {
                System.err.println("Method can't be null");
            }
            return false;
        }
        Object argument = null;
        Class<?> paramType = method.getParameterTypes()[0];
        if (paramType.equals(objectValue.getClass())) {
            argument = objectValue;
        } else if (paramType.isAssignableFrom(objectValue.getClass())) {
            argument = objectValue;
        } else {
            String value = objectValue.toString();
            if (paramType.equals(Integer.class)) {
                argument = new Integer(value);
            } else if (paramType.equals(String.class)) {
                argument = value;
            } else if (paramType.equals(ContourInfo.class)) {
                argument = new ContourInfo(value);
            } else if (paramType.equals(Range.class)) {
                int idx = value.indexOf(":");
                if (idx >= 0) {
                    argument = new Range(new Double(value.substring(0, idx)), new Double(value.substring(idx + 1)));
                }
            } else if (paramType.equals(Double.TYPE)) {
                argument = new Double(value);
            } else if (paramType.equals(Integer.TYPE)) {
                argument = new Integer(value);
            } else if (paramType.equals(Float.TYPE)) {
                argument = new Float(value);
            } else if (paramType.equals(Boolean.TYPE)) {
                argument = new Boolean(value);
            } else if (paramType.equals(Rectangle2D.Float.class)) {
                String[] toks = StringUtil.split(value, ",", 4);
                argument = new Rectangle2D.Float(Float.parseFloat(toks[0]), Float.parseFloat(toks[1]), Float.parseFloat(toks[2]), Float.parseFloat(toks[3]));
            } else if (paramType.equals(Rectangle2D.Double.class)) {
                String[] toks = StringUtil.split(value, ",", 4);
                argument = new Rectangle2D.Double(Double.parseDouble(toks[0]), Double.parseDouble(toks[1]), Double.parseDouble(toks[2]), Double.parseDouble(toks[3]));
            } else if (paramType.equals(Color.class)) {
                argument = GuiUtils.decodeColor(value, Color.white);
            } else if (paramType.equals(Dimension.class)) {
                int idx = value.indexOf(":");
                if (idx >= 0) {
                    argument = new Dimension(new Integer(value.substring(0, idx)), new Integer(value.substring(idx + 1)));
                }
            } else if (paramType.equals(Object.class)) {
                argument = value;
            }
        }
        if (argument == null && !ignoreError) {
            System.err.println("Misc.propertySet: Unknown type:" + paramType.getName());
        }
        if (argument != null) {
            method.invoke(object, argument);
            return true;
        }
        return false;
    }

    public static int getInt(String stringValue, int dflt) {
        if (stringValue != null) {
            try {
                dflt = Integer.decode(stringValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dflt;
    }

    public static boolean getBoolean(String stringValue, boolean dflt) {
        if (stringValue != null) {
            try {
                dflt = new Boolean(stringValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dflt;
    }

    public static Vector toVector(Object[] objectArray) {
        Vector<Object> v = new Vector<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            v.add(objectArray[i]);
        }
        return v;
    }

    public static <E> List<E> makeUnique(List<E> l) {
        return new ArrayList<E>(new HashSet<E>(l));
    }

    public static List toList(Object[] l) {
        ArrayList<Object> v = new ArrayList<Object>();
        for (int i = 0; i < l.length; ++i) {
            v.add(l[i]);
        }
        return v;
    }

    public static List toList(Enumeration enumeration) {
        ArrayList list = new ArrayList();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public static List newList(Object[] l) {
        return Misc.toList(l);
    }

    public static Object safeGet(List l, int index) {
        if (l == null) {
            return null;
        }
        if (index < l.size()) {
            return l.get(index);
        }
        return null;
    }

    public static List createIntervalList(int start, int end, int step) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = start; i <= end; i += step) {
            l.add(new Integer(i));
        }
        return l;
    }

    public static List sort(Collection listToSort) {
        Object[] array = listToSort.toArray();
        Arrays.sort(array);
        return Arrays.asList(array);
    }

    public static List sortTuples(List pairs, final boolean ascending) {
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                Object[] a1 = (Object[])o1;
                Object[] a2 = (Object[])o2;
                int result = ((Comparable)a1[0]).compareTo(a2[0]);
                if (ascending || result == 0) {
                    return result;
                }
                return -result;
            }

            @Override
            public boolean equals(Object obj) {
                return obj == this;
            }
        };
        Object[] array = pairs.toArray();
        Arrays.sort(array, comp);
        return Arrays.asList(array);
    }

    public static Properties parseProperties(String propString) {
        return Misc.parseProperties(propString, ";");
    }

    public static Properties parseProperties(String propString, String delimiter) {
        Properties p = new Properties();
        if (propString == null) {
            return p;
        }
        StringTokenizer tok = new StringTokenizer(propString, delimiter);
        while (tok.hasMoreTokens()) {
            String nameValue = tok.nextToken();
            int idx = nameValue.indexOf("=");
            if (idx < 0) continue;
            p.put(nameValue.substring(0, idx).trim(), nameValue.substring(idx + 1).trim());
        }
        return p;
    }

    public static String getProperty(Hashtable p, String prop, String dflt) {
        if (p == null) {
            return dflt;
        }
        Object v = p.get(prop);
        if (v != null) {
            return v.toString();
        }
        return dflt;
    }

    public static Color getProperty(Hashtable props, String prop, Color dflt) {
        if (props == null) {
            return dflt;
        }
        Object v = props.get(prop);
        if (v == null) {
            return dflt;
        }
        return Color.decode(v.toString());
    }

    public static boolean getProperty(Hashtable props, String prop, boolean dflt) {
        if (props == null) {
            return dflt;
        }
        Object v = props.get(prop);
        if (v == null) {
            return dflt;
        }
        return new Boolean(v.toString());
    }

    public static int getProperty(Hashtable props, String prop, int dflt) {
        if (props == null) {
            return dflt;
        }
        Object v = props.get(prop);
        if (v == null) {
            return dflt;
        }
        try {
            return Integer.parseInt(v.toString());
        }
        catch (NumberFormatException e) {
            System.err.println("Number format exception: " + prop + " " + v);
            return dflt;
        }
    }

    public static float getProperty(Hashtable props, String prop, float dflt) {
        if (props == null) {
            return dflt;
        }
        Object v = props.get(prop);
        if (v == null) {
            return dflt;
        }
        try {
            return Float.parseFloat(v.toString());
        }
        catch (NumberFormatException e) {
            System.err.println("Number format exception: " + prop + " " + v);
            return dflt;
        }
    }

    public static double getProperty(Hashtable props, String prop, double dflt) {
        if (props == null) {
            return dflt;
        }
        Object v = props.get(prop);
        if (v == null) {
            return dflt;
        }
        try {
            return Float.parseFloat(v.toString());
        }
        catch (NumberFormatException e) {
            System.err.println("Number format exception: " + prop + " " + v);
            return dflt;
        }
    }

    public static Properties readProperties(String filename, Properties properties, Class origin) {
        InputStream s = null;
        try {
            s = IOUtil.getInputStream(filename, origin);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Could not open  property file:" + filename);
        }
        if (properties == null) {
            properties = new Properties();
        }
        try {
            properties.load(s);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Could not open  property file:" + filename + " Exception:" + exc);
        }
        return properties;
    }

    public static URL getURL(String name, Class origin) {
        URL url = null;
        while (origin != null && (url = origin.getResource(name)) == null) {
            origin = origin.getSuperclass();
        }
        return url;
    }

    public static String appendUrlArgs(String base, String[] args) {
        return Misc.appendUrlArgs(base, args, true);
    }

    public static String appendUrlArgs(String base, String[] args, boolean addQuestionMark) {
        StringBuffer sb = new StringBuffer(base);
        if (args != null) {
            for (int i = 0; i < args.length; i += 2) {
                if (i == 0) {
                    if (addQuestionMark) {
                        sb.append("?");
                    }
                } else {
                    sb.append("&");
                }
                sb.append(args[i]);
                sb.append("=");
                sb.append(args[i + 1]);
            }
        }
        return sb.toString();
    }

    public static String makeUrl(String protocol, String server, String urlRoot, String[] args) {
        StringBuffer sb = new StringBuffer(protocol);
        sb.append("://");
        sb.append(server);
        sb.append(urlRoot);
        return Misc.appendUrlArgs(sb.toString(), args);
    }

    public static void run(Runnable r) {
        Misc.runInABit(1L, r);
    }

    public static void run(Object object, String methodName) {
        Misc.runInABit(0L, object, methodName, null);
    }

    public static void run(Object object, String methodName, Object arg) {
        Misc.runInABit(0L, object, methodName, arg);
    }

    public static void runInABit(long ms, final Object object, String methodName, final Object arg) {
        try {
            Method theMethod;
            Method method = theMethod = arg == null ? Misc.findMethod(object.getClass(), methodName, new Class[0]) : Misc.findMethod(object.getClass(), methodName, new Class[]{arg.getClass()});
            if (theMethod == null) {
                throw new IllegalArgumentException("Could not find method:" + object.getClass().getName() + "." + methodName);
            }
            Misc.runInABit(ms, new Runnable(){

                @Override
                public void run() {
                    try {
                        if (arg == null) {
                            theMethod.invoke(object, new Object[0]);
                        } else {
                            theMethod.invoke(object, arg);
                        }
                    }
                    catch (Exception exc) {
                        System.err.println("Error in Misc.run:" + exc);
                        exc.printStackTrace();
                    }
                }
            });
        }
        catch (Exception exc) {
            System.err.println("Error in Misc.run:" + exc);
            exc.printStackTrace();
        }
    }

    public static void runInABit(final long ms, final Runnable r) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    3.sleep(ms);
                    r.run();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
    }

    public static String doPost(String action, String data) {
        return Misc.doPost(action, data, null);
    }

    public static String doPost(String action, String data, String[] attrs) {
        Object[] result = Misc.doPostAndGetConnection(action, data, attrs);
        if (result == null) {
            return null;
        }
        return (String)result[1];
    }

    public static Object[] doPostAndGetConnection(String action, String data) {
        return Misc.doPostAndGetConnection(action, data, null);
    }

    public static Object[] doPostAndGetConnection(String action, String data, String[] attrs) {
        HttpURLConnection urlConn = null;
        try {
            String str;
            URL url = new URL(action);
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestMethod("POST");
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            if (attrs != null) {
                for (int i = 0; i < attrs.length; i += 2) {
                    urlConn.setRequestProperty(attrs[i], attrs[i + 1]);
                }
            }
            DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
            printout.writeBytes(data);
            printout.flush();
            printout.close();
            BufferedReader input = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
            StringBuffer result = new StringBuffer();
            while (null != (str = input.readLine())) {
                result.append(str);
            }
            input.close();
            return new Object[]{urlConn, result.toString()};
        }
        catch (Exception exc) {
            System.err.println("Error:" + exc);
            exc.printStackTrace();
            try {
                System.err.println("UrlC:" + urlConn.getResponseMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new Object[]{urlConn, null};
        }
    }

    public static String getValue(String key, Hashtable props) {
        int idx1;
        String value = (String)props.get(key);
        if (value == null) {
            return null;
        }
        String returnValue = "";
        while ((idx1 = value.indexOf("macro.")) >= 0) {
            char c;
            int idx2;
            returnValue = returnValue + value.substring(0, idx1);
            value = value.substring(idx1);
            int length = value.length();
            for (idx2 = 0; idx2 < length && ((c = value.charAt(idx2)) == '.' || Character.isLetterOrDigit(c)); ++idx2) {
            }
            String macroKey = value.substring(0, idx2);
            value = value.substring(idx2);
            String macroValue = (String)props.get(macroKey.trim());
            if (macroValue == null) continue;
            returnValue = returnValue + macroValue;
        }
        returnValue = returnValue + value;
        return returnValue;
    }

    public static String getUniqueId() {
        if (baseTime == null) {
            baseTime = "" + System.currentTimeMillis() + "_" + Math.random();
            baseTime = baseTime.replace('.', '_');
        }
        return baseTime + "_" + ++objectCount;
    }

    public static List addUnique(List dest, List src, Hashtable seen) {
        if (src != null) {
            for (int i = 0; i < src.size(); ++i) {
                Object o = src.get(i);
                if (seen.get(o) != null) continue;
                seen.put(o, o);
                dest.add(o);
            }
        }
        return dest;
    }

    public static List cloneList(List sourceList) {
        if (sourceList == null) {
            return null;
        }
        return new ArrayList(sourceList);
    }

    public static Hashtable newHashtable(Hashtable ht, Object[] o) {
        if (ht == null) {
            ht = new Hashtable<Object, Object>();
        }
        for (int i = 0; i < o.length; i += 2) {
            ht.put(o[i], o[i + 1]);
        }
        return ht;
    }

    public static Hashtable newHashtable(Object[] o) {
        return Misc.newHashtable(new Hashtable(), o);
    }

    public static Hashtable newHashtable(Object key1, Object value1) {
        return Misc.newHashtable(new Object[]{key1}, new Object[]{value1});
    }

    public static Hashtable newHashtable(Object key1, Object value1, Object key2, Object value2) {
        return Misc.newHashtable(new Object[]{key1, key2}, new Object[]{value1, value2});
    }

    public static Hashtable newHashtable(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3) {
        return Misc.newHashtable(new Object[]{key1, key2, key3}, new Object[]{value1, value2, value3});
    }

    public static Hashtable newHashtable(Object[] keys, Object[] values) {
        Hashtable<Object, Object> ht = new Hashtable<Object, Object>();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null || values[i] == null) continue;
            ht.put(keys[i], values[i]);
        }
        return ht;
    }

    public static Object getLast(List l) {
        if (l == null || l.size() == 0) {
            return null;
        }
        return l.get(l.size() - 1);
    }

    public static void removeLast(List l) {
        if (l == null || l.size() == 0) {
            return;
        }
        l.remove(l.size() - 1);
    }

    public static List newList(Object o1) {
        return Misc.toList(new Object[]{o1});
    }

    public static List newList(Object o1, Object o2) {
        return Misc.toList(new Object[]{o1, o2});
    }

    public static List newList(Object o1, Object o2, Object o3) {
        return Misc.toList(new Object[]{o1, o2, o3});
    }

    public static List newList(Object o1, Object o2, Object o3, Object o4) {
        return Misc.toList(new Object[]{o1, o2, o3, o4});
    }

    public static List newList(Object o1, Object o2, Object o3, Object o4, Object o5) {
        return Misc.toList(new Object[]{o1, o2, o3, o4, o5});
    }

    public static List newList(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
        return Misc.toList(new Object[]{o1, o2, o3, o4, o5, o6});
    }

    public static List newList(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7) {
        return Misc.toList(new Object[]{o1, o2, o3, o4, o5, o6, o7});
    }

    public static boolean isHtml(String s) {
        if ((s = s.trim().toLowerCase()).startsWith("<!doctype html")) {
            return true;
        }
        return s.indexOf("<html") >= 0;
    }

    public static boolean typesMatch(Class[] formals, Class[] actuals) {
        if (formals.length != actuals.length) {
            return false;
        }
        for (int j = 0; j < formals.length; ++j) {
            if (actuals[j] == null || formals[j].isAssignableFrom(actuals[j])) continue;
            return false;
        }
        return true;
    }

    public static boolean typesMatchx(Class[] formals, Class[] actuals) {
        if (formals.length != actuals.length) {
            System.err.println("Bad length");
            return false;
        }
        for (int j = 0; j < formals.length; ++j) {
            if (actuals[j] == null || formals[j].isAssignableFrom(actuals[j])) continue;
            System.err.println("not assignable " + formals[j].getName() + " " + actuals[j].getName() + " equals? " + formals[j].equals(actuals[j]));
            return false;
        }
        return true;
    }

    public static Method findMethod(Class c, String methodName, Class[] paramTypes) {
        ArrayList<Method> all = new ArrayList<Method>();
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            if (paramTypes == null) {
                return methods[i];
            }
            if (!Misc.typesMatch(methods[i].getParameterTypes(), paramTypes)) continue;
            all.add(methods[i]);
        }
        if (all.size() > 1) {
            String msg = "More than one method: " + methodName + " found for class:" + c.getName();
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramTypes[i] == null) continue;
                msg = msg + " " + paramTypes[i].getName();
            }
            throw new IllegalArgumentException(msg);
        }
        if (all.size() == 1) {
            return (Method)all.get(0);
        }
        return null;
    }

    public static String getClassMethod(String path) {
        int i2;
        int i1 = path.lastIndexOf(".");
        if (i1 == (i2 = path.indexOf("."))) {
            return path;
        }
        String methodName = path.substring(i1 + 1);
        path = path.substring(0, i1);
        String className = path.substring(path.lastIndexOf(".") + 1);
        return className + "." + methodName;
    }

    public static List getIndexList(List values, List allValues) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (values == null || allValues == null) {
            return indices;
        }
        for (int i = 0; i < values.size(); ++i) {
            int index = allValues.indexOf(values.get(i));
            if (index < 0) continue;
            indices.add(new Integer(index));
        }
        return indices;
    }

    public static List getValuesFromIndices(List indices, List allValues) {
        ArrayList valueList = new ArrayList();
        if (indices == null || allValues == null) {
            return valueList;
        }
        for (int i = 0; i < indices.size(); ++i) {
            int index = (Integer)indices.get(i);
            if (index < 0 || index >= allValues.size()) continue;
            valueList.add(allValues.get(index));
        }
        return valueList;
    }

    public static Constructor findConstructor(Class c, Class[] paramTypes) {
        ArrayList allCtors = new ArrayList();
        Constructor<?>[] constructors = c.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (!Misc.typesMatch(constructors[i].getParameterTypes(), paramTypes)) continue;
            allCtors.add(constructors[i]);
        }
        if (allCtors.size() > 1) {
            throw new IllegalArgumentException("More than one constructors matched for class:" + c.getName());
        }
        if (allCtors.size() == 1) {
            return (Constructor)allCtors.get(0);
        }
        return null;
    }

    public static String getSystemProperty(String key, String dflt) {
        try {
            String result = System.getProperty(key);
            if (result == null) {
                result = dflt;
            }
            return result;
        }
        catch (SecurityException e) {
            System.out.println("ObjectStore: not allowed to get Property " + key);
            return dflt;
        }
    }

    public static byte[] serialize(Serializable object) {
        try {
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            ObjectOutputStream p = new ObjectOutputStream(ostream);
            p.writeObject(object);
            p.flush();
            ostream.close();
            byte[] bytes = ostream.toByteArray();
            return bytes;
        }
        catch (Exception exc) {
            System.err.println("Error serializing:" + exc);
            return null;
        }
    }

    public static Object deserialize(byte[] bytes) {
        try {
            ByteArrayInputStream istream = new ByteArrayInputStream(bytes);
            ObjectInputStream p = new ObjectInputStream(istream);
            Object theObject = p.readObject();
            return theObject;
        }
        catch (Exception exc) {
            System.err.println("Error deserializing:" + exc);
            return null;
        }
    }

    public static DecimalFormat getDecimalFormat(double v) {
        if ((v = Math.abs(v)) == 0.0) {
            return format0;
        }
        if (v < 0.01) {
            return format1;
        }
        if (v < 0.1) {
            return format2;
        }
        if (v < 1.0) {
            return format3;
        }
        if (v < 10.0) {
            return format4;
        }
        if (v > 999999.0) {
            return format7;
        }
        if (v > 9999.0) {
            return format6;
        }
        if (v > 999.0) {
            return format5;
        }
        return format4;
    }

    public static String format(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return MISSING;
        }
        return Misc.getDecimalFormat(value).format(value);
    }

    public static double parseValue(String value) throws NumberFormatException {
        return Misc.parseNumber(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double parseNumber(String value) throws NumberFormatException {
        if (value.equals(MISSING) || value.equals(NaN)) {
            return Double.NaN;
        }
        try {
            value = value.replace("e", "E");
            DecimalFormat decimalFormat = formatter;
            synchronized (decimalFormat) {
                return formatter.parse(value).doubleValue();
            }
        }
        catch (ParseException pe) {
            throw new NumberFormatException(pe.getMessage());
        }
    }

    public static int hashcode(Object o1) {
        return o1 == null ? 1 : o1.hashCode();
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 != null && o2 != null) {
            return o1.equals(o2);
        }
        return o1 == null && o2 == null;
    }

    public static boolean equalsIgnoreCase(Object o1, Object o2) {
        if (o1 != null && o2 != null) {
            return o1.toString().equalsIgnoreCase(o2.toString());
        }
        return o1 == null && o2 == null;
    }

    public static boolean haveSeen(Object o, Hashtable map) {
        if (o == null) {
            return false;
        }
        if (map.get(o) != null) {
            return true;
        }
        map.put(o, o);
        return false;
    }

    public static boolean haveNotSeen(Object o, Hashtable map) {
        return !Misc.haveSeen(o, map);
    }

    public static void printArray(String prefix, Object[] array) {
        System.out.println(prefix + (array == null ? " null" : StringUtil.toString(array)));
    }

    public static void printArray(String prefix, byte[] array) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(": ");
        if (array == null) {
            buf.append(" null ");
        } else {
            for (int i = 0; i < array.length; ++i) {
                buf.append("[");
                buf.append(i);
                buf.append("]: ");
                buf.append(array[i]);
                buf.append(" ");
            }
        }
        System.out.println(buf.toString());
    }

    public static void printArray(String prefix, int[] array) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(": ");
        if (array == null) {
            buf.append(" null ");
        } else {
            for (int i = 0; i < array.length; ++i) {
                buf.append("[");
                buf.append(i);
                buf.append("]: ");
                buf.append(array[i]);
                buf.append(" ");
            }
        }
        System.out.println(buf.toString());
    }

    public static void printArray(String prefix, float[] array) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(": ");
        if (array == null) {
            buf.append(" null ");
        } else {
            for (int i = 0; i < array.length; ++i) {
                buf.append("[");
                buf.append(i);
                buf.append("]: ");
                buf.append(array[i]);
                buf.append(" ");
            }
        }
        System.out.println(buf.toString());
    }

    public static void printArray(String prefix, double[] array) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(": ");
        if (array == null) {
            buf.append(" null ");
        } else {
            for (int i = 0; i < array.length; ++i) {
                buf.append("[");
                buf.append(i);
                buf.append("]: ");
                buf.append(array[i]);
                buf.append(" ");
            }
        }
        System.out.println(buf.toString());
    }

    public static void printArray(String prefix, boolean[] array) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(": ");
        if (array == null) {
            buf.append(" null ");
        } else {
            for (int i = 0; i < array.length; ++i) {
                buf.append("[");
                buf.append(i);
                buf.append("]: ");
                buf.append(array[i]);
                buf.append(" ");
            }
        }
        System.out.println(buf.toString());
    }

    public static void printMembers(Object o) {
        Class<?> c = o.getClass();
        Field[] fields = c.getFields();
        System.err.println("Fields:");
        for (int i = 0; i < fields.length; ++i) {
            try {
                System.err.println("\t" + fields[i].getName() + "=" + fields[i].get(o));
                continue;
            }
            catch (Exception exc) {
                System.err.println("\t" + fields[i].getName() + "= no access");
            }
        }
        System.err.println("Methods:");
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (!name.startsWith("get")) continue;
            try {
                System.err.println("\t" + name + "=" + methods[i].invoke(o, new Object[0]));
                continue;
            }
            catch (Exception exc) {
                System.err.println("\t" + name + "= no access");
            }
        }
    }

    public static void printStack(String msg, int maxLines, String onlyIfTraceContainsThisString) {
        String trace = Misc.getStackTrace();
        if (onlyIfTraceContainsThisString != null && trace.indexOf(onlyIfTraceContainsThisString) < 0) {
            return;
        }
        if (msg != null) {
            System.out.println(msg);
        }
        StringTokenizer tok = new StringTokenizer(trace, "\n");
        int allcnt = 0;
        int cnt = 0;
        while (tok.hasMoreTokens()) {
            String line = tok.nextToken();
            if (++allcnt <= 4) continue;
            System.out.println(line);
            if (++cnt <= maxLines) continue;
            break;
        }
    }

    public static void printStack(String msg, int maxLines) {
        Misc.printStack(msg, maxLines, null);
    }

    public static void printStack(String msg) {
        Misc.printStack(msg, Integer.MAX_VALUE);
    }

    public static long usedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static long gc() {
        Thread t = Thread.currentThread();
        for (int i = 0; i < 5; ++i) {
            Runtime.getRuntime().gc();
            try {
                Thread.sleep(400L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Misc.usedMemory();
    }

    public static void sleepSeconds(long seconds) {
        try {
            Thread.currentThread();
            Thread.sleep(seconds * 1000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void sleep(long ms) {
        try {
            Thread.currentThread();
            Thread.sleep(ms);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void fatal(Throwable exc) {
        System.err.println("An error  has occurred:");
        if (exc != null) {
            exc.printStackTrace();
        }
        System.exit(1);
    }

    public static void fatal(String msg) {
        System.err.println("An error  has occurred:" + msg);
        System.exit(1);
    }

    public static float[] toFloat(double[] d) {
        float[] f = new float[d.length];
        for (int i = 0; i < d.length; ++i) {
            f[i] = (float)d[i];
        }
        return f;
    }

    public static double[] toDouble(float[] d) {
        double[] f = new double[d.length];
        for (int i = 0; i < d.length; ++i) {
            f[i] = d[i];
        }
        return f;
    }

    public static double[][] toDouble(int[][] d) {
        double[][] f = new double[d.length][];
        for (int i = 0; i < f.length; ++i) {
            f[i] = Misc.toDouble(d[i]);
        }
        return f;
    }

    public static double[] toDouble(int[] d) {
        double[] f = new double[d.length];
        for (int i = 0; i < d.length; ++i) {
            f[i] = d[i];
        }
        return f;
    }

    public static double[] arrayToDouble(float[] d) {
        double[] f = new double[d.length];
        for (int i = 0; i < d.length; ++i) {
            f[i] = d[i];
        }
        return f;
    }

    public static float[][] toFloat(double[][] d) {
        float[][] f = new float[d.length][];
        for (int i = 0; i < f.length; ++i) {
            f[i] = Misc.toFloat(d[i]);
        }
        return f;
    }

    public static double[][] toDouble(float[][] d) {
        double[][] f = new double[d.length][];
        for (int i = 0; i < f.length; ++i) {
            f[i] = Misc.toDouble(d[i]);
        }
        return f;
    }

    public static double parseDouble(String s) {
        if (s == null) {
            return Double.NaN;
        }
        if ((s = s.trim()).equals(NaN)) {
            return Double.NaN;
        }
        return Double.parseDouble(s);
    }

    public static float getAverage(float[] values) {
        if (values == null || values.length == 0) {
            return Float.NaN;
        }
        int size = values.length;
        int total = 0;
        float all = 0.0f;
        for (int i = 0; i < size; ++i) {
            if (values[i] != values[i]) continue;
            ++total;
            all += values[i];
        }
        if (total == 0) {
            return Float.NaN;
        }
        return all / (float)total;
    }

    public static float parseFloat(String s) {
        if (s == null) {
            return Float.NaN;
        }
        if ((s = s.trim()).equals(NaN)) {
            return Float.NaN;
        }
        return Float.parseFloat(s);
    }

    public static double[] parseDoubles(String sourceString) {
        return Misc.parseDoubles(sourceString, ",");
    }

    public static double[] parseDoubles(String sourceString, String delimiter) {
        if (sourceString == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(sourceString, delimiter);
        double[] cw = new double[tok.countTokens()];
        int cnt = 0;
        while (tok.hasMoreTokens()) {
            cw[cnt++] = Misc.parseDouble(tok.nextToken());
        }
        return cw;
    }

    public static double[] parseLatLons(String sourceString) {
        return Misc.parseLatLons(sourceString, ",");
    }

    public static double[] parseLatLons(String sourceString, String delimiter) {
        if (sourceString == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(sourceString, delimiter);
        double[] cw = new double[tok.countTokens()];
        int cnt = 0;
        while (tok.hasMoreTokens()) {
            cw[cnt++] = Misc.decodeLatLon(tok.nextToken());
        }
        return cw;
    }

    public static float[] parseFloats(String sourceString) {
        return Misc.parseFloats(sourceString, ",");
    }

    public static float[] parseFloats(String sourceString, String delimiter) {
        if (sourceString == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(sourceString, delimiter);
        float[] cw = new float[tok.countTokens()];
        int cnt = 0;
        while (tok.hasMoreTokens()) {
            cw[cnt++] = Misc.parseFloat(tok.nextToken());
        }
        return cw;
    }

    public static int[] parseInts(String sourceString, String delimiter) {
        if (sourceString == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(sourceString, delimiter);
        int[] cw = new int[tok.countTokens()];
        int cnt = 0;
        while (tok.hasMoreTokens()) {
            cw[cnt++] = (int)Misc.parseDouble(tok.nextToken());
        }
        return cw;
    }

    public static double normalizeLongitude(double lonValue) {
        int cnt = 0;
        while (lonValue < -180.0 || lonValue > 180.0) {
            double d = lonValue = lonValue < -180.0 ? lonValue + 360.0 : lonValue - 360.0;
            if (cnt++ <= 10000) continue;
            throw new IllegalArgumentException("Bad longitude value:" + lonValue);
        }
        return lonValue;
    }

    public static double[] computeTicks(double high, double low, double base, double interval) {
        double[] vals = null;
        long nlo = Math.round(Math.ceil((low - base) / Math.abs(interval)));
        long nhi = Math.round(Math.floor((high - base) / Math.abs(interval)));
        int numc = (int)(nhi - nlo) + 1;
        if (numc < 1) {
            return vals;
        }
        vals = new double[numc];
        for (int i = 0; i < numc; ++i) {
            vals[i] = base + (double)(nlo + (long)i) * interval;
        }
        return vals;
    }

    public static float[] computeTicks(float high, float low, float base, float interval) {
        float[] vals = null;
        long nlo = Math.round(Math.ceil((low - base) / Math.abs(interval)));
        long nhi = Math.round(Math.floor((high - base) / Math.abs(interval)));
        int numc = (int)(nhi - nlo) + 1;
        if (numc < 1) {
            return vals;
        }
        vals = new float[numc];
        for (int i = 0; i < numc; ++i) {
            vals[i] = base + (float)(nlo + (long)i) * interval;
        }
        return vals;
    }

    public static double computeTickSpacing(double min, double max) {
        double ratio;
        double range = Math.abs(max - min);
        if (range == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        double majorTickSpacing = range;
        double tens = 1.0;
        if (range < tens) {
            tens /= 10.0;
            while (range < tens) {
                tens /= 10.0;
            }
        } else {
            while (10.0 * tens <= range) {
                tens *= 10.0;
            }
        }
        if ((ratio = range / tens) < 2.0) {
            tens /= 5.0;
        } else if (ratio < 4.0) {
            tens /= 2.0;
        }
        majorTickSpacing = tens;
        return majorTickSpacing;
    }

    public static Hashtable createLabelTable(double max, double min, double base, double increment) {
        Hashtable<Double, String> labelTable = new Hashtable<Double, String>();
        if (min > max || increment > max - min) {
            return labelTable;
        }
        double[] values = Misc.computeTicks(max, min, base, increment);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                labelTable.put(new Double(values[i]), Misc.format(values[i]));
            }
        }
        return labelTable;
    }

    public static void print(List l) {
        for (int i = 0; i < l.size(); ++i) {
            System.err.println("" + i + "=" + l.get(i));
        }
    }

    public static boolean containsString(String string, List objects, boolean lowerCase) {
        if (lowerCase) {
            string = string.toLowerCase();
        }
        for (Object o : objects) {
            if (!(lowerCase ? Misc.equals(string, o.toString().toLowerCase()) : Misc.equals(string, o.toString()))) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Object object, Object[] array) {
        return Misc.indexOf(object, array) >= 0;
    }

    public static int indexOf(Object object, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!Misc.equals(object, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean allStrings(List listToCheck) {
        Iterator iter = listToCheck.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof String) continue;
            return false;
        }
        return true;
    }

    public static boolean hasSuffix(String fileOrUrl, String suffix) {
        return IOUtil.hasSuffix(fileOrUrl, suffix);
    }

    public static boolean isTextFile(String filename) {
        return IOUtil.isTextFile(filename);
    }

    public static boolean isImageFile(String filename) {
        return IOUtil.isImageFile(filename);
    }

    public static boolean isHtmlFile(String filenameOrUrl) {
        return IOUtil.isHtmlFile(filenameOrUrl);
    }

    public static InputStream getInputStream(String filename) throws FileNotFoundException, IOException {
        return IOUtil.getInputStream(filename);
    }

    public static InputStream getInputStream(String filename, Class origin) throws FileNotFoundException, IOException {
        return IOUtil.getInputStream(filename, origin);
    }

    public static String readContents(File file) throws FileNotFoundException, IOException {
        return IOUtil.readContents(file);
    }

    public static String readContents(String contentName, String dflt) {
        return IOUtil.readContents(contentName, dflt);
    }

    public static String readContents(String contentName) throws FileNotFoundException, IOException {
        return IOUtil.readContents(contentName);
    }

    public static String readContents(String contentName, Class origin) throws FileNotFoundException, IOException {
        return IOUtil.readContents(contentName, origin);
    }

    public static String readContents(InputStream is) throws IOException {
        return IOUtil.readContents(is);
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        return IOUtil.readBytes(is);
    }

    public static byte[] readBytes(InputStream is, Object loadId) throws IOException {
        return IOUtil.readBytes(is, loadId);
    }

    public static File getMostRecentFile(File dir) {
        return IOUtil.getMostRecentFile(dir);
    }

    public static File getMostRecentFile(File dir, FileFilter filter) {
        return IOUtil.getMostRecentFile(dir, filter);
    }

    public static File[] sortFilesOnAge(File directory, FileFilter filter, boolean youngestFirst) {
        return IOUtil.sortFilesOnAge(directory, filter, youngestFirst);
    }

    public static File[] sortFilesOnAge(File[] files, boolean youngestFirst) {
        return IOUtil.sortFilesOnAge(files, youngestFirst);
    }

    public static File[] toFiles(List files) {
        return IOUtil.toFiles(files);
    }

    public static FileFilter wrapFilter(javax.swing.filechooser.FileFilter filter) {
        return IOUtil.wrapFilter(filter);
    }

    public static File getMostRecentFile(File dir, javax.swing.filechooser.FileFilter filter) {
        return IOUtil.getMostRecentFile(dir, filter);
    }

    public static String getFileTail(String f) {
        return IOUtil.getFileTail(f);
    }

    public static String getFileRoot(String f) {
        return IOUtil.getFileRoot(f);
    }

    public static String stripExtension(String f) {
        return IOUtil.stripExtension(f);
    }

    public static String cleanFileName(String name) {
        return IOUtil.cleanFileName(name);
    }

    public static String getFileExtension(String f) {
        return IOUtil.getFileExtension(f);
    }

    public static void writeFile(String filename, String contents) throws FileNotFoundException, IOException {
        IOUtil.writeFile(filename, contents);
    }

    public static void writeFile(File filename, String contents) throws FileNotFoundException, IOException {
        IOUtil.writeFile(filename, contents);
    }

    public static void writeBytes(File filename, byte[] contents) throws FileNotFoundException, IOException {
        IOUtil.writeBytes(filename, contents);
    }

    public static String readFile(String filename, Class origin, String dflt) {
        return IOUtil.readContents(filename, origin, dflt);
    }

    public static String readFile(String filename, Class origin) throws FileNotFoundException, IOException {
        return IOUtil.readContents(filename, origin);
    }

    public static void moveFile(File from, File to) throws FileNotFoundException, IOException {
        IOUtil.moveFile(from, to);
    }

    public static void copyFile(File from, File to) throws FileNotFoundException, IOException {
        IOUtil.copyFile(from, to);
    }

    public static String joinDir(String f1, String f2) {
        return IOUtil.joinDir(f1, f2);
    }

    public static String joinDir(File f1, String filename) {
        return IOUtil.joinDir(f1, filename);
    }

    public static String makeDir(String path) {
        return IOUtil.makeDir(path);
    }

    public static String makeDir(File f) {
        return IOUtil.makeDir(f);
    }

    public static List getDirectories(File dir, boolean recurse) {
        return IOUtil.getDirectories(dir, recurse);
    }

    public static List getDirectories(List dirs, boolean recurse) {
        return IOUtil.getDirectories(dirs, recurse);
    }

    private static void pruneIfEmpty(File root) {
        IOUtil.pruneIfEmpty(root);
    }

    public static void pruneEmptyDirectories(File root) {
        IOUtil.pruneEmptyDirectories(root);
    }

    public static void deleteDirectory(File root) {
        IOUtil.deleteDirectory(root);
    }

    public static Object findMatch(String source, List patternList, Object dflt) {
        return StringUtil.findMatch(source, patternList, dflt);
    }

    public static Object findMatch(String source, List patternList, List results, Object dflt) {
        return StringUtil.findMatch(source, patternList, results, dflt);
    }

    public static boolean containsRegExp(String patternString) {
        return StringUtil.containsRegExp(patternString);
    }

    public static boolean stringMatch(String input, String patternString) {
        return StringUtil.stringMatch(input, patternString);
    }

    public static boolean stringMatch(String input, String patternString, boolean substring, boolean caseSensitive) {
        return StringUtil.stringMatch(input, patternString, substring, caseSensitive);
    }

    public static boolean startsWithVowel(String value) {
        return StringUtil.startsWithVowel(value);
    }

    public static String breakText(String text, String insert, int lineSize) {
        return StringUtil.breakText(text, insert, lineSize);
    }

    public static String stripTags(String html) {
        return StringUtil.stripTags(html);
    }

    public static String removeWhitespace(String inputString) {
        return StringUtil.removeWhitespace(inputString);
    }

    public static String zeroString(int value) {
        return StringUtil.zeroString(value);
    }

    public static String padZero(int value, int numDigits) {
        return StringUtil.padZero(value, numDigits);
    }

    public static String padLeft(String s, int desiredLength) {
        return StringUtil.padLeft(s, desiredLength);
    }

    public static String padLeft(String s, int desiredLength, String padString) {
        return StringUtil.padLeft(s, desiredLength, padString);
    }

    public static String padRight(String s, int desiredLength) {
        return StringUtil.padRight(s, desiredLength);
    }

    public static String padRight(String s, int desiredLength, String padString) {
        return StringUtil.padRight(s, desiredLength, padString);
    }

    public static String join(String[] args) {
        return StringUtil.join(args);
    }

    public static String join(String delimiter, Object[] args) {
        return StringUtil.join(delimiter, args);
    }

    public static String join(String delimiter, Object[] args, boolean ignoreEmptyStrings) {
        return StringUtil.join(delimiter, args, ignoreEmptyStrings);
    }

    public static String join(String delimiter, List args) {
        return StringUtil.join(delimiter, args);
    }

    public static String join(String delimiter, List args, boolean ignoreEmptyStrings) {
        return StringUtil.join(delimiter, args, ignoreEmptyStrings);
    }

    public static List split(Object source) {
        return StringUtil.split(source);
    }

    public static List parseLineWords(String content, int[] indices, int[] lengths, String lineDelimiter, String commentString, boolean trimWords) {
        return StringUtil.parseLineWords(content, indices, lengths, lineDelimiter, commentString, trimWords);
    }

    public static List split(Object source, String delimiter) {
        return StringUtil.split(source, delimiter);
    }

    public static List split(Object source, String delimiter, boolean trim) {
        return StringUtil.split(source, delimiter, trim);
    }

    public static List split(Object source, String delimiter, boolean trim, boolean excludeZeroLength) {
        return StringUtil.split(source, delimiter, trim, excludeZeroLength);
    }

    public static String[] split(String s, String delimiter, int cnt) {
        return StringUtil.split(s, delimiter, cnt);
    }

    public static String[] listToStringArray(List objectList) {
        return StringUtil.listToStringArray(objectList);
    }

    public static String listToString(List l) {
        return StringUtil.listToString(l);
    }

    public static List toString(List l) {
        return StringUtil.toString(l);
    }

    public static String replace(String string, String pattern, String value) {
        return StringUtil.replace(string, pattern, value);
    }

    public static String replaceList(String v, String[] patterns, String[] values) {
        return StringUtil.replaceList(v, patterns, values);
    }

    public static String replaceList(String v, List patterns, List values) {
        return StringUtil.replaceList(v, patterns, values);
    }

    public static List replaceList(List sourceList, String[] patterns, String[] values) {
        return StringUtil.replaceList(sourceList, patterns, values);
    }

    public static StringBuffer append(StringBuffer sb, Object s1) {
        return StringUtil.append(sb, s1);
    }

    public static StringBuffer append(StringBuffer sb, Object s1, Object s2) {
        return StringUtil.append(sb, s1, s2);
    }

    public static StringBuffer append(StringBuffer sb, Object s1, Object s2, Object s3) {
        return StringUtil.append(sb, s1, s2, s3);
    }

    public static StringBuffer append(StringBuffer sb, Object s1, Object s2, Object s3, Object s4) {
        return StringUtil.append(sb, s1, s2, s3, s4);
    }

    public static StringBuffer append(StringBuffer sb, Object s1, Object s2, Object s3, Object s4, Object s5) {
        return StringUtil.append(sb, s1, s2, s3, s4, s5);
    }

    public static List parseCsv(String s, boolean skipFirst) {
        return StringUtil.parseCsv(s, skipFirst);
    }

    public static final String shorten(String s, int length) {
        return StringUtil.shorten(s, length);
    }

    public static String toString(Object[] array) {
        return StringUtil.toString(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addClassLoader(ClassLoader cl) {
        List<ClassLoader> list = classLoaders;
        synchronized (list) {
            classLoaders.add(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ClassLoader> getClassLoaders() {
        List<ClassLoader> list = classLoaders;
        synchronized (list) {
            return new ArrayList<ClassLoader>(classLoaders);
        }
    }

    public static Class findClass(String className) throws ClassNotFoundException {
        List<ClassLoader> classLoaders = Misc.getClassLoaders();
        for (ClassLoader classLoader : classLoaders) {
            PluginClassLoader pcl;
            Class c;
            if (!(classLoader instanceof PluginClassLoader) || (c = (pcl = (PluginClassLoader)classLoader).getClassFromPlugin(className)) == null) continue;
            return c;
        }
        for (ClassLoader classLoader : classLoaders) {
            try {
                Class<?> c = Class.forName(className, true, classLoader);
                if (c == null) continue;
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return Class.forName(className);
    }

    public static long getPauseEveryTime(int minutesDelta) {
        double sleepTime;
        if (minutesDelta <= 0) {
            minutesDelta = 1;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        int currentMinutes = cal.get(12) + cal.get(10) * 60;
        if (minutesDelta > currentMinutes) {
            sleepTime = 60000 * (minutesDelta - currentMinutes);
        } else {
            int foo = currentMinutes % minutesDelta;
            sleepTime = 60000 * (minutesDelta - foo);
        }
        return (long)sleepTime;
    }

    public static void pauseEvery(int minutesDelta) {
        long sleepTime = Misc.getPauseEveryTime(minutesDelta);
        Misc.sleep(sleepTime);
    }

    public static float[][] cloneArray(float[][] a) {
        float[][] b = new float[a.length][a[0].length];
        for (int i = 0; i < a.length; ++i) {
            System.arraycopy(a[i], 0, b[i], 0, a[0].length);
        }
        return b;
    }

    public static float[] reverseArray(float[] a) {
        float[] b = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            b[a.length - i] = a[i];
        }
        return b;
    }

    public static float[][] subtractArray(float[][] a, float[][] b, float[][] c) {
        if (c == null) {
            c = new float[a.length][a[0].length];
        }
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                c[i][j] = a[i][j] - b[i][j];
            }
        }
        return c;
    }

    public static float[][] addArray(float[][] a, float[][] b, float[][] c) {
        if (c == null) {
            c = new float[a.length][a[0].length];
        }
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                c[i][j] = a[i][j] + b[i][j];
            }
        }
        return c;
    }

    public static float[] getRange(float[][] a) {
        float[] range = new float[]{Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY};
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                float val = a[i][j];
                if (val != val) continue;
                range[0] = Math.min(range[0], val);
                range[1] = Math.max(range[1], val);
            }
        }
        return range;
    }

    public static float[][] getRanges(float[][] a) {
        float[][] ranges = new float[a.length][];
        for (int i = 0; i < a.length; ++i) {
            ranges[i] = Misc.getRange(new float[][]{a[i]});
        }
        return ranges;
    }

    public static void fillArray(float[][] a, float value) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                a[i][j] = value;
            }
        }
    }

    public static double[][] cloneArray(double[][] a) {
        double[][] b = new double[a.length][a[0].length];
        for (int i = 0; i < a.length; ++i) {
            System.arraycopy(a[i], 0, b[i], 0, a[0].length);
        }
        return b;
    }

    public static boolean arraysEquals(double[] a, double[] b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (b == null && a != null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEquals(int[] a, int[] b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (b == null && a != null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEquals(float[] a, float[] b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (b == null && a != null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEquals(String[] a, String[] b) {
        if (a == null && b != null) {
            return false;
        }
        if (b == null && a != null) {
            return false;
        }
        if (b == null && a == null) {
            return true;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (Misc.equals(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEquals(float[][] a, float[][] b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (b == null && a != null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        if (a[0].length != b[0].length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (Arrays.equals(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEquals(double[][] a, double[][] b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (b == null && a != null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        if (a[0].length != b[0].length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (Arrays.equals(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEquals(int[][] a, int[][] b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (b == null && a != null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        if (a[0].length != b[0].length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (Arrays.equals(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEquals(int[][][] a, int[][][] b) {
        if (a == b) {
            return true;
        }
        if (a == null && b != null) {
            return false;
        }
        if (b == null && a != null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        if (a[0].length != b[0].length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (Misc.arraysEquals(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    public static float[] merge(float[] a, float[] b) {
        int i;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        float[] newArray = new float[a.length + b.length];
        for (i = 0; i < a.length; ++i) {
            newArray[i] = a[i];
        }
        for (i = 0; i < b.length; ++i) {
            newArray[i + a.length] = b[i];
        }
        return newArray;
    }

    public static float[] interpolate(int cnt, float start, float end) {
        double delta = (end - start) / (float)(cnt - 1);
        float[] vals = new float[cnt];
        for (int i = 0; i < cnt; ++i) {
            vals[i] = (float)((double)start + delta * (double)i);
        }
        return vals;
    }

    public static float[][] copy(float[][] pts, int pointCnt) {
        int numFields = pts.length;
        float[][] newPts = new float[numFields][pointCnt];
        for (int i = 0; i < pointCnt; ++i) {
            for (int fieldIdx = 0; fieldIdx < numFields; ++fieldIdx) {
                newPts[fieldIdx][i] = pts[fieldIdx][i];
            }
        }
        return newPts;
    }

    public static float[][] expand(float[][] pts) {
        int numFields = pts.length;
        float[][] newPts = new float[numFields][pts[0].length * 2];
        for (int i = 0; i < pts[0].length; ++i) {
            for (int fieldIdx = 0; fieldIdx < numFields; ++fieldIdx) {
                newPts[fieldIdx][i] = pts[fieldIdx][i];
            }
        }
        return newPts;
    }

    public static Runnable getRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                int x = 0;
                int y = 0;
                while (true) {
                    for (int i = 0; i < 100000000; ++i) {
                        y = x;
                    }
                    ++x;
                    System.err.print(".");
                }
            }
        };
    }

    public static void printBits(int b) {
        System.err.println(Misc.getBits(b));
    }

    private static String getBits(int b) {
        String s = "";
        for (int i = 31; i >= 0; --i) {
            s = (b & 1 << i) != 0 ? s + "1" : s + "0";
            if (i % 8 != 0) continue;
            s = s + "|";
        }
        return s;
    }

    public static String getStackTrace() {
        return Misc.getStackTrace(new IllegalArgumentException(""));
    }

    public static String getStackTrace(Throwable exc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exc.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    public static void main(String[] args) {
        long t1 = System.currentTimeMillis();
        double d = 0.0;
        for (int i = 0; i < 10000000; ++i) {
            d = new Double("2.3");
        }
        long t2 = System.currentTimeMillis();
        long t3 = System.currentTimeMillis();
        System.err.println("time 1:" + (t2 - t1));
    }

    public static int[] find(int value, int[] array) {
        ArrayList<Integer> indices = new ArrayList<Integer>(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            indices.add(i);
        }
        int m = indices.size();
        int[] rv = new int[m];
        for (int i = 0; i < m; ++i) {
            rv[i] = (Integer)indices.get(i);
        }
        return rv;
    }

    public static int[] find(float value, float[] array) {
        ArrayList<Integer> indices = new ArrayList<Integer>(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            indices.add(i);
        }
        int m = indices.size();
        int[] rv = new int[m];
        for (int i = 0; i < m; ++i) {
            rv[i] = (Integer)indices.get(i);
        }
        return rv;
    }

    public static int[] find(double value, double[] array) {
        ArrayList<Integer> indices = new ArrayList<Integer>(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            indices.add(i);
        }
        int m = indices.size();
        int[] rv = new int[m];
        for (int i = 0; i < m; ++i) {
            rv[i] = (Integer)indices.get(i);
        }
        return rv;
    }

    public static boolean isNaN(float[][] values) {
        if (Float.isNaN(values[0][0])) {
            for (int i = 0; i < values.length; ++i) {
                for (int j = 0; j < values[i].length; ++j) {
                    float value = values[i][j];
                    if (value != value) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isNaN(double[][] values) {
        if (Double.isNaN(values[0][0])) {
            for (int i = 0; i < values.length; ++i) {
                for (int j = 0; j < values[i].length; ++j) {
                    double value = values[i][j];
                    if (value != value) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    static {
        debug = false;
        classLoaders = new ArrayList<ClassLoader>();
        overrideCurrentTime = -1L;
        objectCount = 0;
        formatter = new DecimalFormat();
        format0 = new DecimalFormat("0.#");
        format1 = new DecimalFormat("0.#E0");
        format2 = new DecimalFormat("#.00##");
        format3 = new DecimalFormat("#.0##");
        format4 = new DecimalFormat("###.#");
        format5 = new DecimalFormat("####.#");
        format6 = new DecimalFormat("#####.#");
        format7 = new DecimalFormat("0.###E0");
    }
}

