/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.sound.midi.Instrument;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.MidiManager;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;

public class MidiProperties {
    private boolean muted = true;
    private int lowNote = 0;
    private int highNote = 127;
    private String instrumentName = null;
    private JTextField spanFld;
    private JComboBox instrumentBox;
    JCheckBox mutedCbx;
    private JTextField lowNoteFld;
    private JTextField highNoteFld;

    public MidiProperties() {
    }

    public MidiProperties(String instrumentName, int lowNote, int highNote, boolean muted) {
        this.instrumentName = instrumentName;
        this.lowNote = lowNote;
        this.highNote = highNote;
        this.muted = muted;
    }

    public MidiProperties(MidiProperties that) {
        this.instrumentName = that.instrumentName;
        this.lowNote = that.lowNote;
        this.highNote = that.highNote;
        this.muted = that.muted;
    }

    public void setInstrumentName(String value) {
        this.instrumentName = value;
    }

    public String getInstrumentName() {
        return this.instrumentName;
    }

    public void setMuted(boolean value) {
        this.muted = value;
    }

    public boolean getMuted() {
        return this.muted;
    }

    public void setLowNote(int value) {
        this.lowNote = value;
    }

    public int getLowNote() {
        return this.lowNote;
    }

    public void setHighNote(int value) {
        this.highNote = value;
    }

    public int getHighNote() {
        return this.highNote;
    }

    public void setProperties(MidiProperties that) {
        this.instrumentName = that.instrumentName;
        this.lowNote = that.lowNote;
        this.highNote = that.highNote;
        this.muted = that.muted;
    }

    public boolean showPropertyDialog(Window w) {
        List comps = this.getPropertiesComponents(new ArrayList());
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel contents = GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        if (!GuiUtils.showOkCancelDialog(w, "MidiManager Properties", contents, null)) {
            return false;
        }
        return this.applyProperties();
    }

    public boolean applyProperties() {
        TwoFacedObject tfo = (TwoFacedObject)this.instrumentBox.getSelectedItem();
        this.instrumentName = tfo.toString();
        this.muted = this.mutedCbx.isSelected();
        this.lowNote = new Integer(this.lowNoteFld.getText().trim());
        this.highNote = new Integer(this.highNoteFld.getText().trim());
        if (this.highNote < this.lowNote) {
            this.lowNote = Math.max(this.lowNote, 0);
            this.highNote = Math.min(this.highNote, 127);
        } else {
            this.lowNote = Math.min(this.lowNote, 127);
            this.highNote = Math.max(this.highNote, 0);
        }
        return true;
    }

    public List getPropertiesComponents(List comps) {
        comps.add(GuiUtils.filler());
        this.mutedCbx = new JCheckBox("Muted", this.getMuted());
        comps.add(GuiUtils.left(this.mutedCbx));
        comps.add(GuiUtils.rLabel("Instrument: "));
        Vector<TwoFacedObject> v = new Vector<TwoFacedObject>();
        Instrument[] instruments = MidiManager.getInstrumentList();
        TwoFacedObject selected = new TwoFacedObject((Object)"None", new Integer(-1));
        if (instruments != null) {
            for (int i = 0; i < instruments.length && i < 128; ++i) {
                String name;
                if (instruments[i] == null || (name = instruments[i].getName()) == null) continue;
                TwoFacedObject tfo = new TwoFacedObject((Object)name, new Integer(i));
                if (name.equals(this.instrumentName)) {
                    selected = tfo;
                }
                v.add(tfo);
            }
        }
        this.instrumentBox = new JComboBox(v);
        comps.add(GuiUtils.left(this.instrumentBox));
        this.instrumentBox.setSelectedItem(selected);
        this.lowNoteFld = new JTextField("" + this.getLowNote(), 5);
        this.highNoteFld = new JTextField("" + this.getHighNote(), 5);
        comps.add(GuiUtils.rLabel("Note Range:"));
        comps.add(GuiUtils.left(GuiUtils.hbox(Misc.newList(new JLabel("Low: "), this.lowNoteFld, new JLabel("High: "), this.highNoteFld))));
        return comps;
    }
}

