/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import ucar.unidata.util.MidiProperties;
import ucar.unidata.util.Misc;

public class MidiManager {
    private static Instrument[] instrumentList;
    private Synthesizer synthesizer;
    private Sequencer sequencer;
    private Sequence sequence;
    private Instrument[] instruments;
    private ChannelData[] channels;
    private MidiProperties myProps = new MidiProperties();
    int playTimeStamp = 0;
    MidiChannel currentChannel;
    int currentKey = -1;

    public MidiManager() {
        this(new MidiProperties());
    }

    public MidiManager(MidiProperties props) {
        this.myProps = props;
        this.open();
        this.setInstrument(props.getInstrumentName());
    }

    public void close() {
    }

    public void open() {
        try {
            if (this.synthesizer == null && (this.synthesizer = MidiSystem.getSynthesizer()) == null) {
                System.out.println("getSynthesizer() failed!");
                return;
            }
            this.synthesizer.open();
            this.sequencer = MidiSystem.getSequencer();
            this.sequence = new Sequence(0.0f, 10);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        Soundbank sb = this.synthesizer.getDefaultSoundbank();
        if (sb != null) {
            this.instruments = this.synthesizer.getDefaultSoundbank().getInstruments();
            this.synthesizer.loadInstrument(this.instruments[0]);
            for (int i = 0; i < this.instruments.length; ++i) {
            }
        }
        MidiChannel[] midiChannels = this.synthesizer.getChannels();
        this.channels = new ChannelData[midiChannels.length];
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = new ChannelData(midiChannels[i], i);
        }
    }

    public void setInstrument(int index) {
        if (index < 0 || index >= this.instruments.length) {
            return;
        }
        this.setInstrument(this.instruments[index]);
        this.channels[0].channel.programChange(index);
    }

    public void setInstrument(String instrumentName) {
        this.setInstrument(this.getInstrumentIndex(instrumentName));
    }

    public void setInstrument(Instrument instrument) {
        this.synthesizer.loadInstrument(instrument);
    }

    public static Instrument[] getInstrumentList() {
        if (instrumentList == null) {
            MidiManager midiManager = new MidiManager();
            instrumentList = midiManager.instruments;
            midiManager.close();
        }
        return instrumentList;
    }

    private int getInstrumentIndex(String instrumentName) {
        if (instrumentName == null) {
            return -1;
        }
        Instrument[] instruments = MidiManager.getInstrumentList();
        for (int i = 0; i < instruments.length; ++i) {
            if (instruments[i] == null || !Misc.equals(instrumentName, instruments[i].getName())) continue;
            return i;
        }
        return -1;
    }

    public synchronized void play(int key, long milliseconds) {
        ++this.playTimeStamp;
        if (this.currentChannel != null) {
            this.currentChannel.allSoundOff();
            this.currentChannel.allNotesOff();
        }
        this.currentChannel = this.channels[0].channel;
        this.currentKey = key;
        this.currentChannel.noteOn(key, this.channels[0].velocity);
        this.turnOffInABit(key, this.currentChannel, this.playTimeStamp, milliseconds);
    }

    public void turnOffInABit(int key, final MidiChannel channel, final int timeStamp, long milliseconds) {
        Misc.runInABit(milliseconds, new Runnable(){

            @Override
            public void run() {
                if (timeStamp != MidiManager.this.playTimeStamp) {
                    return;
                }
                MidiManager.this.currentChannel.allNotesOff();
                channel.allSoundOff();
            }
        });
    }

    class ChannelData {
        MidiChannel channel;
        boolean solo;
        boolean mono;
        boolean mute;
        boolean sustain;
        int velocity;
        int pressure;
        int bend;
        int reverb;
        int row;
        int col;
        int num;

        public ChannelData(MidiChannel channel, int num) {
            this.channel = channel;
            this.num = num;
            this.reverb = 64;
            this.bend = 64;
            this.pressure = 64;
            this.velocity = 64;
            this.reverb = 0;
        }
    }
}

