/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MenuUtil {
    public static final String MENU_SEPARATOR = "separator";

    public static boolean typesMatch(Class[] formals, Class[] actuals) {
        if (formals.length != actuals.length) {
            return false;
        }
        for (int j = 0; j < formals.length; ++j) {
            if (actuals[j] == null || formals[j].isAssignableFrom(actuals[j])) continue;
            return false;
        }
        return true;
    }

    public static Method findMethod(Class c, String methodName, Class[] paramTypes) {
        ArrayList<Method> all = new ArrayList<Method>();
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            if (paramTypes == null) {
                return methods[i];
            }
            if (!MenuUtil.typesMatch(methods[i].getParameterTypes(), paramTypes)) continue;
            all.add(methods[i]);
        }
        if (all.size() > 1) {
            String msg = "More than one method: " + methodName + " found for class:" + c.getName();
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramTypes[i] == null) continue;
                msg = msg + " " + paramTypes[i].getName();
            }
            throw new IllegalArgumentException(msg);
        }
        if (all.size() == 1) {
            return (Method)all.get(0);
        }
        return null;
    }

    private static Method findMethod(Object object, String methodName, Object arg) {
        Method theMethod = null;
        theMethod = arg == null ? MenuUtil.findMethod(object.getClass(), methodName, new Class[0]) : MenuUtil.findMethod(object.getClass(), methodName, new Class[]{arg.getClass()});
        if (theMethod == null) {
            System.err.println("arg = " + arg);
            throw new IllegalArgumentException("Unknown method:" + object.getClass() + "." + methodName + "(" + (arg == null ? "" : arg.getClass().getName()) + ")");
        }
        return theMethod;
    }

    public static JMenuItem makeMenuItem(String label, Object object, String methodName, Object arg) {
        return MenuUtil.makeMenuItem(label, object, methodName, arg, false);
    }

    public static JMenuItem makeMenuItem(String label, Object object, String methodName) {
        return MenuUtil.makeMenuItem(label, object, methodName, null, false);
    }

    public static JMenuItem makeMenuItem(String label, final Object object, String methodName, final Object arg, final boolean inThread) {
        final Method theMethod = MenuUtil.findMethod(object, methodName, arg);
        JMenuItem mi = new JMenuItem(label);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (inThread) {
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            this.invokeMethod();
                        }
                    };
                    t.start();
                } else {
                    this.invokeMethod();
                }
            }

            public void invokeMethod() {
                try {
                    if (arg == null) {
                        theMethod.invoke(object, new Object[0]);
                    } else {
                        theMethod.invoke(object, arg);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        mi.addActionListener(listener);
        return mi;
    }

    public static JCheckBoxMenuItem makeCheckboxMenuItem(String label, Object object, String property, Object arg) {
        boolean value = true;
        try {
            Class[] classArray;
            String methodName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            Class<?> clazz = object.getClass();
            if (arg == null) {
                classArray = new Class[]{};
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = arg.getClass();
            }
            Method theMethod = MenuUtil.findMethod(clazz, methodName, classArray);
            if (theMethod != null) {
                Object[] objectArray;
                if (arg == null) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = arg;
                }
                Boolean v = (Boolean)theMethod.invoke(object, objectArray);
                value = v;
            }
        }
        catch (Exception exc) {
            System.err.println("Error in makeCeckbox:" + exc);
            exc.printStackTrace();
        }
        return MenuUtil.makeCheckboxMenuItem(label, object, property, value, arg);
    }

    public static JCheckBoxMenuItem makeCheckboxMenuItem(String label, final Object object, final String property, boolean value, final Object arg) {
        final JCheckBoxMenuItem cbx = new JCheckBoxMenuItem(label, value);
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                try {
                    Class[] classArray;
                    String methodName = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
                    Class<?> clazz = object.getClass();
                    if (arg == null) {
                        Class[] classArray2 = new Class[1];
                        classArray = classArray2;
                        classArray2[0] = Boolean.TYPE;
                    } else {
                        Class[] classArray3 = new Class[2];
                        classArray3[0] = Boolean.TYPE;
                        classArray = classArray3;
                        classArray3[1] = arg.getClass();
                    }
                    Method theMethod = MenuUtil.findMethod(clazz, methodName, classArray);
                    if (theMethod == null) {
                        System.err.println("Unknown method:" + object.getClass() + "." + methodName);
                    } else {
                        Object[] objectArray;
                        if (arg == null) {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = new Boolean(cbx.isSelected());
                        } else {
                            Object[] objectArray3 = new Object[2];
                            objectArray3[0] = new Boolean(cbx.isSelected());
                            objectArray = objectArray3;
                            objectArray3[1] = arg;
                        }
                        theMethod.invoke(object, objectArray);
                    }
                }
                catch (Exception exc) {
                    System.err.println("Error in makeCheckbox:" + exc);
                    exc.printStackTrace();
                }
            }
        };
        cbx.addItemListener(listener);
        return cbx;
    }

    public static JMenu makeMenu(String name, List menuItems) {
        return MenuUtil.makeMenu(new JMenu(name), menuItems);
    }

    public static JMenu makeMenu(JMenu menu, List menuItems) {
        if (menuItems == null) {
            return menu;
        }
        for (int i = 0; i < menuItems.size(); ++i) {
            Object o = menuItems.get(i);
            if (o.toString().equals(MENU_SEPARATOR)) {
                menu.addSeparator();
                continue;
            }
            if (!(o instanceof JMenuItem)) continue;
            menu.add((JMenuItem)o);
        }
        return menu;
    }

    public static List makeMenuItems(Object object, Object[][] items) {
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        for (int i = 0; i < items.length; ++i) {
            JMenuItem menuItem = MenuUtil.makeMenuItem(items[i][0].toString(), object, items[i][1].toString(), items[i].length >= 3 ? items[i][2] : null);
            if (items[i].length == 4) {
                menuItem.setToolTipText((String)items[i][3]);
            }
            list.add(menuItem);
        }
        return list;
    }

    public static void showPopupMenu(List menuItems, Component comp) {
        JPopupMenu popup = MenuUtil.makePopupMenu(menuItems);
        popup.show(comp, 0, (int)comp.getBounds().getHeight());
    }

    public static JPopupMenu makePopupMenu(JPopupMenu menu, List menuItems) {
        if (menuItems == null || menuItems.size() == 0) {
            return null;
        }
        for (int i = 0; i < menuItems.size(); ++i) {
            Object o = menuItems.get(i);
            if (o.toString().equals(MENU_SEPARATOR)) {
                menu.addSeparator();
                continue;
            }
            if (o instanceof JMenuItem) {
                menu.add((JMenuItem)o);
                continue;
            }
            if (!(o instanceof JMenu)) continue;
            menu.add((JMenu)o);
        }
        return menu;
    }

    public static JPopupMenu makePopupMenu(List menuItems) {
        return MenuUtil.makePopupMenu(new JPopupMenu(), menuItems);
    }
}

