/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import ucar.unidata.util.CacheManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.util.Removable;

public class MemoryMonitor
extends JPanel
implements Runnable,
Removable {
    private boolean running = false;
    private long sleepInterval = 1000L;
    private Thread thread;
    private int percentThreshold;
    private int timesAboveThreshold = 0;
    private static DecimalFormat fmt = new DecimalFormat("#0");
    private JLabel label1;
    private JLabel label2;
    private Color labelForeground;
    private boolean inTheRed = false;
    private static long lastTimeClearCache = -1L;
    private boolean showClock = true;
    private static final Font clockFont = new Font("Dialog", 1, 11);
    private static SimpleDateFormat clockFormat = new SimpleDateFormat("HH:mm:ss z");
    private String memoryLabel = "";

    public MemoryMonitor() {
        this(80);
    }

    public MemoryMonitor(int percentThreshold) {
        this(percentThreshold, true);
    }

    public MemoryMonitor(int percentThreshold, boolean showTheClock) {
        super(new BorderLayout());
        this.showClock = showTheClock;
        this.label1 = new JLabel("", 4){

            @Override
            public String getToolTipText(MouseEvent me) {
                StringBuffer sb = new StringBuffer();
                sb.append("<html><table>");
                sb.append("<tr><td align=right><b>Current Date/Time:</b></td><td><i>" + GuiUtils.formatDate(new Date()) + "</i></td></tr>");
                sb.append("<tr><td align=right><b>Memory Usage:</b></td><td><i>" + MemoryMonitor.this.memoryLabel + "</i></td></tr>");
                sb.append("</table>");
                if (MemoryMonitor.this.showClock) {
                    sb.append("Click to show memory usage");
                } else {
                    sb.append("Click to show clock");
                }
                sb.append("</html>");
                return sb.toString();
            }
        };
        this.label2 = new JLabel("");
        Font f = this.label1.getFont();
        this.label1.setToolTipText("Used memory/Max memory");
        this.label2.setToolTipText("Used memory/Max memory");
        this.label1.setFont(f);
        this.label2.setFont(f);
        this.percentThreshold = percentThreshold;
        this.add("Center", new Msg.SkipPanel(GuiUtils.hbox(Misc.newList(this.label1, this.label2))));
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    MemoryMonitor.this.showClock = !MemoryMonitor.this.showClock;
                    MemoryMonitor.this.showStats();
                }
                MemoryMonitor.this.handleMouseEvent(e);
            }
        };
        this.labelForeground = this.label2.getForeground();
        this.label1.addMouseListener(ml);
        this.label2.addMouseListener(ml);
        this.start();
    }

    @Override
    public void doRemove() {
        this.running = false;
        GuiUtils.empty(this);
    }

    private void popupMenu(MouseEvent event) {
        JPopupMenu popup = new JPopupMenu();
        if (this.running) {
            // empty if block
        }
        popup.add(GuiUtils.makeMenuItem("Clear Cache", this, "clearCache"));
        popup.show(this, event.getX(), event.getY());
    }

    public void toggleRunning() {
        if (this.running) {
            this.stop();
        } else {
            this.start();
        }
    }

    private void handleMouseEvent(MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event)) {
            this.popupMenu(event);
            return;
        }
    }

    public void setLabelFont(Font f) {
        this.label1.setFont(f);
        this.label2.setFont(f);
    }

    public synchronized void stop() {
        this.running = false;
        this.label1.setEnabled(false);
        this.label2.setEnabled(false);
    }

    private synchronized void start() {
        if (this.running) {
            return;
        }
        this.label1.setEnabled(true);
        this.label2.setEnabled(true);
        this.running = true;
        this.thread = new Thread((Runnable)this, "Memory monitor");
        this.thread.start();
    }

    public void clearCache() {
        CacheManager.clearCache();
    }

    private static String humanReadableByteCount(long bytes, boolean useBaseTwoUnits) {
        int unit;
        int n = unit = useBaseTwoUnits ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (useBaseTwoUnits ? "KMGTPE" : "kMGTPE").charAt(exp - 1) + (useBaseTwoUnits ? "i" : "");
        String humanReadable = !pre.toLowerCase().contains("k") && !pre.contains("M") ? String.format("%.3f %sB", (double)bytes / Math.pow(unit, exp), pre) : String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
        return humanReadable;
    }

    private void showStats() {
        try {
            String text;
            long maxTotalMemory = Runtime.getRuntime().maxMemory();
            long currentAllocatedMemory = Runtime.getRuntime().totalMemory();
            long currentFreeAllocatedMemory = Runtime.getRuntime().freeMemory();
            long currentUsedMemory = currentAllocatedMemory - currentFreeAllocatedMemory;
            int percent = (int)(100.0 * (double)(currentUsedMemory / maxTotalMemory));
            this.memoryLabel = MemoryMonitor.humanReadableByteCount(currentUsedMemory, false) + "/" + MemoryMonitor.humanReadableByteCount(maxTotalMemory, false);
            if (this.showClock) {
                Date d = new Date();
                clockFormat.setTimeZone(GuiUtils.getTimeZone());
                text = "  " + clockFormat.format(d);
            } else {
                text = this.memoryLabel;
            }
            this.label1.setText(text);
            long now = System.currentTimeMillis();
            if (lastTimeClearCache < 0L) {
                lastTimeClearCache = now;
            }
            if ((percent = (int)(100.0 * (double)(currentUsedMemory / maxTotalMemory))) > this.percentThreshold) {
                ++this.timesAboveThreshold;
                if (this.timesAboveThreshold > 5) {
                    if (now - lastTimeClearCache > 5000L) {
                        CacheManager.clearCache();
                        lastTimeClearCache = now;
                    }
                    if (!this.inTheRed) {
                        this.setInTheRed(true);
                    }
                }
            } else {
                if (this.inTheRed) {
                    this.setInTheRed(false);
                }
                this.timesAboveThreshold = 0;
                lastTimeClearCache = now;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void setInTheRed(boolean red) {
        this.inTheRed = red;
        if (this.inTheRed) {
            this.label2.setForeground(Color.red);
        } else {
            this.label2.setForeground(this.labelForeground);
        }
    }

    @Override
    public void run() {
        while (this.running) {
            this.showStats();
            try {
                Thread.sleep(this.sleepInterval);
            }
            catch (Exception exception) {}
        }
    }

    public void setRunning(boolean r) {
        this.running = r;
    }

    public boolean getRunning() {
        return this.running;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        MemoryMonitor mm = new MemoryMonitor();
        f.getContentPane().add(mm);
        f.pack();
        f.setVisible(true);
    }
}

