/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import ucar.unidata.util.CacheManager;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LayoutUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.util.ObjectArray;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.WrapperException;

public class LogUtil {
    static LogCategory log_ = LogUtil.getLogInstance(LogUtil.class.getName());
    private static String lastErrorMessage = "";
    private static long lastErrorTime = 0L;
    private static boolean testMode = false;
    private static boolean showErrorsInGui = true;
    private static ArrayList exceptions = new ArrayList();
    private static ArrayList msgs = new ArrayList();
    private static boolean debug = false;
    private static ByteArrayOutputStream outputBuffer;
    private static PrintStream originalErr;
    private static PrintStream originalOut;
    private static JFrame consoleWindow;
    private static JTextArea consoleText;
    private static DialogManager dialogManager;
    private static List currentWindows;
    private static ArrayList messageLogs;
    private static String lastMessageString;
    public static int printlncnt;

    private LogUtil() {
    }

    public static LogCategory getLogInstance(String name) {
        return new LogCategory(name);
    }

    public static boolean anyErrors() {
        return exceptions.size() > 0;
    }

    public static List getExceptions() {
        return exceptions;
    }

    public static List getMessages() {
        return msgs;
    }

    public static void setTestMode(boolean v) {
        testMode = v;
    }

    public static boolean getTestMode() {
        return testMode;
    }

    public static boolean showGui() {
        return !LogUtil.getTestMode() && LogUtil.getShowErrorsInGui();
    }

    public static void setShowErrorsInGui(boolean v) {
        showErrorsInGui = v;
    }

    public static boolean getShowErrorsInGui() {
        return showErrorsInGui;
    }

    public static boolean getInteractiveMode() {
        return !testMode;
    }

    public static void setDebugMode(boolean v) {
        debug = v;
    }

    public static boolean getDebugMode() {
        return debug;
    }

    public static void configure() {
    }

    private static Properties[] getProperties(String filename, Class origin) {
        ArrayList<Properties> l = new ArrayList<Properties>();
        InputStream s = null;
        try {
            s = IOUtil.getInputStream(filename, origin);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Could not open  property file:" + filename);
        }
        Properties p = new Properties();
        try {
            p.load(s);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Could not open  property file:" + filename + " Exception:" + exc);
        }
        l.add(p);
        Properties[] sa = new Properties[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            sa[i] = (Properties)l.get(i);
        }
        return sa;
    }

    public static void logException(String msg, Throwable exc) {
        LogUtil.printException(log_, msg, exc);
    }

    public static void printExceptionsNoGui(List errorMessages, List exceptions) {
        if (exceptions == null) {
            return;
        }
        for (int i = 0; i < exceptions.size(); ++i) {
            Exception exc = (Exception)exceptions.get(i);
            String message = (String)errorMessages.get(i);
            LogUtil.logException(message, exc);
        }
    }

    public static void printExceptionsNoGui(String errorMessage, List exceptions) {
        if (exceptions == null) {
            return;
        }
        for (int i = 0; i < exceptions.size(); ++i) {
            Exception exc = (Exception)exceptions.get(i);
            LogUtil.logException(errorMessage, exc);
        }
    }

    public static void printExceptions(List exceptions) {
        if (exceptions == null) {
            return;
        }
        ArrayList<String> messages = new ArrayList<String>();
        for (int i = 0; i < exceptions.size(); ++i) {
            messages.add(((Exception)exceptions.get(i)).getMessage());
        }
        LogUtil.printExceptions(messages, exceptions);
    }

    public static void println(String msg) {
        if (originalErr != null) {
            originalErr.println(msg);
        } else {
            System.err.println(msg);
        }
    }

    public static void startOutputBuffer() {
        if (outputBuffer != null) {
            return;
        }
        outputBuffer = new ByteArrayOutputStream();
        originalErr = System.err;
        originalOut = System.out;
        System.setErr(new PrintStream(outputBuffer));
        System.setOut(new PrintStream(outputBuffer));
    }

    public static String getOutputBuffer(boolean andClearIt) {
        if (outputBuffer == null) {
            return null;
        }
        String s = outputBuffer.toString();
        if (andClearIt) {
            outputBuffer.reset();
        }
        return s;
    }

    public static void stopOutputBuffer() {
        outputBuffer = null;
        if (originalErr != null) {
            System.setErr(originalErr);
            System.setOut(originalOut);
        }
    }

    public static void printExceptions(List errorMessages, List exceptions) {
        LogUtil.printExceptions("Errors have occured", errorMessages, exceptions);
    }

    public static void printExceptions(String label, List errorMessages, List exceptions) {
        if (exceptions == null) {
            return;
        }
        if (exceptions.size() == 1) {
            LogUtil.logException((String)errorMessages.get(0), (Throwable)exceptions.get(0));
            return;
        }
        if (!LogUtil.showGui()) {
            LogUtil.printExceptionsNoGui(errorMessages, exceptions);
            return;
        }
        JPanel contents = LayoutUtil.topCenter(new JLabel(label), LogUtil.getMultiExceptionsPanel(errorMessages, exceptions));
        GuiUtils.showDialog("Errors", contents, LogUtil.getCurrentWindow());
    }

    public static Throwable getInnerException(Throwable exc) {
        Throwable innerInner;
        if (exc == null) {
            return null;
        }
        Throwable inner = null;
        if (exc instanceof WrapperException) {
            inner = ((WrapperException)exc).getException();
        } else if (exc instanceof InvocationTargetException) {
            inner = ((InvocationTargetException)exc).getTargetException();
        } else {
            Throwable cause = exc.getCause();
            if (cause != null) {
                inner = cause;
            }
        }
        if (inner != null && (innerInner = LogUtil.getInnerException(inner)) != null) {
            inner = innerInner;
        }
        if (inner == null) {
            return exc;
        }
        return inner;
    }

    public static JPanel getMultiExceptionsPanel(List errorMessages, List exceptions) {
        final JTextArea tv = new JTextArea(15, 60);
        final JScrollPane sp = new JScrollPane(tv);
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        for (int i = 0; i < exceptions.size(); ++i) {
            Throwable exc = (Throwable)exceptions.get(i);
            String message = "";
            if (errorMessages != null && i < errorMessages.size()) {
                message = (String)errorMessages.get(i);
            }
            if (message != null && message.length() == 0) {
                message = exc.getMessage();
            }
            JButton jb = new JButton("Details");
            jb.addActionListener(new ObjectListener(new ObjectArray(message, exc)){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ObjectArray oa = (ObjectArray)this.theObject;
                    Throwable theException = (Throwable)oa.getObject2();
                    StringBuffer stackMessage = new StringBuffer();
                    Throwable innerException = LogUtil.getInnerException(theException);
                    if (innerException != null) {
                        stackMessage.append("Contained exception:" + innerException.getMessage() + "\n");
                        stackMessage.append(LogUtil.getStackTrace(innerException));
                        stackMessage.append("Exception thrown at:\n");
                    }
                    theException.printStackTrace();
                    stackMessage.append(theException.getMessage() + "\n");
                    stackMessage.append(LogUtil.getStackTrace(theException));
                    sp.getViewport().setViewPosition(new Point(0, 0));
                    String msg = stackMessage.toString();
                    LogUtil.consoleMessage(msg);
                    System.err.println(msg);
                    tv.setText(msg);
                    sp.getViewport().setViewPosition(new Point(0, 0));
                    tv.setCaretPosition(0);
                }
            });
            comps.add(jb);
            comps.add(new JLabel("  " + message + "  "));
        }
        JPanel jp = LayoutUtil.doLayout(LayoutUtil.getComponentArray(comps), 2, LayoutUtil.WT_NY, LayoutUtil.WT_N);
        JScrollPane jpScroll = GuiUtils.makeScrollPane(LayoutUtil.top(jp), 100, 100);
        jpScroll.setPreferredSize(new Dimension(100, 100));
        jpScroll.setSize(new Dimension(100, 100));
        JPanel contents = LayoutUtil.topCenter(jpScroll, sp);
        return contents;
    }

    public static String getStackTrace() {
        return Misc.getStackTrace();
    }

    public static String getStackTrace(Throwable exc) {
        return Misc.getStackTrace(exc);
    }

    public static void showConsole() {
        if (consoleWindow == null) {
            LogUtil.checkConsole();
            JButton clearBtn = new JButton("Clear");
            clearBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    consoleText.setText("");
                }
            });
            JButton writeBtn = new JButton("Write to file");
            writeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String filename = FileManager.getWriteFile(FileManager.FILTER_LOG, ".log");
                    if (filename == null) {
                        return;
                    }
                    try {
                        IOUtil.writeFile(filename, consoleText.getText());
                    }
                    catch (Exception exc) {
                        LogUtil.logException("Writing to file:" + filename, exc);
                    }
                }
            });
            JScrollPane sp = new JScrollPane(consoleText, 22, 30);
            JViewport vp = sp.getViewport();
            vp.setViewSize(new Dimension(300, 400));
            JPanel contents = LayoutUtil.centerBottom(sp, LayoutUtil.wrap(LayoutUtil.hflow(Misc.newList(clearBtn, writeBtn))));
            consoleWindow = GuiUtils.makeWindow("Console", contents, 10, 10);
        }
        consoleWindow.setVisible(true);
    }

    private static void checkConsole() {
        if (consoleText == null) {
            consoleText = new JTextArea(10, 30);
            consoleText.setEditable(false);
        }
    }

    public static void consoleMessage(String msg) {
        LogUtil.checkConsole();
        msg = Msg.msg(msg);
        consoleText.append(msg + "\n");
    }

    public static void setDialogManager(DialogManager manager) {
        dialogManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Window getCurrentWindow() {
        List list = currentWindows;
        synchronized (list) {
            if (currentWindows.size() == 0) {
                return null;
            }
            return (Window)currentWindows.get(currentWindows.size() - 1);
        }
    }

    public static void registerWindow(final Window w) {
        WindowAdapter windowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                currentWindows.remove(w);
                e.getWindow().removeWindowListener(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowActivated(WindowEvent e) {
                List list = currentWindows;
                synchronized (list) {
                    if (currentWindows.contains(w)) {
                        currentWindows.remove(w);
                    }
                    currentWindows.add(w);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent e) {
                List list = currentWindows;
                synchronized (list) {
                    currentWindows.remove(w);
                    e.getWindow().removeWindowListener(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowIconified(WindowEvent e) {
                List list = currentWindows;
                synchronized (list) {
                    currentWindows.remove(w);
                }
            }
        };
        w.addWindowListener(windowListener);
    }

    public static void printException(LogCategory log_, String xmsg, Throwable exc) {
        if (!LogUtil.getInteractiveMode()) {
            System.err.println(xmsg);
        } else {
            LogUtil.printException(log_, xmsg, exc, (File)null);
        }
    }

    public static void printException(LogCategory log_, String xmsg, Throwable exc, byte[] fileBytes) {
        File f = null;
        if (fileBytes != null) {
            f = CacheManager.getTmpFile("error");
            try {
                IOUtil.writeBytes(f, fileBytes);
            }
            catch (Exception fileException) {
                f = null;
            }
        }
        LogUtil.printException(log_, xmsg, exc, f);
    }

    public static void printException(LogCategory log_, String xmsg, Throwable originalException, File file) {
        String msg;
        xmsg = Msg.msg(xmsg);
        Throwable exc = originalException;
        Throwable wrappedExc = LogUtil.getInnerException(originalException);
        if (wrappedExc != null) {
            exc = wrappedExc;
        }
        String excMessage = exc.getMessage();
        if (originalException instanceof WrapperException) {
            msg = originalException.getMessage();
            if (excMessage != null && msg != null && msg.length() > 0 && !msg.trim().equals(excMessage.trim())) {
                excMessage = msg + " " + excMessage;
            }
        }
        excMessage = excMessage == null ? "\n" + exc.getClass().getName() : "\n" + excMessage;
        msg = xmsg + " " + excMessage;
        if (file != null) {
            msg = msg + "\n\n" + "View file at:" + file;
        }
        long time = System.currentTimeMillis();
        if (msg.equals(lastErrorMessage) && time - lastErrorTime < 1000L) {
            return;
        }
        lastErrorMessage = msg;
        LogUtil.consoleMessage(msg);
        LogUtil.consoleMessage(LogUtil.getStackTrace(exc));
        if (log_ != null) {
            log_.error(msg);
        }
        if (LogUtil.showGui()) {
            final JDialog dialog = GuiUtils.createDialog(LogUtil.getCurrentWindow(), "Error", true);
            final JPanel bottomPanel = new JPanel(new BorderLayout());
            JButton showConsoleBtn = new JButton("Show Console");
            ArrayList<JButton> buttonList = new ArrayList<JButton>();
            if (dialogManager != null) {
                dialogManager.addErrorButtons(dialog, buttonList, msg, exc);
            }
            final JButton detailsBtn = new JButton("Show Details");
            JTextArea detailsArea = new JTextArea(LogUtil.getStackTrace(exc));
            detailsArea.setBackground(new JPanel().getBackground());
            detailsArea.setEditable(false);
            JScrollPane sp = new JScrollPane(detailsArea);
            sp.setPreferredSize(new Dimension(500, 200));
            JButton closeBtn = new JButton("OK");
            final boolean[] showing = new boolean[]{false};
            final JPanel detailsPanel = LayoutUtil.center(sp);
            closeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    lastErrorTime = System.currentTimeMillis();
                    dialog.dispose();
                }
            });
            detailsBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (showing[0]) {
                        bottomPanel.removeAll();
                        detailsBtn.setText("Show Details");
                    } else {
                        bottomPanel.add(detailsPanel);
                        detailsBtn.setText("Hide Details");
                    }
                    showing[0] = !showing[0];
                    bottomPanel.invalidate();
                    dialog.pack();
                }
            });
            JComponent errorLbl = new JLabel(GuiUtils.getImageIcon("/auxdata/ui/icons/Error.gif"));
            errorLbl = LayoutUtil.top(LayoutUtil.inset((Component)errorLbl, new Insets(8, 8, 8, 8)));
            buttonList.add(detailsBtn);
            buttonList.add(closeBtn);
            LayoutUtil.tmpInsets = new Insets(0, 4, 0, 4);
            JPanel buttons = LayoutUtil.doLayout(buttonList, buttonList.size(), LayoutUtil.WT_N, LayoutUtil.WT_N);
            buttons = LayoutUtil.inset((Component)buttons, 5);
            JPanel messageComp = LayoutUtil.inset((Component)LogUtil.getMessageComponent(msg), new Insets(8, 0, 8, 8));
            JPanel topPanel = LayoutUtil.leftCenter(errorLbl, messageComp);
            topPanel.setBackground(Color.red);
            JPanel contents = LayoutUtil.centerBottom(topPanel, buttons);
            contents = LayoutUtil.doLayout(new Component[]{contents, bottomPanel}, 1, LayoutUtil.WT_Y, LayoutUtil.WT_Y);
            dialog.getContentPane().add(contents);
            dialog.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dialogSize = dialog.getSize();
            dialog.setLocation(Math.max(0, screenSize.width / 2 - dialogSize.width / 2), Math.max(0, screenSize.height / 2 - dialogSize.height / 2));
            dialog.setVisible(true);
        }
        exc.printStackTrace(System.err);
        if (!LogUtil.showGui()) {
            exceptions.add(exc);
            msgs.add(xmsg);
        }
    }

    public static void printExceptionNoGui(LogCategory log_, String xmsg, Throwable exc) {
        if (exc instanceof InvocationTargetException) {
            exc = ((InvocationTargetException)exc).getTargetException();
        }
        LogUtil.consoleMessage(LogUtil.getStackTrace(exc));
        exc.printStackTrace(System.err);
        if (LogUtil.getTestMode()) {
            exceptions.add(exc);
            msgs.add(xmsg);
        }
    }

    public static void printMessage(String msg) {
        log_.error(msg);
        LogUtil.consoleMessage(msg);
    }

    public static void userMessage(String msg) {
        LogUtil.userMessage(null, msg, false);
    }

    public static void userMessage(LogCategory log_, String msg) {
        LogUtil.userMessage(log_, msg, false);
    }

    public static void userMessage(LogCategory log_, String msg, String consoleMsg) {
        LogUtil.userMessage(log_, msg);
        log_.error(consoleMsg);
    }

    public static void userMessage(LogCategory log_, String msg, boolean andLog) {
        msg = Msg.msg(msg);
        if (andLog && log_ != null) {
            log_.error(msg);
        }
        if (LogUtil.showGui()) {
            LogUtil.consoleMessage(msg);
            JComponent msgComponent = LogUtil.getMessageComponent(msg);
            GuiUtils.addModalDialogComponent(msgComponent);
            JOptionPane.showMessageDialog(LogUtil.getCurrentWindow(), msgComponent);
            GuiUtils.removeModalDialogComponent(msgComponent);
        } else if (!andLog || log_ == null) {
            System.err.println(msg);
        }
    }

    private static JComponent getMessageComponent(String msg) {
        if (msg.startsWith("<html>")) {
            Component[] comps = GuiUtils.getHtmlComponent(msg, null, 500, 400);
            return (JScrollPane)comps[1];
        }
        if (msg.length() < 50) {
            return new JLabel(msg);
        }
        List<String> lines = StringUtil.split(msg, "\n");
        StringBuilder sb = new StringBuilder(msg.length() * 2);
        for (String line : lines) {
            line = StringUtil.breakText(line, "\n", 50);
            sb.append(line).append('\n');
        }
        JTextArea textArea = new JTextArea(sb.toString());
        textArea.setFont(textArea.getFont().deriveFont(1));
        textArea.setBackground(new JPanel().getBackground());
        textArea.setEditable(false);
        JScrollPane textSp = GuiUtils.makeScrollPane(textArea, 400, 200);
        textSp.setPreferredSize(new Dimension(400, 200));
        return textSp;
    }

    public static void userErrorMessage(LogCategory log_, String msg) {
        msg = Msg.msg(msg);
        if (log_ != null) {
            log_.error(msg);
        }
        if (LogUtil.showGui()) {
            LogUtil.consoleMessage(msg);
            JComponent msgComponent = LogUtil.getMessageComponent(msg);
            GuiUtils.addModalDialogComponent(msgComponent);
            JOptionPane.showMessageDialog(LogUtil.getCurrentWindow(), msgComponent, "Error", 0);
            GuiUtils.removeModalDialogComponent(msgComponent);
        } else {
            System.err.println(msg);
        }
    }

    public static void userErrorMessage(JLabel label) {
        if (LogUtil.showGui()) {
            GuiUtils.addModalDialogComponent(label);
            JOptionPane.showMessageDialog(LogUtil.getCurrentWindow(), label, "Error", 0);
            GuiUtils.removeModalDialogComponent(label);
        } else {
            System.err.println(label.getText());
        }
    }

    public static void userErrorMessage(String msg) {
        LogUtil.userErrorMessage(null, msg);
    }

    public static void userErrorMessage(Object msg) {
        if (LogUtil.showGui()) {
            if (!(msg instanceof Component)) {
                msg = new JLabel(msg.toString());
            }
            GuiUtils.addModalDialogComponent((Component)msg);
            JOptionPane.showMessageDialog(LogUtil.getCurrentWindow(), msg, "Error", 0);
            GuiUtils.removeModalDialogComponent((Component)msg);
        } else {
            System.err.println(msg);
        }
    }

    public static void addMessageLogger(JTextArea t) {
        messageLogs.add(t);
    }

    public static void addMessageLogger(JLabel t) {
        messageLogs.add(t);
    }

    public static void removeMessageLogger(Object t) {
        messageLogs.remove(t);
    }

    public static void clearMessage(String message) {
        if (lastMessageString != null && message.equals(lastMessageString)) {
            LogUtil.message("");
        }
    }

    public static void message(String msg) {
        lastMessageString = msg = Msg.msg(msg);
        for (int i = 0; i < messageLogs.size(); ++i) {
            Object logger = messageLogs.get(i);
            if (logger instanceof JTextArea) {
                if (msg.trim().length() <= 0) continue;
                ((JTextArea)logger).append(msg + "\n");
                ((JTextArea)logger).repaint();
                continue;
            }
            if (!(logger instanceof JLabel)) continue;
            ((JLabel)logger).setText(msg);
            ((JLabel)logger).repaint();
        }
    }

    public static void tracePrintlns() {
        System.setErr(new PrintStream(new ByteArrayOutputStream()){

            @Override
            public void println(String s) {
                this.doit(s);
            }

            @Override
            public void println(Object x) {
                this.doit("" + x);
            }

            private void doit(String s) {
                if (printlncnt > 0) {
                    System.out.println("Recurse:" + s);
                    super.println(s);
                    return;
                }
                ++printlncnt;
                System.out.println("PRINT:" + s);
                IllegalArgumentException exc = new IllegalArgumentException("");
                exc.printStackTrace();
                --printlncnt;
            }
        });
    }

    public static StringBuffer getStackDump(boolean asHtml) {
        return LogUtil.getStackDump(asHtml, false);
    }

    public static StringBuffer getStackDump(boolean asHtml, boolean onlyRunning) {
        StringBuffer longSB = new StringBuffer();
        if (asHtml) {
            longSB.append("<pre>\n");
        }
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] ids = threadBean.getAllThreadIds();
        StringBuffer blockedSB = new StringBuffer();
        StringBuffer otherSB = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            ThreadInfo info = threadBean.getThreadInfo(ids[i], Integer.MAX_VALUE);
            if (info == null || onlyRunning && info.getThreadState() != Thread.State.RUNNABLE) continue;
            StackTraceElement[] stack = info.getStackTrace();
            String extra = "";
            String style = "";
            StringBuffer sb = otherSB;
            if (info.getThreadState() == Thread.State.WAITING) {
                extra = " on " + info.getLockName();
            } else if (info.getThreadState() == Thread.State.BLOCKED) {
                style = "  background-color:#cccccc; ";
                extra = asHtml ? " on " + info.getLockName() + " held by <a href=\"#id" + info.getLockOwnerId() + "\">" + info.getLockOwnerName() + " id:" + info.getLockOwnerId() + "</a>" : " on " + info.getLockName() + " held by " + info.getLockOwnerId() + info.getLockOwnerName() + " id:" + info.getLockOwnerId();
                sb = blockedSB;
            }
            if (asHtml) {
                sb.append("<a name=\"id" + ids[i] + "\"></a>");
                sb.append("<span style=\"" + style + "\">&quot;" + info.getThreadName() + "&quot;" + " ID:" + ids[i] + "  " + (Object)((Object)info.getThreadState()) + extra + "</span>\n");
            } else {
                sb.append("\"" + info.getThreadName() + "\"" + " ID:" + ids[i] + "  " + (Object)((Object)info.getThreadState()) + extra + "\n");
            }
            String space = asHtml ? "&nbsp;&nbsp;&nbsp;&nbsp;" : "    ";
            for (int stackIdx = 0; stackIdx < stack.length; ++stackIdx) {
                sb.append(space);
                sb.append(stack[stackIdx] + "\n");
            }
            sb.append("\n\n");
        }
        longSB.append(blockedSB);
        longSB.append(otherSB);
        if (asHtml) {
            longSB.append("</pre>");
        }
        return longSB;
    }

    static {
        currentWindows = new ArrayList();
        messageLogs = new ArrayList();
        lastMessageString = "";
        printlncnt = 0;
    }

    public static interface DialogManager {
        public void addErrorButtons(JDialog var1, List var2, String var3, Throwable var4);
    }

    public static class LogCategory {
        public LogCategory(String name) {
        }

        public void debug(String msg) {
            if (debug) {
                LogUtil.consoleMessage(msg);
                System.err.println(msg);
            }
        }

        public void error(String msg) {
            System.err.println("ERROR: " + msg);
        }

        public void warn(String msg) {
            System.err.println("WARNING: " + msg);
        }

        public boolean isDebugEnabled() {
            return debug;
        }
    }
}

