/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ucar.unidata.util.MenuUtil;

public class LayoutUtil
extends MenuUtil {
    private static final Insets DFLT_INSETS = new Insets(0, 0, 0, 0);
    public static Insets tmpInsets;
    public static final Insets INSETS_5;
    public static final Insets INSETS_2;
    public static int[] tmpColFills;
    private static final int DFLT_ANCHOR = 17;
    public static int tmpAnchor;
    public static int tmpFill;
    public static final Insets ZERO_INSETS;
    public static final double[] WT_Y;
    public static final double[] WT_YY;
    public static final double[] WT_YYY;
    public static final double[] WT_N;
    public static final double[] WT_NN;
    public static final double[] WT_NNN;
    public static final double[] WT_YN;
    public static final double[] WT_YYN;
    public static final double[] WT_YNYN;
    public static final double[] WT_NYNYN;
    public static final double[] WT_NY;
    public static final double[] WT_NYN;
    public static final double[] WT_YNY;
    public static final double[] WT_NYY;
    public static final double[] WT_YNN;
    public static final double[] WT_NNY;
    public static final double[] WT_NNNY;
    public static final double[] WT_NNYN;
    public static final double[] WT_NNYNY;
    public static final double[] WT_NNYNYNY;
    public static final double[] WT_NYNY;

    public static void setNoFill() {
        tmpFill = 0;
    }

    public static JComponent hfill(JComponent comp) {
        LayoutUtil.setHFill();
        return LayoutUtil.doLayout(new Component[]{comp}, 1, WT_Y, WT_N);
    }

    public static void setHFill() {
        tmpFill = 2;
    }

    public static void setAnchorBottom() {
        tmpAnchor = 16;
    }

    public static void setAnchorTop() {
        tmpAnchor = 12;
    }

    public static JPanel inset(Component c, int insetSize) {
        return LayoutUtil.inset(c, insetSize, insetSize);
    }

    public static JPanel inset(Component c, int insetSizeHor, int insetSizeVert) {
        return LayoutUtil.doLayout(new JPanel(), new Component[]{c}, 1, WT_Y, WT_Y, null, null, new Insets(insetSizeVert, insetSizeHor, insetSizeVert, insetSizeHor));
    }

    public static JPanel inset(Component c, Insets insets) {
        return LayoutUtil.doLayout(new JPanel(), new Component[]{c}, 1, WT_Y, WT_Y, null, null, insets);
    }

    public static JPanel wrapLeft(Component c) {
        return LayoutUtil.doLayout(new Component[]{c, LayoutUtil.filler()}, 2, WT_NY, WT_N);
    }

    public static JPanel wrap(Component c) {
        return LayoutUtil.doLayout(new Component[]{c}, 1, WT_N, WT_N);
    }

    public static JPanel hflow(List components) {
        return LayoutUtil.hflow(components, 0, 0);
    }

    public static JPanel hflow(List components, int hgap, int vgap) {
        JPanel p = new JPanel(new FlowLayout(0, hgap, vgap));
        for (int i = 0; i < components.size(); ++i) {
            Component comp = (Component)components.get(i);
            if (comp == null) continue;
            p.add(comp);
        }
        return p;
    }

    public static JPanel hgrid(Component comp1, Component comp2) {
        return LayoutUtil.hgrid(LayoutUtil.toList(new Object[]{comp1, comp2}));
    }

    public static JPanel hgrid(List components) {
        return LayoutUtil.hgrid(components, 0);
    }

    public static JPanel hgrid(List components, int space) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 0, space, space));
        for (int i = 0; i < components.size(); ++i) {
            panel.add((Component)components.get(i));
        }
        return panel;
    }

    public static JPanel vgrid(List components) {
        return LayoutUtil.vgrid(new JPanel(), components, 0);
    }

    public static JPanel vgrid(JPanel panel, List components, int space) {
        if (panel == null) {
            panel = new JPanel();
        }
        panel.setLayout(new GridLayout(0, 1, space, space));
        for (int i = 0; i < components.size(); ++i) {
            panel.add((Component)components.get(i));
        }
        return panel;
    }

    public static JPanel rowGrid(List comps, int rows) {
        return LayoutUtil.rowGrid(LayoutUtil.getComponentArray(comps), rows);
    }

    public static JPanel rowGrid(Component[] components, int rows) {
        return LayoutUtil.grid(components, rows, 0, 0);
    }

    public static JPanel colGrid(Component[] components, int cols) {
        return LayoutUtil.grid(components, 0, cols, 0);
    }

    public static JPanel grid(Component[] components, int rows, int cols) {
        return LayoutUtil.grid(components, rows, cols, 0);
    }

    public static JPanel grid(Component[] components, int rows, int cols, int space) {
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(rows, cols, space, space));
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == null) {
                p.add(LayoutUtil.filler());
                continue;
            }
            p.add(components[i]);
        }
        return p;
    }

    public static JPanel inset(JPanel parent, Component c, int insetSize) {
        return LayoutUtil.doLayout(parent, new Component[]{c}, 1, WT_Y, WT_Y, null, null, new Insets(insetSize, insetSize, insetSize, insetSize));
    }

    public static JPanel doLayout(List components, int numberOfColumns, int hinset, int vinset) {
        return LayoutUtil.doLayout(new JPanel(), LayoutUtil.getComponentArray(components), numberOfColumns, WT_N, WT_N, null, null, new Insets(hinset, vinset, hinset, vinset));
    }

    public static Component[] getComponentArray(List listOfComponents) {
        Component[] c = new Component[listOfComponents.size()];
        for (int i = 0; i < listOfComponents.size(); ++i) {
            c[i] = (Component)listOfComponents.get(i);
        }
        return c;
    }

    public static JPanel doLayout(List components, int numberOfColumns, double[] weightsX, double[] weightsY) {
        return LayoutUtil.doLayout(new JPanel(), LayoutUtil.getComponentArray(components), numberOfColumns, weightsX, weightsY, null, null, null);
    }

    public static JPanel doLayout(Component[] components, int numberOfColumns, double[] weightsX, double[] weightsY) {
        return LayoutUtil.doLayout(new JPanel(), components, numberOfColumns, weightsX, weightsY, null, null, null);
    }

    public static JPanel doLayout(JPanel parentContainer, Component[] components, int numberOfColumns, double[] weightsX, double[] weightsY) {
        return LayoutUtil.doLayout(parentContainer, components, numberOfColumns, weightsX, weightsY, null, null, null);
    }

    public static JPanel vbox(Component c1, Component c2) {
        return LayoutUtil.vbox(LayoutUtil.toList(new Object[]{c1, c2}));
    }

    public static JPanel vbox(Component c1, Component c2, Component c3) {
        return LayoutUtil.vbox(LayoutUtil.toList(new Object[]{c1, c2, c3}));
    }

    public static JPanel vbox(Component c1, Component c2, Component c3, Component c4) {
        return LayoutUtil.vbox(LayoutUtil.toList(new Object[]{c1, c2, c3, c4}));
    }

    public static JPanel vbox(Component c1, Component c2, Component c3, Component c4, Component c5) {
        return LayoutUtil.vbox(LayoutUtil.toList(new Object[]{c1, c2, c3, c4, c5}));
    }

    public static JPanel vbox(Component[] components) {
        return LayoutUtil.vbox(LayoutUtil.toList(components));
    }

    public static List toList(Object[] l) {
        ArrayList<Object> v = new ArrayList<Object>();
        for (int i = 0; i < l.length; ++i) {
            v.add(l[i]);
        }
        return v;
    }

    public static JPanel vbox(List components) {
        return LayoutUtil.vbox(new JPanel(), components);
    }

    public static JPanel vbox(JPanel panel, List components) {
        return LayoutUtil.doLayout(panel, LayoutUtil.getComponentArray(components), 1, WT_Y, WT_N);
    }

    public static JPanel leftVbox(List components) {
        ArrayList<JPanel> tmp = new ArrayList<JPanel>();
        for (int i = 0; i < components.size(); ++i) {
            tmp.add(LayoutUtil.left((Component)components.get(i)));
        }
        return LayoutUtil.vbox(tmp);
    }

    public static JPanel hbox(Component c1, Component c2, int spacing) {
        return LayoutUtil.hbox(new JPanel(), LayoutUtil.toList(new Object[]{c1, c2}), spacing);
    }

    public static JPanel hbox(Component c1, Component c2, Component c3, int spacing) {
        return LayoutUtil.hbox(new JPanel(), LayoutUtil.toList(new Object[]{c1, c2, c3}), spacing);
    }

    public static JPanel hbox(Component c1, Component c2) {
        return LayoutUtil.hbox(LayoutUtil.toList(new Object[]{c1, c2}));
    }

    public static JPanel hbox(Component c1, Component c2, Component c3) {
        return LayoutUtil.hbox(LayoutUtil.toList(new Object[]{c1, c2, c3}));
    }

    public static JPanel hbox(Component c1, Component c2, Component c3, Component c4) {
        return LayoutUtil.hbox(LayoutUtil.toList(new Object[]{c1, c2, c3, c4}));
    }

    public static JPanel hbox(List components, int spacing) {
        return LayoutUtil.hbox(new JPanel(), components, spacing);
    }

    public static JPanel hbox(List components) {
        return LayoutUtil.hbox(new JPanel(), components);
    }

    public static JPanel hbox(Component[] components) {
        return LayoutUtil.hbox(new JPanel(), LayoutUtil.toList(components));
    }

    public static JPanel hbox(Component[] components, int spacing) {
        return LayoutUtil.hbox(new JPanel(), LayoutUtil.toList(components), spacing);
    }

    public static JPanel hbox(JPanel panel, List components) {
        return LayoutUtil.hbox(panel, components, 0);
    }

    public static JPanel hbox(JPanel panel, List components, int space) {
        panel.setLayout(new BoxLayout(panel, 0));
        for (int i = 0; i < components.size(); ++i) {
            panel.add((Component)components.get(i));
            if (space <= 0) continue;
            panel.add(Box.createHorizontalStrut(space));
        }
        return panel;
    }

    public static JPanel doLayout(JPanel parentContainer, Component[] components, int numberOfColumns, double[] weightsX, double[] weightsY, Hashtable anchors, Hashtable fills, Insets insets) {
        if (parentContainer == null) {
            parentContainer = new JPanel();
        }
        if (components.length > 512) {
            Component[] comps1 = new Component[components.length / 2];
            Component[] comps2 = new Component[components.length / 2 + 1];
            int cnt = 0;
            for (int i = 0; i < components.length; ++i) {
                if (i < comps1.length) {
                    comps1[i] = components[i];
                    continue;
                }
                comps2[cnt++] = components[i];
            }
            JPanel comp1 = LayoutUtil.doLayout(null, comps1, numberOfColumns, weightsX, weightsY, anchors, fills, insets);
            JPanel comp2 = LayoutUtil.doLayout(null, comps2, numberOfColumns, weightsX, weightsY, anchors, fills, insets);
            return LayoutUtil.vbox((Component)comp1, comp2);
        }
        GridBagLayout l = new GridBagLayout();
        parentContainer.setLayout(l);
        GridBagConstraints consts = new GridBagConstraints();
        if (insets == null) {
            insets = tmpInsets;
            tmpInsets = null;
        }
        consts.insets = insets == null ? DFLT_INSETS : insets;
        int[] dfltColFills = null;
        if (tmpColFills != null) {
            dfltColFills = tmpColFills;
        }
        tmpColFills = null;
        int dfltAnchor = tmpAnchor == -1 ? 17 : tmpAnchor;
        tmpAnchor = -1;
        int dfltFill = tmpFill >= 0 ? tmpFill : 1;
        tmpFill = -1;
        int col = 0;
        int row = 0;
        double weightX = 1.0;
        double weightY = 0.0;
        for (int i = 0; i < components.length; ++i) {
            Integer anchor;
            Component comp = components[i];
            consts.anchor = dfltAnchor;
            consts.fill = dfltFill;
            if (fills != null && comp != null) {
                Integer fill = (Integer)fills.get(comp);
                if (fill != null) {
                    consts.fill = fill;
                }
            } else if (dfltColFills != null) {
                consts.fill = dfltColFills[col];
            }
            if (weightsX != null && col < weightsX.length) {
                weightX = weightsX[col];
            }
            if (weightsY != null && row < weightsY.length) {
                weightY = weightsY[row];
            }
            boolean lastCol = false;
            if (col == numberOfColumns - 1) {
                lastCol = true;
                consts.gridwidth = 0;
            } else {
                ++col;
            }
            consts.weightx = weightX;
            consts.weighty = weightY;
            if (anchors != null && comp != null && (anchor = (Integer)anchors.get(comp)) != null) {
                consts.anchor = anchor;
            }
            if (lastCol) {
                col = 0;
                ++row;
            }
            if (comp != null) {
                l.setConstraints(comp, consts);
                parentContainer.add(comp);
            }
            consts.gridwidth = 1;
        }
        return parentContainer;
    }

    public static JPanel topLeft(Component top) {
        return LayoutUtil.top(LayoutUtil.left(top));
    }

    public static JPanel top(Component top) {
        return LayoutUtil.topCenterBottom(top, LayoutUtil.filler(), null);
    }

    public static JPanel left(Component left) {
        return LayoutUtil.leftCenter(left, LayoutUtil.filler());
    }

    public static JPanel topCenter(Component top, Component center) {
        return LayoutUtil.topCenterBottom(top, center, null);
    }

    public static JPanel topBottom(Component top, Component bottom) {
        return LayoutUtil.topCenterBottom(top, null, bottom);
    }

    public static JPanel centerBottom(Component center, Component bottom) {
        return LayoutUtil.topCenterBottom(null, center, bottom);
    }

    public static JPanel bottom(Component bottom) {
        return LayoutUtil.topCenterBottom(null, null, bottom);
    }

    public static JPanel center(Component center) {
        return LayoutUtil.topCenterBottom(null, center, null);
    }

    public static JPanel topCenterBottom(Component top, Component center, Component bottom) {
        JPanel p = new JPanel(new BorderLayout());
        if (top != null) {
            p.add("North", top);
        }
        if (center != null) {
            p.add("Center", center);
        }
        if (bottom != null) {
            p.add("South", bottom);
        }
        return p;
    }

    public static JPanel leftRight(Component left, Component right) {
        return LayoutUtil.leftCenterRight(left, null, right);
    }

    public static JPanel leftCenterRight(Component left, Component center, Component right) {
        JPanel p = new JPanel(new BorderLayout());
        if (left != null) {
            p.add("West", left);
        }
        if (center != null) {
            p.add("Center", center);
        }
        if (right != null) {
            p.add("East", right);
        }
        return p;
    }

    public static JPanel centerRight(Component center, Component right) {
        return LayoutUtil.leftCenterRight(null, center, right);
    }

    public static JPanel right(Component right) {
        return LayoutUtil.leftCenterRight(null, null, right);
    }

    public static JPanel leftCenter(Component left, Component center) {
        return LayoutUtil.leftCenterRight(left, center, null);
    }

    public static Component filler() {
        return new JPanel();
    }

    public static JComponent filler(int width, int height) {
        JPanel filler = new JPanel();
        filler.setPreferredSize(new Dimension(width, height));
        return filler;
    }

    static {
        INSETS_5 = new Insets(5, 5, 5, 5);
        INSETS_2 = new Insets(2, 2, 2, 2);
        tmpColFills = null;
        tmpAnchor = -1;
        tmpFill = -1;
        ZERO_INSETS = new Insets(0, 0, 0, 0);
        WT_Y = new double[]{1.0};
        WT_YY = new double[]{1.0, 1.0};
        WT_YYY = new double[]{1.0, 1.0, 1.0};
        WT_N = new double[]{0.0};
        WT_NN = new double[]{0.0};
        WT_NNN = new double[]{0.0};
        WT_YN = new double[]{1.0, 0.0};
        WT_YYN = new double[]{1.0, 1.0, 0.0};
        WT_YNYN = new double[]{1.0, 0.0, 1.0, 0.0};
        WT_NYNYN = new double[]{0.0, 1.0, 0.0, 1.0, 0.0};
        WT_NY = new double[]{0.0, 1.0};
        WT_NYN = new double[]{0.0, 1.0, 0.0};
        WT_YNY = new double[]{1.0, 0.0, 1.0};
        WT_NYY = new double[]{0.0, 1.0, 1.0};
        WT_YNN = new double[]{1.0, 0.0, 0.0};
        WT_NNY = new double[]{0.0, 0.0, 1.0};
        WT_NNNY = new double[]{0.0, 0.0, 0.0, 1.0};
        WT_NNYN = new double[]{0.0, 0.0, 1.0, 0.0};
        WT_NNYNY = new double[]{0.0, 0.0, 1.0, 0.0, 1.0};
        WT_NNYNYNY = new double[]{0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0};
        WT_NYNY = new double[]{0.0, 1.0, 0.0, 1.0};
    }
}

