/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.util.Utils;

public class Json {
    public static final String MIMETYPE = "application/json";
    public static final String NULL = "null";
    public static final boolean DFLT_QUOTE = false;
    public static final String FIELD_NAME = "name";
    public static final String FIELD_FIELDS = "fields";
    public static final String FIELD_DATA = "data";
    public static final String FIELD_VALUES = "values";
    public static final String FIELD_LATITUDE = "latitude";
    public static final String FIELD_LONGITUDE = "longitude";
    public static final String FIELD_ELEVATION = "elevation";
    public static final String FIELD_DATE = "date";

    public static void addGeolocation(Appendable pw, double lat, double lon, double elevation) throws Exception {
        pw.append(Json.attr(FIELD_LATITUDE, lat));
        pw.append(",\n");
        pw.append(Json.attr(FIELD_LONGITUDE, lon));
        pw.append(",\n");
        pw.append(Json.attr(FIELD_ELEVATION, elevation));
    }

    public static String mapAndQuote(String ... values) {
        return Json.map(values, true);
    }

    public static String map(String ... values) {
        return Json.map(values, false);
    }

    public static String map(List<String> values) {
        return Json.map(values, false);
    }

    public static String mapAndQuote(List<String> values) {
        return Json.map(values, true);
    }

    public static String map(String[] values, boolean quoteValue) {
        return Json.map(Misc.toList(values), quoteValue);
    }

    public static String map(List<String> values, boolean quoteValue) {
        StringBuffer row = new StringBuffer();
        row.append(Json.mapOpen());
        for (int i = 0; i < values.size(); i += 2) {
            if (i > 0) {
                row.append(",\n");
            }
            String name = values.get(i);
            String value = values.get(i + 1);
            row.append(Json.attr(name, value, quoteValue));
        }
        row.append(Json.mapClose());
        return row.toString();
    }

    public static String list(String[] values) {
        return Json.list(Misc.toList(values));
    }

    public static String list(List values) {
        return Json.list(values, false);
    }

    public static String mapKey(String key) {
        return "\"" + key + "\":";
    }

    public static String mapOpen() {
        return "{";
    }

    public static String mapClose() {
        return "}";
    }

    public static String listOpen() {
        return "[";
    }

    public static String listClose() {
        return "]";
    }

    public static String list(List values, boolean quoteValue) {
        StringBuffer row = new StringBuffer();
        row.append(Json.listOpen());
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                row.append(",\n");
            }
            if (quoteValue) {
                row.append(Json.quote(values.get(i).toString()));
                continue;
            }
            row.append(values.get(i).toString());
        }
        row.append(Json.listClose());
        return row.toString();
    }

    public static String tfoList(List<TwoFacedObject> values) {
        return Json.tfoList(values, "id", "label");
    }

    public static String tfoList(List<TwoFacedObject> values, String idKey, String labelKey) {
        ArrayList<String> arrayVals = new ArrayList<String>();
        for (TwoFacedObject tfo : values) {
            ArrayList<String> mapValues = new ArrayList<String>();
            String id = TwoFacedObject.getIdString(tfo);
            String label = tfo.toString();
            mapValues.add(idKey);
            mapValues.add(id == null ? label : id);
            mapValues.add(labelKey);
            mapValues.add(label);
            arrayVals.add(Json.map(mapValues, true));
        }
        return Json.list(arrayVals);
    }

    public static String getString(String s, boolean quote) {
        if (s == null) {
            return NULL;
        }
        if (quote) {
            return Json.quote(s);
        }
        return s;
    }

    public static String attr(String name, double value) {
        return Json.attr(name, Json.formatNumber(value), false);
    }

    public static String attr(String name, long value) {
        return Json.attr(name, "" + value, false);
    }

    public static String attr(String name, String value) {
        return Json.attr(name, value, false);
    }

    public static String attr(String name, String value, boolean quoteValue) {
        return Json.mapKey(name) + Json.getString(value, quoteValue);
    }

    public static void quoteAttr(List<String> items, String name, String value) {
        items.add(name);
        items.add(Json.getString(value, true));
    }

    public static void attr(List<String> items, String name, String value) {
        items.add(name);
        items.add(Json.getString(value, false));
    }

    public static String formatNumber(double d) {
        if (Double.isNaN(d)) {
            return NULL;
        }
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            return NULL;
        }
        return "" + d;
    }

    public static String quote(String s) {
        try {
            if (s == null) {
                return NULL;
            }
            s = Json.cleanString(s);
            s = s.replaceAll("\"", "\\\\\"");
            return "\"" + s + "\"";
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Could not quote string:" + s);
        }
    }

    public static String cleanString(String aText) {
        if (!Utils.stringDefined(aText)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aText);
        char character = iterator.current();
        char char_slash = '\\';
        char char_dquote = '\"';
        while (character != '\uffff') {
            if (character == char_dquote) {
                result.append(character);
            } else if (character == char_slash) {
                result.append(char_slash);
                result.append(char_slash);
            } else if (character == '\b') {
                result.append("\\b");
            } else if (character == '\f') {
                result.append("\\f");
            } else if (character == '\n') {
                result.append("\\n");
            } else if (character == '\r') {
                result.append("\\r");
            } else if (character == '\t') {
                result.append("\\t");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        String s = result.toString();
        s = s.replaceAll("[^\n\\x20-\\x7E]+", " ");
        return s;
    }

    public static void main(String[] args) {
        System.err.println(Json.cleanString("953731 NWT Ltd. \\x \\\" also operates as \"South Camp Enterprises\".-- provides rental vehicles"));
    }
}

