/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LayoutUtil;
import ucar.unidata.util.Misc;

public class JobManager {
    private static JobManager jobManager;
    private static Object MUTEX;
    private static Hashtable loadMap;
    private static Hashtable dialogMap;
    private static Hashtable stoppedLoads;
    private static int objectCount;

    public static JobManager getManager() {
        if (jobManager == null) {
            jobManager = new JobManager();
        }
        return jobManager;
    }

    public void setDialogLabel1(Object jobId, String msg) {
        if (jobId == null) {
            return;
        }
        DialogInfo dialogInfo = (DialogInfo)dialogMap.get(jobId);
        if (dialogInfo != null) {
            dialogInfo.label1.setText(msg);
        }
    }

    public void setDialogLabel2(Object jobId, String msg) {
        if (jobId == null) {
            return;
        }
        DialogInfo dialogInfo = (DialogInfo)dialogMap.get(jobId);
        if (dialogInfo != null) {
            dialogInfo.label2.setText(msg);
        }
    }

    public String getDialogLabel2(Object jobId) {
        if (jobId == null) {
            return null;
        }
        DialogInfo dialogInfo = (DialogInfo)dialogMap.get(jobId);
        if (dialogInfo != null) {
            return dialogInfo.label2.getText();
        }
        return null;
    }

    public Object startLoad(String name) {
        return this.startLoad(name, false);
    }

    public Object startLoad(String name, boolean showDialog) {
        return this.startLoad(name, showDialog, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object startLoad(final String name, final boolean showDialog, final boolean modal) {
        Object object = MUTEX;
        synchronized (object) {
            final Integer id = new Integer(++objectCount);
            loadMap.put(id, name);
            Misc.run(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DialogInfo dialogInfo = null;
                    Object object = MUTEX;
                    synchronized (object) {
                        if (loadMap.get(id) == null) {
                            return;
                        }
                        dialogInfo = new DialogInfo(id, name, modal);
                        if (showDialog) {
                            dialogInfo.getDialog();
                        }
                        dialogMap.put(id, dialogInfo);
                    }
                    if (showDialog) {
                        dialogInfo.showDialog();
                    }
                }
            });
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoad(String name, Object id) {
        Object object = MUTEX;
        synchronized (object) {
            loadMap.put(id, name);
            dialogMap.put(id, new DialogInfo(id, name, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canContinue(Object id) {
        if (id == null) {
            return true;
        }
        Object object = MUTEX;
        synchronized (object) {
            return loadMap.get(id) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object stopAndRestart(Object id, String name) {
        Object object = MUTEX;
        synchronized (object) {
            this.stopLoad(id);
            return this.startLoad(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLoad(Object id) {
        if (id == null) {
            return;
        }
        Object object = MUTEX;
        synchronized (object) {
            Object a = loadMap.get(id);
            if (a == null) {
                return;
            }
            loadMap.remove(id);
            DialogInfo dialogInfo = (DialogInfo)dialogMap.get(id);
            dialogMap.remove(id);
            if (dialogInfo != null && dialogInfo.dialog != null) {
                dialogInfo.dialog.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllLoads() {
        Object object = MUTEX;
        synchronized (object) {
            Enumeration keys = loadMap.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                this.stopLoad(key);
            }
        }
    }

    static {
        MUTEX = new Object();
        loadMap = new Hashtable();
        dialogMap = new Hashtable();
        stoppedLoads = new Hashtable();
        objectCount = 0;
    }

    private class DialogInfo {
        JDialog dialog;
        JLabel label1;
        JLabel label2;
        Object jobId;
        boolean modal;
        String name;

        public DialogInfo(Object id, String name, boolean modal) {
            this.jobId = id;
            this.modal = modal;
            this.name = name;
            this.label1 = new JLabel("                                   ");
            this.label2 = new JLabel("                                   ");
        }

        public void showDialog() {
            this.getDialog().setVisible(true);
        }

        public JDialog getDialog() {
            if (this.dialog == null) {
                this.dialog = GuiUtils.createDialog(null, this.name, this.modal);
                JButton cancelBtn = new JButton("Cancel");
                cancelBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        JobManager.this.stopLoad(DialogInfo.this.jobId);
                        DialogInfo.this.dialog.dispose();
                    }
                });
                JLabel waitLbl = new JLabel(new ImageIcon(GuiUtils.getImage("/ucar/unidata/idv/images/wait.gif")));
                JPanel contents = LayoutUtil.vbox(LayoutUtil.hbox(new JLabel(this.name), LayoutUtil.inset((Component)waitLbl, 5)), LayoutUtil.vbox(LayoutUtil.filler(300, 5), this.label1, this.label2), LayoutUtil.wrap(LayoutUtil.inset((Component)cancelBtn, 10)));
                this.dialog.getContentPane().add(LayoutUtil.inset((Component)contents, 5));
                this.dialog.pack();
                GuiUtils.packInCenter(this.dialog);
            }
            return this.dialog;
        }
    }
}

