/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import ucar.unidata.util.ByteString;

public final class ISO646 {
    private static final byte BB = -128;
    private static final byte CN = 64;
    private static final byte DI = 32;
    private static final byte LO = 16;
    private static final byte PU = 8;
    private static final byte SP = 4;
    private static final byte UP = 2;
    private static final byte XD = 1;
    private static final byte XDI = 33;
    private static final byte XLO = 17;
    private static final byte XUP = 3;
    private static final byte[] tab_ = new byte[]{-128, -128, -128, -128, -128, -128, -128, -128, -128, 64, 64, 64, 64, 64, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, -128, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 33, 33, 33, 33, 33, 33, 33, 33, 33, 33, 8, 8, 8, 8, 8, 8, 8, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 8, 8, 8, 8, 8, 8, 17, 17, 17, 17, 17, 17, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 8, 8, 8, 8, -128};

    public static boolean isdigit(byte ch) {
        try {
            return (tab_[ch] & 0x20) != 0;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return false;
        }
    }

    public static boolean isupper(byte ch) {
        try {
            return (tab_[ch] & 2) != 0;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return false;
        }
    }

    public static boolean islower(byte ch) {
        try {
            return (tab_[ch] & 0x10) != 0;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return false;
        }
    }

    public static boolean isalnum(byte ch) {
        try {
            return (tab_[ch] & 0x32) != 0;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return false;
        }
    }

    public static boolean isspace(byte ch) {
        try {
            return (tab_[ch] & 0x44) != 0;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return false;
        }
    }

    public static boolean isupnum(byte ch) {
        try {
            return (tab_[ch] & 0x22) != 0;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return false;
        }
    }

    public static void main(String[] args) {
        try {
            byte bb;
            int ch;
            System.out.print("isdigit: ");
            for (ch = -128; ch <= 127; ++ch) {
                bb = (byte)ch;
                if (!ISO646.isdigit(bb)) continue;
                System.out.print(ByteString.ByteToChar8859_1(bb));
            }
            System.out.println("");
            System.out.print("isupper: ");
            for (ch = -128; ch <= 127; ++ch) {
                bb = (byte)ch;
                if (!ISO646.isupper(bb)) continue;
                System.out.print(ByteString.ByteToChar8859_1(bb));
            }
            System.out.println("");
            System.out.print("islower: ");
            for (ch = -128; ch <= 127; ++ch) {
                bb = (byte)ch;
                if (!ISO646.islower(bb)) continue;
                System.out.print(ByteString.ByteToChar8859_1(bb));
            }
            System.out.println("");
            System.out.print("isupnum: ");
            for (ch = -128; ch <= 127; ++ch) {
                bb = (byte)ch;
                if (!ISO646.isupnum(bb)) continue;
                System.out.print(ByteString.ByteToChar8859_1(bb));
            }
            System.out.println("");
        }
        catch (Exception ee) {
            ee.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }
}

