/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import ucar.unidata.util.CacheManager;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.util.UserInfo;
import ucar.unidata.xml.XmlUtil;

public class IOUtil {
    private static Hashtable isHtmlCache = new Hashtable();
    public static boolean debug = false;
    private static UserAccountManager userAccountManager;
    private static Object MUTEX;

    public static boolean hasSuffix(String fileOrUrl, String suffix) {
        fileOrUrl = fileOrUrl.toLowerCase();
        if (suffix.startsWith(".")) {
            suffix = suffix.substring(1);
        }
        if (fileOrUrl.endsWith("." + suffix)) {
            return true;
        }
        return fileOrUrl.indexOf("." + suffix + "?") >= 0;
    }

    public static File getMostRecentFile(File dir) {
        return IOUtil.getMostRecentFile(dir, (FileFilter)null);
    }

    public static File getMostRecentFile(File dir, FileFilter filter) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory:" + dir);
        }
        File[] list = filter == null ? dir.listFiles() : dir.listFiles(filter);
        File latestFile = null;
        long latest = Long.MIN_VALUE;
        for (int i = 0; i < list.length; ++i) {
            long tmp = list[i].lastModified();
            if (tmp <= latest) continue;
            latestFile = list[i];
            latest = tmp;
        }
        return latestFile;
    }

    public static File[] sortFilesOnAge(File directory, FileFilter filter, boolean youngestFirst) {
        File[] files = filter == null ? directory.listFiles() : directory.listFiles(filter);
        IOUtil.sortFilesOnAge(files, youngestFirst);
        return files;
    }

    public static File[] getNormalFiles(File[] files) {
        ArrayList<File> normalFiles = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile()) continue;
            normalFiles.add(files[i]);
        }
        return IOUtil.toFiles(normalFiles);
    }

    public static File[] sortFilesOnAge(File[] files, boolean youngestFirst) {
        int i;
        Object[] fw = new FileWrapper[files.length];
        for (i = 0; i < fw.length; ++i) {
            fw[i] = new FileWrapper(files[i], youngestFirst);
        }
        Arrays.sort(fw);
        for (i = 0; i < fw.length; ++i) {
            files[i] = ((FileWrapper)fw[i]).file;
        }
        return files;
    }

    public static FileWrapper[] sortFilesOnAge(FileWrapper[] files) {
        Arrays.sort(files);
        return files;
    }

    public static List<File> deleteFiles(List<File> files) {
        ArrayList<File> notDeleted = new ArrayList<File>();
        for (File f : files) {
            if (f.delete()) continue;
            notDeleted.add(f);
        }
        return notDeleted;
    }

    public static List<File> findFilesToScour(File dir, double hours, long maxBytes) {
        ArrayList<File> results = new ArrayList<File>();
        long t1 = System.currentTimeMillis();
        List<File> allFiles = IOUtil.getFiles(dir, true);
        long t2 = System.currentTimeMillis();
        long t3 = System.currentTimeMillis();
        FileWrapper[] files = IOUtil.sortFilesOnAge(FileWrapper.toArray(allFiles, false));
        long t4 = System.currentTimeMillis();
        long now = new Date().getTime();
        long totalSize = 0L;
        long t5 = System.currentTimeMillis();
        for (int i = 0; i < files.length; ++i) {
            totalSize += files[i].length();
        }
        long t6 = System.currentTimeMillis();
        System.err.println("Scouring  found " + files.length + " in " + (t2 - t1) + "ms   sort time:" + (t4 - t3) + " size:" + (int)((double)totalSize / 1000.0) + "KB  " + (t6 - t5));
        long t7 = System.currentTimeMillis();
        for (int i = 0; i < files.length; ++i) {
            double ageHours;
            if (files[i].isDirectory()) continue;
            if (totalSize <= maxBytes) break;
            long lastModified = files[i].lastModified();
            long fileSize = files[i].length();
            if (hours > 0.0 && (ageHours = DateUtil.millisToHours(now - lastModified)) <= hours) continue;
            results.add(files[i].file);
            totalSize -= files[i].length();
        }
        long t8 = System.currentTimeMillis();
        System.err.println("Scour loop time:" + (t8 - t7) + " found " + results.size() + " files to delete");
        return results;
    }

    public static double millisToMinutes(double millis) {
        return millis / 1000.0 / 60.0;
    }

    public static File[] sortFilesOnName(File[] files) {
        return IOUtil.sortFilesOnName(files, false);
    }

    public static File[] sortFilesOnName(File[] files, boolean descending) {
        int i;
        List tuples = new ArrayList<Object[]>();
        for (i = 0; i < files.length; ++i) {
            tuples.add(new Object[]{files[i].getName().toLowerCase(), files[i]});
        }
        tuples = Misc.sortTuples(tuples, descending);
        files = new File[tuples.size()];
        for (i = 0; i < tuples.size(); ++i) {
            Object[] tuple = (Object[])tuples.get(i);
            files[i] = (File)tuple[1];
        }
        return files;
    }

    public static File[] toFiles(List files) {
        File[] fileArray = new File[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            fileArray[i] = new File(files.get(i).toString());
        }
        return fileArray;
    }

    public static FileFilter wrapFilter(final javax.swing.filechooser.FileFilter filter) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return filter == null ? true : filter.accept(f);
            }
        };
    }

    public static File getMostRecentFile(File dir, javax.swing.filechooser.FileFilter filter) {
        return IOUtil.getMostRecentFile(dir, IOUtil.wrapFilter(filter));
    }

    public static long writeTo(InputStream from, OutputStream to) throws IOException {
        return IOUtil.writeTo(from, to, null, 0L);
    }

    public static void write(OutputStream to, String s) throws Exception {
        to.write(s.getBytes());
    }

    public static String readContents(URL url) throws Exception {
        URLConnection connection = url.openConnection();
        InputStream is = connection.getInputStream();
        return IOUtil.readContents(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long writeTo(URL from, File file, Object loadId) throws IOException {
        URLConnection connection = from.openConnection();
        InputStream is = connection.getInputStream();
        int length = connection.getContentLength();
        long numBytes = -1L;
        FileOutputStream fos = new FileOutputStream(file);
        try {
            long result;
            numBytes = result = IOUtil.writeTo(is, fos, loadId, length);
        }
        finally {
            IOUtil.close(fos);
            IOUtil.close(is);
            if (numBytes <= 0L) {
                try {
                    file.delete();
                }
                catch (Exception exception) {}
            }
        }
        return numBytes;
    }

    public static long writeTo(InputStream from, OutputStream to, Object loadId, long length) throws IOException {
        int howMany;
        from = new BufferedInputStream(from, 100000);
        byte[] content = new byte[100000];
        long total = 0L;
        while ((howMany = from.read(content)) > 0) {
            total += (long)howMany;
            if (!JobManager.getManager().canContinue(loadId)) {
                return -1L;
            }
            String msg = length > 0L ? "Transferred " + total / 1000L + "/" + length / 1000L + " Kbytes " : "Transferred " + total / 1000L + " Kbytes";
            JobManager.getManager().setDialogLabel2(loadId, msg);
            to.write(content, 0, howMany);
        }
        return total;
    }

    public static List writeTo(List urls, String prefix, String suffix) throws IOException {
        return IOUtil.writeTo(urls, prefix, suffix, null);
    }

    public static List writeTo(List urls, String prefix, String suffix, Object loadId) throws IOException {
        ArrayList<String> suffixes = new ArrayList<String>();
        if (!suffix.startsWith(".")) {
            suffix = "." + suffix;
        }
        if (urls.size() == 1) {
            suffixes.add(suffix);
        } else {
            for (int i = 0; i < urls.size(); ++i) {
                suffixes.add(i + suffix);
            }
        }
        return IOUtil.writeTo(urls, prefix, suffixes, loadId);
    }

    public static List writeTo(List urls, String prefix, List suffixes, Object loadId) throws IOException {
        String msg;
        String path;
        ArrayList<String> files = new ArrayList<String>();
        int total = 0;
        ArrayList<String> exists = new ArrayList<String>();
        if (urls.size() == 1) {
            String path2 = prefix + "" + suffixes.get(0);
            if (new File(path2).exists()) {
                exists.add(path2);
            }
        } else {
            for (int i = 0; i < urls.size(); ++i) {
                path = prefix + suffixes.get(i);
                if (!new File(path).exists()) continue;
                exists.add(path);
            }
        }
        if (exists.size() > 0 && JOptionPane.showConfirmDialog(null, (msg = exists.size() == 1 ? "File: " + exists.get(0) + " exists.\n" : "The following files exists:\n" + StringUtil.join("\n", exists) + "\n") + "Do you want to overwrite?", "File exists", 0) == 1) {
            return null;
        }
        for (int i = 0; i < urls.size(); ++i) {
            InputStream from;
            path = prefix + suffixes.get(i);
            Object obj = urls.get(i);
            JobManager.getManager().setDialogLabel1(loadId, " Writing:  " + IOUtil.getFileTail(path));
            int length = 0;
            if (obj instanceof InputStream) {
                from = (InputStream)obj;
            } else {
                URL url = obj instanceof URL ? (URL)obj : IOUtil.getURL(obj.toString(), IOUtil.class);
                URLConnection connection = url.openConnection();
                try {
                    from = connection.getInputStream();
                    length = connection.getContentLength();
                }
                catch (Exception exc) {
                    String msg2 = "There was an error reading the data";
                    Map<String, List<String>> fields = connection.getHeaderFields();
                    if (connection instanceof HttpURLConnection) {
                        try {
                            msg2 = IOUtil.readContents(((HttpURLConnection)connection).getErrorStream());
                        }
                        catch (Exception exc2) {
                            System.err.println(exc2);
                        }
                    }
                    for (int fieldIdx = 0; fieldIdx < fields.size(); ++fieldIdx) {
                        System.err.println(connection.getHeaderFieldKey(fieldIdx) + "=" + connection.getHeaderField(fieldIdx));
                    }
                    LogUtil.userErrorMessage(msg2);
                    return null;
                }
            }
            files.add(path);
            FileOutputStream to = new FileOutputStream(path);
            long bytes = IOUtil.writeTo(from, to, loadId, length);
            try {
                from.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((OutputStream)to).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bytes <= 0L) {
                return null;
            }
            total = (int)((long)total + bytes);
            JobManager.getManager().setDialogLabel2(loadId, "Transferred " + total / 1000 + "K bytes");
            if (JobManager.getManager().canContinue(loadId)) continue;
            return null;
        }
        return files;
    }

    public static List<String> getListing(String path, Class c) {
        ArrayList<String> listing;
        block3: {
            block2: {
                listing = new ArrayList<String>();
                File f = new File(path);
                if (!f.exists()) break block2;
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    listing.add(files[i].toString());
                }
                break block3;
            }
            String contents = IOUtil.readContents(path, c, null);
            if (contents == null) break block3;
            List<String> lines = StringUtil.split(contents, "\n", true, true);
            for (String file : lines) {
                listing.add(IOUtil.joinDir(path, file));
            }
        }
        return listing;
    }

    public static String getFileTail(String f) {
        int idx = f.lastIndexOf("/");
        if (idx < 0) {
            idx = f.lastIndexOf(File.separator);
        }
        if (idx < 0) {
            return f;
        }
        if ((idx = (f = f.substring(idx + 1)).indexOf("?")) >= 0) {
            f = f.substring(0, idx);
        }
        return f;
    }

    public static String getFileRoot(String f) {
        int idx = f.lastIndexOf("/");
        if (idx < 0) {
            idx = f.lastIndexOf(File.separator);
        }
        if (idx < 0) {
            return ".";
        }
        return f.substring(0, idx);
    }

    public static String stripExtension(String f) {
        int idx = f.lastIndexOf(".");
        if (idx < 0) {
            return f;
        }
        return f.substring(0, idx);
    }

    public static String cleanFileName(String name) {
        return StringUtil.replaceList(name, new String[]{":", "/", "\\", "?", "&"}, new String[]{"_", "_", "_", "_", "_"});
    }

    public static String getFileExtension(String f) {
        int slashIdx;
        int idx = f.lastIndexOf(".");
        if (idx < (slashIdx = f.lastIndexOf("/"))) {
            return "";
        }
        if (idx < 0) {
            return "";
        }
        String ext = f.substring(idx).toLowerCase();
        if ((idx = ext.indexOf("?")) >= 0) {
            ext = ext.substring(0, idx);
        }
        return ext;
    }

    public static void writeFile(String filename, String contents) throws FileNotFoundException, IOException {
        IOUtil.writeFile(new File(filename), contents);
    }

    public static void writeFile(File filename, String contents) throws FileNotFoundException, IOException {
        IOUtil.writeBytes(filename, contents.getBytes());
    }

    public static void writeBytes(File filename, byte[] contents) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(filename);
        out.write(contents);
        out.flush();
        out.close();
    }

    public static void moveFile(File from, File to) throws FileNotFoundException, IOException {
        if (to.isDirectory()) {
            to = new File(IOUtil.joinDir(to, IOUtil.getFileTail(from.toString())));
        }
        if (!from.renameTo(to)) {
            throw new IllegalStateException("Could not move file:" + from + " to:" + to);
        }
    }

    public static void copyFile(File from, File to) throws FileNotFoundException, IOException {
        if (to.isDirectory()) {
            to = new File(IOUtil.joinDir(to, IOUtil.getFileTail(from.toString())));
        }
        FileInputStream fis = new FileInputStream(from);
        IOUtil.copyFile(fis, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream fis, File to) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(to);
        try {
            IOUtil.writeTo(fis, fos);
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception exception) {}
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
    }

    public static boolean isTextFile(String filename) {
        return (filename = filename.toLowerCase()).endsWith(".txt") || filename.endsWith(".text");
    }

    public static boolean isImageFile(String filename) {
        return (filename = filename.toLowerCase()).endsWith(".gif") || filename.endsWith(".jpg") || filename.endsWith(".jpeg") || filename.endsWith(".png");
    }

    public static boolean isHtmlFile(String filenameOrUrl) {
        Boolean b = (Boolean)isHtmlCache.get(filenameOrUrl);
        if (b != null) {
            return b;
        }
        boolean result = IOUtil.isHtmlFileInner(filenameOrUrl);
        isHtmlCache.put(filenameOrUrl, new Boolean(result));
        return result;
    }

    private static boolean isHtmlFileInner(String filenameOrUrl) {
        String originalUrl = filenameOrUrl;
        if (IOUtil.isHtmlSuffix(filenameOrUrl = filenameOrUrl.toLowerCase())) {
            return true;
        }
        int hashIndex = filenameOrUrl.indexOf("#");
        if (hashIndex > 0 && IOUtil.isHtmlSuffix(filenameOrUrl = filenameOrUrl.substring(0, hashIndex))) {
            return true;
        }
        if (filenameOrUrl.indexOf("?") < 0 && filenameOrUrl.startsWith("http:") && !StringUtil.stringMatch(filenameOrUrl, "http://[^\\/].*\\.\\.*")) {
            return true;
        }
        String ext = IOUtil.getFileExtension(filenameOrUrl);
        int idx = ext.indexOf("?");
        if (idx >= 0) {
            ext = ext.substring(0, idx);
        }
        if (ext.length() == 0) {
            return IOUtil.isHttpProtocol(filenameOrUrl);
        }
        if (ext.equals(".php") && IOUtil.isHttpProtocol(filenameOrUrl)) {
            try {
                URL url = new URL(originalUrl);
                URLConnection connection = url.openConnection();
                String type = connection.getContentType();
                return type.indexOf("text/html") >= 0;
            }
            catch (Exception exception) {
                return true;
            }
        }
        return ext.equals(".com") || ext.equals(".edu") || ext.equals(".org") || IOUtil.isHtmlSuffix(ext);
    }

    public static boolean isHtmlSuffix(String url) {
        return url.endsWith(".htm") || url.endsWith(".html") || url.endsWith(".shtml");
    }

    public static boolean isHttpProtocol(String url) {
        return url.startsWith("http:") || url.startsWith("https:");
    }

    public static InputStream getInputStream(String filename) throws FileNotFoundException, IOException {
        return IOUtil.getInputStream(filename, null);
    }

    public static InputStream getInputStream(String filename, Class origin) throws FileNotFoundException, IOException {
        return IOUtil.getInputStream(filename, origin, 0);
    }

    private static InputStream getInputStream(String filename, Class origin, int tries) throws FileNotFoundException, IOException {
        block7: {
            try {
                URL url = IOUtil.getURL(filename, origin);
                if (url == null) break block7;
                URLConnection connection = url.openConnection();
                connection.setReadTimeout(30000);
                connection.setAllowUserInteraction(true);
                if (connection instanceof HttpURLConnection) {
                    String auth;
                    HttpURLConnection huc = (HttpURLConnection)connection;
                    int response = huc.getResponseCode();
                    if (response == 302 || response == 301 || response == 303) {
                        String newUrl = connection.getHeaderField("Location");
                        if (tries > 10) {
                            throw new IllegalArgumentException("Too many nested URL fetches:" + filename);
                        }
                        return IOUtil.getInputStream(newUrl, origin, tries + 1);
                    }
                    if (huc.getResponseCode() == 401 && (auth = connection.getHeaderField("WWW-Authenticate")) != null && userAccountManager != null) {
                        do {
                            url = new URL(url.toString());
                            connection = url.openConnection();
                            huc = (HttpURLConnection)connection;
                            String host = url.getHost();
                            UserInfo userInfo = userAccountManager.getUserNamePassword(host + ":" + auth, "<html>The server: <i>" + host + "<i> requires a username/password</html>");
                            if (userInfo == null) break;
                            String authReturn = "Basic " + XmlUtil.encodeBase64(new String(userInfo.getUserId() + ":" + userInfo.getPassword()).getBytes());
                            huc.addRequestProperty("Authorization", authReturn);
                        } while (huc.getResponseCode() == 401);
                    }
                }
                return connection.getInputStream();
            }
            catch (Exception exc) {
                throw new IOException("Could not load resource:" + filename + " error:" + exc);
            }
        }
        throw new FileNotFoundException("Could not load resource:" + filename);
    }

    public static void setUserAccountManager(UserAccountManager manager) {
        userAccountManager = manager;
    }

    public static InputStream getInputStreamOLDWAY(String filename, Class origin) throws FileNotFoundException, IOException {
        File f;
        InputStream s = null;
        if (s == null && (f = new File(filename)).exists()) {
            try {
                s = new FileInputStream(f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (s == null) {
            try {
                String encodedUrl = StringUtil.replace(filename, " ", "%20");
                URL dataUrl = new URL(encodedUrl);
                URLConnection connection = dataUrl.openConnection();
                s = connection.getInputStream();
            }
            catch (Exception encodedUrl) {
                // empty catch block
            }
        }
        if (s == null) {
            ClassLoader cl;
            List<ClassLoader> classLoaders = Misc.getClassLoaders();
            for (int i = 0; i < classLoaders.size() && (s = (cl = classLoaders.get(i)).getResourceAsStream(filename)) == null; ++i) {
            }
        }
        if (s == null) {
            while (origin != null && (s = origin.getResourceAsStream(filename)) == null) {
                origin = origin.getSuperclass();
            }
        }
        if (s == null) {
            s = IOUtil.class.getResourceAsStream(filename);
        }
        if (s == null) {
            throw new FileNotFoundException("Unable to open:" + filename);
        }
        return s;
    }

    public static URL getURL(String filename, Class origin) throws FileNotFoundException, IOException {
        File f = new File(filename = filename.trim());
        if (f.exists()) {
            try {
                String name = f.getName();
                if (name.indexOf("%") >= 0) {
                    name = URLEncoder.encode(name, "UTF-8");
                    f = new File(IOUtil.joinDir(f.getParent(), name));
                }
                return f.toURL();
            }
            catch (Exception name) {
                // empty catch block
            }
        }
        String encodedUrl = StringUtil.replace(filename, " ", "%20");
        try {
            return new URL(encodedUrl);
        }
        catch (Exception exception) {
            List<ClassLoader> classLoaders = Misc.getClassLoaders();
            for (int i = 0; i < classLoaders.size(); ++i) {
                try {
                    ClassLoader cl = classLoaders.get(i);
                    URL url = cl.getResource(filename);
                    if (url == null) continue;
                    return url;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            while (origin != null) {
                try {
                    URL url = origin.getResource(filename);
                    if (url != null) {
                        return url;
                    }
                    origin = origin.getSuperclass();
                }
                catch (Exception url) {}
            }
            try {
                URL url = IOUtil.class.getResource(filename);
                if (url != null) {
                    return url;
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw new FileNotFoundException("Unable to open:" + filename);
        }
    }

    public static String readContents(File file) throws FileNotFoundException, IOException {
        return IOUtil.readContents(file.getPath());
    }

    public static boolean isADescendent(File parent, File child) {
        if (child == null) {
            return false;
        }
        if (parent.equals(child)) {
            return true;
        }
        File newParent = child.getParentFile();
        return IOUtil.isADescendent(parent, newParent);
    }

    public static String readContents(String contentName, String dflt) {
        return IOUtil.readContents(contentName, IOUtil.class, dflt);
    }

    public static String readContents(String contentName, Class origin, String dflt) {
        try {
            return IOUtil.readContents(contentName, origin);
        }
        catch (Exception exception) {
            return dflt;
        }
    }

    public static String readContents(String contentName) throws FileNotFoundException, IOException {
        return IOUtil.readContents(contentName, IOUtil.class);
    }

    public static boolean isRelativePath(String path) {
        if (path.startsWith("https:") || path.startsWith("ftp:") || path.startsWith("http:") || path.startsWith("/") || path.startsWith(File.separator)) {
            return false;
        }
        return !path.substring(1, 2).equals(":");
    }

    public static String readContents(String contentName, Class origin) throws FileNotFoundException, IOException {
        InputStream s = IOUtil.getInputStream(contentName, origin);
        if (s == null) {
            return null;
        }
        String results = IOUtil.readContents(s);
        try {
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    public static byte[] readBytesAndCache(String contentName, String cacheGroup) throws FileNotFoundException, IOException {
        return IOUtil.readBytesAndCache(contentName, cacheGroup, false);
    }

    public static boolean isZipFile(String file) {
        return (file = file.toLowerCase()).endsWith(".zip") || file.endsWith(".jar") || file.endsWith(".zidv");
    }

    public static byte[] readBytesAndCache(String contentName, String cacheGroup, boolean unzipIfNeeded) throws FileNotFoundException, IOException {
        byte[] bytes = null;
        if (!new File(contentName).exists() && (bytes = CacheManager.getCachedFile(cacheGroup, contentName)) != null) {
            return bytes;
        }
        bytes = IOUtil.readBytes(IOUtil.getInputStream(contentName, IOUtil.class));
        if (bytes != null) {
            if (unzipIfNeeded && contentName.endsWith(".zip")) {
                ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(bytes));
                ZipEntry ze = null;
                ze = zin.getNextEntry();
                if (ze != null) {
                    String name = ze.getName().toLowerCase();
                    bytes = IOUtil.readBytes(zin);
                }
            }
            CacheManager.putCachedFile(cacheGroup, contentName, bytes);
        }
        return bytes;
    }

    public static String readContents(InputStream is) throws IOException {
        return new String(IOUtil.readBytes(is));
    }

    public static String readInputStream(InputStream is) throws IOException {
        return new String(IOUtil.readBytes(is));
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        return IOUtil.readBytes(is, null);
    }

    public static byte[] readBytes(InputStream is, Object loadId) throws IOException {
        return IOUtil.readBytes(is, loadId, true);
    }

    public static void close(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream is, Object loadId, boolean closeIt) throws IOException {
        int totalRead = 0;
        byte[] content = IOUtil.getByteBuffer();
        try {
            while (true) {
                int howMany = is.read(content, totalRead, content.length - totalRead);
                if (loadId != null && !JobManager.getManager().canContinue(loadId)) {
                    byte[] byArray = null;
                    return byArray;
                }
                if (howMany < 0) {
                    break;
                }
                if (howMany == 0 || (totalRead += howMany) < content.length) continue;
                byte[] tmp = content;
                int newLength = content.length < 25000000 ? content.length * 2 : content.length + 5000000;
                content = new byte[newLength];
                System.arraycopy(tmp, 0, content, 0, totalRead);
            }
        }
        finally {
            try {
                if (closeIt) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        byte[] results = new byte[totalRead];
        System.arraycopy(content, 0, results, 0, totalRead);
        IOUtil.putByteBuffer(content);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putByteBuffer(byte[] bytes) {
        Object object = MUTEX;
        synchronized (object) {
            if (bytes.length < 5000000) {
                CacheManager.put(MUTEX, "bytes", bytes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getByteBuffer() {
        Object object = MUTEX;
        synchronized (object) {
            byte[] bytes = (byte[])CacheManager.get(MUTEX, "bytes");
            if (bytes == null) {
                bytes = new byte[1000000];
            } else {
                CacheManager.remove(MUTEX, "bytes");
            }
            return bytes;
        }
    }

    public static String joinDir(String f1, String f2) {
        return IOUtil.joinDirs(f1, f2);
    }

    public static String joinDir(File f1, String filename) {
        return IOUtil.joinDirs(f1.getPath(), filename);
    }

    public static String joinDirs(String ... f) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < f.length; ++i) {
            sb.append(i == 0 ? "" : File.separator).append(f[i]);
        }
        return sb.toString();
    }

    public static String makeDir(String path) {
        return IOUtil.makeDir(new File(path));
    }

    public static String makeDir(File f) {
        if (!f.exists() && !f.mkdir()) {
            System.out.println("Failed to make directory " + f.getPath());
        }
        return f.getPath();
    }

    public static final void makeDirRecursive(File f) {
        if (f == null) {
            return;
        }
        if (f.exists()) {
            return;
        }
        IOUtil.makeDirRecursive(f.getParentFile());
        f.mkdir();
    }

    public static List<File> getFiles(File dir, boolean recurse) {
        return IOUtil.getFiles(new ArrayList(), dir, recurse);
    }

    public static List<File> getFiles(List files, File dir, boolean recurse) {
        return IOUtil.getFiles(files, dir, recurse, null);
    }

    public static List<File> getFiles(List files, File dir, boolean recurse, PatternFileFilter filter) {
        if (files == null) {
            files = new ArrayList<File>();
        }
        List<File> dirs = IOUtil.getDirectories(dir, recurse);
        dirs.add(0, dir);
        for (int dirIdx = 0; dirIdx < dirs.size(); ++dirIdx) {
            File[] allFiles;
            File directory = dirs.get(dirIdx);
            File[] fileArray = allFiles = filter == null ? directory.listFiles() : directory.listFiles(filter);
            if (allFiles == null) continue;
            for (int fileIdx = 0; fileIdx < allFiles.length; ++fileIdx) {
                if (allFiles[fileIdx].isDirectory()) continue;
                files.add(allFiles[fileIdx]);
            }
        }
        return files;
    }

    public static boolean walkDirectory(File dir, FileViewer fileViewer) throws Exception {
        return IOUtil.walkDirectory(dir, fileViewer, 0);
    }

    public static boolean walkDirectory(File dir, FileViewer fileViewer, int level) throws Exception {
        File[] children = dir.listFiles();
        if (children == null) {
            return true;
        }
        children = IOUtil.sortFilesOnName(children);
        for (int i = 0; i < children.length; ++i) {
            int what = fileViewer.viewFile(children[i]);
            if (what == 3) {
                return false;
            }
            if (what != 1 || IOUtil.walkDirectory(children[i], fileViewer, level + 1)) continue;
            return false;
        }
        return true;
    }

    public static List<File> getDirectories(File dir, boolean recurse) {
        return IOUtil.getDirectories(Misc.newList(dir), recurse);
    }

    public static List<File> getDirectories(List dirs, boolean recurse) {
        ArrayList<File> results = new ArrayList<File>();
        for (int i = 0; i < dirs.size(); ++i) {
            File dir;
            if (dirs.get(i) == null || !(dir = !(dirs.get(i) instanceof File) ? new File(dirs.get(i).toString()) : (File)dirs.get(i)).exists()) continue;
            File[] subdirs = dir.listFiles();
            for (int subDirIdx = 0; subDirIdx < subdirs.length; ++subDirIdx) {
                if (!subdirs[subDirIdx].isDirectory()) continue;
                results.add(subdirs[subDirIdx]);
                if (!recurse) continue;
                results.addAll(IOUtil.getDirectories(subdirs[subDirIdx], recurse));
            }
        }
        return results;
    }

    public static void pruneIfEmpty(File root) {
        if (root == null) {
            return;
        }
        File[] files = root.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            IOUtil.pruneIfEmpty(files[i]);
        }
        if (root.listFiles().length == 0) {
            root.delete();
        }
    }

    public static void pruneEmptyDirectories(File root) {
        File[] files = root.listFiles();
        for (int i = 0; i < files.length; ++i) {
            IOUtil.pruneIfEmpty(files[i]);
        }
    }

    public static void deleteDirectory(File root) {
        if (root.exists() && root.isDirectory()) {
            File[] files = root.listFiles();
            for (int i = 0; i < files.length; ++i) {
                IOUtil.deleteDirectory(files[i]);
            }
        }
        root.delete();
    }

    public static void wait(File directory, String filePattern, double sleepSeconds) {
        Object[] newFiles;
        PatternFileFilter pattern = null;
        if (filePattern != null) {
            pattern = new PatternFileFilter(filePattern);
        }
        Object[] allFiles = pattern == null ? directory.listFiles() : directory.listFiles(pattern);
        do {
            Misc.sleep((long)(1000.0 * sleepSeconds));
        } while (Arrays.equals(allFiles, newFiles = pattern == null ? directory.listFiles() : directory.listFiles(pattern)));
    }

    public static void wait(List files, double sleepSeconds) {
        if (files == null || files.size() == 0) {
            return;
        }
        long[] times = new long[files.size()];
        for (int i = 0; i < times.length; ++i) {
            times[i] = ((File)files.get(i)).lastModified();
        }
        boolean oneChanged = false;
        block1: while (!oneChanged) {
            Misc.sleep((long)(1000.0 * sleepSeconds));
            for (int i = 0; i < times.length; ++i) {
                File theFile = (File)files.get(i);
                if (times[i] == theFile.lastModified()) continue;
                oneChanged = true;
                continue block1;
            }
        }
    }

    public static Object readSerializedObject(String file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis, 100000);
        ObjectInputStream ois = new ObjectInputStream(bis);
        Object o = ois.readObject();
        ois.close();
        bis.close();
        fis.close();
        return o;
    }

    public static void writeSerializedObject(String file, Object o) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(o);
        oos.close();
        fos.close();
    }

    public static void testio() throws Exception {
        byte[] d = new byte[4000000];
        IOUtil.writeSerializedObject("test.dat", d);
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            d = (byte[])IOUtil.readSerializedObject("test.dat");
        }
        long t2 = System.currentTimeMillis();
        System.err.println("Time:" + (t2 - t1));
    }

    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            long t1 = System.currentTimeMillis();
            String md5 = IOUtil.getMd5(arg);
            long t2 = System.currentTimeMillis();
            System.err.println(arg + " " + md5 + " time:" + (t2 - t1));
        }
    }

    public static void writeJarFile(String filename, List files) throws IOException {
        IOUtil.writeJarFile(filename, files, null);
    }

    public static void writeJarFile(String filename, List files, String pathPrefix) throws IOException {
        IOUtil.writeJarFile(filename, files, pathPrefix, false);
    }

    public static void writeJarFile(String filename, List files, String pathPrefix, boolean makeFilesUnique) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(filename));
        Hashtable<String, String> seen = new Hashtable<String, String>();
        for (int i = 0; i < files.size(); ++i) {
            String path;
            byte[] bytes;
            Object tmp = files.get(i);
            if (tmp instanceof String) {
                bytes = IOUtil.readBytes(IOUtil.getInputStream((String)tmp));
                path = IOUtil.getFileTail((String)tmp);
            } else if (tmp instanceof TwoFacedObject) {
                TwoFacedObject tfo = (TwoFacedObject)tmp;
                bytes = tfo.getId() instanceof byte[] ? (byte[])tfo.getId() : IOUtil.readBytes(IOUtil.getInputStream(tfo.getId().toString()));
                path = tfo.getLabel().toString();
            } else {
                throw new IllegalArgumentException("Unknown file:" + tmp);
            }
            if (makeFilesUnique) {
                int cnt = 0;
                while (seen.get(path) != null) {
                    path = "v" + cnt++ + "_" + path;
                }
                seen.put(path, path);
            }
            if (pathPrefix != null) {
                path = pathPrefix + "/" + path;
            }
            zos.putNextEntry(new ZipEntry(path));
            zos.write(bytes, 0, bytes.length);
        }
        zos.close();
    }

    public static byte[] createChecksum(String filename) throws Exception {
        int numRead;
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(filename), 10000);
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        ((InputStream)fis).close();
        return complete.digest();
    }

    public static String getMD5Checksum(String filename) throws Exception {
        byte[] b = IOUtil.createChecksum(filename);
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static String getMd5(String path) throws Exception {
        return IOUtil.getMD5Checksum(path);
    }

    static {
        MUTEX = new Object();
    }

    static class FileInfo {
        File f;
        long dttm;

        public FileInfo(File f) {
            this.f = f;
            this.dttm = f.lastModified();
        }

        public String toString() {
            return this.f.toString();
        }
    }

    public static interface FileViewer {
        public static final int DO_CONTINUE = 1;
        public static final int DO_DONTRECURSE = 2;
        public static final int DO_STOP = 3;

        public int viewFile(File var1) throws Exception;
    }

    public static interface UserAccountManager {
        public UserInfo getUserNamePassword(String var1, String var2);
    }

    public static class FileWrapper
    implements Comparable {
        File file;
        long modified;
        boolean youngestFirst;
        long size = -1L;

        public FileWrapper(File f, boolean youngestFirst) {
            this.file = f;
            this.youngestFirst = youngestFirst;
            this.modified = this.file.lastModified();
        }

        public String toString() {
            return "" + this.file;
        }

        public File getFile() {
            return this.file;
        }

        public long lastModified() {
            return this.modified;
        }

        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        public boolean delete() {
            return this.file.delete();
        }

        public long length() {
            if (this.size < 0L) {
                this.size = this.file.length();
            }
            return this.size;
        }

        public static FileWrapper[] toArray(File[] files, boolean youngestFirst) {
            FileWrapper[] fw = new FileWrapper[files.length];
            for (int i = 0; i < fw.length; ++i) {
                fw[i] = new FileWrapper(files[i], youngestFirst);
            }
            return fw;
        }

        public static FileWrapper[] toArray(List<File> files, boolean youngestFirst) {
            FileWrapper[] fw = new FileWrapper[files.size()];
            for (int i = 0; i < fw.length; ++i) {
                fw[i] = new FileWrapper(files.get(i), youngestFirst);
            }
            return fw;
        }

        public int compareTo(Object o) {
            FileWrapper that = (FileWrapper)o;
            if (this.modified > that.modified) {
                return this.youngestFirst ? -1 : 1;
            }
            if (this.modified < that.modified) {
                return this.youngestFirst ? 1 : -1;
            }
            return that.file.compareTo(this.file);
        }
    }
}

