/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.MultipartStream;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.WrapperException;

public class HttpServer {
    public static final int RESPONSE_OK = 200;
    public static final int RESPONSE_NOTFOUND = 404;
    public static final int RESPONSE_UNAUTHORIZED = 401;
    public static final int RESPONSE_INTERNALERROR = 500;
    public static final String TYPE_GET = "GET";
    public static final String TYPE_POST = "POST";
    private ServerSocket serverSocket;
    private int port = 8080;
    private boolean running = false;
    protected Hashtable serverProperties = new Hashtable();

    public HttpServer(int port) {
        this.port = port;
    }

    public HttpServer(String propertyFile) {
        this.serverProperties = Misc.readProperties(propertyFile, null, this.getClass());
        this.port = Misc.getProperty(this.serverProperties, "port", this.port);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public Hashtable getProperties() {
        return this.serverProperties;
    }

    public void init() {
        this.initServer();
    }

    protected void handleError(String msg, Exception exc) {
        LogUtil.logException(msg, exc);
    }

    protected void initServerSocket(ServerSocket socket) {
    }

    private void initServer() {
        try {
            this.serverSocket = new ServerSocket(this.port);
            this.initServerSocket(this.serverSocket);
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
        try {
            this.running = true;
            while (this.running) {
                Socket socket = this.serverSocket.accept();
                try {
                    RequestHandler request = this.doMakeRequestHandler(socket);
                    if (request == null) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    Misc.run(request);
                }
                catch (SocketException request) {
                }
                catch (Exception exc) {
                    this.handleError("Error reading connection", exc);
                }
            }
            this.serverSocket.close();
        }
        catch (Exception e) {
            this.handleError("Error opening connection", e);
        }
    }

    protected RequestHandler doMakeRequestHandler(Socket socket) throws Exception {
        return new RequestHandler(this, socket);
    }

    public static void xxxxmain(String[] args) {
        int port = 80;
        try {
            if (args.length > 0) {
                port = Integer.parseInt(args[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        new HttpServer(port).init();
    }

    public static class RequestHandler
    implements Runnable {
        public static final String CRLF = "\r\n";
        public static final char LF = '\n';
        Socket socket;
        InputStream input;
        OutputStream output;
        protected HttpServer server;

        public RequestHandler(HttpServer server, Socket socket) throws Exception {
            this.server = server;
            this.socket = socket;
            this.input = socket.getInputStream();
            this.output = socket.getOutputStream();
            this.input = new BufferedInputStream(this.input);
        }

        public Socket getSocket() {
            return this.socket;
        }

        public OutputStream getOutputStream() {
            return this.output;
        }

        @Override
        public void run() {
            try {
                this.processRequest();
            }
            catch (SocketException socketException) {
            }
            catch (Exception e) {
                this.server.handleError("exc:", e);
            }
            try {
                this.socket.close();
                this.output.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void log(String msg) {
            System.err.println(msg);
        }

        private String readLine() throws Exception {
            StringBuffer sb = new StringBuffer();
            int lineLength = 0;
            do {
                char c;
                if ((c = (char)this.input.read()) == '\uffffffff' || c == '\n') {
                    return sb.toString().trim();
                }
                if (!Character.isDefined(c)) {
                    return sb.toString().trim();
                }
                sb.append(c + "");
            } while (lineLength++ <= 1000);
            Misc.sleep(1000L);
            throw new IllegalArgumentException("bad line");
        }

        private void processRequest() throws Exception {
            String firstLine = null;
            Hashtable<String, String> props = new Hashtable<String, String>();
            int lineCnt = 0;
            while (true) {
                String headerLine = this.readLine();
                if (lineCnt++ > 500) {
                    Misc.sleep(1000L);
                    throw new IllegalArgumentException("bad header");
                }
                if (headerLine.equals(CRLF) || headerLine.equals("")) break;
                if (firstLine == null) {
                    firstLine = headerLine;
                    continue;
                }
                int index = headerLine.indexOf(":");
                if (index < 0) continue;
                String propName = headerLine.substring(0, index).trim();
                String propValue = headerLine.substring(index + 1).trim();
                props.put(propName, propValue);
            }
            if (firstLine == null) {
                return;
            }
            StringTokenizer s = new StringTokenizer(firstLine);
            String requestType = s.nextToken();
            Hashtable args = new Hashtable();
            String path = s.nextToken();
            String[] toks = StringUtil.split(path, "?", 2);
            if (toks != null) {
                path = toks[0];
            }
            String contentType = (String)props.get("Content-Type");
            if (requestType.equals(HttpServer.TYPE_POST) && contentType != null && contentType.trim().startsWith("multipart/form-data")) {
                this.parseMultiPartFormData(contentType, props, args);
                this.handleRequest(path, args, props, null);
                return;
            }
            String contentLength = (String)props.get("Content-Length");
            String contentString = null;
            byte[] content = null;
            if (contentLength != null) {
                int totalRead;
                int howMany;
                content = new byte[100000];
                int len = new Integer(contentLength);
                byte[] buffer = new byte[100000];
                for (totalRead = 0; totalRead < len && (howMany = this.input.read(buffer, 0, buffer.length)) >= 0; totalRead += howMany) {
                    if (totalRead + howMany > content.length) {
                        byte[] tmp = content;
                        content = new byte[content.length + 100000];
                        System.arraycopy(tmp, 0, content, 0, totalRead);
                    }
                    System.arraycopy(buffer, 0, content, totalRead, howMany);
                }
                byte[] tmp = content;
                content = new byte[totalRead];
                System.arraycopy(tmp, 0, content, 0, totalRead);
            }
            if (content != null) {
                contentString = new String(content, 0, content.length);
            }
            if (requestType.equals(HttpServer.TYPE_GET)) {
                if (toks != null && toks.length > 1) {
                    this.parseArgs(toks[1], args);
                }
            } else if (requestType.equals(HttpServer.TYPE_POST)) {
                if (this.okToParseContent(path, contentString, args)) {
                    this.parseArgs(contentString, args);
                }
            } else {
                throw new IllegalArgumentException("unknown type: " + requestType);
            }
            this.handleRequest(path, args, props, contentString);
        }

        private void parseMultiPartFormData(String type, Hashtable props, Hashtable args) {
            String boundary = null;
            List<String> toks = StringUtil.split(type, ";", true, true);
            for (String tok : toks) {
                List<String> subToks;
                if (tok.indexOf("=") <= 0 || (subToks = StringUtil.split(tok, "=", true, true)).size() != 2) continue;
                String name = subToks.get(0).trim();
                String value = subToks.get(1).trim();
                if (!name.equals("boundary")) continue;
                boundary = value;
            }
            if (boundary == null) {
                throw new IllegalArgumentException("Could not find multipart boundary in:" + type);
            }
            try {
                MultipartStream multipartStream = new MultipartStream(this.input, boundary.getBytes(), 1000000);
                boolean nextPart = multipartStream.skipPreamble();
                boolean cnt = true;
                Pattern namePattern = Pattern.compile("[\\s;:]+name\\s*=\\s*\"([^\"]+)\"");
                Pattern filenamePattern = Pattern.compile("[\\s;:]+filename\\s*=\\s*\"([^\"]+)\"");
                while (nextPart) {
                    String header = multipartStream.readHeaders();
                    List<String> lineToks = StringUtil.split(header, "\n", true, true);
                    String attrName = null;
                    String filename = null;
                    for (int i = 0; i < lineToks.size(); ++i) {
                        String line = lineToks.get(i);
                        int index = line.indexOf(":");
                        if (index < 0) continue;
                        String propName = line.substring(0, index).trim();
                        String propValue = line.substring(index + 1).trim();
                        if (propName.equals("Content-Disposition")) {
                            Matcher nameMatcher = namePattern.matcher(propValue);
                            Matcher filenameMatcher = filenamePattern.matcher(propValue);
                            if (nameMatcher.find()) {
                                attrName = nameMatcher.group(1);
                            }
                            if (filenameMatcher.find()) {
                                filename = filenameMatcher.group(1);
                            }
                        }
                        if (attrName != null) continue;
                        throw new IllegalArgumentException("Could not find name attribute in multipart");
                    }
                    if (filename != null) {
                        this.handleFileUpload(attrName, filename, props, args, multipartStream);
                    } else {
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        multipartStream.readBodyData((OutputStream)output);
                        String value = new String(output.toByteArray());
                        this.addArg(args, attrName, value);
                    }
                    if (multipartStream.readBoundary()) continue;
                    break;
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }

        protected void addArg(Hashtable args, String name, String value) {
            Object obj = args.get(name);
            if (obj != null) {
                if (obj instanceof List) {
                    ((List)obj).add(value);
                    return;
                }
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(obj);
                l.add(value);
                args.put(name, l);
                return;
            }
            args.put(name, value);
        }

        protected void handleFileUpload(String attrName, String filename, Hashtable props, Hashtable args, MultipartStream multipartStream) throws Exception {
            throw new IllegalArgumentException("handleFileUpload not implemented");
        }

        protected boolean okToParseContent(String path, String contentString, Hashtable httpArgs) {
            return true;
        }

        protected void parseArgs(String args, Hashtable ht) {
            if (args == null) {
                return;
            }
            List<String> argToks = StringUtil.split(args, "&", true, true);
            for (int i = 0; i < argToks.size(); ++i) {
                String tok = argToks.get(i).toString();
                String[] toks = StringUtil.split(tok, "=", 2);
                if (toks == null || toks.length < 1) continue;
                this.addArg(ht, this.decode(toks[0]), this.decode(toks[1]));
            }
        }

        protected void handleRequest(String path, Hashtable formArgs, Hashtable httpArgs, String content) throws Exception {
            StringBuffer sb = new StringBuffer("<html>");
            Enumeration keys = formArgs.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                sb.append(key + "=" + formArgs.get(key) + "<p>\n");
            }
            sb.append("</html>");
            this.writeResult(true, sb.toString(), "text/html");
        }

        private String decode(String s) {
            try {
                return URLDecoder.decode(s, "UTF-8");
            }
            catch (Exception exc) {
                System.err.println("err:" + exc);
                return s;
            }
        }

        protected void writeLine(String line) throws Exception {
            this.output.write(line.getBytes());
        }

        public void writeResult(boolean ok, String content, String type) throws Exception {
            this.writeResult(ok ? 200 : 404, content, type);
        }

        public void writeResult(int code, String content, String type) throws Exception {
            this.writeResult(code, content.getBytes(), type);
        }

        public void writeResult(boolean ok, StringBuffer content, String type) throws Exception {
            this.writeResult(ok ? 200 : 404, content.toString().getBytes(), type);
        }

        public void writeResult(int code, StringBuffer content, String type) throws Exception {
            this.writeResult(code, content.toString().getBytes(), type);
        }

        public void writeXml(StringBuffer content) throws Exception {
            this.writeResult(200, content.toString().getBytes(), "text/xml");
        }

        public void writeHtml(StringBuffer content) throws Exception {
            this.writeResult(200, content.toString().getBytes(), "text/html");
        }

        public void writeResult(boolean ok, byte[] content, String type) throws Exception {
            this.writeResult(ok ? 200 : 404, content, type);
        }

        public void writeResult(int code, byte[] content, String type) throws Exception {
            try {
                this.writeHeader(code, content.length, type);
                this.output.write(content);
                this.output.close();
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }

        public void writeResult(int code, InputStream inputStream, String type) throws Exception {
            this.writeHeader(code, -1L, type);
            IOUtil.writeTo(inputStream, this.output);
            this.output.close();
        }

        protected void writeHeader(int code, long length, String type) throws Exception {
            if (code == 200) {
                this.writeLine("HTTP/1.0 " + code + "  OK" + CRLF);
            } else {
                this.writeLine("HTTP/1.0 " + code + CRLF);
            }
            if (length >= 0L) {
                // empty if block
            }
            this.writeLine("Content-type: " + type + CRLF);
            this.writeHeaderArgs();
            this.writeLine("\n");
        }

        public void redirect(String url) throws Exception {
            this.writeLine("HTTP/1.0 300 OK\r\n");
            this.writeLine("Location: " + url + CRLF);
            this.writeLine("Cache-Control: no-cache\r\n");
            this.writeHeaderArgs();
            this.writeLine("\n");
            this.output.close();
        }

        protected void writeHeaderArgs() throws Exception {
        }

        protected void writeBytes(InputStream fis, String type, long length) throws Exception {
            this.writeHeader(200, length, type);
            byte[] buffer = new byte[1024];
            int bytes = 0;
            while ((bytes = fis.read(buffer)) != -1) {
                this.output.write(buffer, 0, bytes);
            }
        }

        private static String contentType(String fileName) {
            if (fileName.endsWith(".htm") || fileName.endsWith(".html")) {
                return "text/html";
            }
            return "";
        }
    }
}

