/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.Color;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;

public class HtmlUtil {
    public static final String HTTP_USER_AGENT = "User-Agent";
    public static final String HTTP_CONTENT_LENGTH = "Content-Length";
    public static final String HTTP_CONTENT_DESCRIPTION = "Content-Description";
    public static final String HTTP_WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String HTTP_SET_COOKIE = "Set-Cookie";
    public static final String SIZE_3 = "  size=\"3\" ";
    public static final String SIZE_4 = "  size=\"4\" ";
    public static final String SIZE_5 = "  size=\"5\" ";
    public static final String SIZE_6 = "  size=\"6\" ";
    public static final String SIZE_7 = "  size=\"7\" ";
    public static final String SIZE_8 = "  size=\"8\" ";
    public static final String SIZE_9 = "  size=\"9\" ";
    public static final String SIZE_10 = "  size=\"10\" ";
    public static final String SIZE_20 = "  size=\"20\" ";
    public static final String SIZE_15 = "  size=\"15\" ";
    public static final String SIZE_25 = "  size=\"25\" ";
    public static final String SIZE_30 = "  size=\"30\" ";
    public static final String SIZE_40 = "  size=\"40\" ";
    public static final String SIZE_50 = "  size=\"50\" ";
    public static final String SIZE_60 = "  size=\"60\" ";
    public static final String SIZE_70 = "  size=\"70\" ";
    public static final String SIZE_80 = "  size=\"80\" ";
    public static final String SIZE_90 = "  size=\"90\" ";
    public static final String ENTITY_NBSP = "&nbsp;";
    public static final String ENTITY_GT = "&gt;";
    public static final String ENTITY_LT = "&lt;";
    public static final String TAG_A = "a";
    public static final String TAG_B = "b";
    public static final String TAG_BR = "br";
    public static final String TAG_CENTER = "center";
    public static final String TAG_DIV = "div";
    public static final String TAG_FORM = "form";
    public static final String TAG_HR = "hr";
    public static final String TAG_H1 = "h1";
    public static final String TAG_H2 = "h2";
    public static final String TAG_H3 = "h3";
    public static final String TAG_I = "i";
    public static final String TAG_IMG = "img";
    public static final String TAG_INPUT = "input";
    public static final String TAG_IFRAME = "iframe";
    public static final String TAG_LI = "li";
    public static final String TAG_LINK = "link";
    public static final String TAG_NOBR = "nobr";
    public static final String TAG_OPTION = "option";
    public static final String TAG_P = "p";
    public static final String TAG_PRE = "pre";
    public static final String TAG_SCRIPT = "script";
    public static final String TAG_SPAN = "span";
    public static final String TAG_SELECT = "select";
    public static final String TAG_TABLE = "table";
    public static final String TAG_TD = "td";
    public static final String TAG_TR = "tr";
    public static final String TAG_TEXTAREA = "textarea";
    public static final String TAG_UL = "ul";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_ALIGN = "align";
    public static final String ATTR_ALT = "alt";
    public static final String ATTR_BORDER = "border";
    public static final String ATTR_BGCOLOR = "bgcolor";
    public static final String ATTR_CELLSPACING = "cellspacing";
    public static final String ATTR_CELLPADDING = "cellpadding";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_COLS = "cols";
    public static final String ATTR_COLSPAN = "colspan";
    public static final String ATTR_ENCTYPE = "enctype";
    public static final String ATTR_HREF = "href";
    public static final String ATTR_HEIGHT = "height";
    public static final String ATTR_ID = "id";
    public static final String ATTR_METHOD = "method";
    public static final String ATTR_MULTIPLE = "multiple";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ONMOUSEMOVE = "onmousemove";
    public static final String ATTR_ONMOUSEOVER = "onmouseover";
    public static final String ATTR_ONMOUSEUP = "onmouseup";
    public static final String ATTR_ONMOUSEOUT = "onmouseout";
    public static final String ATTR_ONMOUSEDOWN = "onmousedown";
    public static final String ATTR_ONCLICK = "onClick";
    public static final String ATTR_READONLY = "READONLY";
    public static final String ATTR_REL = "rel";
    public static final String ATTR_ROWS = "rows";
    public static final String ATTR_SELECTED = "selected";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_SRC = "src";
    public static final String ATTR_STYLE = "style";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_TARGET = "target";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_VALIGN = "valign";
    public static final String ATTR_WIDTH = "width";
    public static final String CLASS_BLOCK = "block";
    public static final String CLASS_CHECKBOX = "checkbox";
    public static final String CLASS_DISABLEDINPUT = "disabledinput";
    public static final String CLASS_ERRORLABEL = "errorlabel";
    public static final String CLASS_FILEINPUT = "fileinput";
    public static final String CLASS_FORMLABEL = "formlabel";
    public static final String CLASS_FORMLABEL_TOP = "formlabeltop";
    public static final String CLASS_HIDDENINPUT = "hiddeninput";
    public static final String CLASS_INPUT = "input";
    public static final String CLASS_PASSWORD = "password";
    public static final String CLASS_RADIO = "radio";
    public static final String CLASS_SELECT = "select";
    public static final String CLASS_SUBMIT = "submit";
    public static final String CLASS_SUBMITIMAGE = "submitimage";
    public static final String CLASS_TAB_CONTENT = "tab_content";
    public static final String CLASS_TAB_CONTENTS = "tab_contents";
    public static final String CLASS_TEXTAREA = "textarea";
    public static final String TYPE_FILE = "file";
    public static final String TYPE_PASSWORD = "password";
    public static final String TYPE_SUBMIT = "submit";
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_RADIO = "radio";
    public static final String TYPE_INPUT = "input";
    public static final String TYPE_TEXTAREA = "textarea";
    public static final String TYPE_CHECKBOX = "checkbox";
    public static final String TYPE_HIDDEN = "hidden";
    public static final String VALUE_BOTTOM = "bottom";
    public static final String VALUE_CENTER = "center";
    public static final String VALUE_FALSE = "false";
    public static final String VALUE_LEFT = "left";
    public static final String VALUE_MULTIPART = "multipart/form-data";
    public static final String VALUE_POST = "post";
    public static final String VALUE_RIGHT = "right";
    public static final String VALUE_SELECTED = "selected";
    public static final String VALUE_TOP = "top";
    public static final String VALUE_TRUE = "true";
    static int tabCnt = 0;
    private static String blockHideImageUrl;
    private static String blockShowImageUrl;
    private static String inlineHideImageUrl;
    private static String inlineShowImageUrl;
    public static int blockCnt;

    public static String open(String comp) {
        return "<" + comp + ">";
    }

    public static String comma(String s1, String s2) {
        return HtmlUtil.comma(new String[]{s1, s2});
    }

    public static String comma(String s1, String s2, String s3) {
        return HtmlUtil.comma(new String[]{s1, s2, s3});
    }

    public static String comma(String s1, String s2, String s3, String s4) {
        return HtmlUtil.comma(new String[]{s1, s2, s3, s4});
    }

    public static String comma(String s1, String s2, String s3, String s4, String s5) {
        return HtmlUtil.comma(new String[]{s1, s2, s3, s4, s5});
    }

    public static String comma(String[] s) {
        return StringUtil.join(",", s);
    }

    public static String open(String comp, String attrs) {
        return "<" + comp + attrs + ">";
    }

    public static String close(String comp) {
        return "</" + comp + ">";
    }

    public static String tag(String comp) {
        return "<" + comp + "/>";
    }

    public static String tag(String comp, String attrs) {
        return "<" + comp + attrs + "/>";
    }

    public static String tag(String tag, String attrs, String inner) {
        return HtmlUtil.open(tag, attrs) + inner + HtmlUtil.close(tag);
    }

    public static String hidden(String name, Object value) {
        return HtmlUtil.hidden(name, value, "");
    }

    public static String hidden(String name, Object value, String extra) {
        return HtmlUtil.tag("input", extra + HtmlUtil.attrs(ATTR_TYPE, TYPE_HIDDEN, ATTR_NAME, name, ATTR_VALUE, "" + value, ATTR_CLASS, CLASS_HIDDENINPUT));
    }

    public static String hbox(String s1, String s2) {
        return HtmlUtil.tag(TAG_TABLE, HtmlUtil.attrs(ATTR_CELLSPACING, "0", ATTR_CELLPADDING, "0"), HtmlUtil.rowTop(HtmlUtil.cols(s1, s2)));
    }

    public static String br() {
        return HtmlUtil.open(TAG_BR);
    }

    public static String br(String line) {
        return line + HtmlUtil.open(TAG_BR);
    }

    public static String hr() {
        return HtmlUtil.open(TAG_HR);
    }

    public static String p() {
        return HtmlUtil.open(TAG_P);
    }

    public static String nobr(String inner) {
        return HtmlUtil.tag(TAG_NOBR, "", inner);
    }

    public static String b(String inner) {
        return HtmlUtil.tag(TAG_B, "", inner);
    }

    public static String italics(String inner) {
        return HtmlUtil.tag(TAG_I, "", inner);
    }

    public static String li(String inner, String extra) {
        return HtmlUtil.tag(TAG_LI, extra, inner);
    }

    public static String center(String inner) {
        return HtmlUtil.tag("center", "", inner);
    }

    public static String pad(String s) {
        return HtmlUtil.space(1) + s + HtmlUtil.space(1);
    }

    public static String padLeft(String s) {
        return HtmlUtil.space(1) + s;
    }

    public static String padRight(String s) {
        return s + HtmlUtil.space(1);
    }

    public static String space(int cnt) {
        if (cnt == 1) {
            return " ";
        }
        String s = "";
        while (cnt-- > 0) {
            s = s + ENTITY_NBSP;
        }
        return s;
    }

    public static String quote(String s) {
        return "\"" + s + "\"";
    }

    public static String squote(String s) {
        return "'" + s + "'";
    }

    public static String img(String path) {
        return HtmlUtil.img(path, "");
    }

    public static String img(String path, String title) {
        return HtmlUtil.img(path, title, "");
    }

    public static String img(String path, String title, String extra) {
        if (title.length() > 0) {
            return HtmlUtil.tag(TAG_IMG, HtmlUtil.attrs(ATTR_BORDER, "0", ATTR_SRC, path, ATTR_TITLE, title, ATTR_ALT, title) + " " + extra);
        }
        return HtmlUtil.tag(TAG_IMG, HtmlUtil.attrs(ATTR_BORDER, "0", ATTR_SRC, path) + " " + extra);
    }

    public static String cssClass(String c) {
        return HtmlUtil.attr(ATTR_CLASS, c);
    }

    public static String title(String c) {
        return HtmlUtil.attr(ATTR_TITLE, c);
    }

    public static String id(String c) {
        return HtmlUtil.attr(ATTR_ID, c);
    }

    public static String style(String c) {
        return HtmlUtil.attr(ATTR_STYLE, c);
    }

    public static String bold(String v1) {
        return HtmlUtil.tag(TAG_B, "", v1);
    }

    public static String col(String v1) {
        return HtmlUtil.col(v1, "");
    }

    public static String col(String v1, String attr) {
        return HtmlUtil.tag(TAG_TD, " " + attr + " ", v1);
    }

    public static String colRight(String v1) {
        return HtmlUtil.tag(TAG_TD, " " + HtmlUtil.attr(ATTR_ALIGN, VALUE_RIGHT) + " ", v1);
    }

    public static String span(String content, String extra) {
        return HtmlUtil.tag(TAG_SPAN, extra, content);
    }

    public static String div(String content, String extra) {
        return HtmlUtil.tag(TAG_DIV, extra, content);
    }

    public static String h1(String content) {
        return HtmlUtil.tag(TAG_H1, "", content);
    }

    public static String h2(String content) {
        return HtmlUtil.tag(TAG_H2, "", content);
    }

    public static String h3(String content) {
        return HtmlUtil.tag(TAG_H3, "", content);
    }

    public static String ul() {
        return HtmlUtil.open(TAG_UL, "");
    }

    public static String p(String content) {
        return HtmlUtil.tag(TAG_P, "", content);
    }

    public static String pre(String content) {
        return HtmlUtil.tag(TAG_PRE, "", content);
    }

    public static String url(String path, String n1, Object v1) {
        return HtmlUtil.url(path, new String[]{n1, v1.toString()});
    }

    public static String url(String path, String n1, Object v1, String n2, Object v2) {
        return HtmlUtil.url(path, new String[]{n1, v1.toString(), n2, v2.toString()});
    }

    public static String url(String path, String n1, Object v1, String n2, Object v2, String n3, Object v3) {
        return HtmlUtil.url(path, new String[]{n1, v1.toString(), n2, v2.toString(), n3, v3.toString()});
    }

    public static String url(String path, String n1, Object v1, String n2, Object v2, String n3, Object v3, String n4, Object v4) {
        return HtmlUtil.url(path, new String[]{n1, v1.toString(), n2, v2.toString(), n3, v3.toString(), n4, v4.toString()});
    }

    public static String url(String path, List args) {
        return HtmlUtil.url(path, Misc.listToStringArray(args));
    }

    public static String url(String path, String[] args) {
        return HtmlUtil.url(path, args, true);
    }

    public static String url(String path, String[] args, boolean encodeArgs) {
        if (args.length == 0) {
            return path.toString();
        }
        boolean addAmpersand = false;
        String url = path.toString();
        if (url.indexOf("?") >= 0) {
            if (!url.endsWith("?")) {
                addAmpersand = true;
            }
        } else {
            url = url + "?";
        }
        for (int i = 0; i < args.length; i += 2) {
            if (addAmpersand) {
                url = url + "&";
            }
            try {
                url = url + HtmlUtil.arg(args[i], args[i + 1], encodeArgs);
            }
            catch (Exception exc) {
                System.err.println("error encoding arg(1):" + args[i + 1] + " " + exc);
                exc.printStackTrace();
            }
            addAmpersand = true;
        }
        return url;
    }

    public static String args(String[] args) {
        ArrayList<String> a = new ArrayList<String>();
        for (int i = 0; i < args.length; i += 2) {
            a.add(HtmlUtil.arg(args[i], args[i + 1]));
        }
        return StringUtil.join("&", a);
    }

    public static String args(Hashtable args) {
        ArrayList<String> a = new ArrayList<String>();
        Enumeration keys = args.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = args.get(key);
            if (value instanceof List) {
                for (Object v : (List)value) {
                    a.add(HtmlUtil.arg(key.toString(), v.toString()));
                }
                continue;
            }
            a.add(HtmlUtil.arg(key.toString(), value.toString()));
        }
        return StringUtil.join("&", a);
    }

    public static String arg(String name, String value) {
        return HtmlUtil.arg(name, value, true);
    }

    public static String arg(String name, String value, boolean encodeArg) {
        try {
            return name + "=" + (encodeArg ? URLEncoder.encode(value, "UTF-8") : value);
        }
        catch (Exception exc) {
            System.err.println("error encoding arg(2):" + value + " " + exc);
            exc.printStackTrace();
            return "";
        }
    }

    public static String row(String row) {
        return HtmlUtil.tag(TAG_TR, "", row);
    }

    public static String row(String row, String extra) {
        return HtmlUtil.tag(TAG_TR, extra, row);
    }

    public static String rowTop(String row) {
        return HtmlUtil.tag(TAG_TR, HtmlUtil.attr(ATTR_VALIGN, VALUE_TOP), row);
    }

    public static String rowBottom(String row) {
        return HtmlUtil.tag(TAG_TR, HtmlUtil.attr(ATTR_VALIGN, VALUE_BOTTOM), row);
    }

    public static String cols(String s1) {
        return HtmlUtil.tag(TAG_TD, "", s1);
    }

    public static String cols(String s1, String s2) {
        return HtmlUtil.cols(s1) + HtmlUtil.cols(s2);
    }

    public static String cols(String s1, String s2, String s3) {
        return HtmlUtil.cols(s1) + HtmlUtil.cols(s2) + HtmlUtil.cols(s3);
    }

    public static String cols(String s1, String s2, String s3, String s4) {
        return HtmlUtil.cols(s1) + HtmlUtil.cols(s2) + HtmlUtil.cols(s3) + HtmlUtil.cols(s4);
    }

    public static String cols(String s1, String s2, String s3, String s4, String s5) {
        return HtmlUtil.cols(s1) + HtmlUtil.cols(s2) + HtmlUtil.cols(s3) + HtmlUtil.cols(s4) + HtmlUtil.cols(s5);
    }

    public static String cols(String s1, String s2, String s3, String s4, String s5, String s6) {
        return HtmlUtil.cols(s1) + HtmlUtil.cols(s2) + HtmlUtil.cols(s3) + HtmlUtil.cols(s4) + HtmlUtil.cols(s5) + HtmlUtil.cols(s6);
    }

    public static String headerCols(Object[] columns) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < columns.length; ++i) {
            sb.append(HtmlUtil.cols(HtmlUtil.b(columns[i].toString())));
        }
        return sb.toString();
    }

    public static String cols(Object[] columns) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < columns.length; ++i) {
            sb.append(HtmlUtil.cols(columns[i].toString()));
        }
        return sb.toString();
    }

    public static String makeLatLonInput(String arg, String value) {
        return HtmlUtil.makeLatLonInput(arg, value, null);
    }

    public static String makeLatLonInput(String arg, String value, String tip) {
        return HtmlUtil.input(arg, (Object)value, HtmlUtil.attrs(ATTR_SIZE, "5") + HtmlUtil.id(arg) + (tip != null ? HtmlUtil.title(tip) : ""));
    }

    public static String makeLatLonBox(String baseName, String southValue, String northValue, String eastValue, String westValue) {
        return HtmlUtil.makeLatLonBox(baseName + "_south", baseName + "_north", baseName + "_east", baseName + "_west", southValue, northValue, eastValue, westValue);
    }

    public static String makeLatLonBox(String southArg, String northArg, String eastArg, String westArg, String southValue, String northValue, String eastValue, String westValue) {
        return "<table cellspacing=0 cellpadding=1><tr><td colspan=\"2\" align=\"center\">" + HtmlUtil.makeLatLonInput(northArg, northValue, "North") + "</td></tr>" + "<tr><td>" + HtmlUtil.makeLatLonInput(westArg, westValue, "West") + "</td><td>" + HtmlUtil.makeLatLonInput(eastArg, eastValue, "East") + "</tr>" + "<tr><td colspan=\"2\" align=\"center\">" + HtmlUtil.makeLatLonInput(southArg, southValue, "South") + "</table>";
    }

    public static String makeLatLonBox(String baseName, double south, double north, double east, double west) {
        return HtmlUtil.makeLatLonBox(baseName, HtmlUtil.toString(south), HtmlUtil.toString(north), HtmlUtil.toString(east), HtmlUtil.toString(west));
    }

    private static String toString(double v) {
        if (v == v) {
            return "" + v;
        }
        return "";
    }

    public static String makeAreaLabel(double south, double north, double east, double west) {
        return HtmlUtil.table("<tr><td colspan=\"2\" align=\"center\">" + HtmlUtil.toString(north) + "</td></tr>" + "<tr><td>" + HtmlUtil.toString(west) + "</td><td>" + HtmlUtil.toString(east) + "</tr>" + "<tr><td colspan=\"2\" align=\"center\">" + HtmlUtil.toString(south));
    }

    public static String checkbox(String name) {
        return HtmlUtil.checkbox(name, VALUE_TRUE, false);
    }

    public static String checkbox(String name, String value) {
        return HtmlUtil.checkbox(name, value, false);
    }

    public static String radio(String name, String value, boolean checked) {
        return HtmlUtil.tag("input", HtmlUtil.attrs(ATTR_CLASS, "radio", ATTR_TYPE, "radio", ATTR_NAME, name, ATTR_VALUE, value) + (checked ? " checked " : ""));
    }

    public static String checkbox(String name, String value, boolean checked) {
        return HtmlUtil.checkbox(name, value, checked, "");
    }

    public static String checkbox(String name, String value, boolean checked, String extra) {
        return HtmlUtil.tag("input", extra + HtmlUtil.attrs(ATTR_CLASS, "checkbox", ATTR_TYPE, "checkbox", ATTR_NAME, name, ATTR_VALUE, value) + (checked ? " checked " : ""));
    }

    public static String form(String url) {
        return HtmlUtil.form(url, "");
    }

    public static String form(String url, String extra) {
        return HtmlUtil.open(TAG_FORM, HtmlUtil.attr(ATTR_ACTION, url) + " " + extra);
    }

    public static String formPost(String url) {
        return HtmlUtil.open(TAG_FORM, HtmlUtil.attrs(ATTR_METHOD, VALUE_POST, ATTR_ACTION, url));
    }

    public static String formPost(String url, String extra) {
        return HtmlUtil.open(TAG_FORM, HtmlUtil.attrs(ATTR_METHOD, VALUE_POST, ATTR_ACTION, url) + " " + extra);
    }

    public static String uploadForm(String url, String extra) {
        return HtmlUtil.open(TAG_FORM, " accept-charset=\"UTF-8\" " + HtmlUtil.attrs(ATTR_METHOD, VALUE_POST, ATTR_ACTION, url, ATTR_ENCTYPE, VALUE_MULTIPART) + " " + extra);
    }

    public static String href(String url, String label) {
        return HtmlUtil.tag(TAG_A, HtmlUtil.attrs(ATTR_HREF, url), label);
    }

    public static String href(String url, String label, String extra) {
        return HtmlUtil.tag(TAG_A, HtmlUtil.attrs(ATTR_HREF, url) + " " + extra, label);
    }

    public static String submitImage(String img, String name) {
        return HtmlUtil.tag("input", HtmlUtil.attrs(ATTR_CLASS, CLASS_SUBMITIMAGE, ATTR_NAME, name, ATTR_VALUE, name) + HtmlUtil.attrs(ATTR_BORDER, "0", ATTR_SRC, img, ATTR_TYPE, TYPE_IMAGE));
    }

    public static String submitImage(String img, String name, String alt) {
        return HtmlUtil.tag("input", HtmlUtil.attrs(ATTR_NAME, name, ATTR_BORDER, "0", ATTR_SRC, img, ATTR_VALUE, name) + HtmlUtil.attrs(ATTR_CLASS, CLASS_SUBMITIMAGE, ATTR_TITLE, alt, ATTR_ALT, alt, ATTR_TYPE, TYPE_IMAGE));
    }

    public static String submit(String label, String name) {
        return HtmlUtil.tag("input", HtmlUtil.attrs(ATTR_NAME, name, ATTR_TYPE, "submit", ATTR_VALUE, label, ATTR_CLASS, "submit"));
    }

    public static String submit(String label) {
        return HtmlUtil.tag("input", HtmlUtil.attrs(ATTR_CLASS, "submit", ATTR_TYPE, "submit", ATTR_VALUE, label));
    }

    public static String textArea(String name, String value, int rows, int columns) {
        return HtmlUtil.textArea(name, value, rows, columns, "");
    }

    public static String textArea(String name, String value, int rows, int columns, String extra) {
        return HtmlUtil.tag("textarea", HtmlUtil.attrs(ATTR_NAME, name, ATTR_CLASS, "textarea") + HtmlUtil.attrs(ATTR_ROWS, "" + rows, ATTR_COLS, "" + columns) + extra, value);
    }

    public static String password(String name) {
        return HtmlUtil.tag("input", HtmlUtil.attrs(ATTR_CLASS, "password", ATTR_TYPE, "password", ATTR_NAME, name));
    }

    public static String password(String name, String value, String extra) {
        return HtmlUtil.tag("input", extra + HtmlUtil.attrs(ATTR_VALUE, value, ATTR_CLASS, "password", ATTR_TYPE, "password", ATTR_NAME, name));
    }

    public static String input(String name) {
        return HtmlUtil.input(name, null, "");
    }

    public static String input(String name, Object value) {
        return HtmlUtil.input(name, value, "");
    }

    public static String input(String name, Object value, int size) {
        return HtmlUtil.input(name, value, HtmlUtil.attrs(ATTR_SIZE, "" + size));
    }

    public static String input(String name, Object value, String extra) {
        if (extra == null || extra.length() == 0) {
            return HtmlUtil.tag("input", HtmlUtil.attrs(ATTR_CLASS, "input", ATTR_NAME, name, ATTR_VALUE, value == null ? "" : value.toString()) + " " + extra);
        }
        if (extra.indexOf("class=") >= 0) {
            return HtmlUtil.tag("input", HtmlUtil.attrs(ATTR_NAME, name, ATTR_VALUE, value == null ? "" : value.toString()) + " " + extra);
        }
        return HtmlUtil.tag("input", HtmlUtil.attrs(ATTR_NAME, name, ATTR_CLASS, "input", ATTR_VALUE, value == null ? "" : value.toString()) + " " + extra);
    }

    public static String disabledInput(String name, Object value, String extra) {
        String classAttr = "";
        if (extra.indexOf("class=") < 0) {
            classAttr = HtmlUtil.cssClass(CLASS_DISABLEDINPUT);
        }
        return HtmlUtil.tag("input", " READONLY " + HtmlUtil.attrs(ATTR_NAME, name, ATTR_VALUE, value == null ? "" : value.toString()) + " " + extra + classAttr);
    }

    public static String fileInput(String name, String extra) {
        return HtmlUtil.tag("input", HtmlUtil.attrs(ATTR_CLASS, CLASS_FILEINPUT, ATTR_TYPE, TYPE_FILE, ATTR_NAME, name) + " " + extra);
    }

    public static String select(String name, List values) {
        return HtmlUtil.select(name, values, null);
    }

    public static String select(String name, List values, String selected) {
        return HtmlUtil.select(name, values, selected, Integer.MAX_VALUE);
    }

    public static String select(String name, List values, String selected, String extra) {
        return HtmlUtil.select(name, values, selected, extra, Integer.MAX_VALUE);
    }

    public static String select(String name, List values, List<String> selected, String extra) {
        return HtmlUtil.select(name, values, selected, extra, Integer.MAX_VALUE);
    }

    public static String select(String name, Object[] values, String selected, int maxLength) {
        return HtmlUtil.select(name, Misc.toList(values), selected, maxLength);
    }

    public static String select(String name, List values, String selected, int maxLength) {
        return HtmlUtil.select(name, values, selected, "", maxLength);
    }

    public static String select(String name, List values, String selected, String extra, int maxLength) {
        List selectedList = null;
        if (selected != null && selected.length() > 0) {
            selectedList = Misc.newList(selected);
        }
        return HtmlUtil.select(name, values, selectedList, extra, maxLength);
    }

    public static String select(String name, List values, List selected, String extra, int maxLength) {
        StringBuffer sb = new StringBuffer();
        String attrs = extra != null && extra.indexOf(ATTR_CLASS) < 0 ? HtmlUtil.attrs(ATTR_NAME, name, ATTR_CLASS, "select") : HtmlUtil.attrs(ATTR_NAME, name);
        sb.append(HtmlUtil.open("select", attrs + extra));
        HashSet<String> seenSelected = new HashSet<String>();
        for (int i = 0; i < values.size(); ++i) {
            String label;
            String value;
            Object obj = values.get(i);
            String extraAttr = "";
            if (obj instanceof TwoFacedObject) {
                TwoFacedObject tfo = (TwoFacedObject)obj;
                value = tfo.getId().toString();
                label = tfo.toString();
            } else if (obj instanceof Selector) {
                Selector selector = (Selector)obj;
                value = selector.id;
                label = selector.label;
                if (selector.icon != null) {
                    extraAttr = HtmlUtil.style("margin:3px;margin-left:" + selector.margin + "px;padding-left:20px;padding-bottom:0px;padding-top:2px;background-repeat:no-repeat; background-image: url(" + selector.icon + ");");
                } else if (selector.isHeader) {
                    extraAttr = HtmlUtil.style("font-weight:bold");
                }
            } else {
                value = label = obj.toString();
            }
            String selectedAttr = "";
            if (selected != null && (selected.contains(value) || selected.contains(obj)) && !seenSelected.contains(value)) {
                selectedAttr = HtmlUtil.attrs("selected", "selected");
                seenSelected.add(value);
            }
            if (label.length() > maxLength) {
                label = "..." + label.substring(label.length() - maxLength);
            }
            sb.append(HtmlUtil.tag(TAG_OPTION, selectedAttr + extraAttr + HtmlUtil.attrs(ATTR_TITLE, value, ATTR_VALUE, value), label));
        }
        sb.append(HtmlUtil.close("select"));
        return sb.toString();
    }

    public static String colorSelect(String name, String selected) {
        StringBuffer sb = new StringBuffer();
        sb.append(HtmlUtil.open("select", HtmlUtil.attrs(ATTR_NAME, name, ATTR_CLASS, "select")));
        String value = "none";
        sb.append(HtmlUtil.tag(TAG_OPTION, HtmlUtil.attrs(ATTR_TITLE, value, ATTR_VALUE, ""), value));
        for (int i = 0; i < GuiUtils.COLORS.length; ++i) {
            Color c = GuiUtils.COLORS[i];
            String label = GuiUtils.COLORNAMES[i];
            value = StringUtil.toHexString(c);
            value = value.replace("#", "");
            String selectedAttr = "";
            if (Misc.equals(value, selected)) {
                selectedAttr = HtmlUtil.attrs("selected", "selected");
            }
            String textColor = "";
            if (c.equals(Color.black)) {
                textColor = "color:#FFFFFF;";
            }
            sb.append(HtmlUtil.tag(TAG_OPTION, selectedAttr + HtmlUtil.attrs(ATTR_TITLE, value, ATTR_VALUE, value, ATTR_STYLE, "background-color:" + value + ";" + textColor), label));
        }
        sb.append(HtmlUtil.close("select"));
        return sb.toString();
    }

    public static String inset(String html, int top, int left, int bottom, int right) {
        return HtmlUtil.span(html, HtmlUtil.style((top == 0 ? "" : "margin-top:" + top + "px;") + (left == 0 ? "" : "margin-left:" + left + "px;") + (bottom == 0 ? "" : "margin-bottom:" + bottom + "px;") + (right == 0 ? "" : "margin-right:" + top + "px;")));
    }

    public static String insetDiv(String html, int top, int left, int bottom, int right) {
        return HtmlUtil.div(html, HtmlUtil.style((top == 0 ? "" : "margin-top:" + top + "px;") + (left == 0 ? "" : "margin-left:" + left + "px;") + (bottom == 0 ? "" : "margin-bottom:" + bottom + "px;") + (right == 0 ? "" : "margin-right:" + top + "px;")));
    }

    public static String inset(String html, int space) {
        return HtmlUtil.div(html, HtmlUtil.style("margin:" + space + "px;"));
    }

    public static String insetLeft(String html, int space) {
        return HtmlUtil.div(html, HtmlUtil.style("margin-left:" + space + "px;"));
    }

    public static String colspan(String s, int cols) {
        return HtmlUtil.tag(TAG_TD, HtmlUtil.attr(ATTR_COLSPAN, "" + cols), s);
    }

    public static String formTableTop(String[] cols) {
        StringBuffer sb = new StringBuffer();
        sb.append(HtmlUtil.formTable());
        for (int i = 0; i < cols.length; i += 2) {
            sb.append(HtmlUtil.formEntryTop(cols[i], cols[i + 1]));
        }
        sb.append(HtmlUtil.formTableClose());
        return sb.toString();
    }

    public static String formTable(String[] cols) {
        StringBuffer sb = new StringBuffer();
        sb.append(HtmlUtil.formTable());
        for (int i = 0; i < cols.length; i += 2) {
            sb.append(HtmlUtil.formEntry(cols[i], cols[i + 1]));
        }
        sb.append(HtmlUtil.formTableClose());
        return sb.toString();
    }

    public static String formEntryTop(String[] cols) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cols.length; i += 2) {
            sb.append(HtmlUtil.formEntryTop(cols[i], cols[i + 1]));
        }
        return sb.toString();
    }

    public static String leftRight(String left, String right) {
        return HtmlUtil.leftRight(left, right, "");
    }

    public static String leftRight(String left, String right, String attrs) {
        return HtmlUtil.tag(TAG_TABLE, HtmlUtil.attrs(ATTR_WIDTH, "100%", ATTR_CELLPADDING, "0", ATTR_CELLSPACING, "0") + attrs, HtmlUtil.row(HtmlUtil.col(left) + HtmlUtil.col(right, HtmlUtil.attr(ATTR_ALIGN, VALUE_RIGHT)), HtmlUtil.attr(ATTR_VALIGN, VALUE_TOP)));
    }

    public static String table(String contents) {
        return HtmlUtil.table(contents, HtmlUtil.attrs(ATTR_CELLPADDING, "0", ATTR_CELLSPACING, "0"));
    }

    public static String table(String contents, String attrs) {
        return HtmlUtil.tag(TAG_TABLE, attrs, contents);
    }

    public static String table(Object[] columns) {
        return HtmlUtil.table(HtmlUtil.row(HtmlUtil.cols(columns), HtmlUtil.attr(ATTR_VALIGN, VALUE_TOP)));
    }

    public static String table(Object[] columns, int spacing) {
        return HtmlUtil.table(HtmlUtil.row(HtmlUtil.cols(columns), HtmlUtil.attr(ATTR_VALIGN, VALUE_TOP)), HtmlUtil.attrs(ATTR_CELLSPACING, "" + spacing));
    }

    public static StringBuffer table(List columns, int numCols, String attributes) {
        if (attributes == null) {
            attributes = HtmlUtil.attrs(ATTR_CELLPADDING, "0", ATTR_CELLSPACING, "0");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(HtmlUtil.open(TAG_TABLE, attributes));
        int cols = 0;
        for (int i = 0; i < columns.size(); ++i) {
            if (cols == 0) {
                if (i >= 1) {
                    sb.append(HtmlUtil.close(TAG_TR));
                }
                sb.append(HtmlUtil.open(TAG_TR));
            }
            sb.append(HtmlUtil.col(columns.get(i).toString()));
            if (++cols < numCols) continue;
            cols = 0;
        }
        sb.append(HtmlUtil.close(TAG_TR));
        sb.append(HtmlUtil.close(TAG_TABLE));
        return sb;
    }

    public static String formTable() {
        return HtmlUtil.open(TAG_TABLE, HtmlUtil.attrs(ATTR_CELLPADDING, "3", ATTR_CELLSPACING, "3"));
    }

    public static String formTable(String extra) {
        return HtmlUtil.open(TAG_TABLE, HtmlUtil.attrs(ATTR_CELLPADDING, "5", ATTR_CELLSPACING, "5") + " " + extra);
    }

    public static String formTableClose() {
        return HtmlUtil.close(TAG_TABLE);
    }

    public static String formClose() {
        return HtmlUtil.close(TAG_FORM);
    }

    public static String formEntry(String left, String right) {
        return HtmlUtil.tag(TAG_TR, "", HtmlUtil.tag(TAG_TD, HtmlUtil.attrs(ATTR_ALIGN, VALUE_RIGHT, ATTR_CLASS, CLASS_FORMLABEL), left) + HtmlUtil.tag(TAG_TD, "", right));
    }

    public static String formEntryTop(String left, String right) {
        return HtmlUtil.formEntryTop(left, right, "", true);
    }

    public static String formEntryTop(String left, String right, String trExtra, boolean dummy) {
        left = HtmlUtil.div(left, HtmlUtil.cssClass(CLASS_FORMLABEL_TOP));
        String label = HtmlUtil.tag(TAG_TD, HtmlUtil.attrs(ATTR_ALIGN, VALUE_RIGHT, ATTR_VALIGN, VALUE_TOP), left);
        return HtmlUtil.tag(TAG_TR, HtmlUtil.attrs(ATTR_VALIGN, VALUE_TOP) + " " + trExtra, label + HtmlUtil.tag(TAG_TD, "", right));
    }

    public static String formEntryTop(String col1, String left, String right) {
        return HtmlUtil.tag(TAG_TR, HtmlUtil.attrs(ATTR_VALIGN, VALUE_TOP), HtmlUtil.col(col1, HtmlUtil.attr(ATTR_VALIGN, VALUE_TOP)) + HtmlUtil.col(left, HtmlUtil.attrs(ATTR_VALIGN, VALUE_TOP, ATTR_ALIGN, VALUE_RIGHT, ATTR_CLASS, CLASS_FORMLABEL_TOP)) + HtmlUtil.col(right));
    }

    public static String attr(String name, String value) {
        return " " + name + "=" + HtmlUtil.quote(value) + " ";
    }

    public static String attrs(String name, String value) {
        return " " + name + "=" + HtmlUtil.quote(value) + " ";
    }

    public static String attrs(String[] pairs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pairs.length; i += 2) {
            sb.append(HtmlUtil.attrs(pairs[i], pairs[i + 1]));
        }
        return sb.toString();
    }

    public static String attrs(String n1, String v1, String n2, String v2) {
        return HtmlUtil.attr(n1, v1) + HtmlUtil.attr(n2, v2);
    }

    public static String attrs(String n1, String v1, String n2, String v2, String n3, String v3) {
        return HtmlUtil.attrs(n1, v1, n2, v2) + HtmlUtil.attr(n3, v3);
    }

    public static String attrs(String n1, String v1, String n2, String v2, String n3, String v3, String n4, String v4) {
        return HtmlUtil.attrs(n1, v1, n2, v2, n3, v3) + HtmlUtil.attr(n4, v4);
    }

    public static String onMouseOver(String call) {
        return HtmlUtil.attrs(ATTR_ONMOUSEOVER, call);
    }

    public static String onMouseMove(String call) {
        return HtmlUtil.attrs(ATTR_ONMOUSEMOVE, call);
    }

    public static String onMouseOut(String call) {
        return HtmlUtil.attrs(ATTR_ONMOUSEOUT, call);
    }

    public static String onMouseUp(String call) {
        return HtmlUtil.attrs(ATTR_ONMOUSEUP, call);
    }

    public static String onMouseDown(String call) {
        return HtmlUtil.attrs(ATTR_ONMOUSEDOWN, call);
    }

    public static String onMouseClick(String call) {
        return HtmlUtil.attrs(ATTR_ONCLICK, call);
    }

    public static String mouseClickHref(String call, String label) {
        return HtmlUtil.mouseClickHref(call, label, "");
    }

    public static String mouseClickHref(String call, String label, String extra) {
        String result = HtmlUtil.tag(TAG_A, HtmlUtil.attrs(ATTR_HREF, "javascript:void(0);") + HtmlUtil.onMouseClick(call) + extra, label);
        return result;
    }

    public static String jsLink(String events, String content) {
        return HtmlUtil.jsLink(events, content, "");
    }

    public static String jsLink(String events, String content, String extra) {
        return HtmlUtil.tag(TAG_A, HtmlUtil.attrs(ATTR_HREF, "javascript:noop();") + " " + events + " " + extra, content);
    }

    public static String script(String s) {
        return HtmlUtil.tag(TAG_SCRIPT, HtmlUtil.attrs(ATTR_TYPE, "text/JavaScript"), s);
    }

    public static String call(String function, String args) {
        return function + "(" + args + ");";
    }

    public static String callln(String function, String args) {
        return function + "(" + args + ");\n";
    }

    public static String importJS(String jsUrl) {
        return HtmlUtil.tag(TAG_SCRIPT, HtmlUtil.attr(ATTR_SRC, jsUrl), "");
    }

    public static String cssLink(String url) {
        return HtmlUtil.tag(TAG_LINK, HtmlUtil.attrs(ATTR_HREF, url, ATTR_REL, "stylesheet", ATTR_TYPE, "text/css"));
    }

    public static String makeTabs(List titles, List contents, boolean skipEmpty) {
        return HtmlUtil.makeTabs(titles, contents, skipEmpty, CLASS_TAB_CONTENT);
    }

    public static String makeTabs(List titles, List contents, boolean skipEmpty, String tabContentClass) {
        return HtmlUtil.makeTabs(titles, contents, skipEmpty, tabContentClass, CLASS_TAB_CONTENTS);
    }

    public static String makeTabs(List titles, List contents, boolean skipEmpty, String tabContentClass, String wrapperClass) {
        String id = "tab_" + tabCnt++;
        String ids = "tab_" + tabCnt++ + "_ids";
        StringBuffer titleSB = new StringBuffer("");
        StringBuffer contentSB = new StringBuffer();
        StringBuffer idArray = new StringBuffer("new Array(");
        int cnt = 0;
        for (int i = 0; i < titles.size(); ++i) {
            String content = contents.get(i).toString();
            if (skipEmpty && content.length() == 0) continue;
            String tabId = id + "_" + i;
            if (cnt > 0) {
                idArray.append(",");
            }
            ++cnt;
            idArray.append(HtmlUtil.squote(tabId));
        }
        if (cnt == 1 && skipEmpty) {
            return contents.get(0).toString();
        }
        idArray.append(")");
        String selectedOne = null;
        for (int i = 0; i < titles.size(); ++i) {
            String title;
            String content = contents.get(i).toString();
            if (skipEmpty && content.length() == 0 || !(title = titles.get(i).toString()).startsWith("selected:")) continue;
            selectedOne = title;
            break;
        }
        boolean didone = false;
        for (int i = 0; i < titles.size(); ++i) {
            boolean selected;
            String content = contents.get(i).toString();
            if (skipEmpty && content.length() == 0) continue;
            String title = titles.get(i).toString();
            String tabId = id + "_" + i;
            contentSB.append("\n");
            boolean bl = selectedOne == null ? !didone : (selected = Misc.equals(title, selectedOne));
            if (selected && selectedOne != null) {
                title = title.substring("selected:".length());
            }
            contentSB.append(HtmlUtil.div(content, HtmlUtil.cssClass(tabContentClass + (selected ? "_on" : "_off")) + HtmlUtil.id("content_" + tabId) + HtmlUtil.style("display:" + (selected ? CLASS_BLOCK : "none") + ";visibility:" + (selected ? "visible" : TYPE_HIDDEN))));
            String link = HtmlUtil.href("javascript:tabPress(" + HtmlUtil.squote(id) + "," + idArray + "," + HtmlUtil.squote(tabId) + ")", title);
            titleSB.append(HtmlUtil.span(link, (selected ? HtmlUtil.cssClass("tab_title_on") : HtmlUtil.cssClass("tab_title_off")) + HtmlUtil.id("title_" + tabId)));
            didone = true;
        }
        return HtmlUtil.div(titleSB.toString(), HtmlUtil.cssClass("tab_titles")) + HtmlUtil.div(contentSB.toString(), HtmlUtil.cssClass(wrapperClass));
    }

    public static void setBlockHideShowImage(String hideImg, String showImg) {
        blockHideImageUrl = hideImg;
        blockShowImageUrl = showImg;
    }

    public static void setInlineHideShowImage(String hideImg, String showImg) {
        inlineHideImageUrl = hideImg;
        inlineShowImageUrl = showImg;
    }

    public static String makeShowHideBlock(String label, String content, boolean visible) {
        return HtmlUtil.makeShowHideBlock(label, content, visible, HtmlUtil.cssClass("toggleblocklabel"));
    }

    public static String makeShowHideBlock(String label, String content, boolean visible, String headerExtra) {
        return HtmlUtil.makeShowHideBlock(label, content, visible, headerExtra, HtmlUtil.cssClass(CLASS_BLOCK), blockHideImageUrl, blockShowImageUrl);
    }

    public static String makeShowHideBlock(String label, String content, boolean visible, String headerExtra, String blockExtra) {
        return HtmlUtil.makeShowHideBlock(label, content, visible, headerExtra, blockExtra, blockHideImageUrl, blockShowImageUrl);
    }

    public static String makeShowHideBlock(String label, String content, boolean visible, String headerExtra, String blockExtra, String hideImg, String showImg) {
        String id = "block_" + blockCnt++;
        StringBuffer sb = new StringBuffer();
        String img = "";
        if (showImg != null && showImg.length() > 0) {
            img = HtmlUtil.img(visible ? hideImg : showImg, "", " id='" + id + "img' ");
        }
        String link = HtmlUtil.jsLink(HtmlUtil.onMouseClick("toggleBlockVisibility('" + id + "','" + id + "img','" + hideImg + "','" + showImg + "')"), img, HtmlUtil.cssClass("toggleblocklabellink"));
        link = link + " " + label;
        sb.append("<div  " + blockExtra + ">");
        sb.append(HtmlUtil.div(link, headerExtra));
        sb.append("<div " + HtmlUtil.cssClass("hideshowblock") + HtmlUtil.id(id) + HtmlUtil.style("display:block;visibility:visible") + ">");
        if (!visible) {
            sb.append(HtmlUtil.script(HtmlUtil.call("hide", HtmlUtil.squote(id))));
        }
        sb.append(content.toString());
        sb.append(HtmlUtil.close(TAG_DIV));
        sb.append(HtmlUtil.close(TAG_DIV));
        return sb.toString();
    }

    public static String[] getToggle(String label, boolean visible) {
        return HtmlUtil.getToggle(label, visible, blockHideImageUrl, blockShowImageUrl);
    }

    public static String[] getToggle(String label, boolean visible, String hideImg, String showImg) {
        String id = "block_" + blockCnt++;
        String img = HtmlUtil.img(visible ? hideImg : showImg, "", HtmlUtil.id(id + TAG_IMG));
        String link = HtmlUtil.jsLink(HtmlUtil.onMouseClick("toggleBlockVisibility('" + id + "','" + id + "img','" + hideImg + "','" + showImg + "')"), img, HtmlUtil.cssClass("toggleblocklabellink"));
        if (label.length() > 0) {
            link = link + " " + label;
        }
        String initJS = "";
        if (!visible) {
            initJS = HtmlUtil.call("hide", HtmlUtil.squote(id));
        }
        return new String[]{id, link, initJS};
    }

    public static String makeToggleBlock(String content, StringBuffer contentSB, boolean visible) {
        String blockExtra = "";
        String id = "block_" + blockCnt++;
        StringBuffer sb = contentSB;
        String img = "";
        String js = HtmlUtil.onMouseClick(HtmlUtil.call("toggleBlockVisibility", HtmlUtil.squote(id) + "," + HtmlUtil.squote(id + TAG_IMG) + "," + HtmlUtil.squote("") + "," + HtmlUtil.squote("")));
        sb.append("<div " + HtmlUtil.cssClass("hideshowblock") + HtmlUtil.id(id) + HtmlUtil.style("display:block;visibility:visible") + ">");
        if (!visible) {
            sb.append(HtmlUtil.script(HtmlUtil.call("hide", HtmlUtil.squote(id))));
        }
        sb.append(content.toString());
        sb.append(HtmlUtil.close(TAG_DIV));
        return js;
    }

    public static String makeToggleInline(String label, String content, boolean visible) {
        String hideImg = inlineHideImageUrl;
        String showImg = inlineShowImageUrl;
        if (hideImg == null) {
            hideImg = blockHideImageUrl;
        }
        if (showImg == null) {
            showImg = blockShowImageUrl;
        }
        String id = "block_" + blockCnt++;
        StringBuffer sb = new StringBuffer();
        String img = "";
        if (showImg != null && showImg.length() > 0) {
            img = HtmlUtil.img(visible ? hideImg : showImg, "", " id='" + id + "img' ") + HtmlUtil.space(1);
        }
        String link = HtmlUtil.jsLink(HtmlUtil.onMouseClick("toggleInlineVisibility('" + id + "','" + id + "img','" + hideImg + "','" + showImg + "')"), img + label, HtmlUtil.cssClass("toggleblocklabellink"));
        sb.append(link);
        sb.append("<span " + HtmlUtil.cssClass("hideshowblock") + HtmlUtil.id(id) + HtmlUtil.style("display:inline;visibility:visible") + ">");
        if (!visible) {
            sb.append(HtmlUtil.script(HtmlUtil.call("hide", HtmlUtil.squote(id))));
        }
        sb.append(content.toString());
        sb.append(HtmlUtil.close(TAG_SPAN));
        return sb.toString();
    }

    public static String makeToggleTable(String label, String content, boolean visible) {
        String hideImg = inlineHideImageUrl;
        String showImg = inlineShowImageUrl;
        if (hideImg == null) {
            hideImg = blockHideImageUrl;
        }
        if (showImg == null) {
            showImg = blockShowImageUrl;
        }
        String id = "block_" + blockCnt++;
        StringBuffer sb = new StringBuffer("<table border=0 width=\"100%\"><tr valign=top>");
        String img = "";
        if (showImg != null && showImg.length() > 0) {
            img = HtmlUtil.img(visible ? hideImg : showImg, "", " id='" + id + "img' ") + HtmlUtil.space(1);
        }
        String link = HtmlUtil.jsLink(HtmlUtil.onMouseClick("toggleInlineVisibility('" + id + "','" + id + "img','" + hideImg + "','" + showImg + "')"), img + label, HtmlUtil.cssClass("toggleblocklabellink"));
        sb.append("<td width=1%>");
        sb.append(link);
        sb.append("</td><td>");
        sb.append("<div " + HtmlUtil.cssClass("hideshowblock") + HtmlUtil.id(id) + HtmlUtil.style("display:inline;visibility:visible") + ">");
        if (!visible) {
            sb.append(HtmlUtil.script(HtmlUtil.call("hide", HtmlUtil.squote(id))));
        }
        sb.append(content.toString());
        sb.append(HtmlUtil.close(TAG_DIV));
        sb.append("</td></tr></table>");
        return sb.toString();
    }

    public static String makeShowHideBlock(String clickHtml, String label, String content, boolean visible) {
        String id = "block_" + blockCnt++;
        StringBuffer sb = new StringBuffer();
        String link = HtmlUtil.jsLink(HtmlUtil.onMouseClick("toggleBlockVisibility('" + id + "','" + id + "img','" + "" + "','" + "" + "')"), clickHtml, HtmlUtil.cssClass("toggleblocklabellink")) + label;
        sb.append(link);
        sb.append(HtmlUtil.open(TAG_SPAN, HtmlUtil.cssClass("hideshowblock") + HtmlUtil.id(id) + HtmlUtil.style("display:block;visibility:visible")));
        if (!visible) {
            sb.append(HtmlUtil.script(HtmlUtil.call("hide", HtmlUtil.squote(id))));
        }
        sb.append(content.toString());
        sb.append(HtmlUtil.close(TAG_SPAN));
        return sb.toString();
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception exc) {
            System.err.println("error encoding arg(3):" + s + " " + exc);
            exc.printStackTrace();
            return "";
        }
    }

    public static String urlEncodeExceptSpace(String s) {
        try {
            s = s.replace(" ", "_SPACE_");
            s = URLEncoder.encode(s, "UTF-8");
            s = s.replace("_SPACE_", " ");
            return s;
        }
        catch (Exception exc) {
            System.err.println("error encoding arg(4):" + s + " " + exc);
            exc.printStackTrace();
            return "";
        }
    }

    public static String entityEncode(String input) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
                sb.append(ch);
                continue;
            }
            sb.append("&#" + ch + ";");
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        for (String a : args) {
            System.err.println(a + ":" + HtmlUtil.entityEncode(a));
            System.err.println(a + ":" + HtmlUtil.urlEncode(a));
        }
    }

    public static final String sizeAttr(int size) {
        return "  size=" + HtmlUtil.quote("" + size) + " ";
    }

    static {
        blockCnt = 0;
    }

    public static class Selector {
        int margin = 3;
        String label;
        String id;
        String icon;
        boolean isHeader = false;

        public Selector(String label, String id, String icon) {
            this(label, id, icon, 3, false);
        }

        public Selector(String label, String id, String icon, int margin) {
            this(label, id, icon, margin, false);
        }

        public Selector(String label, String id, String icon, int margin, boolean isHeader) {
            this.label = label;
            this.id = id;
            this.icon = icon;
            this.margin = margin;
            this.isHeader = isHeader;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String getIcon() {
            return this.icon;
        }
    }
}

