/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

public class HashCodeUtils {
    public static final int SEED = 23;
    private static final int fODD_PRIME_NUMBER = 37;

    public static int hash(int aSeed, boolean aBoolean) {
        return HashCodeUtils.firstTerm(aSeed) + (aBoolean ? 1 : 0);
    }

    public static int hash(int aSeed, char aChar) {
        return HashCodeUtils.firstTerm(aSeed) + aChar;
    }

    public static int hash(int aSeed, int aInt) {
        return HashCodeUtils.firstTerm(aSeed) + aInt;
    }

    public static int hash(int aSeed, long aLong) {
        return HashCodeUtils.firstTerm(aSeed) + (int)(aLong ^ aLong >>> 32);
    }

    public static int hash(int aSeed, float aFloat) {
        return HashCodeUtils.hash(aSeed, Float.floatToIntBits(aFloat));
    }

    public static int hash(int aSeed, double aDouble) {
        return HashCodeUtils.hash(aSeed, Double.doubleToLongBits(aDouble));
    }

    private static int firstTerm(int aSeed) {
        return 37 * aSeed;
    }

    private static boolean isArray(Object aObject) {
        return aObject.getClass().isArray();
    }
}

