/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.unidata.util.CacheManager;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LayoutUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.MenuUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.util.WrapperException;

public class GuiUtils
extends LayoutUtil {
    private static String applicationTitle = "";
    public static String MISSING_IMAGE = "/ucar/unidata/util/scream.gif";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_TOOLTIP = "tooltip";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_ID = "id";
    public static final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    public static final Cursor normalCursor = Cursor.getPredefinedCursor(0);
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(GuiUtils.class.getName());
    public static final int[] FONT_SIZES = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 18, 20, 24, 26, 28, 32, 36, 40, 48, 56, 64, 72};
    public static final String[] COLORNAMES = new String[]{"blue", "black", "red", "gray", "light gray", "white", "green", "orange", "cyan", "magenta", "pink", "yellow"};
    public static final Color[] COLORS = new Color[]{Color.blue, Color.black, Color.red, Color.gray, Color.lightGray, Color.white, Color.green, Color.orange, Color.cyan, Color.magenta, Color.pink, Color.yellow};
    public static final String HEX_COLOR_PATTERN = "^?(([a-fA-F0-9]){3}){1,2}$";
    public static String CMD_APPLY = "Apply";
    public static String CMD_CANCEL = "Cancel";
    public static String CMD_CLOSE = "Close";
    public static String CMD_IMPORT = "Import";
    public static String CMD_EXPORT = "Export";
    public static String CMD_SUBMIT = "Submit";
    public static String CMD_RENAME = "Rename";
    public static String CMD_REMOVE = "Remove";
    public static String CMD_NEW = "New";
    public static String CMD_YES = "Yes";
    public static String CMD_NO = "No";
    public static String CMD_OK = "OK";
    public static String CMD_OPEN = "Open";
    public static String CMD_RESET = "Reset";
    public static String CMD_HELP = "Help";
    public static String CMD_SAVE = "Save";
    public static String CMD_SAVEAS = "Save as";
    public static String CMD_UPDATE = "Update";
    public static String CMD_START = "Start";
    public static String CMD_STOP = "Stop";
    public static Font buttonFont = new Font("Dialog", 1, 10);
    private static Hashtable imageCache = new Hashtable();
    private static boolean setIconsInMenus = true;
    private static int dfltIconSize = -1;
    private static TimeZone defaultTimeZone;
    private static SimpleDateFormat defaultDateFormat;
    public static final TimeZone TIMEZONE_UTC;
    private static Font dfltFont;
    private static JTextField intervalStepFld;
    private static JTextField intervalStartFld;
    private static List modalDialogComponents;

    private GuiUtils() {
    }

    public static void initLabels() {
        CMD_APPLY = Msg.msg(CMD_APPLY);
        CMD_CANCEL = Msg.msg(CMD_CANCEL);
        CMD_CLOSE = Msg.msg(CMD_CLOSE);
        CMD_IMPORT = Msg.msg(CMD_IMPORT);
        CMD_EXPORT = Msg.msg(CMD_EXPORT);
        CMD_RENAME = Msg.msg(CMD_RENAME);
        CMD_REMOVE = Msg.msg(CMD_REMOVE);
        CMD_NEW = Msg.msg(CMD_NEW);
        CMD_YES = Msg.msg(CMD_YES);
        CMD_NO = Msg.msg(CMD_NO);
        CMD_OK = Msg.msg(CMD_OK);
        CMD_OPEN = Msg.msg(CMD_OPEN);
        CMD_RESET = Msg.msg(CMD_RESET);
        CMD_HELP = Msg.msg(CMD_HELP);
        CMD_SAVE = Msg.msg(CMD_SAVE);
        CMD_SAVEAS = Msg.msg(CMD_SAVEAS);
        CMD_UPDATE = Msg.msg(CMD_UPDATE);
        CMD_START = Msg.msg(CMD_START);
        CMD_STOP = Msg.msg(CMD_STOP);
    }

    public static void setTimeZone(TimeZone tz) {
        defaultTimeZone = tz;
    }

    public static TimeZone getTimeZone() {
        if (defaultTimeZone == null) {
            return TIMEZONE_UTC;
        }
        return defaultTimeZone;
    }

    public static void setDefaultDateFormat(String fmt) {
        defaultDateFormat = new SimpleDateFormat(fmt);
        defaultDateFormat.setTimeZone(defaultTimeZone);
    }

    public static String formatDate(Date dttm) {
        return defaultDateFormat.format(dttm);
    }

    public static void setDefaultIconSize(int size) {
        dfltIconSize = size;
    }

    public static int getDefaultIconSize() {
        return dfltIconSize;
    }

    public static void setDefaultFont(Font font) {
        dfltFont = font;
        if (dfltFont != null) {
            buttonFont = dfltFont;
        }
    }

    public static Font getDefaultFont() {
        if (dfltFont != null) {
            return dfltFont;
        }
        return null;
    }

    public static void applyDefaultFont(Component comp) {
        if (dfltFont != null) {
            comp.setFont(dfltFont);
        }
    }

    public static JLabel getFixedWidthLabel(String s) {
        JLabel lbl = new JLabel(s);
        Font lblFont = lbl.getFont();
        Font monoFont = new Font("Monospaced", lblFont.getStyle(), lblFont.getSize());
        lbl.setFont(monoFont);
        return lbl;
    }

    public static void setFixedWidthFont(Component comp) {
        Font lblFont = comp.getFont();
        Font monoFont = new Font("Monospaced", lblFont.getStyle(), lblFont.getSize());
        comp.setFont(monoFont);
    }

    public static void setCursor(Component component, Cursor cursor) {
        Window f = GuiUtils.getWindow(component);
        if (f != null) {
            f.setCursor(cursor);
        }
    }

    public static JFrame getFrame(Component component) {
        if (component == null) {
            return null;
        }
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!JFrame.class.isAssignableFrom(parent.getClass())) continue;
            return (JFrame)parent;
        }
        return null;
    }

    public static void showComponentInTabs(Component comp) {
        GuiUtils.showComponentInTabs(comp, true);
    }

    public static void showComponentInTabs(Component comp, boolean andShowWindow) {
        if (comp == null) {
            return;
        }
        Container parent = comp.getParent();
        if (parent == null) {
            return;
        }
        if (parent instanceof Window && andShowWindow) {
            if (parent instanceof JFrame) {
                ((JFrame)parent).setState(0);
            }
            ((Window)parent).setVisible(true);
            GuiUtils.toFront((Window)parent);
            GuiUtils.toFrontModalDialogs();
        }
        if (parent instanceof JTabbedPane) {
            ((JTabbedPane)parent).setSelectedComponent(comp);
        }
        if (parent instanceof CardLayoutPanel) {
            CardLayoutPanel cardLayoutPanel = (CardLayoutPanel)parent;
            cardLayoutPanel.show(comp);
        }
        GuiUtils.showComponentInTabs(parent, andShowWindow);
    }

    public static void toFront(Window window) {
        if (window == null) {
            return;
        }
        window.setVisible(true);
        window.toFront();
        if (window instanceof Frame) {
            Frame frame = (Frame)window;
        }
    }

    public static Window getWindow(Component component) {
        if (component == null) {
            return null;
        }
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Window)) continue;
            return (Window)parent;
        }
        return null;
    }

    public static void empty(Container c) {
        GuiUtils.empty(c, false);
    }

    public static void empty(final Container c, boolean doItInSwingThread) {
        if (c == null) {
            return;
        }
        if (doItInSwingThread) {
            GuiUtils.invokeInSwingThread(new Runnable(){

                @Override
                public void run() {
                    GuiUtils.empty(c, false);
                }
            });
            return;
        }
        if (c != null) {
            c.removeAll();
            Container parent = c.getParent();
            if (parent != null) {
                parent.remove(c);
            }
        }
    }

    public static Color decodeColor(String value, Color dflt) {
        if (value == null) {
            return dflt;
        }
        if ((value = value.trim()).equals("null")) {
            return null;
        }
        String s = value;
        String lookFor = ",";
        int i1 = s.indexOf(lookFor);
        if (i1 < 0) {
            lookFor = " ";
            i1 = s.indexOf(lookFor);
        }
        if (i1 > 0) {
            String red = s.substring(0, i1);
            int i2 = (s = s.substring(i1 + 1).trim()).indexOf(lookFor);
            if (i2 > 0) {
                String green = s.substring(0, i2);
                String blue = s.substring(i2 + 1);
                try {
                    return new Color(Integer.decode(red), Integer.decode(green), Integer.decode(blue));
                }
                catch (Exception exc) {
                    System.err.println("Bad color:" + value);
                }
            }
        }
        try {
            if (Pattern.matches(HEX_COLOR_PATTERN, s)) {
                s = "#" + s;
            }
            return new Color(Integer.decode(s));
        }
        catch (Exception e) {
            s = value.toLowerCase();
            for (int i = 0; i < COLORNAMES.length; ++i) {
                if (!s.equals(COLORNAMES[i])) continue;
                return COLORS[i];
            }
            return dflt;
        }
    }

    public static String getColorName(Color color) {
        for (int i = 0; i < COLORNAMES.length; ++i) {
            if (!color.equals(COLORS[i])) continue;
            return COLORNAMES[i];
        }
        return "blue";
    }

    public static boolean checkHeight(int height) {
        return height <= 100;
    }

    public static void setPreferredWidth(JComponent comp, int width) {
        int height = comp.getPreferredSize().height;
        if (!GuiUtils.checkHeight(height)) {
            height = 24;
        }
        comp.setPreferredSize(new Dimension(width, height));
    }

    public static JComponent[] makeColorSwatchWidget(Color color, String label) {
        ColorSwatch swatch = new ColorSwatch(color, label);
        return new JComponent[]{swatch, swatch.setBtn, swatch.clearBtn};
    }

    public static JComboBox makeColorNameComboBox(Color dflt) {
        String colorName;
        Vector names = new Vector(Misc.toList(COLORNAMES));
        JComboBox jcb = new JComboBox(names);
        if (dflt != null && (colorName = GuiUtils.getColorName(dflt)) != null) {
            jcb.setSelectedItem(colorName);
        }
        return jcb;
    }

    public static ImageIcon getImageIcon(String file) {
        return GuiUtils.getImageIcon(file, true);
    }

    public static ImageIcon getImageIcon(String file, boolean cache) {
        return GuiUtils.getImageIcon(file, GuiUtils.class, cache);
    }

    public static ImageIcon getImageIcon(String file, Class c) {
        return GuiUtils.getImageIcon(file, c, true);
    }

    public static ImageIcon getImageIcon(String file, Class c, boolean cache) {
        Image image;
        if (c == null) {
            c = GuiUtils.class;
        }
        if ((image = GuiUtils.getImage(file, c, cache, false)) == null) {
            return null;
        }
        return new ImageIcon(image);
    }

    public static ImageIcon getScaledImageIcon(String file, Class c, boolean cache) {
        ImageIcon icon = GuiUtils.getImageIcon(file, c, cache);
        return GuiUtils.scaleImageIcon(icon);
    }

    public static ImageIcon scaleImageIcon(ImageIcon icon) {
        if (icon == null) {
            return null;
        }
        int w = icon.getIconWidth();
        if (w > 0 && w < dfltIconSize) {
            Image image = icon.getImage();
            int h = image.getHeight(null);
            h = (int)((double)h * ((double)dfltIconSize / (double)w));
            image = image.getScaledInstance(dfltIconSize, h, 0);
            icon.setImage(image);
        }
        return icon;
    }

    public static Image getImage(String file) {
        return GuiUtils.getImage(file, GuiUtils.class);
    }

    public static Image getImage(String file, Class c) {
        return GuiUtils.getImage(file, c, true);
    }

    public static Image getImage(String file, Class c, boolean cache) {
        return GuiUtils.getImage(file, c, cache, false);
    }

    public static Image getImage(String file, Class c, boolean cache, boolean returnNullIfNotFound) {
        if (!CacheManager.getDoCache()) {
            cache = false;
        }
        if (file == null) {
            return null;
        }
        if (c == null) {
            c = GuiUtils.class;
        }
        String key = file + "-" + c.getName();
        Image image = null;
        if (cache && (image = (Image)imageCache.get(key)) != null) {
            return image;
        }
        try {
            InputStream is = IOUtil.getInputStream(file, c);
            if (is != null) {
                byte[] bytes = IOUtil.readBytes(is);
                image = Toolkit.getDefaultToolkit().createImage(bytes);
                if (cache) {
                    imageCache.put(key, image);
                }
                return image;
            }
            if (returnNullIfNotFound) {
                return null;
            }
        }
        catch (Exception exc) {
            if (returnNullIfNotFound) {
                return null;
            }
            System.err.println(exc + " getting image ");
        }
        System.err.println("Unable to find image:" + file);
        URL url = Misc.getURL(MISSING_IMAGE, GuiUtils.class);
        if (url == null) {
            System.err.println("Whoah, could not load missing image:" + MISSING_IMAGE);
            return null;
        }
        return Toolkit.getDefaultToolkit().createImage(url);
    }

    public static void showDialogNearSrc(Component src, Component theWindow) {
        try {
            boolean iconified;
            boolean bl = iconified = src instanceof Frame && ((Frame)src).getState() == 1;
            if (src != null && !iconified) {
                Point loc = src.getLocationOnScreen();
                loc.y += src.getSize().height + 10;
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                screenSize.height -= 50;
                Dimension windowSize = theWindow.getSize();
                if (loc.y + windowSize.height > screenSize.height) {
                    loc.y = screenSize.height - windowSize.height;
                }
                if (loc.x + windowSize.width > screenSize.width) {
                    loc.x = screenSize.width - windowSize.width;
                }
                theWindow.setLocation(loc);
            } else {
                Point center = GuiUtils.getLocation(null);
                theWindow.setLocation(center.x - theWindow.getWidth() / 2, center.y - theWindow.getHeight() / 2);
            }
        }
        catch (Exception exc) {
            Point center = GuiUtils.getLocation(null);
            theWindow.setLocation(center.x - theWindow.getWidth() / 2, center.y - theWindow.getHeight() / 2);
        }
        GuiUtils.showWidget(theWindow);
    }

    public static void showWidget(Component c) {
        if (c == null) {
            return;
        }
        c.setVisible(true);
        if (c instanceof Frame) {
            if (((Frame)c).getState() == 1) {
                ((Frame)c).setState(0);
            }
            GuiUtils.toFront((Frame)c);
        }
    }

    public static JButton makeJButton(String label, ActionListener listener) {
        JButton b = new JButton(label);
        b.addActionListener(listener);
        return b;
    }

    public static JButton makeJButton(String label, Object[] args) {
        JButton b = new JButton(label);
        if (args.length / 2 * 2 != args.length) {
            throw new IllegalArgumentException("makeJButton: must have an even number of arguments");
        }
        for (int i = 0; i < args.length; i += 2) {
            String attr = (String)args[i];
            if (attr.equals("-tooltip")) {
                b.setToolTipText((String)args[i + 1]);
                continue;
            }
            if (attr.equals("-bg")) {
                b.setBackground((Color)args[i + 1]);
                continue;
            }
            if (attr.equals("-font")) {
                b.setFont((Font)args[i + 1]);
                continue;
            }
            if (attr.equals("-listener")) {
                b.addActionListener((ActionListener)args[i + 1]);
                continue;
            }
            if (attr.equals("-command")) {
                b.setActionCommand((String)args[i + 1]);
                continue;
            }
            throw new IllegalArgumentException("makeJButton: unknown argument: " + attr);
        }
        return b;
    }

    public static double getSliderPercent(JSlider s) {
        BoundedRangeModel r = s.getModel();
        return (double)(s.getValue() - r.getMinimum()) / (double)(r.getMaximum() - r.getMinimum());
    }

    public static void setSliderPercent(JSlider s, double percent) {
        BoundedRangeModel r = s.getModel();
        s.setValue(r.getMinimum() + (int)(percent * (double)(r.getMaximum() - r.getMinimum())));
    }

    public static void setBackgroundOnTree(Container c, Color bgColor) {
        c.setBackground(bgColor);
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component child = c.getComponent(i);
            if (child instanceof Container) {
                GuiUtils.setBackgroundOnTree((Container)child, bgColor);
                continue;
            }
            child.setBackground(bgColor);
        }
    }

    public static void setToolTipOnTree(Container c, String tooltip) {
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component child = c.getComponent(i);
            if (child instanceof Container) {
                GuiUtils.setToolTipOnTree((Container)child, tooltip);
            }
            if (!(child instanceof JComponent)) continue;
            ((JComponent)child).setToolTipText(tooltip);
        }
    }

    public static void setFontOnTree(JComponent c, Font f) {
        c.setFont(f);
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component child = c.getComponent(i);
            if (!(child instanceof JComponent)) continue;
            GuiUtils.setFontOnTree((JComponent)child, f);
        }
    }

    public static void setForegroundOnTree(Component comp, Color fgColor) {
        GuiUtils.setForegroundOnTree(comp, fgColor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setForegroundOnTree(Component comp, Color fgColor, Color ifEquals) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (ifEquals == null || ifEquals.equals(comp.getForeground())) {
                comp.setForeground(fgColor);
            }
            if (comp instanceof Container) {
                Container c = (Container)comp;
                for (int i = 0; i < c.getComponentCount(); ++i) {
                    Component child = c.getComponent(i);
                    GuiUtils.setForegroundOnTree(child, fgColor);
                }
            }
        }
    }

    public static void enableTree(Component comp, boolean enable) {
        comp.setEnabled(enable);
        if (comp instanceof Container) {
            Container container = (Container)comp;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                GuiUtils.enableTree(container.getComponent(i), enable);
            }
        }
    }

    public static void enableComponents(List comps, boolean enable) {
        for (int i = 0; i < comps.size(); ++i) {
            GuiUtils.enableTree((Component)comps.get(i), enable);
        }
    }

    public static void enablePanel(JPanel panel, boolean enable) {
        ArrayList<Component> cList = new ArrayList<Component>();
        Component[] ac = panel.getComponents();
        for (int i = 0; i < ac.length; ++i) {
            Component a = ac[i];
            cList.add(a);
        }
        GuiUtils.enableComponents(cList, enable);
    }

    public static JScrollPane makeScrollPane(Component c, int xdim, int ydim) {
        JScrollPane sp = new JScrollPane(c, 20, 30);
        JViewport vp = sp.getViewport();
        vp.setViewSize(new Dimension(xdim, ydim));
        return sp;
    }

    public static JComponent setSize(JComponent comp, int w, int h) {
        comp.setSize(w, h);
        comp.setPreferredSize(new Dimension(w, h));
        return comp;
    }

    public static ButtonGroup buttonGroup(JToggleButton b1, JToggleButton b2) {
        ButtonGroup bg = new ButtonGroup();
        bg.add(b1);
        bg.add(b2);
        return bg;
    }

    public static ButtonGroup buttonGroup(JToggleButton b1, JToggleButton b2, JToggleButton b3) {
        ButtonGroup bg = GuiUtils.buttonGroup(b1, b2);
        bg.add(b3);
        return bg;
    }

    public static ButtonGroup buttonGroup(JToggleButton b1, JToggleButton b2, JToggleButton b3, JToggleButton b4) {
        ButtonGroup bg = GuiUtils.buttonGroup(b1, b2, b3);
        bg.add(b4);
        return bg;
    }

    public static JComponent valignLabel(String s) {
        return GuiUtils.top(GuiUtils.inset((Component)GuiUtils.rLabel(s), new Insets(7, 0, 0, 0)));
    }

    public static JComponent formLayout(List objects) {
        return GuiUtils.formLayout(objects, INSETS_5);
    }

    public static JComponent formLayout(List objects, Insets insets) {
        Component[] comps = new Component[objects.size()];
        for (int i = 0; i < objects.size(); ++i) {
            Component comp = null;
            Object object = objects.get(i);
            comp = !(object instanceof Component) ? GuiUtils.rLabel(object.toString()) : (Component)object;
            comps[i] = comp;
        }
        LayoutUtil.tmpInsets = insets;
        return GuiUtils.doLayout(comps, 2, WT_NY, WT_N);
    }

    public static JComponent formLayout(Object[] objects, Insets insets) {
        return GuiUtils.formLayout(Misc.toList(objects), insets);
    }

    public static JComponent formLayout(Object[] objects) {
        return GuiUtils.formLayout(Misc.toList(objects));
    }

    public static JPanel flowRight(Component[] comps) {
        JPanel p = new JPanel(new FlowLayout(2));
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] == null) continue;
            p.add(comps[i]);
        }
        return p;
    }

    public static JPanel flow(Component[] comps) {
        JPanel p = new JPanel();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] == null) continue;
            p.add(comps[i]);
        }
        return p;
    }

    public static JPanel makeButtons(ActionListener l, String[] cmds) {
        return GuiUtils.makeButtons(l, null, cmds, null);
    }

    public static JPanel makeButtons(ActionListener l, String[] cmds, Hashtable buttonMap) {
        return GuiUtils.makeButtons(l, null, cmds, buttonMap);
    }

    public static JPanel makeButtons(ActionListener l, String[] labels, String[] cmds) {
        return GuiUtils.makeButtons(l, labels, cmds, null);
    }

    public static JPanel makeButtons(ActionListener l, String[] labels, String[] cmds, Hashtable buttonMap) {
        return GuiUtils.makeButtons(l, labels, cmds, null, buttonMap);
    }

    public static JPanel makeButtons(ActionListener l, String[] labels, String[] cmds, String[] tooltips, Hashtable buttonMap) {
        JPanel p = new JPanel();
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        p.setLayout(new BoxLayout(p, 0));
        for (int i = 0; i < cmds.length; ++i) {
            JButton button;
            String label;
            String cmd = cmds[i] != null ? cmds[i] : (labels != null ? labels[i] : "");
            String string = label = labels != null ? labels[i] : cmd;
            if (label == null) {
                label = cmd;
            }
            if (label.startsWith("icon:")) {
                button = GuiUtils.getImageButton(label.substring(5), GuiUtils.class);
                button.addActionListener(l);
                button.setActionCommand(cmd);
            } else {
                button = GuiUtils.makeJButton(label, new Object[]{"-listener", l, "-command", cmd});
            }
            if (cmd.equals(CMD_OK)) {
                button.setDefaultCapable(true);
            }
            if (tooltips != null && i < tooltips.length) {
                button.setToolTipText(tooltips[i]);
            }
            if (buttonMap != null) {
                buttonMap.put(cmd, button);
            }
            buttons.add(button);
        }
        return GuiUtils.doLayout(p, GuiUtils.getComponentArray(buttons), buttons.size(), WT_N, WT_N, null, null, new Insets(5, 5, 5, 5));
    }

    public static JPanel makeApplyCancelButtons(ActionListener l) {
        return GuiUtils.makeButtons(l, new String[]{"Apply", "Cancel"}, new String[]{CMD_APPLY, CMD_CANCEL});
    }

    public static JButton makeApplyButton(ActionListener l) {
        JButton b = new JButton("Apply");
        b.setActionCommand(CMD_APPLY);
        b.addActionListener(l);
        return b;
    }

    public static JPanel makeOkCancelButtons(ActionListener l) {
        return GuiUtils.makeOkCancelButtons(l, "OK", "Cancel");
    }

    public static JPanel makeNewOkCancelButtons(ActionListener l) {
        return GuiUtils.makeNewOkCancelButtons(l, CMD_NEW, CMD_OK, CMD_CANCEL);
    }

    public static JPanel makeNewOkCancelHelpButtons(ActionListener l) {
        return GuiUtils.makeButtons(l, new String[]{CMD_NEW, CMD_OK, CMD_CANCEL, CMD_HELP});
    }

    public static JPanel makeNewOkCancelButtons(ActionListener l, String newLabel, String okLabel, String cancelLabel) {
        return GuiUtils.makeButtons(l, new String[]{newLabel, okLabel, cancelLabel}, new String[]{CMD_NEW, CMD_OK, CMD_CANCEL});
    }

    public static JPanel makeOkCancelButtons(ActionListener l, String okLabel, String cancelLabel) {
        return GuiUtils.makeButtons(l, new String[]{okLabel, cancelLabel}, new String[]{CMD_OK, CMD_CANCEL});
    }

    public static JPanel makeApplyOkCancelButtons(ActionListener l) {
        return GuiUtils.makeButtons(l, new String[]{"Apply", "OK", "Cancel"}, new String[]{CMD_APPLY, CMD_OK, CMD_CANCEL});
    }

    public static JPanel makeOkHelpCancelButtons(ActionListener l) {
        return GuiUtils.makeButtons(l, new String[]{"OK", "Help", "Cancel"}, new String[]{CMD_OK, CMD_HELP, CMD_CANCEL});
    }

    public static JPanel makeApplyOkHelpCancelButtons(ActionListener l) {
        return GuiUtils.makeButtons(l, new String[]{"Apply", "OK", "Help", "Cancel"}, new String[]{CMD_APPLY, CMD_OK, CMD_HELP, CMD_CANCEL});
    }

    public static JPanel makeApplyOkResetCancelButtons(ActionListener l) {
        return GuiUtils.makeButtons(l, new String[]{"Apply", "OK", "Reset", "Cancel"}, new String[]{CMD_APPLY, CMD_OK, CMD_RESET, CMD_CANCEL});
    }

    public static boolean showYesNoDialog(Window frame, String message, String title) {
        return GuiUtils.showYesNoDialog(frame, message, title, "Yes", "No");
    }

    public static boolean showYesNoDialog(Window frame, String message, String title, String yes, String no) {
        Object[] options = new Object[]{yes, no};
        Window component = frame;
        if (component == null) {
            component = LogUtil.getCurrentWindow();
        }
        boolean result = 0 == JOptionPane.showOptionDialog(component, message, title, 0, 3, null, options, yes);
        return result;
    }

    public static void insertText(JTextComponent comp, String s) {
        int pos = comp.getCaretPosition();
        String t = comp.getText();
        t = t.substring(0, pos) + s + t.substring(pos);
        comp.setText(t);
        comp.setCaretPosition(pos + s.length());
    }

    public static int showYesNoCancelDialog(Window frame, String message, String title) {
        return GuiUtils.showYesNoCancelDialog(frame, message, title, CMD_YES);
    }

    public static int showYesNoCancelDialog(Window frame, String message, String title, String defaultCmd) {
        Object[] options = new Object[]{CMD_YES, CMD_NO, CMD_CANCEL};
        Window component = frame;
        if (component == null) {
            component = LogUtil.getCurrentWindow();
        }
        int result = JOptionPane.showOptionDialog(component, message, title, 1, 3, null, options, defaultCmd);
        return result;
    }

    public static boolean showYesNoDialog(Window frame, String title, Component contents, Component src) {
        JDialog dialog = GuiUtils.createDialog(frame, title, true);
        ObjectListener listener = GuiUtils.getCloseDialogListener(dialog);
        JPanel buttons = GuiUtils.makeButtons(listener, new String[]{CMD_YES, CMD_NO});
        GuiUtils.packDialog(dialog, GuiUtils.centerBottom(contents, buttons));
        dialog.setLocation(GuiUtils.getLocation(src));
        dialog.setVisible(true);
        return listener.theObject.equals(CMD_YES);
    }

    public static boolean showOkCancelDialog(Window f, String title, Component contents, Component src) {
        return GuiUtils.showOkCancelDialog(f, title, contents, src, null);
    }

    public static boolean showOkCancelDialog(Window f, String title, Component contents, Component src, List actionComponents) {
        return GuiUtils.showOkCancelDialog(f, title, contents, src, actionComponents, CMD_OK);
    }

    private static void setDefaultButton(Container c, JRootPane root) {
        if (c instanceof JButton && Misc.equals(((JButton)c).getActionCommand(), CMD_OK)) {
            root.setDefaultButton((JButton)c);
            return;
        }
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component child = c.getComponent(i);
            if (!(child instanceof Container)) continue;
            GuiUtils.setDefaultButton((Container)child, root);
        }
    }

    public static JFrame createFrame(String title) {
        JFrame frame = new JFrame(title);
        LogUtil.registerWindow(frame);
        return frame;
    }

    public static JDialog createDialog(String title, boolean modal) {
        return GuiUtils.createDialog(null, title, modal);
    }

    public static Component[] popup(String text, int x, int y, boolean modal) {
        try {
            String contents = IOUtil.readContents(text, (String)null);
            if (contents != null) {
                text = contents;
            }
        }
        catch (Exception contents) {
            // empty catch block
        }
        Component[] comps = GuiUtils.getHtmlComponent(text, null, 200, 200);
        Component scroller = comps[1];
        final JDialog dialog = GuiUtils.createDialog(null, "Popup", modal);
        JButton btn = new JButton("Close");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialog.dispose();
            }
        });
        dialog.getContentPane().add(GuiUtils.centerBottom(scroller, GuiUtils.wrap(btn)));
        dialog.pack();
        dialog.setLocation(new Point(x, y));
        dialog.setVisible(true);
        return new Component[]{comps[0], dialog};
    }

    public static JDialog createDialog(Window parent, String title, boolean modal) {
        if (modal && parent == null) {
            parent = LogUtil.getCurrentWindow();
        }
        JDialog dialog = parent == null || parent instanceof Frame ? new JDialog((Frame)parent, title, modal) : (parent instanceof Dialog ? new JDialog((Dialog)parent, title, modal) : new JDialog((Dialog)null, title, modal));
        if (!modal) {
            LogUtil.registerWindow(dialog);
        }
        return dialog;
    }

    public static boolean showOkCancelDialog(Window f, String title, Component contents, Component src, List actionComponents, String okLabel) {
        return GuiUtils.showOkCancelDialog(f, title, contents, src, actionComponents, okLabel, true, null);
    }

    public static boolean showOkCancelDialog(Window f, String title, Component contents, Component src, List actionComponents, String okLabel, boolean resizable, Dimension dialogPrefSize) {
        if (!LogUtil.getInteractiveMode()) {
            throw new IllegalStateException("Cannot show dialog in non-interactive mode");
        }
        JDialog dialog = GuiUtils.createDialog(f, title, true);
        final ObjectListener listener = GuiUtils.getCloseDialogListener(dialog);
        JPanel buttons = GuiUtils.makeOkCancelButtons(listener, okLabel, CMD_CANCEL);
        if (actionComponents != null) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    listener.actionPerformed(new ActionEvent(this, 0, CMD_OK));
                }
            };
            for (int i = 0; i < actionComponents.size(); ++i) {
                Object o = actionComponents.get(i);
                if (o instanceof JTextField) {
                    ((JTextField)o).addActionListener(actionListener);
                    continue;
                }
                if (!(o instanceof JComboBox)) continue;
                ((JComboBox)o).getEditor().addActionListener(actionListener);
            }
        }
        if (dialogPrefSize != null) {
            dialog.setPreferredSize(dialogPrefSize);
        }
        GuiUtils.packDialog(dialog, GuiUtils.centerBottom(contents, buttons));
        GuiUtils.setDefaultButton(buttons, dialog.getRootPane());
        dialog.setResizable(resizable);
        if (src != null) {
            dialog.setLocation(GuiUtils.getLocation(src));
            dialog.setVisible(true);
        } else {
            GuiUtils.showInCenter(dialog);
        }
        return listener.theObject.equals(CMD_OK);
    }

    public static void showOkDialog(Window f, String title, Component contents, Component src) {
        if (!LogUtil.getInteractiveMode()) {
            throw new IllegalStateException("Cannot show dialog in non-interactive mode");
        }
        JDialog dialog = GuiUtils.createDialog(f, title, true);
        ObjectListener listener = GuiUtils.getCloseDialogListener(dialog);
        JPanel buttons = GuiUtils.makeButtons((ActionListener)listener, new String[]{CMD_OK}, new String[]{CMD_OK});
        GuiUtils.packDialog(dialog, GuiUtils.centerBottom(contents, buttons));
        GuiUtils.setDefaultButton(buttons, dialog.getRootPane());
        if (src != null) {
            dialog.setLocation(GuiUtils.getLocation(src));
            dialog.setVisible(true);
        } else {
            GuiUtils.showInCenter(dialog);
        }
    }

    public static int makeDialog(Window f, String title, Component contents, Component src, String[] buttonLabels) {
        JDialog dialog = GuiUtils.createDialog(f, title, true);
        ObjectListener listener = GuiUtils.getCloseDialogListener(dialog);
        JPanel buttons = GuiUtils.makeButtons((ActionListener)listener, buttonLabels, buttonLabels);
        GuiUtils.packDialog(dialog, GuiUtils.centerBottom(contents, GuiUtils.inset((Component)buttons, 5)));
        if (src != null) {
            dialog.setLocation(GuiUtils.getLocation(src));
        } else {
            dialog.setLocation(new Point(200, 100));
        }
        GuiUtils.setDefaultButton(buttons, dialog.getRootPane());
        dialog.setVisible(true);
        for (int i = 0; i < buttonLabels.length; ++i) {
            if (!listener.theObject.equals(buttonLabels[i])) continue;
            return i;
        }
        return -1;
    }

    public static void configureStepSelection(final JList list) {
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    GuiUtils.popupConfigureStepSelection(e, list);
                }
            }
        });
        if (list.getToolTipText() == null) {
            list.setToolTipText("Right mouse to show range select popup menu");
        }
    }

    private static void popupConfigureStepSelection(MouseEvent e, JList list) {
        if (!list.isEnabled()) {
            return;
        }
        ArrayList items = new ArrayList();
        GuiUtils.getConfigureStepSelectionItems(list, items);
        JPopupMenu popup = GuiUtils.makePopupMenu(items);
        popup.show(list, e.getX(), e.getY());
    }

    public static void showIntervalSelectionDialog(JList list) {
        tmpInsets = INSETS_5;
        JPanel contents = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Start Index:"), intervalStartFld, GuiUtils.rLabel("Interval:"), intervalStepFld}, 2, WT_NN, WT_N);
        contents = GuiUtils.vbox(new JLabel("Choose Selection Interval"), contents);
        contents = GuiUtils.inset((Component)contents, 5);
        int size = list.getModel().getSize();
        while (GuiUtils.showOkCancelDialog(null, "Selection Interval", contents, list)) {
            try {
                int start = new Integer(intervalStartFld.getText().trim()) - 1;
                int step = new Integer(intervalStepFld.getText().trim());
                list.clearSelection();
                for (int idx = start; idx < size; idx += step) {
                    list.addSelectionInterval(idx, idx);
                }
                return;
            }
            catch (NumberFormatException nfe) {
                LogUtil.userErrorMessage("Bad input value");
                continue;
            }
            break;
        }
        return;
    }

    public static void getConfigureStepSelectionItems(final JList list, List items) {
        if (!list.isEnabled()) {
            return;
        }
        final int size = list.getModel().getSize();
        int[] steps = new int[]{1, 2, 3, 4, 5, 10, 20};
        String[] labels = new String[]{"all", "every other one", "every third one", "every fourth one", "every fifth one", "every tenth one", "every twentieth one"};
        JMenu rangeMenu = new JMenu("Select Range");
        items.add(rangeMenu);
        for (int i = 0; i < 20 && i < list.getModel().getSize(); ++i) {
            JMenuItem item = new JMenuItem("First  " + (i + 1));
            rangeMenu.add(item);
            final int cnt = i + 1;
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    list.clearSelection();
                    for (int idx = 0; idx < cnt; ++idx) {
                        list.addSelectionInterval(idx, idx);
                    }
                }
            });
        }
        JMenuItem selectStrideMenuItem = new JMenuItem("Choose Interval");
        selectStrideMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                final JList theList = list;
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        GuiUtils.showIntervalSelectionDialog(theList);
                    }
                });
            }
        });
        items.add("separator");
        items.add(selectStrideMenuItem);
        items.add("separator");
        for (int i = 0; i < steps.length && steps[i] <= size; ++i) {
            final int step = steps[i];
            JMenuItem item = new JMenuItem("Select " + labels[i]);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    list.clearSelection();
                    for (int idx = 0; idx < size; idx += step) {
                        list.addSelectionInterval(idx, idx);
                    }
                }
            });
            items.add(item);
        }
    }

    public static JComponent formLayout(List comps, boolean rightAlignFirstColumn) {
        return GuiUtils.formLayout(comps, WT_NY, WT_N, rightAlignFirstColumn);
    }

    public static JComponent formLayout(Component[] comps) {
        return GuiUtils.formLayout(Misc.toList(comps));
    }

    public static JComponent formLayout(Component[] comps, double[] widths, double[] heights) {
        return GuiUtils.formLayout(Misc.toList(comps), widths, heights, true);
    }

    public static JComponent formLayout(List comps, double[] widths, double[] heights) {
        return GuiUtils.formLayout(comps, widths, heights, true);
    }

    public static JComponent formLayout(List comps, double[] widths, double[] heights, boolean rightAlignFirstColumn) {
        if (rightAlignFirstColumn) {
            for (int i = 0; i < comps.size(); i += 2) {
                JComponent comp = (JComponent)comps.get(i);
                comp = GuiUtils.right(comp);
                comps.set(i, comp);
            }
        }
        tmpInsets = new Insets(5, 5, 5, 5);
        return GuiUtils.doLayout(comps, 2, widths, heights);
    }

    public static JPanel label(String label, Component widget) {
        return GuiUtils.doLayout(new Component[]{new JLabel(label), widget}, 2, WT_NY, WT_N);
    }

    public static JPanel label(Component widget, String label) {
        return GuiUtils.doLayout(new Component[]{widget, new JLabel(label)}, 2, WT_N, WT_N);
    }

    public static JFrame packWindow(JFrame f, Component contents) {
        return GuiUtils.packWindow(f, contents, false);
    }

    public static JFrame packWindow(JFrame f, Component contents, boolean andShow) {
        if (f == null) {
            f = new JFrame();
        }
        Container cpane = f.getContentPane();
        cpane.add(contents);
        f.pack();
        Msg.translateTree(f);
        if (andShow) {
            f.setVisible(true);
        }
        return f;
    }

    public static JDialog packDialog(JDialog f, Component contents) {
        Container cpane = f.getContentPane();
        cpane.add(contents);
        f.pack();
        Msg.translateTree(f);
        return f;
    }

    public static JFrame makeWindow(String title, Component contents, int x, int y) {
        JFrame f = new JFrame(title);
        Container cpane = f.getContentPane();
        cpane.add(contents);
        f.pack();
        Msg.translateTree(f);
        f.setLocation(x, y);
        return f;
    }

    public static JMenuBar makeMenuBar(List menus) {
        if (menus == null || menus.size() == 0) {
            return null;
        }
        JMenuBar menuBar = new JMenuBar();
        for (int i = 0; i < menus.size(); ++i) {
            menuBar.add((JMenu)menus.get(i));
        }
        return menuBar;
    }

    public static ObjectListener getCloseDialogListener(final JDialog dialog) {
        return new ObjectListener(dialog){

            @Override
            public void actionPerformed(ActionEvent ae) {
                this.theObject = ae.getActionCommand();
                dialog.setVisible(false);
            }
        };
    }

    public static JLabel getImageLabel(String icon, Class origin) {
        return new JLabel(GuiUtils.getImageIcon(icon, origin));
    }

    public static JLabel getImageLabel(String icon) {
        return new JLabel(GuiUtils.getImageIcon(icon, GuiUtils.class));
    }

    public static JButton getImageButton(String icon, Class origin) {
        return GuiUtils.getImageButton(icon, origin, 0, 0);
    }

    public static JButton getImageButton(String icon, Class origin, int hInset, int vInset) {
        return GuiUtils.getImageButton(GuiUtils.getImageIcon(icon, origin), hInset, vInset);
    }

    public static JButton getScaledImageButton(String icon, Class origin, int hInset, int vInset) {
        return GuiUtils.getImageButton(GuiUtils.getScaledImageIcon(icon, origin, true), hInset, vInset);
    }

    public static JButton getImageButton(ImageIcon icon) {
        return GuiUtils.getImageButton(icon, 0);
    }

    public static JButton getImageButton(ImageIcon icon, int offset) {
        return GuiUtils.getImageButton(icon, offset, offset);
    }

    public static JButton getImageButton(ImageIcon icon, int hinset, int vinset) {
        JButton b = new JButton(icon);
        b.setBackground(null);
        b.setContentAreaFilled(false);
        b.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        b.setPreferredSize(new Dimension(icon.getIconWidth() + hinset, icon.getIconHeight() + vinset));
        return b;
    }

    public static JToggleButton getToggleImageButton(String icon, String selectedIcon, int hinset, int vinset, boolean addMouseOverBorder) {
        return GuiUtils.getToggleImageButton(GuiUtils.getImageIcon(icon), GuiUtils.getImageIcon(selectedIcon), hinset, vinset, addMouseOverBorder);
    }

    public static JToggleButton getToggleImageButton(ImageIcon icon, ImageIcon selectedIcon, int hinset, int vinset) {
        return GuiUtils.getToggleImageButton(icon, selectedIcon, hinset, vinset, false);
    }

    public static JToggleButton getToggleImageButton(ImageIcon icon, ImageIcon selectedIcon, int hinset, int vinset, boolean addMouseOverBorder) {
        JToggleButton b = new JToggleButton(icon);
        if (icon != selectedIcon) {
            b.setSelectedIcon(selectedIcon);
        }
        if (addMouseOverBorder) {
            GuiUtils.makeMouseOverBorder(b);
        } else {
            b.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }
        b.setPreferredSize(new Dimension(icon.getIconWidth() + hinset, icon.getIconHeight() + vinset));
        return b;
    }

    public static void makeMouseOverBorder(final JComponent b) {
        b.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (b.isEnabled()) {
                    b.setBorder(BorderFactory.createLineBorder(Color.gray));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                b.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        });
    }

    public static JToggleButton getToggleButton(String iconPath, int hinset, int vinset) {
        return GuiUtils.getToggleButton(GuiUtils.getImageIcon(iconPath, GuiUtils.class), hinset, vinset);
    }

    public static JToggleButton getToggleButton(ImageIcon icon, int hinset, int vinset) {
        JToggleButton b = new JToggleButton(icon);
        b.setPreferredSize(new Dimension(icon.getIconWidth() + hinset, icon.getIconHeight() + vinset));
        return b;
    }

    public static Point getLocation(Component src) {
        if (src != null) {
            try {
                return src.getLocationOnScreen();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        return new Point(ss.width / 2 - 100, ss.height / 2 - 100);
    }

    public static void showInCenter(JDialog dialog) {
        GuiUtils.packInCenter(dialog);
        dialog.setVisible(true);
    }

    public static void packInCenter(JDialog dialog) {
        dialog.pack();
        Point center = GuiUtils.getLocation(null);
        int x = center.x - dialog.getWidth() / 2;
        int y = center.y - dialog.getHeight() / 2;
        if (x < 20) {
            x = 20;
        }
        if (y < 20) {
            y = 20;
        }
        dialog.setLocation(x, y);
    }

    public static JSplitPane vsplit(Component top, Component bottom, int topSpace, double resizeWeight) {
        JSplitPane split = GuiUtils.vsplit(top, bottom, topSpace);
        split.setResizeWeight(resizeWeight);
        return split;
    }

    public static JSplitPane vsplit(Component top, Component bottom, int topSpace) {
        JSplitPane split = GuiUtils.vsplit(top, bottom);
        split.setDividerLocation(topSpace);
        return split;
    }

    public static JSplitPane vsplit(Component top, Component bottom, double resizeWeight) {
        JSplitPane split = GuiUtils.vsplit(top, bottom);
        split.setResizeWeight(resizeWeight);
        return split;
    }

    public static JSplitPane vsplit(Component top, Component bottom) {
        return new JSplitPane(0, top, bottom);
    }

    public static JSplitPane hsplit(Component left, Component right, int leftSpace, double resizeWeight) {
        JSplitPane split = GuiUtils.hsplit(left, right, leftSpace);
        split.setResizeWeight(resizeWeight);
        return split;
    }

    public static JSplitPane hsplit(Component left, Component right, int leftSpace) {
        JSplitPane split = GuiUtils.hsplit(left, right);
        if (leftSpace >= 0) {
            split.setDividerLocation(leftSpace);
        }
        return split;
    }

    public static JSplitPane hsplit(Component left, Component right, double resizeWeight) {
        JSplitPane split = GuiUtils.hsplit(left, right);
        split.setResizeWeight(resizeWeight);
        return split;
    }

    public static JSplitPane hsplit(Component left, Component right) {
        return new JSplitPane(1, left, right);
    }

    public static JLabel rLabel(String s) {
        return new JLabel(s, 4);
    }

    public static JLabel cLabel(String s) {
        return new JLabel(s, 0);
    }

    public static JLabel lLabel(String s) {
        return new JLabel(s);
    }

    public static JComponent hspace(int w, int h) {
        JLabel p = new JLabel(" ");
        p.setMinimumSize(new Dimension(w, h));
        p.setPreferredSize(new Dimension(w, h));
        return p;
    }

    public static String getInput(String question, String label, String initValue) {
        return GuiUtils.getInput(question, label, initValue, "");
    }

    public static String getInput(String question, String label, String initValue, String trailingLabel) {
        return GuiUtils.getInput(question, label, initValue, trailingLabel, null);
    }

    public static String getInput(String question, String label, String initValue, String trailingLabel, Object underLabel) {
        return GuiUtils.getInput(question, label, initValue, trailingLabel, underLabel, "");
    }

    public static String getInput(String question, String label, String initValue, String trailingLabel, Object underLabel, String title) {
        return GuiUtils.getInput(question, label, initValue, trailingLabel, underLabel, title, 20);
    }

    public static String getInput(String question, String label, String initValue, String trailingLabel, Object underLabel, String title, int fieldWidth) {
        return GuiUtils.getInput(question, label, initValue, trailingLabel, underLabel, title, fieldWidth, null);
    }

    public static String getInput(String question, String label, String initValue, String trailingLabel, Object underLabel, String title, int fieldWidth, JComponent nearComponent) {
        final JDialog dialog = GuiUtils.createDialog(title, true);
        final JTextField field = new JTextField(initValue == null ? "" : initValue, fieldWidth);
        ObjectListener listener = new ObjectListener(new Boolean(false)){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                this.theObject = ae.getSource() == field || cmd.equals(CMD_OK) ? new Boolean(true) : new Boolean(false);
                dialog.setVisible(false);
            }
        };
        field.addActionListener(listener);
        ArrayList<JPanel> comps = new ArrayList<JPanel>();
        if (question != null) {
            comps.add(GuiUtils.left(GuiUtils.inset((Component)new JLabel(question), 4)));
        }
        if (trailingLabel != null) {
            comps.add(GuiUtils.left(GuiUtils.centerRight(GuiUtils.label(label, field), new JLabel(trailingLabel))));
        } else {
            comps.add(GuiUtils.left(GuiUtils.label(label, field)));
        }
        if (underLabel != null) {
            if (underLabel instanceof String) {
                comps.add(GuiUtils.left(new JLabel(underLabel.toString())));
            } else if (underLabel instanceof Component) {
                comps.add(GuiUtils.left((Component)underLabel));
            }
        }
        JPanel contents = GuiUtils.inset((Component)GuiUtils.centerBottom(GuiUtils.vbox(comps), GuiUtils.makeOkCancelButtons(listener)), 4);
        GuiUtils.packDialog(dialog, contents);
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        if (nearComponent != null) {
            GuiUtils.showDialogNearSrc(nearComponent, dialog);
        } else {
            Point ctr = new Point(ss.width / 2 - 100, ss.height / 2 - 100);
            dialog.setLocation(ctr);
            dialog.setVisible(true);
        }
        if (!((Boolean)listener.theObject).booleanValue()) {
            return null;
        }
        return field.getText();
    }

    public static String getInput(String question) {
        return JOptionPane.showInputDialog(LogUtil.getCurrentWindow(), (Object)question);
    }

    public static boolean askYesNo(String title, Object question) {
        int response = JOptionPane.showConfirmDialog(LogUtil.getCurrentWindow(), question, title, 0);
        return response == 0;
    }

    public static boolean askOkCancel(String title, Object question) {
        int response = JOptionPane.showConfirmDialog(LogUtil.getCurrentWindow(), question, title, 2);
        return response == 0;
    }

    public static void showDialog(String title, Component comp) {
        GuiUtils.showDialog(title, comp, null);
    }

    public static void addModalDialogComponent(Component comp) {
        modalDialogComponents.add(comp);
    }

    public static void removeModalDialogComponent(Component comp) {
        modalDialogComponents.remove(comp);
    }

    public static void showDialog(String title, Component comp, Component parentComponent) {
        if (parentComponent == null) {
            parentComponent = LogUtil.getCurrentWindow();
        }
        modalDialogComponents.add(comp);
        JOptionPane.showMessageDialog(parentComponent, comp, title, 1);
        modalDialogComponents.remove(comp);
    }

    public static void toFrontModalDialogs() {
        for (int i = 0; i < modalDialogComponents.size(); ++i) {
            Component comp = (Component)modalDialogComponents.get(i);
            Window window = GuiUtils.getWindow(comp);
            if (window == null) continue;
            GuiUtils.toFront(window);
        }
    }

    public static void setListData(JComboBox box, Object[] items) {
        box.removeAllItems();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                box.addItem(items[i]);
            }
        }
    }

    public static boolean anySelected(JComboBox box) {
        if (box == null) {
            return false;
        }
        if (box.getModel().getSize() > 0) {
            return box.getSelectedItem() != null;
        }
        return false;
    }

    public static void setListData(JComboBox box, List items) {
        box.removeAllItems();
        if (items != null) {
            for (int i = 0; i < items.size(); ++i) {
                box.addItem(items.get(i));
            }
        }
    }

    public static JComboBox getEditableBox(List items, Object selected) {
        JComboBox fld = new JComboBox();
        fld.setEditable(true);
        if (selected != null && !items.contains(selected)) {
            items.add(selected);
        }
        GuiUtils.setListData(fld, items);
        if (selected != null) {
            fld.setSelectedItem(selected);
        }
        return fld;
    }

    public static int getBoxValue(JComboBox box) {
        Object o = box.getSelectedItem();
        return (int)Misc.parseValue(o.toString());
    }

    public static JComboBox createValueBox(ActionListener listener, String command, int initValue, List values, boolean editable) {
        JComboBox box = new JComboBox(new Vector(values));
        if (editable) {
            box.setEditable(true);
        }
        box.setActionCommand(command);
        box.setSelectedItem(new Integer(initValue));
        box.addActionListener(listener);
        return box;
    }

    public static JMenuItem processXmlMenuItem(Node node, ActionListener listener, Hashtable menuItems) throws Exception {
        return GuiUtils.processXmlMenuItem(node, listener, menuItems, null);
    }

    public static JMenuItem processXmlMenuItem(Node node, ActionListener listener, Hashtable menuItems, Hashtable<String, ImageIcon> actionIcons) throws Exception {
        String tooltip;
        int keyCode;
        ImageIcon imageIcon;
        NamedNodeMap attrs = node.getAttributes();
        String label = Msg.msg(GuiUtils.getAttribute(attrs, "label"));
        String action = GuiUtils.getAttribute(attrs, ATTR_ACTION, (String)null);
        ImageIcon imageIcon2 = imageIcon = action != null && actionIcons != null ? actionIcons.get(action) : null;
        if (!GuiUtils.getIconsInMenus()) {
            imageIcon = null;
        }
        JMenuItem menuItem = imageIcon != null ? new JMenuItem(label, GuiUtils.scaleImageIcon(imageIcon)) : new JMenuItem(label);
        String mnemonic = GuiUtils.getAttribute(node, "mnemonic", (String)null);
        if (mnemonic != null && (keyCode = GuiUtils.charToKeyCode(mnemonic.trim().toUpperCase().charAt(0))) != -1) {
            menuItem.setMnemonic(keyCode);
        }
        if ((tooltip = GuiUtils.getAttribute(attrs, ATTR_TOOLTIP, (String)null)) != null) {
            menuItem.setToolTipText(tooltip);
        }
        String id = GuiUtils.getAttribute(attrs, ATTR_ID, (String)null);
        String icon = GuiUtils.getAttribute(attrs, ATTR_ICON, (String)null);
        menuItem.addActionListener(listener);
        if (action != null) {
            menuItem.setActionCommand(action);
        }
        if (icon != null) {
            GuiUtils.setIcon(menuItem, icon);
        }
        if (id != null) {
            menuItems.put(id, menuItem);
        }
        return menuItem;
    }

    public static int charToKeyCode(String s) {
        return GuiUtils.charToKeyCode(s.trim().toUpperCase().charAt(0));
    }

    public static int charToKeyCode(char ch) {
        if (ch == 'A' || ch == 'a') {
            return 65;
        }
        if (ch == 'B' || ch == 'b') {
            return 66;
        }
        if (ch == 'C' || ch == 'c') {
            return 67;
        }
        if (ch == 'D' || ch == 'd') {
            return 68;
        }
        if (ch == 'E' || ch == 'e') {
            return 69;
        }
        if (ch == 'F' || ch == 'f') {
            return 70;
        }
        if (ch == 'G' || ch == 'g') {
            return 71;
        }
        if (ch == 'H' || ch == 'h') {
            return 72;
        }
        if (ch == 'I' || ch == 'i') {
            return 73;
        }
        if (ch == 'J' || ch == 'j') {
            return 74;
        }
        if (ch == 'K' || ch == 'k') {
            return 75;
        }
        if (ch == 'L' || ch == 'l') {
            return 76;
        }
        if (ch == 'M' || ch == 'm') {
            return 77;
        }
        if (ch == 'N' || ch == 'n') {
            return 78;
        }
        if (ch == 'O' || ch == 'o') {
            return 79;
        }
        if (ch == 'P' || ch == 'p') {
            return 80;
        }
        if (ch == 'Q' || ch == 'q') {
            return 81;
        }
        if (ch == 'R' || ch == 'r') {
            return 82;
        }
        if (ch == 'S' || ch == 's') {
            return 83;
        }
        if (ch == 'T' || ch == 't') {
            return 84;
        }
        if (ch == 'U' || ch == 'u') {
            return 85;
        }
        if (ch == 'V' || ch == 'v') {
            return 86;
        }
        if (ch == 'W' || ch == 'w') {
            return 87;
        }
        if (ch == 'X' || ch == 'x') {
            return 88;
        }
        if (ch == 'Y' || ch == 'y') {
            return 89;
        }
        if (ch == 'Z' || ch == 'z') {
            return 90;
        }
        return -1;
    }

    public static JMenu processXmlMenu(Node menuNode, ActionListener listener, Hashtable menuItems) throws Exception {
        return GuiUtils.processXmlMenu(menuNode, listener, menuItems, null);
    }

    public static JMenu processXmlMenu(Node menuNode, ActionListener listener, Hashtable menuItems, Hashtable<String, ImageIcon> actionIcons) throws Exception {
        int keyCode;
        NamedNodeMap attrs = menuNode.getAttributes();
        String id = GuiUtils.getAttribute(attrs, ATTR_ID, (String)null);
        NodeList children = menuNode.getChildNodes();
        String label = Msg.msg(GuiUtils.getAttribute(attrs, "label"));
        JMenu menu = new JMenu(label);
        String mnemonic = GuiUtils.getAttribute(menuNode.getAttributes(), "mnemonic", (String)null);
        String icon = GuiUtils.getAttribute(attrs, ATTR_ICON, (String)null);
        if (icon != null) {
            GuiUtils.setIcon(menu, icon);
        }
        if (mnemonic != null && (keyCode = GuiUtils.charToKeyCode(mnemonic.trim().toUpperCase().charAt(0))) != -1) {
            menu.setMnemonic(keyCode);
        }
        JMenu menuToReturn = menu;
        if (id != null) {
            JMenu existing = (JMenu)menuItems.get(id);
            if (existing == null) {
                menuItems.put(id, menu);
            } else {
                menuToReturn = null;
                menu = existing;
                if (GuiUtils.getAttribute(menuNode.getAttributes(), "replace", false)) {
                    menu.removeAll();
                }
            }
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equals("menuitem")) {
                menu.add(GuiUtils.processXmlMenuItem(child, listener, menuItems, actionIcons));
                continue;
            }
            if (child.getNodeName().equals("menu")) {
                JMenu childMenu = GuiUtils.processXmlMenu(child, listener, menuItems, actionIcons);
                if (childMenu == null) continue;
                menu.add(childMenu);
                continue;
            }
            if (!child.getNodeName().equals("separator")) continue;
            menu.addSeparator();
        }
        return menuToReturn;
    }

    public static JMenuBar processXmlMenuBar(Element root, JMenuBar menuBar, ActionListener listener, Hashtable menuItems) {
        return GuiUtils.processXmlMenuBar(root, menuBar, listener, menuItems, null);
    }

    public static JMenuBar processXmlMenuBar(Element root, JMenuBar menuBar, ActionListener listener, Hashtable menuItems, Hashtable<String, ImageIcon> actionIcons) {
        if (root == null) {
            return menuBar;
        }
        if (menuBar == null) {
            menuBar = new JMenuBar();
        }
        try {
            List menus = GuiUtils.findChildren(root, "menu");
            for (int i = 0; i < menus.size(); ++i) {
                JMenu menu = GuiUtils.processXmlMenu((Node)menus.get(i), listener, menuItems, actionIcons);
                if (menu == null) continue;
                menuBar.add(menu);
            }
        }
        catch (Exception excp) {
            LogUtil.printException(log_, "Processing menu xml", excp);
        }
        return menuBar;
    }

    public static List getItems(JComboBox box) {
        ArrayList l = new ArrayList();
        for (int i = 0; i < box.getItemCount(); ++i) {
            l.add(box.getItemAt(i));
        }
        return l;
    }

    public static boolean isShowing(JFrame f) {
        if (f == null) {
            return false;
        }
        return f.isShowing() && f.getState() != 1;
    }

    public static boolean isShowing(JDialog f) {
        if (f == null) {
            return false;
        }
        return f.isShowing();
    }

    public static Image getImage(Component component) throws Exception {
        RepaintManager manager = RepaintManager.currentManager(component);
        double w = component.getWidth();
        double h = component.getHeight();
        BufferedImage image = new BufferedImage((int)w, (int)h, 1);
        Graphics2D g = (Graphics2D)image.getGraphics();
        component.paint(g);
        return image;
    }

    public static Component[] showHtmlDialog(String html, HyperlinkListener linkListener) {
        return GuiUtils.showHtmlDialog(html, "", linkListener);
    }

    public static Component[] showHtmlDialog(String html, String title, HyperlinkListener linkListener) {
        return GuiUtils.showHtmlDialog(html, title, null, linkListener, false);
    }

    public static Component[] getHtmlComponent(String html, HyperlinkListener linkListener, int width, int height) {
        JEditorPane editor = new JEditorPane();
        editor.setPreferredSize(new Dimension(width, height));
        editor.setEditable(false);
        editor.setContentType("text/html");
        editor.setText(html);
        if (linkListener != null) {
            editor.addHyperlinkListener(linkListener);
        }
        JScrollPane scroller = GuiUtils.makeScrollPane(editor, width, height);
        scroller.setBorder(BorderFactory.createLoweredBevelBorder());
        scroller.setPreferredSize(new Dimension(width, height));
        return new Component[]{editor, scroller};
    }

    public static Component[] showHtmlDialog(String html, String title, String label, HyperlinkListener linkListener, boolean modal) {
        Component[] comps = GuiUtils.getHtmlComponent(html, linkListener, 400, 600);
        JEditorPane editor = (JEditorPane)comps[0];
        JScrollPane scroller = (JScrollPane)comps[1];
        if (title == null) {
            title = "";
        }
        final JDialog window = GuiUtils.createDialog(title, modal);
        ActionListener windowCloser = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                window.dispose();
            }
        };
        JPanel buttons = GuiUtils.makeButtons(windowCloser, new String[]{CMD_CLOSE});
        JPanel contents = GuiUtils.centerBottom(scroller, buttons);
        if (label != null) {
            label = "<html><h4>" + label + "</h4></html>";
            contents = GuiUtils.topCenter(GuiUtils.inset((Component)new JLabel(label), 1), contents);
        }
        window.getContentPane().add(contents);
        window.pack();
        try {
            editor.setCaretPosition(0);
            editor.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Msg.translateTree(window);
        window.setVisible(true);
        return new Component[]{window, editor};
    }

    public static Hashtable initializeExpandedPathsBeforeChange(JTree tree, DefaultMutableTreeNode root) {
        Enumeration<TreePath> paths = tree.getExpandedDescendants(new TreePath(root.getPath()));
        Hashtable<String, Boolean> expandedPaths = new Hashtable<String, Boolean>();
        if (paths != null) {
            while (paths.hasMoreElements()) {
                TreePath treePath = paths.nextElement();
                expandedPaths.put(treePath.toString(), Boolean.TRUE);
            }
        }
        return expandedPaths;
    }

    public static void expandPathsAfterChange(JTree tree, Hashtable state, DefaultMutableTreeNode root) {
        TreePath path = new TreePath(root.getPath());
        if (state.get(path.toString()) != null) {
            tree.expandPath(path);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            GuiUtils.expandPathsAfterChange(tree, state, (DefaultMutableTreeNode)root.getChildAt(i));
        }
    }

    public static TreeSearchResults doTreeSearch(JTree tree, Object lastState, String nodeDesc, JComponent near) {
        return GuiUtils.doTreeSearch(tree, lastState, nodeDesc, near, null);
    }

    public static void limitMenuSize(List items, String name, int size) {
        for (int i = 0; i < items.size(); ++i) {
            Object o = items.get(i);
            if (!(o instanceof JMenu)) continue;
            JMenu menu = (JMenu)o;
            GuiUtils.limitMenuSize(menu, name, size);
        }
    }

    public static void limitMenuSize(JMenu menu, String name, int size) {
        GuiUtils.limitMenuSize(menu, name, size, true);
    }

    public static void limitMenuSize(JMenu menu, String name, int size, boolean recurse) {
        int cnt = menu.getItemCount();
        ArrayList<JMenuItem> subMenus = new ArrayList<JMenuItem>();
        ArrayList<JMenuItem> subItems = new ArrayList<JMenuItem>();
        for (int i = 0; i < cnt; ++i) {
            JMenuItem mi = menu.getItem(i);
            subItems.add(mi);
            if (!(mi instanceof JMenu)) continue;
            subMenus.add(mi);
        }
        if (recurse) {
            GuiUtils.limitMenuSize(subMenus, name, size);
        }
        if (cnt >= size) {
            menu.removeAll();
            JMenu currentMenu = new JMenu(name + " 1");
            menu.add(currentMenu);
            for (int i = 0; i < subItems.size(); ++i) {
                JMenuItem mi = (JMenuItem)subItems.get(i);
                if (currentMenu.getItemCount() >= size) {
                    currentMenu = new JMenu(name + " " + (menu.getItemCount() + 1));
                    menu.add(currentMenu);
                }
                if (mi == null) continue;
                currentMenu.add(mi);
            }
        }
    }

    public static TreeSearchResults doTreeSearch(JTree tree, Object lastState, String nodeDesc, JComponent near, String originalPhrase) {
        String startAt = null;
        String searchString = "";
        String label = "Search for a " + nodeDesc;
        if (lastState != null) {
            searchString = (String)((Object[])lastState)[0];
            startAt = (String)((Object[])lastState)[1];
        }
        if (originalPhrase != null) {
            searchString = originalPhrase;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        Object node = null;
        boolean success = false;
        do {
            Object treeRoot;
            if (originalPhrase == null) {
                String s = GuiUtils.getInput(label, "Search For: ", searchString, null, null, "", 20, near);
                if (s == null) break;
                searchString = s;
            }
            if ((node = GuiUtils.treeSearch(treeModel, treeRoot = tree.getModel().getRoot(), searchString, new Object[]{startAt})) != null) {
                success = true;
                Object[] pathArray = treeModel.getPathToRoot((TreeNode)node);
                TreePath path = new TreePath(pathArray);
                tree.setSelectionPath(path);
                tree.scrollPathToVisible(path);
                break;
            }
            tree.clearSelection();
            startAt = null;
            label = "Could not find " + nodeDesc;
        } while (originalPhrase == null);
        return new TreeSearchResults(success, new Object[]{searchString, node != null ? node.toString() : (String)null});
    }

    private static Object treeSearch(DefaultTreeModel treeModel, Object node, String s, Object[] startAt) {
        if (startAt[0] == null && StringUtil.stringMatch(node.toString(), s, true, false)) {
            return node;
        }
        if (startAt[0] != null && Misc.equals(startAt[0].toString(), node.toString())) {
            startAt[0] = null;
        }
        int cnt = treeModel.getChildCount(node);
        for (int i = 0; i < cnt; ++i) {
            Object child = treeModel.getChild(node, i);
            if ((child = GuiUtils.treeSearch(treeModel, child, s, startAt)) == null) continue;
            return child;
        }
        return null;
    }

    public static String toCsv(TableModel model) {
        return GuiUtils.toCsv(model, false);
    }

    public static String toCsv(TableModel model, boolean includeColumnNames) {
        StringBuffer sb = new StringBuffer();
        int rows = model.getRowCount();
        int cols = model.getColumnCount();
        if (includeColumnNames) {
            for (int col = 0; col < cols; ++col) {
                if (col > 0) {
                    sb.append(",");
                }
                sb.append(model.getColumnName(col));
            }
            sb.append("\n");
        }
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                if (col > 0) {
                    sb.append(",");
                }
                sb.append(model.getValueAt(row, col));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void exportAsCsv(TableModel model) {
        GuiUtils.exportAsCsv("", model, false);
    }

    public static void exportAsCsv(String header, TableModel model) {
        GuiUtils.exportAsCsv(header, model, false);
    }

    public static void exportAsCsv(String header, TableModel model, boolean includeColumnNames) {
        String filename = FileManager.getWriteFile(Misc.newList(FileManager.FILTER_CSV, FileManager.FILTER_XLS), ".csv");
        if (filename == null) {
            return;
        }
        GuiUtils.exportAsCsv(header, model, filename, includeColumnNames);
    }

    public static void exportAsCsv(String header, TableModel model, String filename) {
        GuiUtils.exportAsCsv(header, model, filename, false);
    }

    public static void exportAsCsv(String header, TableModel model, String filename, boolean includeColumnNames) {
        if (filename.toLowerCase().endsWith(".xls")) {
            try {
                Class c = Misc.findClass("ucar.unidata.data.DataUtil");
                Method method = Misc.findMethod(c, "writeXls", new Class[]{String.class, List.class});
                ArrayList rows = new ArrayList();
                int numRows = model.getRowCount();
                int numCols = model.getColumnCount();
                if (includeColumnNames) {
                    ArrayList<String> colNames = new ArrayList<String>();
                    for (int i = 0; i < model.getColumnCount(); ++i) {
                        colNames.add(model.getColumnName(i));
                    }
                    rows.add(colNames);
                }
                for (int row = 0; row < numRows; ++row) {
                    ArrayList<Object> cols = new ArrayList<Object>();
                    rows.add(cols);
                    for (int col = 0; col < numCols; ++col) {
                        cols.add(model.getValueAt(row, col));
                    }
                }
                method.invoke(null, filename, rows);
            }
            catch (Exception exc) {
                LogUtil.logException("Exporting data to xsl", exc);
            }
            return;
        }
        String csv = GuiUtils.toCsv(model, includeColumnNames);
        if (csv == null) {
            return;
        }
        if (header == null) {
            header = "";
        }
        try {
            String output = header == null || header.equals("") ? csv : header + "\n" + csv;
            IOUtil.writeFile(filename, output);
        }
        catch (Exception exc) {
            LogUtil.logException("Exporting data", exc);
        }
    }

    public static void setupDirectoryChooser(JButton btn, JTextField directoryFld) {
        GuiUtils.setupFileChooser(btn, directoryFld, true);
    }

    public static void setupFileChooser(JButton btn, final JTextField directoryFld, final boolean justDirectories) {
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = new JFileChooser(new File(directoryFld.getText().trim()));
                if (justDirectories) {
                    chooser.setFileSelectionMode(1);
                }
                File file = chooser.getSelectedFile();
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    directoryFld.setText(chooser.getSelectedFile().toString());
                }
            }
        });
    }

    public static JCheckBox makeCheckbox(String label, Object object, String property) {
        return GuiUtils.makeCheckbox(label, object, property, null);
    }

    public static JCheckBox makeCheckbox(String label, final Object object, final String property, final Object arg) {
        boolean value = true;
        try {
            Class[] classArray;
            String methodName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            Class<?> clazz = object.getClass();
            if (arg == null) {
                classArray = new Class[]{};
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = arg.getClass();
            }
            Method theMethod = Misc.findMethod(clazz, methodName, classArray);
            if (theMethod != null) {
                Object[] objectArray;
                if (arg == null) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = arg;
                }
                Boolean v = (Boolean)theMethod.invoke(object, objectArray);
                value = v;
            }
        }
        catch (Exception exc) {
            System.err.println("Error in makeCeckbox:" + exc);
            exc.printStackTrace();
        }
        final JCheckBox cbx = new JCheckBox(label, value);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    Class[] classArray;
                    String methodName = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
                    Class<?> clazz = object.getClass();
                    if (arg == null) {
                        Class[] classArray2 = new Class[1];
                        classArray = classArray2;
                        classArray2[0] = Boolean.TYPE;
                    } else {
                        Class[] classArray3 = new Class[2];
                        classArray3[0] = Boolean.TYPE;
                        classArray = classArray3;
                        classArray3[1] = arg.getClass();
                    }
                    Method theMethod = Misc.findMethod(clazz, methodName, classArray);
                    if (theMethod == null) {
                        System.err.println("Unknown method:" + object.getClass() + "." + methodName);
                    } else {
                        Object[] objectArray;
                        if (arg == null) {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = new Boolean(cbx.isSelected());
                        } else {
                            Object[] objectArray3 = new Object[2];
                            objectArray3[0] = new Boolean(cbx.isSelected());
                            objectArray = objectArray3;
                            objectArray3[1] = arg;
                        }
                        theMethod.invoke(object, objectArray);
                    }
                }
                catch (Exception exc) {
                    System.err.println("Error in makeCheckbox:" + exc);
                    exc.printStackTrace();
                }
            }
        };
        cbx.addActionListener(listener);
        return cbx;
    }

    public static JRadioButton[] makeRadioButtons(List labels, int selectedIndex, final Object object, String methodName) {
        try {
            final Method theMethod = Misc.findMethod(object.getClass(), methodName, new Class[]{Integer.TYPE});
            JRadioButton[] rbs = new JRadioButton[labels.size()];
            ButtonGroup bg = new ButtonGroup();
            for (int i = 0; i < labels.size(); ++i) {
                final int theIndex = i;
                JRadioButton rb = new JRadioButton(labels.get(i).toString(), i == selectedIndex);
                bg.add(rb);
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        try {
                            theMethod.invoke(object, new Integer(theIndex));
                        }
                        catch (Exception exc) {
                            System.err.println("Error in makeCheckbox:" + exc);
                            exc.printStackTrace();
                        }
                    }
                };
                rb.addActionListener(listener);
                rbs[i] = rb;
            }
            return rbs;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Error in makeCeckbox:" + exc);
        }
    }

    public static JButton makeButton(String label, Object object, String methodName) {
        return GuiUtils.makeButton(label, object, methodName, null);
    }

    public static JButton makeButton(String label, Object object, String methodName, Object arg) {
        return GuiUtils.makeButton(label, object, methodName, arg, null);
    }

    public static JButton makeButton(String label, Object object, String methodName, Object arg, String tooltip) {
        JButton btn = new JButton(label);
        btn.addActionListener(GuiUtils.makeActionListener(object, methodName, arg));
        if (tooltip != null) {
            btn.setToolTipText(tooltip);
        }
        return btn;
    }

    public static ActionListener makeActionListener(final Object object, final String methodName, final Object arg) {
        final Method theMethod = GuiUtils.findMethod(object, methodName, arg);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    if (arg == null) {
                        theMethod.invoke(object, new Object[0]);
                    } else {
                        theMethod.invoke(object, arg);
                    }
                }
                catch (Exception exc) {
                    LogUtil.logException("Error in makeActionListener calling:" + methodName, exc);
                }
            }
        };
        return listener;
    }

    public static void invokeInSwingThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exc) {
                throw new WrapperException("Error invoking in swing thread", exc);
            }
        }
    }

    public static JButton makeImageButton(String label, Object object, String methodName) {
        return GuiUtils.makeImageButton(label, object, methodName, null);
    }

    public static JButton makeImageButton(String label, Object object, String methodName, Object arg) {
        return GuiUtils.makeImageButton(label, object, methodName, arg, false);
    }

    public static JButton makeImageButton(String label, Object object, String methodName, Object arg, boolean addMouseOverBorder) {
        JButton btn = GuiUtils.getImageButton(label, GuiUtils.class);
        btn.setBackground(null);
        if (addMouseOverBorder) {
            GuiUtils.makeMouseOverBorder(btn);
        }
        return (JButton)GuiUtils.addActionListener(btn, object, methodName, arg);
    }

    public static JComponent addActionListener(JComponent comp, final Object object, final String methodName, final Object arg) {
        final Method theMethod = GuiUtils.findMethod(object, methodName, arg);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    if (arg == null) {
                        theMethod.invoke(object, new Object[0]);
                    } else {
                        theMethod.invoke(object, arg);
                    }
                }
                catch (Exception exc) {
                    LogUtil.logException("Error in makeButton calling:" + methodName, exc);
                }
            }
        };
        if (comp instanceof AbstractButton) {
            ((AbstractButton)comp).addActionListener(listener);
        } else if (comp instanceof JTextField) {
            ((JTextField)comp).addActionListener(listener);
        } else {
            throw new IllegalArgumentException("Cannot add action listener");
        }
        return comp;
    }

    public static JMenu makeDynamicMenu(String name, Object object, String methodName) {
        return GuiUtils.makeDynamicMenu(name, object, methodName, true);
    }

    public static JMenu makeDynamicMenu(final String name, final Object object, String methodName, final boolean doRemoveAll) {
        final JMenu menu = new JMenu(name);
        final Method theMethod = GuiUtils.findMethod(object, methodName, menu);
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                try {
                    if (doRemoveAll) {
                        menu.removeAll();
                    }
                    theMethod.invoke(object, menu);
                }
                catch (Exception exc) {
                    LogUtil.logException("Error in makeDynamicMenu:" + name, exc);
                }
            }
        });
        return menu;
    }

    public static JComboBox makeComboBox(List items, Object selected, boolean editable, Object listener, String methodName) {
        return GuiUtils.makeComboBox(items, selected, editable, listener, methodName, false);
    }

    public static JComboBox makeComboBox(List items, Object selected, boolean editable, final Object listener, String methodName, boolean inAThread) {
        final Method theMethod = GuiUtils.findMethod(listener, methodName, selected == null ? new Object() : selected);
        final JComboBox box = new JComboBox(new Vector(items));
        if (selected != null) {
            box.setSelectedItem(selected);
        }
        if (editable) {
            Dimension preferred = box.getPreferredSize();
            box.setEditable(true);
            if (GuiUtils.checkHeight(preferred.height)) {
                box.setPreferredSize(preferred);
            }
        }
        box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    theMethod.invoke(listener, box.getSelectedItem());
                }
                catch (Exception exc) {
                    System.err.println("Error invoking method" + exc);
                    exc.printStackTrace();
                }
            }
        });
        return box;
    }

    public static JComboBox makeComboBox(int[] values, String[] labels, int current) {
        List l = TwoFacedObject.createList(values, labels);
        JComboBox box = new JComboBox(new Vector(l));
        TwoFacedObject selected = TwoFacedObject.findId(new Integer(current), l);
        if (selected != null) {
            box.setSelectedItem(selected);
        }
        return box;
    }

    public static void setValueOfBox(JComboBox box, int value, int[] values, String[] labels) {
        for (int i = 0; i < values.length; ++i) {
            if (value != values[i]) continue;
            box.setSelectedItem(new TwoFacedObject((Object)labels[i], value));
            return;
        }
        box.setSelectedItem(new TwoFacedObject((Object)("" + value), value));
    }

    public static int getValueFromBox(JComboBox box) {
        TwoFacedObject tfo = (TwoFacedObject)box.getSelectedItem();
        return (Integer)tfo.getId();
    }

    public static JSlider makeSlider(int min, int max, int value, Object listener, String methodName) {
        return GuiUtils.makeSlider(min, max, value, listener, methodName, false);
    }

    public static JSlider makeSlider(int min, int max, int value, final Object listener, String methodName, final boolean updateAsMove) {
        final Method theMethod = GuiUtils.findMethodWithClass(listener, methodName, Integer.TYPE);
        JSlider slider = new JSlider(min, max, value);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slider = (JSlider)e.getSource();
                if (updateAsMove || !slider.getValueIsAdjusting()) {
                    int value = slider.getValue();
                    try {
                        theMethod.invoke(listener, new Integer(value));
                    }
                    catch (Exception exc) {
                        System.err.println("Error invoking method" + exc);
                        exc.printStackTrace();
                    }
                }
            }
        });
        return slider;
    }

    private static Method findMethod(Object object, String methodName, Object arg) {
        Method theMethod = null;
        theMethod = arg == null ? Misc.findMethod(object.getClass(), methodName, new Class[0]) : Misc.findMethod(object.getClass(), methodName, new Class[]{arg.getClass()});
        if (theMethod == null) {
            System.err.println("arg = " + arg);
            throw new IllegalArgumentException("Unknown method:" + object.getClass() + "." + methodName + "(" + (arg == null ? "" : arg.getClass().getName()) + ")");
        }
        return theMethod;
    }

    private static Method findMethodWithClass(Object object, String methodName, Class c) {
        Method theMethod = null;
        theMethod = Misc.findMethod(object.getClass(), methodName, new Class[]{c});
        if (theMethod == null) {
            throw new IllegalArgumentException("Unknown method:" + object.getClass() + "." + methodName);
        }
        return theMethod;
    }

    public static Vector getFontSizeList() {
        int[] fontSizes = FONT_SIZES;
        Vector<Integer> fontSizeList = new Vector<Integer>();
        for (int i = 0; i < FONT_SIZES.length; ++i) {
            fontSizeList.add(new Integer(FONT_SIZES[i]));
        }
        return fontSizeList;
    }

    public static Vector getFontList() {
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        Vector<TwoFacedObject> fontList = new Vector<TwoFacedObject>();
        Object selected = null;
        for (int i = 0; i < fonts.length; ++i) {
            fontList.add(GuiUtils.makeTwoFacedFont(fonts[i]));
        }
        return fontList;
    }

    public static TwoFacedObject makeTwoFacedFont(Font f) {
        return new TwoFacedObject((Object)StringUtil.shorten(f.getName(), 24), f);
    }

    public static void makeRowVisible(JTable table, int row) {
        Rectangle cellRect = table.getCellRect(row, 0, true);
        if (cellRect != null) {
            table.scrollRectToVisible(cellRect);
        }
    }

    public static void scrollToTop(final JEditorPane editor) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    editor.scrollRectToVisible(new Rectangle(1, 1, 1, 1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static void addMouseListenerRecurse(MouseListener listener, Container c) {
        c.addMouseListener(listener);
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component child = c.getComponent(i);
            if (!(child instanceof Container)) continue;
            GuiUtils.addMouseListenerRecurse(listener, (Container)child);
        }
    }

    public static void addKeyListenerRecurse(KeyListener listener, Container c) {
        c.addKeyListener(listener);
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component child = c.getComponent(i);
            if (!(child instanceof Container)) continue;
            GuiUtils.addKeyListenerRecurse(listener, (Container)child);
        }
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static double distance(double[] p1, double[] p2) {
        return GuiUtils.distance(p1[0], p1[1], p2[0], p2[1]);
    }

    public static double distance(int[] p1, int[] p2) {
        return GuiUtils.distance(p1[0], p1[1], p2[0], p2[1]);
    }

    public static double distance(double x, double y, Rectangle2D r) {
        double minDistance = GuiUtils.distance(x, y, r.getX(), r.getY());
        minDistance = Math.min(minDistance, GuiUtils.distance(x, y, r.getX(), r.getY() + r.getHeight()));
        minDistance = Math.min(minDistance, GuiUtils.distance(x, y, r.getX() + r.getWidth(), r.getY()));
        minDistance = Math.min(minDistance, GuiUtils.distance(x, y, r.getX() + r.getWidth(), r.getY() + r.getHeight()));
        if (y >= r.getY() && y <= r.getY() + r.getHeight()) {
            minDistance = Math.min(minDistance, Math.min(Math.abs(x - r.getX()), Math.abs(x - (r.getX() + r.getWidth()))));
        }
        if (x >= r.getX() && x <= r.getX() + r.getWidth()) {
            minDistance = Math.min(minDistance, Math.min(Math.abs(y - r.getY()), Math.abs(y - (r.getY() + r.getHeight()))));
        }
        return minDistance;
    }

    public static JLabel makeVerticalLabel(String text) {
        JLabel l = new JLabel(text);
        l.setUI(new VerticalLabelUI(false));
        return l;
    }

    public static JComponent doMultiSplitPane(List comps, boolean hsplit) {
        JSplitPane split;
        if (comps.size() == 0) {
            return null;
        }
        if (comps.size() == 1) {
            return (JComponent)comps.get(0);
        }
        if (comps.size() == 2) {
            split = hsplit ? GuiUtils.hsplit((Component)comps.get(0), (Component)comps.get(1), 0.5) : GuiUtils.vsplit((Component)comps.get(0), (Component)comps.get(1), 0.5);
        } else {
            Component comp = (Component)comps.get(0);
            comps.remove(0);
            int size = comps.size();
            split = hsplit ? GuiUtils.hsplit(comp, GuiUtils.doMultiSplitPane(comps, hsplit)) : GuiUtils.vsplit(comp, GuiUtils.doMultiSplitPane(comps, hsplit));
            split.setResizeWeight(1.0 / (double)(++size));
        }
        split.setOneTouchExpandable(true);
        return split;
    }

    public static JTabbedPane getNestedTabbedPane() {
        return GuiUtils.getNestedTabbedPane(1);
    }

    public static JTabbedPane getNestedTabbedPane(int orient) {
        if (orient == 1) {
            return GuiUtils.getNestedTabbedPane(orient, 1, 0, 0, 0);
        }
        if (orient == 3) {
            return GuiUtils.getNestedTabbedPane(orient, 0, 0, 1, 0);
        }
        if (orient == 2) {
            return GuiUtils.getNestedTabbedPane(orient, 1, 1, 0, 0);
        }
        return GuiUtils.getNestedTabbedPane(orient, 1, 0, 0, 1);
    }

    public static JTabbedPane getNestedTabbedPane(int orient, int top, int left, int bottom, int right) {
        Insets oldInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        Insets insets = new Insets(top, left, bottom, right);
        UIManager.put("TabbedPane.contentBorderInsets", insets);
        JTabbedPane tabPane = new JTabbedPane(orient);
        UIManager.put("TabbedPane.contentBorderInsets", oldInsets);
        return tabPane;
    }

    public static JComponent[] makeSliderPopup(int min, int max, int value, ChangeListener listener) {
        final JButton btn = GuiUtils.getImageButton("/auxdata/ui/icons/Slider16.gif", GuiUtils.class);
        GuiUtils.makeMouseOverBorder(btn);
        btn.setToolTipText("Change the Value");
        final JSlider slider = new JSlider(min, max, value);
        final JDialog[] dialogArray = new JDialog[]{null};
        slider.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (dialogArray[0] != null) {
                    dialogArray[0].dispose();
                }
                dialogArray[0] = null;
            }
        });
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10 || ke.getKeyCode() == 27) {
                    if (dialogArray[0] != null) {
                        dialogArray[0].dispose();
                    }
                    dialogArray[0] = null;
                }
            }
        };
        slider.addKeyListener(keyListener);
        slider.addChangeListener(listener);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialogArray[0] = GuiUtils.createDialog(GuiUtils.getWindow(btn), "", false);
                JDialog d = dialogArray[0];
                dialogArray[0].setUndecorated(true);
                JButton closeBtn = GuiUtils.getImageButton("/auxdata/ui/icons/cancel.gif", GuiUtils.class);
                GuiUtils.makeMouseOverBorder(closeBtn);
                closeBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if (dialogArray[0] != null) {
                            dialogArray[0].dispose();
                        }
                        dialogArray[0] = null;
                    }
                });
                JPanel panel = LayoutUtil.leftCenter(GuiUtils.top(closeBtn), slider);
                panel = LayoutUtil.inset((Component)panel, 1);
                panel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
                d.getContentPane().add(panel);
                d.pack();
                Msg.translateTree(d);
                Point loc = btn.getLocationOnScreen();
                loc.y += btn.getSize().height;
                d.setLocation(loc);
                slider.requestFocus();
                d.setVisible(true);
            }
        });
        return new JComponent[]{btn, slider};
    }

    public static void positionAndFitToScreen(Window window, Rectangle bounds) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int diff = bounds.x + bounds.width - screenSize.width;
        if (diff > 0) {
            bounds.x -= Math.min(diff, bounds.x);
            diff = screenSize.width - (bounds.x + bounds.width);
            if (diff > 0) {
                bounds.width -= diff;
            }
        }
        if ((diff = bounds.y + bounds.height - screenSize.height) > 0) {
            bounds.y -= Math.min(diff, bounds.y);
            diff = screenSize.height - (bounds.y + bounds.height);
            if (diff > 0) {
                bounds.height -= diff;
            }
        }
        window.setBounds(bounds);
    }

    public static void toggleHeavyWeightComponents(Component comp, boolean visible) {
        if (!(comp instanceof JComponent) && !comp.getClass().getName().startsWith("javax.swing")) {
            comp.setVisible(visible);
        }
        if (!(comp instanceof Container)) {
            return;
        }
        Container cont = (Container)comp;
        if (visible && cont instanceof JTabbedPane) {
            GuiUtils.checkHeavyWeightComponents((JTabbedPane)cont);
            return;
        }
        Component[] comps = cont.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Component child = comps[i];
            GuiUtils.toggleHeavyWeightComponents(child, visible);
        }
    }

    public static void checkHeavyWeightComponents(JTabbedPane tab) {
        Component[] comps = tab.getComponents();
        int selectedIdx = tab.getSelectedIndex();
        for (int i = 0; i < comps.length; ++i) {
            GuiUtils.toggleHeavyWeightComponents(comps[i], i == selectedIdx);
        }
    }

    public static void resetHeavyWeightComponents(JTabbedPane tab) {
        Component[] comps = tab.getComponents();
        int selectedIdx = tab.getSelectedIndex();
        for (int i = 0; i < comps.length; ++i) {
            GuiUtils.toggleHeavyWeightComponents(comps[i], true);
        }
    }

    public static void handleHeavyWeightComponentsInTabs(final JTabbedPane tab) {
        tab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GuiUtils.checkHeavyWeightComponents(tab);
            }
        });
    }

    public static void main(String[] args) throws Exception {
        JTextField fld = new JTextField("", 20);
        JTextArea tarea = new JTextArea("", 10, 10);
        GuiUtils.addKeyBindings(fld);
        GuiUtils.addKeyBindings(tarea);
        Action[] actions = tarea.getActions();
        for (int i = 0; i < actions.length; ++i) {
        }
        GuiUtils.showOkCancelDialog(null, "", GuiUtils.vbox(fld, tarea), null);
    }

    public static JButton makeFileBrowseButton(JTextComponent fld) {
        return GuiUtils.makeFileBrowseButton(fld, null);
    }

    public static JButton makeFileBrowseButton(JTextComponent fld, List filters) {
        return GuiUtils.makeFileBrowseButton(fld, false, filters);
    }

    public static JButton makeFileBrowseButton(final JTextComponent fld, final boolean chooseDirectory, final List filters) {
        JButton browseButton = new JButton(chooseDirectory ? "Select Directory..." : "Select File...");
        browseButton.setToolTipText(chooseDirectory ? "Choose a directory" : "Choose a file from disk");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser;
                File f = new File(fld.getText());
                JFileChooser jFileChooser = chooser = (f = f.getParentFile()) != null && f.exists() ? new JFileChooser(f) : new JFileChooser();
                if (chooseDirectory) {
                    chooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory();
                        }

                        @Override
                        public String getDescription() {
                            return "Directories";
                        }
                    });
                    chooser.setAcceptAllFileFilterUsed(false);
                    chooser.setFileSelectionMode(1);
                } else if (filters != null) {
                    for (int i = 0; i < filters.size(); ++i) {
                        chooser.addChoosableFileFilter((FileFilter)filters.get(i));
                    }
                    if (filters.size() > 0) {
                        chooser.setFileFilter((FileFilter)filters.get(0));
                    }
                }
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    fld.setText(chooser.getSelectedFile().toString());
                }
            }
        });
        return browseButton;
    }

    public static JComboBox doMakeFontBox(Font f) {
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        ArrayList<TwoFacedObject> fontList = new ArrayList<TwoFacedObject>();
        String theName = null;
        if (f != null) {
            theName = f.getName().toLowerCase();
        }
        TwoFacedObject selected = null;
        for (int i = 0; i < fonts.length; ++i) {
            String name = fonts[i].getName();
            if (name.length() > 24) {
                name = name.substring(0, 23) + "...";
            }
            TwoFacedObject tfo = new TwoFacedObject((Object)name, fonts[i]);
            String fontName = fonts[i].getName().toLowerCase();
            if (selected == null && theName != null && (theName.equalsIgnoreCase(fonts[i].getName()) || fontName.startsWith(theName + "."))) {
                selected = tfo;
            }
            fontList.add(tfo);
        }
        JComboBox fontBox = new JComboBox();
        GuiUtils.setListData(fontBox, fontList);
        if (selected != null) {
            fontBox.setSelectedItem(selected);
        }
        return fontBox;
    }

    public static JComboBox doMakeFontSizeBox(int size) {
        JComboBox fontSizeBox = new JComboBox(GuiUtils.getFontSizeList());
        fontSizeBox.setSelectedItem(new Integer(size));
        return fontSizeBox;
    }

    public static Component italicizeFont(Component comp) {
        Font f;
        if (comp != null && (f = comp.getFont()) != null) {
            comp.setFont(f.deriveFont(2));
        }
        return comp;
    }

    public static void popupUnitMenu(JTextField fld, JComponent comp) {
        String[] unitGroups = new String[]{"Date/Time", "yyyy-MM-dd HH:mm:ss;MM/dd/yy HH:mm z;dd.MM.yy HH:mm z;yyyy-MM-dd;EEE, MMM dd yyyy HH:mm z;HH:mm:ss;HH:mm;yyyy-MM-dd'T'HH:mm:ss'Z';yyyy-MM-dd'T'HH:mm:ssz;yyyy-MM-dd'T'HH:mm:ssZ", "Geo-spatial", "degree;degree_west", "Distance", "foot;kilometer;meter;mile", "Temperature", "Celsius;Kelvin;Fahrenheit", "Speed", "m/sec;mi/hr;km/hr;furlong/fortnight", "Misc", "Text"};
        ArrayList<JMenu> menus = new ArrayList<JMenu>();
        for (int groupIdx = 0; groupIdx < unitGroups.length; groupIdx += 2) {
            String name = unitGroups[groupIdx];
            List<String> units = StringUtil.split(unitGroups[groupIdx + 1], ";");
            ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
            for (int i = 0; i < units.size(); ++i) {
                items.add(GuiUtils.makeMenuItem(units.get(i).toString(), fld, "setText", units.get(i).toString()));
            }
            menus.add(GuiUtils.makeMenu(name, items));
        }
        GuiUtils.showPopupMenu(menus, comp);
    }

    public static boolean getIconsInMenus() {
        return setIconsInMenus;
    }

    public static void setIconsInMenus(boolean doIcons) {
        setIconsInMenus = doIcons;
    }

    public static AbstractButton setIcon(AbstractButton button, String iconPath) {
        if (setIconsInMenus) {
            button.setIcon(GuiUtils.getScaledImageIcon(iconPath, GuiUtils.class, true));
            button.setIconTextGap(2);
        }
        return button;
    }

    public static void setSelectedItems(JList list, List selected) {
        List items = GuiUtils.getItems(list);
        int cnt = 0;
        int[] indices = new int[items.size()];
        for (int i = 0; i < selected.size(); ++i) {
            int idx = items.indexOf(selected.get(i));
            if (idx < 0) continue;
            indices[cnt++] = idx;
        }
        if (cnt > 0) {
            int[] realIndices = new int[cnt];
            for (int i = 0; i < cnt; ++i) {
                realIndices[i] = indices[i];
            }
            list.setSelectedIndices(realIndices);
        }
    }

    public static List getItems(JList list) {
        ArrayList items = new ArrayList();
        ListModel model = list.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            items.add(model.getElementAt(i));
        }
        return items;
    }

    public static String getLocalName(String n, boolean local) {
        return GuiUtils.getLocalName(n, local, true);
    }

    public static String getLocalName(String n, boolean local, boolean addHtml) {
        return (addHtml ? "<html>" : "") + n + (local ? " &lt;<span style=\"color:blue\">local</span>&gt;" : "") + (addHtml ? "</html>" : "");
    }

    public static void appendText(JTextComponent fld, String s, String delimiter) {
        String t = fld.getText();
        while (t.endsWith(" ")) {
            t = t.substring(0, t.length() - 1);
        }
        if (t.length() > 0 && !t.endsWith(delimiter)) {
            t = t + delimiter;
        }
        t = t + s;
        fld.setText(t);
    }

    public static void addKeyBindings(final JTextComponent comp) {
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int endPos;
                String t;
                if (!e.isControlDown()) {
                    return;
                }
                int pos = comp.getCaretPosition();
                if (e.getKeyCode() == 66) {
                    if (comp.getCaretPosition() > 0) {
                        comp.setCaretPosition(pos - 1);
                    }
                    return;
                }
                if (e.getKeyCode() == 70) {
                    if (comp.getCaretPosition() < comp.getText().length()) {
                        comp.setCaretPosition(pos + 1);
                    }
                    return;
                }
                if (e.getKeyCode() == 69) {
                    t = comp.getText();
                    endPos = t.indexOf("\n", pos);
                    if (endPos >= 0) {
                        comp.setCaretPosition(endPos);
                    } else {
                        comp.setCaretPosition(t.length());
                    }
                }
                if (e.getKeyCode() == 79 && comp instanceof JTextArea) {
                    t = comp.getText();
                    t = t.substring(0, pos) + "\n" + t.substring(pos);
                    comp.setText(t);
                    comp.setCaretPosition(pos);
                }
                if (e.getKeyCode() == 75) {
                    t = comp.getText();
                    if (pos >= t.length()) {
                        return;
                    }
                    endPos = t.indexOf("\n", pos);
                    t = endPos == pos ? t.substring(0, pos) + t.substring(endPos + 1) : (endPos > pos ? t.substring(0, pos) + "\n" + t.substring(endPos + 1) : t.substring(0, pos));
                    comp.setText(t);
                    comp.setCaretPosition(pos);
                }
                if (e.getKeyCode() == 68) {
                    t = comp.getText();
                    if (pos >= t.length()) {
                        return;
                    }
                    t = pos > 0 ? t.substring(0, pos) + t.substring(pos + 1) : t.substring(pos + 1);
                    comp.setText(t);
                    if (pos >= 0 && pos < t.length()) {
                        comp.setCaretPosition(pos);
                    }
                }
            }
        });
    }

    public static void moveSubtreesToTop(DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode child;
        int i;
        boolean gotAny = false;
        List children = Misc.toList(parent.children());
        for (i = 0; i < children.size() && !gotAny; ++i) {
            child = (DefaultMutableTreeNode)children.get(i);
            gotAny = child.getChildCount() > 0;
        }
        if (!gotAny) {
            return;
        }
        for (i = children.size() - 1; i >= 0; --i) {
            child = (DefaultMutableTreeNode)children.get(i);
            if (child.getChildCount() <= 0) continue;
            GuiUtils.moveSubtreesToTop(child);
            parent.remove(child);
            parent.insert(child, 0);
        }
    }

    public static JComponent makeHeader(String label) {
        JComponent header = GuiUtils.lLabel(label);
        header = GuiUtils.left(GuiUtils.inset((Component)header, new Insets(10, 5, 0, 0)));
        header.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray.darker()));
        header = GuiUtils.inset((Component)header, new Insets(0, 0, 0, 10));
        return header;
    }

    public static String getAttribute(Node element, String name, String dflt) {
        if (element == null) {
            return dflt;
        }
        return GuiUtils.getAttribute(element.getAttributes(), name, dflt);
    }

    public static String getAttribute(NamedNodeMap attrs, String name, String dflt) {
        if (attrs == null) {
            return dflt;
        }
        Node n = attrs.getNamedItem(name);
        return n == null ? dflt : n.getNodeValue();
    }

    public static boolean getAttribute(NamedNodeMap attrs, String name, boolean dflt) {
        if (attrs == null) {
            return dflt;
        }
        Node n = attrs.getNamedItem(name);
        return n == null ? dflt : new Boolean(n.getNodeValue());
    }

    public static String getAttribute(NamedNodeMap attrs, String name) {
        String value = GuiUtils.getAttribute(attrs, name, (String)null);
        if (value == null) {
            throw new IllegalArgumentException("Could not find xml attribute:" + name);
        }
        return value;
    }

    public static List findChildren(Node parent, String tag) {
        ArrayList<Node> found = new ArrayList<Node>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (tag != null && !tag.equals("*") && !child.getNodeName().equals(tag)) continue;
            found.add(child);
        }
        return found;
    }

    public static int getInt(JTextField fld) {
        return (int)GuiUtils.getValue(fld);
    }

    public static double getValue(JTextField fld) {
        return Misc.parseValue(fld.getText().trim());
    }

    public static void setApplicationTitle(String title) {
        applicationTitle = title;
    }

    public static String getApplicationTitle() {
        return applicationTitle;
    }

    public static boolean doMacMenubar() {
        return false;
    }

    public static boolean isControlKey(InputEvent event) {
        if (!GuiUtils.isMac()) {
            return event.isControlDown();
        }
        return event.isControlDown();
    }

    public static boolean isControlKey(KeyEvent event, int keyCode) {
        if (!GuiUtils.isControlKey(event)) {
            return false;
        }
        return event.getKeyCode() == keyCode;
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("mac") >= 0;
    }

    public static boolean isDeleteEvent(KeyEvent e) {
        return e.getKeyCode() == 127 || GuiUtils.isMac() && e.getKeyCode() == 8 || e.getKeyCode() == 68 && e.isControlDown();
    }

    public static void decorateFrame(JFrame frame, JMenuBar menuBar) {
        if (frame != null & menuBar != null && GuiUtils.doMacMenubar()) {
            frame.setJMenuBar(menuBar);
        }
    }

    public static void showUrl(String s) throws Exception {
        URI url = new URI(s);
        if (!Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            System.err.println("Browse not supported");
            return;
        }
        Desktop.getDesktop().browse(url);
    }

    public static void addLinkListener(JEditorPane editor) {
        editor.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String url = e.getDescription();
                    try {
                        GuiUtils.showUrl(url);
                    }
                    catch (Exception exc) {
                        LogUtil.logException("error showing url:" + url, exc);
                    }
                }
            }
        });
    }

    static {
        defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
        intervalStepFld = new JTextField("1", 4);
        intervalStartFld = new JTextField("1", 4);
        modalDialogComponents = new ArrayList();
    }

    public static class ProgressDialog
    extends JDialog {
        private JLabel statusLbl = new JLabel(" ");
        private boolean cancelPressed = false;

        public ProgressDialog(String title) {
            this(title, false);
        }

        public ProgressDialog(String title, boolean doCancel) {
            super((Frame)null, title, false);
            this.statusLbl.setMinimumSize(new Dimension(350, 20));
            this.statusLbl.setPreferredSize(new Dimension(350, 20));
            JLabel waitLbl = new JLabel(GuiUtils.getImageIcon("/ucar/unidata/util/wait.gif"));
            JPanel contents = GuiUtils.inset((Component)GuiUtils.centerRight(this.statusLbl, waitLbl), 5);
            if (doCancel) {
                JButton btn = new JButton("Cancel");
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        cancelPressed = true;
                        this.setText("Cancelling");
                    }
                });
                contents = GuiUtils.centerBottom(contents, GuiUtils.inset((Component)GuiUtils.wrap(btn), 5));
            }
            this.getContentPane().add(contents);
            this.pack();
            this.setLocation(200, 200);
            this.setVisible(true);
        }

        public void setText(String lbl) {
            this.statusLbl.setText(lbl);
        }

        public boolean isCancelled() {
            return this.cancelPressed;
        }
    }

    public static class CardLayoutPanel
    extends JPanel {
        int counter = 0;
        CardLayout cardLayout;
        Hashtable map = new Hashtable();
        Hashtable keyMap = new Hashtable();

        public CardLayoutPanel() {
            this(new CardLayout());
        }

        public CardLayoutPanel(CardLayout cardLayout) {
            super(cardLayout);
            this.cardLayout = cardLayout;
        }

        public CardLayout getCardLayout() {
            return this.cardLayout;
        }

        public Component getVisibleComponent() {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component child = this.getComponent(i);
                if (!child.isVisible()) continue;
                return child;
            }
            return null;
        }

        public String addCard(Component comp) {
            String layoutKey = "component_" + this.counter++;
            this.add(layoutKey, comp);
            return layoutKey;
        }

        @Override
        public Component add(String layoutKey, Component comp) {
            this.keyMap.put(layoutKey, layoutKey);
            this.map.put(comp, layoutKey);
            return super.add(layoutKey, comp);
        }

        public void show(String key) {
            this.cardLayout.show(this, key);
        }

        public void show(int i) {
            this.show(this.getComponent(i));
        }

        public int getVisibleIndex() {
            int cnt = this.getComponentCount();
            for (int i = 0; i < cnt; ++i) {
                Component child = this.getComponent(i);
                if (!child.isVisible()) continue;
                return i;
            }
            return -1;
        }

        public void flip() {
            int cnt = this.getComponentCount();
            for (int i = 0; i < cnt; ++i) {
                Component child = this.getComponent(i);
                if (!child.isVisible()) continue;
                if (i < cnt - 1) {
                    this.show(this.getComponent(i + 1));
                    break;
                }
                this.show(this.getComponent(0));
                break;
            }
        }

        public boolean contains(Component comp) {
            return this.map.get(comp) != null;
        }

        public boolean containsKey(Object object) {
            return this.keyMap.get(object) != null;
        }

        public void show(Component comp) {
            this.cardLayout.show(this, (String)this.map.get(comp));
        }

        @Override
        public void removeAll() {
            super.removeAll();
            this.map = new Hashtable();
        }

        @Override
        public void remove(Component comp) {
            super.remove(comp);
            Object key = this.map.get(comp);
            if (key != null) {
                this.keyMap.remove(key);
            }
            this.map.remove(comp);
        }
    }

    public static class VerticalLabelUI
    extends BasicLabelUI {
        protected boolean clockwise;
        private static Rectangle paintIconR = new Rectangle();
        private static Rectangle paintTextR = new Rectangle();
        private static Rectangle paintViewR = new Rectangle();
        private static Insets paintViewInsets = new Insets(0, 0, 0, 0);

        VerticalLabelUI(boolean clockwise) {
            this.clockwise = clockwise;
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            Dimension dim = super.getPreferredSize(c);
            return new Dimension(dim.height, dim.width);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Icon icon;
            JLabel label = (JLabel)c;
            String text = label.getText();
            Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
            if (icon == null && text == null) {
                return;
            }
            FontMetrics fm = g.getFontMetrics();
            paintViewInsets = c.getInsets(paintViewInsets);
            VerticalLabelUI.paintViewR.x = VerticalLabelUI.paintViewInsets.left;
            VerticalLabelUI.paintViewR.y = VerticalLabelUI.paintViewInsets.top;
            VerticalLabelUI.paintViewR.height = c.getWidth() - (VerticalLabelUI.paintViewInsets.left + VerticalLabelUI.paintViewInsets.right);
            VerticalLabelUI.paintViewR.width = c.getHeight() - (VerticalLabelUI.paintViewInsets.top + VerticalLabelUI.paintViewInsets.bottom);
            VerticalLabelUI.paintIconR.height = 0;
            VerticalLabelUI.paintIconR.width = 0;
            VerticalLabelUI.paintIconR.y = 0;
            VerticalLabelUI.paintIconR.x = 0;
            VerticalLabelUI.paintTextR.height = 0;
            VerticalLabelUI.paintTextR.width = 0;
            VerticalLabelUI.paintTextR.y = 0;
            VerticalLabelUI.paintTextR.x = 0;
            String clippedText = this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform tr = g2.getTransform();
            if (this.clockwise) {
                g2.rotate(1.5707963267948966);
                g2.translate(0, -c.getWidth());
            } else {
                g2.rotate(-1.5707963267948966);
                g2.translate(-c.getHeight(), 0);
            }
            if (icon != null) {
                icon.paintIcon(c, g, VerticalLabelUI.paintIconR.x, VerticalLabelUI.paintIconR.y);
            }
            if (text != null) {
                int textX = VerticalLabelUI.paintTextR.x;
                int textY = VerticalLabelUI.paintTextR.y + fm.getAscent();
                if (label.isEnabled()) {
                    this.paintEnabledText(label, g, clippedText, textX, textY);
                } else {
                    this.paintDisabledText(label, g, clippedText, textX, textY);
                }
            }
            g2.setTransform(tr);
        }
    }

    public static class TreeSearchResults {
        public boolean success;
        public Object lastState;

        public TreeSearchResults(boolean success, Object lastState) {
            this.success = success;
            this.lastState = lastState;
        }
    }

    public static class ColorSwatch
    extends JPanel {
        boolean doAlpha = false;
        Color color;
        JButton clearBtn;
        JButton setBtn;
        String label;

        public ColorSwatch(Color c, String dialogLabel) {
            this(c, dialogLabel, false);
        }

        public ColorSwatch(Color c, String dialogLabel, boolean alphaOk) {
            this.doAlpha = alphaOk;
            this.color = c;
            this.label = dialogLabel;
            this.setMinimumSize(new Dimension(40, 10));
            this.setPreferredSize(new Dimension(40, 10));
            this.setToolTipText("Click to change color");
            this.setBackground(this.color);
            this.setBorder(BorderFactory.createLoweredBevelBorder());
            this.clearBtn = new JButton("Clear");
            this.clearBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    this.setBackground(null);
                }
            });
            this.setBtn = new JButton("Set");
            this.setBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    this.setColorFromChooser();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Misc.run(new Runnable(){

                        @Override
                        public void run() {
                            this.showColorChooser();
                        }
                    });
                }
            });
        }

        private void showColorChooser() {
            Color oldColor = this.getBackground();
            int alpha = oldColor.getAlpha();
            JColorChooser chooser = new JColorChooser(oldColor);
            JSlider alphaSlider = new JSlider(0, 255, alpha);
            JComponent contents = this.doAlpha ? LayoutUtil.centerBottom(chooser, LayoutUtil.inset((Component)LayoutUtil.hbox(new JLabel("Transparency:"), alphaSlider), new Insets(5, 5, 5, 5))) : chooser;
            if (!GuiUtils.showOkCancelDialog(null, this.label, contents, null)) {
                return;
            }
            alpha = alphaSlider.getValue();
            Color newColor = chooser.getColor();
            if (newColor != null) {
                newColor = new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), alpha);
                this.userSelectedNewColor(newColor);
            }
        }

        private void setColorFromChooser() {
            Color newColor = JColorChooser.showDialog(null, this.label, this.getBackground());
            if (newColor != null) {
                this.userSelectedNewColor(newColor);
            }
        }

        public JButton getSetButton() {
            return this.setBtn;
        }

        public JButton getClearButton() {
            return this.clearBtn;
        }

        public Color getSwatchColor() {
            return this.color;
        }

        public void userSelectedNewColor(Color c) {
            this.setBackground(c);
        }

        @Override
        public void setBackground(Color c) {
            this.color = c;
            super.setBackground(c);
        }

        @Override
        public void paint(Graphics g) {
            Rectangle b = this.getBounds();
            if (this.color != null) {
                g.setColor(Color.black);
                for (int x = 0; x < b.width; x += 4) {
                    g.fillRect(x, 0, 2, b.height);
                }
            }
            super.paint(g);
            if (this.color == null) {
                g.setColor(Color.black);
                g.drawLine(0, 0, b.width, b.height);
                g.drawLine(b.width, 0, 0, b.height);
            }
        }

        public JComponent getPanel() {
            return GuiUtils.hbox((Component)this, (Component)this.clearBtn, 4);
        }

        public Color getColor() {
            return this.color;
        }

        public JComponent getSetPanel() {
            List comps = Misc.newList(this);
            JButton popupBtn = new JButton("Change");
            popupBtn.addActionListener(GuiUtils.makeActionListener(this, "popupNameMenu", popupBtn));
            comps.add(popupBtn);
            return GuiUtils.hbox(comps, 4);
        }

        public void popupNameMenu(JButton popupBtn) {
            ArrayList<Object> items = new ArrayList<Object>();
            for (int i = 0; i < COLORNAMES.length; ++i) {
                items.add(MenuUtil.makeMenuItem(COLORNAMES[i], this, "setColorName", COLORNAMES[i]));
            }
            items.add("separator");
            items.add(MenuUtil.makeMenuItem("Custom", this, "setColorName", "custom"));
            MenuUtil.showPopupMenu(items, popupBtn);
        }

        public void setColorName(String name) {
            if (name.equals("custom")) {
                this.setColorFromChooser();
                return;
            }
            Color newColor = GuiUtils.decodeColor(name, this.getBackground());
            if (newColor != null) {
                this.setBackground(newColor);
            }
        }
    }
}

