/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.Poller;
import ucar.unidata.util.PollingInfo;
import ucar.unidata.util.Trace;

public class FilePoller
extends Poller {
    PollingInfo pollingInfo;
    PatternFileFilter fileFilter;
    List fileInfos = new ArrayList();
    File directory;
    boolean haveInitialized = false;

    public FilePoller(ActionListener listener, PollingInfo info) {
        super(listener, info.getInterval());
        this.pollingInfo = info.cloneMe();
        this.init();
    }

    @Override
    public void init() {
        if (this.pollingInfo.getFilePattern() != null) {
            this.fileFilter = new PatternFileFilter(this.pollingInfo.getFilePattern(), false, this.pollingInfo.getIsHiddenOk());
            Trace.msg("FilePoller.init filter=" + this.fileFilter);
        }
        List paths = this.pollingInfo.getFilePaths();
        for (int i = 0; i < paths.size(); ++i) {
            File f = new File(paths.get(i).toString());
            this.fileInfos.add(new FileInfo(f));
        }
        if (this.fileInfos.size() == 1 && ((FileInfo)this.fileInfos.get(0)).getFile().isDirectory()) {
            this.directory = ((FileInfo)this.fileInfos.get(0)).getFile();
            this.fileInfos = this.getFileInfos();
        }
        super.init();
    }

    @Override
    protected void doPoll() {
        if (this.directory != null) {
            Trace.msg("FilePoller: Polling directory:" + this.directory);
            this.doDirectory();
            return;
        }
        Trace.msg("FilePoller: Polling file:" + this.fileInfos);
        this.doFile();
    }

    private List getFileInfos() {
        File[] list = this.directory.listFiles(this.fileFilter);
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        if (list == null) {
            return files;
        }
        for (int i = 0; i < list.length; ++i) {
            files.add(new FileInfo(list[i]));
        }
        return files;
    }

    private void doDirectory() {
        Trace.call1("FilePoller.doDirectory");
        List newFileInfos = this.getFileInfos();
        ArrayList<File> changedFiles = new ArrayList<File>();
        for (int i = 0; i < newFileInfos.size(); ++i) {
            FileInfo newFileInfo = (FileInfo)newFileInfos.get(i);
            int index = this.fileInfos.indexOf(newFileInfo);
            FileInfo oldFileInfo = null;
            if (index >= 0) {
                oldFileInfo = (FileInfo)this.fileInfos.get(index);
                if (oldFileInfo.size == newFileInfo.size && oldFileInfo.time == newFileInfo.time) continue;
                changedFiles.add(newFileInfo.getFile());
                continue;
            }
            changedFiles.add(newFileInfo.getFile());
        }
        this.fileInfos = newFileInfos;
        Trace.call2("FilePoller.doDirectory", " changed files=" + changedFiles);
        if (changedFiles.size() == 0) {
            return;
        }
        this.waitOnFiles(changedFiles);
        this.fireChange(changedFiles);
    }

    private void fireChange(List files) {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(files, 1, "FILECHANGED"));
        }
    }

    private void doFile() {
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < this.fileInfos.size(); ++i) {
            FileInfo fileInfo = (FileInfo)this.fileInfos.get(i);
            if (!fileInfo.hasChanged()) continue;
            files.add(fileInfo.getFile());
        }
        if (files.size() == 0) {
            return;
        }
        this.waitOnFiles(files);
        if (!this.running) {
            return;
        }
        this.fireChange(files);
    }

    private void waitOnFiles(List files) {
        long[] lengths = new long[files.size()];
        File[] fileArray = new File[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            lengths[i] = ((File)files.get(i)).length();
            fileArray[i] = (File)files.get(i);
        }
        int cnt = 5;
        long subInterval = 1000L;
        while (cnt-- > 0) {
            Misc.sleep(subInterval);
            if (!this.running) {
                return;
            }
            boolean allOk = true;
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i] == null) continue;
                long newLength = fileArray[i].length();
                if (newLength == lengths[i]) {
                    fileArray[i] = null;
                    continue;
                }
                allOk = false;
            }
            if (!allOk) continue;
            break;
        }
    }

    public static void main(String[] args) {
        FileInfo fileInfo = new FileInfo(new File("util"));
        System.err.println("hasChanged:" + fileInfo.hasChanged() + " size=" + fileInfo.size);
    }

    private static class FileInfo {
        File file;
        long time;
        long size;
        boolean hasInitialized = false;

        public FileInfo(File f) {
            this.file = f;
            if (this.file.exists()) {
                this.time = this.file.lastModified();
                this.size = this.file.length();
                this.hasInitialized = true;
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FileInfo)) {
                return false;
            }
            FileInfo that = (FileInfo)obj;
            return Misc.equals(this.file.toString(), that.file.toString());
        }

        public boolean hasChanged() {
            if (!this.hasInitialized) {
                if (this.file.exists()) {
                    this.time = this.file.lastModified();
                    this.size = this.file.length();
                    this.hasInitialized = true;
                    return true;
                }
                return false;
            }
            long newTime = this.file.lastModified();
            long newSize = this.file.length();
            boolean changed = newTime != this.time || newSize != this.size;
            this.time = newTime;
            this.size = newSize;
            return changed;
        }

        public File getFile() {
            return this.file;
        }

        public boolean exists() {
            return this.file.exists();
        }

        public String toString() {
            return this.file.toString();
        }
    }
}

