/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LayoutUtil;
import ucar.unidata.util.MenuUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.PersistentStore;

public class FileManager {
    private static boolean fixFileLockup = false;
    static List directoryHistoryListeners = new ArrayList();
    private static final String CMD_LOADURL = "cmd.loadurl";
    public static final String PROP_DIR_HISTORY = "FileManager.DirectoryHistory";
    public static final String PROP_DIRECTORY = "filemanager.directory";
    private Component parent;
    private JFileChooser chooser = null;
    private List defaultDirs = new ArrayList();
    private boolean readOk = true;
    private static boolean debug = false;
    private static boolean test = false;
    private static boolean fileHidingEnabled = true;
    private static String defaultWriteProperty = "property.filewrite.dir";
    private static String defaultReadProperty = "property.fileread.dir";
    private static PersistentStore fileStore;
    private static final boolean DFLT_INCLUDEALLFILTER = true;
    private static final List NULL_FILTERS;
    private static final String NULL_SUFFIX;
    public static final String SUFFIX_XML = ".xml";
    public static final String SUFFIX_AVI = ".avi";
    public static final String SUFFIX_CSV = ".csv";
    public static final String SUFFIX_XLS = ".xls";
    public static final String SUFFIX_KML = ".kml";
    public static final String SUFFIX_KMZ = ".kmz";
    public static final String SUFFIX_JPG = ".jpg";
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_GIF = ".gif";
    public static final String SUFFIX_MOV = ".mov";
    public static final String SUFFIX_TXT = ".txt";
    public static final String SUFFIX_LOG = ".log";
    public static final String SUFFIX_NETCDF = ".nc";
    public static final String SUFFIX_JAR = ".jar";
    public static final String SUFFIX_ZIP = ".zip";
    private static final JComponent NULL_ACCESSORY;
    public static final PatternFileFilter FILTER_XML;
    public static final PatternFileFilter FILTER_NETCDF;
    public static final PatternFileFilter FILTER_CSV;
    public static final PatternFileFilter FILTER_TXT;
    public static final PatternFileFilter FILTER_XLS;
    public static final PatternFileFilter FILTER_KML;
    public static final PatternFileFilter FILTER_JAR;
    public static final PatternFileFilter FILTER_JPG;
    public static final PatternFileFilter FILTER_IMAGE;
    public static final PatternFileFilter FILTER_IMAGEWRITE;
    public static final PatternFileFilter FILTER_IMAGE_OR_PDF;
    public static final PatternFileFilter FILTER_MOV;
    public static final PatternFileFilter FILTER_AVI;
    public static final PatternFileFilter FILTER_ANIMATEDGIF;
    public static final PatternFileFilter FILTER_ZIP;
    public static final PatternFileFilter FILTER_LOG;
    public static final PatternFileFilter FILTER_KMZ;
    public static final String NULL_STRING;
    public static final String NULL_BTNTEXT;
    public static final String NULL_TITLE;

    public FileManager(Component parent) {
        this(parent, null, new ExtFilter(null, "All Files"));
    }

    public FileManager(Component parent, String defDir, String file_extension, String desc) {
        this(parent, defDir, new ExtFilter(file_extension, desc));
    }

    public FileManager(Component parent, String defDir, FileFilter filter) {
        this(parent, defDir, Misc.newList(filter));
    }

    public FileManager(Component parent, String defDir, FileFilter filter, String title) {
        this(parent, defDir, Misc.newList(filter), title);
    }

    public FileManager(Component parent, String defDir, List filters) {
        this(parent, defDir, filters, null);
    }

    public FileManager(Component parent, String defDir, List filters, String title) {
        this(parent, defDir, filters, title, true);
    }

    public FileManager(Component parent, String defDir, List filters, String title, boolean includeAllFilter) {
        boolean isMac;
        this.parent = parent;
        if (defDir != null) {
            this.defaultDirs.add(defDir);
        }
        String osName = System.getProperty("os.name");
        if (test) {
            System.out.println("OS ==  " + osName + " def =" + defDir);
        }
        boolean isWindose = 0 <= osName.indexOf("Windows");
        boolean bl = isMac = System.getProperty("mrj.version") != null;
        if (isWindose) {
            this.defaultDirs.add("C:/");
        } else if (isMac) {
            this.defaultDirs.add(System.getProperty("user.home"));
        }
        File defaultDirectory = this.findDefaultDirectory(this.defaultDirs);
        SecurityManager backup = System.getSecurityManager();
        System.setSecurityManager(null);
        try {
            this.chooser = new MyFileChooser(defaultDirectory);
            this.chooser.setFileHidingEnabled(FileManager.getFileHidingEnabled());
            if (title != null) {
                this.chooser.setDialogTitle(title);
            }
            if (filters != null) {
                for (int i = 0; i < filters.size(); ++i) {
                    this.chooser.addChoosableFileFilter((FileFilter)filters.get(i));
                }
                if (filters.size() > 0) {
                    this.chooser.setFileFilter((FileFilter)filters.get(0));
                }
            } else if (includeAllFilter) {
                this.chooser.setFileFilter(this.chooser.getAcceptAllFileFilter());
            }
            this.chooser.addPropertyChangeListener(new PropertyChangeListener(){
                File lastFile = null;
                String originalFileSuffix = null;

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String prop = e.getPropertyName();
                    if ("SelectedFileChangedProperty".equals(prop) && FileManager.this.chooser.getSelectedFile() != null) {
                        this.lastFile = FileManager.this.chooser.getSelectedFile();
                        if (this.originalFileSuffix == null) {
                            this.originalFileSuffix = IOUtil.getFileExtension(this.lastFile.toString());
                        }
                    }
                    if ("fileFilterChanged".equals(prop)) {
                        File newFile;
                        String filterSuffix;
                        File f = this.lastFile;
                        FileFilter fileFilter = FileManager.this.chooser.getFileFilter();
                        if (f == null) {
                            return;
                        }
                        String suffix = null;
                        String newFileName = null;
                        if (fileFilter != null && fileFilter instanceof PatternFileFilter && (filterSuffix = ((PatternFileFilter)fileFilter).getPreferredSuffix()) != null) {
                            suffix = filterSuffix;
                        }
                        if (suffix != null) {
                            String filename = f.toString();
                            String fileSuffix = IOUtil.getFileExtension(filename);
                            if (fileSuffix == null || fileSuffix.equals("")) {
                                newFileName = filename + suffix;
                            } else if (!fileSuffix.equals(suffix)) {
                                newFileName = IOUtil.stripExtension(filename) + suffix;
                            }
                        }
                        if (newFileName != null && (newFile = new File(newFileName)).equals(this.lastFile)) {
                            FileManager.this.chooser.setSelectedFile(newFile);
                        }
                    }
                }
            });
        }
        catch (SecurityException se) {
            System.out.println("FileManager SecurityException " + se);
            this.readOk = false;
            JOptionPane.showMessageDialog(null, "Sorry, this Applet does not have disk read permission.");
        }
        System.setSecurityManager(backup);
    }

    public JFileChooser getChooser() {
        return this.chooser;
    }

    public static void setFixFileLockup(boolean b) {
        fixFileLockup = b;
    }

    public static boolean getFileHidingEnabled() {
        return fileHidingEnabled;
    }

    public static void setFileHidingEnabled(boolean value) {
        fileHidingEnabled = value;
    }

    public void setSelectedFile(String file) {
        this.chooser.setSelectedFile(new File(file));
    }

    public String chooseFilename() {
        return this.chooseFilename(null);
    }

    public String chooseFilename(String title) {
        return this.chooseFilename(title, null);
    }

    public String chooseFilename(String title, String approveButtonText) {
        return this.chooseFilename(title, approveButtonText, false);
    }

    public String chooseFilename(String title, String approveButtonText, boolean includeUrl) {
        if (!this.readOk) {
            return null;
        }
        if (approveButtonText != null) {
            this.chooser.setApproveButtonText(approveButtonText);
        }
        SecurityManager backup = System.getSecurityManager();
        System.setSecurityManager(null);
        if (title != null) {
            this.chooser.setDialogTitle(title);
        }
        final JDialog dialog = new JDialog((Frame)null, title != null ? title : "Choose File", true);
        ObjectListener listener = new ObjectListener(null){

            @Override
            public void actionPerformed(ActionEvent ae) {
                this.theObject = ae.getActionCommand();
                dialog.dispose();
            }
        };
        this.chooser.addActionListener(listener);
        if (approveButtonText != null) {
            this.chooser.setApproveButtonText(approveButtonText);
        } else if (this.chooser.getDialogType() == 0) {
            this.chooser.setApproveButtonText("Open");
        } else {
            this.chooser.setApproveButtonText("Save");
        }
        JComponent contents = this.chooser;
        JTextField urlField = null;
        if (includeUrl) {
            urlField = new JTextField("", 30);
            JButton urlButton = new JButton("Load URL:");
            urlButton.setActionCommand(CMD_LOADURL);
            urlField.setActionCommand(CMD_LOADURL);
            urlButton.addActionListener(listener);
            urlField.addActionListener(listener);
            JPanel urlPanel = LayoutUtil.doLayout(new Component[]{urlButton, urlField}, 2, LayoutUtil.WT_NY, LayoutUtil.WT_N);
            contents = LayoutUtil.centerBottom(contents, LayoutUtil.inset((Component)urlPanel, 5));
        }
        List directoryHistory = FileManager.getHistoryList();
        JComponent historyComp = FileManager.makeDirectoryHistoryComponent(this.chooser, true);
        if (directoryHistory != null && directoryHistory.size() > 0) {
            contents = LayoutUtil.centerRight(contents, LayoutUtil.top(LayoutUtil.inset((Component)historyComp, new Insets(13, 0, 0, 10))));
        }
        dialog.getContentPane().add(contents);
        GuiUtils.invokeInSwingThread(new Runnable(){

            @Override
            public void run() {
                GuiUtils.showInCenter(dialog);
            }
        });
        System.setSecurityManager(backup);
        File file = this.chooser.getSelectedFile();
        FileManager.addToHistory(file);
        if (debug) {
            System.out.println("FileManager result " + file);
        }
        if (listener.getObject().equals(CMD_LOADURL)) {
            return urlField.getText().trim();
        }
        if (listener.getObject().equals("ApproveSelection")) {
            return file.getPath();
        }
        return null;
    }

    private static void showGoToMenu(JButton goToBtn, final JFileChooser chooser) {
        List directoryHistory = FileManager.getHistoryList();
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        if (directoryHistory != null) {
            for (int i = 0; i < directoryHistory.size(); ++i) {
                final String dirPath = directoryHistory.get(i).toString();
                JMenuItem mi = new JMenuItem(dirPath);
                items.add(mi);
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        chooser.setCurrentDirectory(new File(dirPath));
                    }
                });
            }
        }
        if (items.size() == 0) {
            items.add(new JMenuItem("No file history"));
        }
        JPopupMenu popup = MenuUtil.makePopupMenu(new JPopupMenu(), items);
        popup.show(goToBtn, 0, (int)goToBtn.getBounds().getHeight());
    }

    public static List getHistoryList(ActionListener listener) {
        if (listener != null && !directoryHistoryListeners.contains(listener)) {
            directoryHistoryListeners.add(listener);
        }
        return FileManager.getHistoryList();
    }

    public static List getHistoryList() {
        if (fileStore == null) {
            return new ArrayList();
        }
        ArrayList l = (ArrayList)fileStore.get(PROP_DIR_HISTORY);
        if (l == null) {
            l = new ArrayList();
        }
        return l;
    }

    public static void addToHistory(File file) {
        int index;
        if (file == null || fileStore == null) {
            return;
        }
        ArrayList<String> directoryHistory = FileManager.getHistoryList();
        File dir = file;
        if (!file.isDirectory()) {
            dir = file.getParentFile();
        }
        if (directoryHistory == null) {
            directoryHistory = new ArrayList<String>();
        }
        if ((index = directoryHistory.indexOf(dir.toString())) >= 0) {
            directoryHistory.remove(index);
        }
        directoryHistory.add(0, dir.toString());
        while (directoryHistory.size() > 20) {
            directoryHistory.remove(directoryHistory.size() - 1);
        }
        fileStore.put(PROP_DIR_HISTORY, directoryHistory);
        fileStore.save();
        for (int i = 0; i < directoryHistoryListeners.size(); ++i) {
            ActionListener listener = (ActionListener)directoryHistoryListeners.get(i);
            listener.actionPerformed(null);
        }
    }

    public void setAccessory(JComponent comp) {
        this.chooser.setAccessory(comp);
    }

    public String getDirectoryName() {
        return this.chooser.getCurrentDirectory().getPath();
    }

    public void setApproveButtonText(String approveButtonText) {
        this.chooser.setApproveButtonText(approveButtonText);
    }

    private File findDefaultDirectory(List tryDefaultDirectories) {
        boolean readOK = true;
        for (int i = 0; i < tryDefaultDirectories.size(); ++i) {
            try {
                File dir;
                String dirName = (String)tryDefaultDirectories.get(i);
                if (debug) {
                    System.out.print("FileManager try " + dirName);
                }
                if ((dir = new File(dirName)).exists()) {
                    if (debug) {
                        System.out.println(" ok ");
                    }
                    return dir;
                }
                if (!debug) continue;
                System.out.println("no ");
                continue;
            }
            catch (SecurityException se) {
                if (debug) {
                    System.out.println("SecurityException in FileManager: " + se);
                }
                readOK = false;
            }
        }
        if (!readOK) {
            JOptionPane.showMessageDialog(null, "Sorry, this Applet does not have disk read permission.");
        }
        return null;
    }

    public static void setStore(PersistentStore store, String writeProperty, String readProperty) {
        defaultWriteProperty = writeProperty;
        defaultReadProperty = readProperty;
        fileStore = store;
    }

    public static File getDirectory(String dfltDir) {
        return FileManager.getDirectory(dfltDir, "Please select a directory");
    }

    public static File getDirectory(String dfltDir, String title) {
        return FileManager.getDirectory(dfltDir, title, null);
    }

    public static File getDirectory(String dfltDir, String title, JComponent accessory) {
        if (dfltDir == null && fileStore != null) {
            dfltDir = (String)fileStore.get(PROP_DIRECTORY);
        }
        MyFileChooser chooser = dfltDir != null ? new MyFileChooser(dfltDir) : new MyFileChooser();
        chooser.setApproveButtonText("Save");
        if (accessory != null) {
            accessory = GuiUtils.inset((Component)accessory, 2);
            chooser.setAccessory(accessory);
        }
        if (title != null) {
            chooser.setDialogTitle(title);
        }
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Directories";
            }
        });
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileSelectionMode(1);
        int result = chooser.showOpenDialog(null);
        if (result == 1) {
            return null;
        }
        File file = chooser.getSelectedFile();
        if (fileStore != null) {
            fileStore.put(PROP_DIRECTORY, file.toString());
            fileStore.save();
        }
        return file;
    }

    public static String getWriteFile(String filename) {
        return FileManager.getFile(true, NULL_TITLE, NULL_BTNTEXT, defaultWriteProperty, NULL_FILTERS, NULL_SUFFIX, true, NULL_ACCESSORY, false, filename);
    }

    public static String getWriteFile() {
        return FileManager.getFile(true, NULL_TITLE, NULL_BTNTEXT, defaultWriteProperty, NULL_FILTERS, NULL_SUFFIX, true, NULL_ACCESSORY, false);
    }

    public static String getWriteFile(List filters, String suffix) {
        return FileManager.getFile(true, NULL_TITLE, NULL_BTNTEXT, defaultWriteProperty, filters, suffix, true, NULL_ACCESSORY, false);
    }

    public static String getWriteFile(FileFilter filter, String suffix) {
        return FileManager.getFile(true, NULL_TITLE, NULL_BTNTEXT, defaultWriteProperty, Misc.newList(filter), suffix, true, NULL_ACCESSORY, false);
    }

    public static String getWriteFile(FileFilter filter, String suffix, JComponent accessory) {
        return FileManager.getFile(true, NULL_TITLE, NULL_BTNTEXT, defaultWriteProperty, Misc.newList(filter), suffix, true, accessory, false);
    }

    public static String getWriteFile(List filters, String suffix, JComponent accessory) {
        return FileManager.getFile(true, NULL_TITLE, NULL_BTNTEXT, defaultWriteProperty, filters, suffix, true, accessory, false);
    }

    public static String getWriteFile(String title, FileFilter filter, String suffix) {
        return FileManager.getFile(true, title, NULL_BTNTEXT, defaultWriteProperty, Misc.newList(filter), suffix, true, NULL_ACCESSORY, false);
    }

    public static String getWriteFile(String title, List filters, String suffix) {
        return FileManager.getFile(true, title, NULL_BTNTEXT, defaultWriteProperty, filters, suffix, true, NULL_ACCESSORY, false);
    }

    public static String getReadFile() {
        return FileManager.getFile(false, NULL_TITLE, NULL_BTNTEXT, defaultReadProperty, NULL_FILTERS, NULL_SUFFIX, true, NULL_ACCESSORY, false);
    }

    public static String getReadFile(FileFilter filter) {
        return FileManager.getFile(false, NULL_TITLE, NULL_BTNTEXT, defaultReadProperty, Misc.newList(filter), NULL_SUFFIX, true, NULL_ACCESSORY, false);
    }

    public static String getReadFile(FileFilter filter, boolean includeAllFilter) {
        return FileManager.getFile(false, NULL_TITLE, NULL_BTNTEXT, defaultReadProperty, Misc.newList(filter), NULL_SUFFIX, includeAllFilter, NULL_ACCESSORY, false);
    }

    public static String getReadFile(String title, FileFilter filter) {
        return FileManager.getFile(false, title, NULL_BTNTEXT, defaultReadProperty, Misc.newList(filter), NULL_SUFFIX, true, NULL_ACCESSORY, false);
    }

    public static String getReadFile(String title, List filters) {
        return FileManager.getFile(false, title, NULL_BTNTEXT, defaultReadProperty, filters, NULL_SUFFIX, true, NULL_ACCESSORY, false);
    }

    public static String getReadFile(String title, List filters, JComponent accessory) {
        return FileManager.getFile(false, title, NULL_BTNTEXT, defaultReadProperty, filters, NULL_SUFFIX, true, accessory, false);
    }

    public static String getReadFileOrURL(String title, List filters, JComponent accessory) {
        return FileManager.getFile(false, title, NULL_BTNTEXT, defaultReadProperty, filters, NULL_SUFFIX, true, accessory, true);
    }

    public static String getFile(boolean forWrite, String title, String buttonText, String property, List filters, String suffix, boolean includeAllFilter, JComponent accessory, boolean includeUrl) {
        return FileManager.getFile(forWrite, title, buttonText, property, filters, suffix, includeAllFilter, accessory, includeUrl, null);
    }

    public static String getFile(boolean forWrite, String title, String buttonText, String property, List filters, String suffix, boolean includeAllFilter, JComponent accessory, boolean includeUrl, String dfltFile) {
        File file;
        String filename;
        block20: {
            String fileDir = null;
            String lastFileName = null;
            if (fileStore != null && property != null && (lastFileName = (String)fileStore.get(property)) != null) {
                File lastFile = new File(lastFileName);
                fileDir = lastFile.getParent();
            }
            title = title != null ? title : (forWrite ? "Save" : "Open");
            FileManager fileManager = new FileManager(null, fileDir, filters, title, includeAllFilter);
            FileFilter defaultFileFilter = null;
            if (dfltFile != null) {
                File dir = fileManager.getChooser().getCurrentDirectory();
                dfltFile = IOUtil.joinDir(dir, IOUtil.getFileTail(dfltFile));
                fileManager.getChooser().setSelectedFile(new File(dfltFile));
            } else if (lastFileName != null) {
                if (filters != null && filters.size() > 0) {
                    boolean ok = false;
                    for (int i = 0; !ok && i < filters.size(); ++i) {
                        FileFilter tmpFileFilter = (FileFilter)filters.get(i);
                        boolean bl = ok = ok || tmpFileFilter.accept(new File(lastFileName));
                        if (!ok) continue;
                        defaultFileFilter = tmpFileFilter;
                    }
                    if (!ok) {
                        lastFileName = null;
                    }
                }
                if (lastFileName != null) {
                    fileManager.setSelectedFile(lastFileName);
                }
            }
            if (accessory != null) {
                accessory = GuiUtils.inset((Component)accessory, 2);
                fileManager.setAccessory(accessory);
            }
            fileManager.getChooser().setDialogType(forWrite ? 1 : 0);
            if (defaultFileFilter != null) {
                fileManager.getChooser().setFileFilter(defaultFileFilter);
            }
            do {
                if ((filename = fileManager.chooseFilename(title, buttonText != null ? buttonText : (forWrite ? "Save" : "Open"), includeUrl)) == null) {
                    return null;
                }
                String tail = IOUtil.getFileTail(filename);
                if (tail.indexOf(".") < 0) {
                    String filterSuffix;
                    FileFilter fileFilter = fileManager.getChooser().getFileFilter();
                    if (fileFilter != null && fileFilter instanceof PatternFileFilter && (filterSuffix = ((PatternFileFilter)fileFilter).getPreferredSuffix()) != null) {
                        suffix = filterSuffix;
                    }
                    if (suffix != null) {
                        filename = filename + suffix;
                    }
                }
                file = new File(filename);
                if (!forWrite) break block20;
                boolean isWritable = true;
                if (file.exists()) {
                    if (JOptionPane.showConfirmDialog(null, "File:" + filename + " exists. Do you want to overwrite?", "File exists", 0) == 1) {
                        return null;
                    }
                    isWritable = file.canWrite();
                } else {
                    File parent = file.getParentFile();
                    if (parent != null) {
                        isWritable = parent.canWrite();
                    }
                }
                if (isWritable) break block20;
            } while (GuiUtils.askOkCancel("File Selection", "The chosen file path is not writable. Select again?"));
            return null;
        }
        String dir = file.getParent();
        if (fileStore != null && dir != null) {
            fileStore.put(property, filename);
            fileStore.save();
        }
        return filename;
    }

    public static JComponent makeDirectoryHistoryComponent(final JFileChooser fileChooser, boolean includeLabel) {
        final JButton goToBtn = new JButton("", GuiUtils.getImageIcon("/auxdata/ui/icons/folder_go.png"));
        goToBtn.setContentAreaFilled(false);
        goToBtn.setMargin(new Insets(1, 1, 1, 1));
        goToBtn.setToolTipText("Show history menu");
        goToBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FileManager.showGoToMenu(goToBtn, fileChooser);
            }
        });
        if (!includeLabel) {
            return goToBtn;
        }
        return goToBtn;
    }

    static {
        NULL_FILTERS = null;
        NULL_SUFFIX = null;
        NULL_ACCESSORY = null;
        FILTER_XML = new PatternFileFilter(".+\\.xml", "eXtensible Markup Language (XML) files (*.xml)", SUFFIX_XML);
        FILTER_NETCDF = new PatternFileFilter(".+\\.nc", "netCDF files (*.nc)", SUFFIX_NETCDF);
        FILTER_CSV = new PatternFileFilter(".+\\.csv", "Comma-Separated Values (CSV) files (*.csv)", SUFFIX_CSV);
        FILTER_TXT = new PatternFileFilter(".+\\.txt", "Text Files (*.txt)", SUFFIX_TXT);
        FILTER_XLS = new PatternFileFilter(".+\\.xls", "Microsoft Excel files", SUFFIX_XLS);
        FILTER_KML = new PatternFileFilter(".+\\.kml", "Google Earth files", SUFFIX_KML);
        FILTER_JAR = new PatternFileFilter("(.+\\.jar$)", "Jar Files (*.jar)", SUFFIX_JAR);
        FILTER_JPG = new PatternFileFilter(".+\\.jpg", "JPEG files (*.jpg)", SUFFIX_JPG);
        FILTER_IMAGE = new PatternFileFilter(".+\\.jpg|.+\\.gif|.+\\.jpeg|.+\\.png", "Image files (*.jpg,*.gif,*.png)");
        FILTER_IMAGEWRITE = new PatternFileFilter(".+\\.jpg|.+\\.jpeg|.+\\.png", "Image files (*.jpg,*.png)");
        FILTER_IMAGE_OR_PDF = new PatternFileFilter(".+\\.jpg|.+\\.jpeg|.+\\.png|\\.pdf", "Image files (*.jpg,*.png) or PDF (*.pdf)");
        FILTER_MOV = new PatternFileFilter(".+\\.mov", "QuickTime files (*.mov)", SUFFIX_MOV);
        FILTER_AVI = new PatternFileFilter(".+\\.avi", "AVI files (*.avi)", SUFFIX_AVI);
        FILTER_ANIMATEDGIF = new PatternFileFilter(".+\\.gif", "Animated GIF (*.gif)", SUFFIX_GIF);
        FILTER_ZIP = new PatternFileFilter(".+\\.zip", "Compressed ZIP (*.zip)", SUFFIX_ZIP);
        FILTER_LOG = new PatternFileFilter(".+\\.log", "Log files (*.log)");
        FILTER_KMZ = new PatternFileFilter(".+\\.kmz", "Google Earth KMZ Files (*.kmz)", SUFFIX_KMZ);
        NULL_STRING = null;
        NULL_BTNTEXT = null;
        NULL_TITLE = null;
    }

    public static class MyFileChooser
    extends JFileChooser {
        public MyFileChooser(File dir) {
            super(dir);
        }

        public MyFileChooser(String path) {
            super(path);
        }

        public MyFileChooser() {
        }

        @Override
        public void updateUI() {
            if (fixFileLockup) {
                this.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
            }
            super.updateUI();
        }
    }

    private class FileSystemRoot
    extends File {
        public FileSystemRoot(File f) {
            super(f, "");
        }

        public FileSystemRoot(String s) {
            super(s);
        }

        @Override
        public boolean isDirectory() {
            return true;
        }
    }

    private class WindowsAltFileSystemView
    extends FileSystemView {
        private WindowsAltFileSystemView() {
        }

        @Override
        public boolean isRoot(File f) {
            if (!f.isAbsolute()) {
                return false;
            }
            String parentPath = f.getParent();
            if (parentPath == null) {
                return true;
            }
            File parent = new File(parentPath);
            return parent.equals(f);
        }

        @Override
        public File createNewFolder(File containingDir) throws IOException {
            if (containingDir == null) {
                throw new IOException("Containing directory is null:");
            }
            File newFolder = null;
            newFolder = this.createFileObject(containingDir, "New Folder");
            for (int i = 2; newFolder.exists() && i < 100; ++i) {
                newFolder = this.createFileObject(containingDir, "New Folder (" + i + ")");
            }
            if (newFolder.exists()) {
                throw new IOException("Directory already exists:" + newFolder.getAbsolutePath());
            }
            newFolder.mkdirs();
            return newFolder;
        }

        @Override
        public boolean isHiddenFile(File f) {
            return false;
        }

        @Override
        public File[] getRoots() {
            Vector<FileSystemRoot> rootsVector = new Vector<FileSystemRoot>();
            System.out.println(" getRoots ");
            FileSystemRoot floppy = new FileSystemRoot("A:\\");
            rootsVector.addElement(floppy);
            for (char c = 'C'; c <= 'Z'; c = (char)((char)(c + 1))) {
                char[] device = new char[]{c, ':', '\\'};
                String deviceName = new String(device);
                System.out.println(" try ");
                System.out.println(" " + deviceName);
                FileSystemRoot deviceFile = new FileSystemRoot(deviceName);
                boolean ok = deviceFile.exists();
                System.out.println(" " + ok);
                if (deviceFile == null || !deviceFile.exists()) continue;
                rootsVector.addElement(deviceFile);
                System.out.println(" use " + deviceName);
            }
            Object[] roots = new File[rootsVector.size()];
            rootsVector.copyInto(roots);
            return roots;
        }
    }

    public static class NetcdfExtFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return file.isDirectory() || name.endsWith(FileManager.SUFFIX_NETCDF) || name.endsWith(".cdf");
        }

        @Override
        public String getDescription() {
            return "netcdf";
        }
    }

    public static class ExtFilter
    extends FileFilter {
        String file_extension;
        String desc;

        public ExtFilter(String file_extension, String desc) {
            this.file_extension = file_extension;
            this.desc = desc;
        }

        @Override
        public boolean accept(File file) {
            if (null == this.file_extension) {
                return true;
            }
            String name = file.getName();
            return file.isDirectory() || name.endsWith(this.file_extension);
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }
}

