/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

public class Defaults {
    private static Defaults defaults = null;
    private static Properties props;
    private static URL defaultsFile;

    private Defaults(URL defaultsFile) {
        Defaults.defaultsFile = defaultsFile;
        props = null;
        props = new Properties();
        try {
            props.load(new BufferedInputStream(defaultsFile.openStream()));
        }
        catch (IOException e) {
            System.err.println("loadDefaults: " + e);
        }
    }

    public static Defaults getInstance() throws Exception {
        if (defaults == null) {
            throw new Exception("Defaults not initialized. Must use intialize method first");
        }
        return defaults;
    }

    public static Defaults initialize(URL defaultsFile) {
        defaults = new Defaults(defaultsFile);
        return defaults;
    }

    public static Defaults initialize(String defaultsFile) {
        URL defaultURL = Defaults.class.getResource(defaultsFile);
        defaults = new Defaults(defaultURL);
        return defaults;
    }

    public static Defaults reset() {
        return Defaults.initialize(defaultsFile);
    }

    public static String getDefault(String key) {
        return props.getProperty(key);
    }

    public static String getDefault(String key, String defaultValue) {
        return props.getProperty(key, defaultValue);
    }

    public static void putDefault(String key, String value) {
        props.put(key, value);
    }

    public void printProperties() {
        props.list(System.out);
    }

    static {
        defaultsFile = null;
    }
}

