/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.util.PersistentStore;

public class Debug {
    private static final String STORE_NAME = "DebugFlags";
    private static TreeMap map = new TreeMap();
    private static boolean debug = false;
    private static boolean changed = true;

    public static void fetchPersistentData(PersistentStore store) {
        Object o = store.get(STORE_NAME);
        if (o != null) {
            map = (TreeMap)o;
            changed = true;
        }
    }

    public static void storePersistentData(PersistentStore store) {
        store.put(STORE_NAME, map);
    }

    public static boolean isSet(String flagName) {
        Object val = map.get(flagName);
        if (null == val) {
            if (debug) {
                System.out.println("Debug.isSet new " + flagName);
            }
            map.put(flagName, new Boolean(false));
            changed = true;
            return false;
        }
        return (Boolean)val;
    }

    public static void set(String flagName, boolean value) {
        Object val = map.get(flagName);
        if (null == val) {
            changed = true;
        }
        map.put(flagName, new Boolean(value));
    }

    public static void clear() {
        map = new TreeMap();
    }

    public static void constructMenu(JMenu topMenu) {
        Set keySet;
        if (debug) {
            System.out.println("Debug.constructMenu " + changed);
        }
        if (!changed) {
            return;
        }
        changed = false;
        if (topMenu.getItemCount() > 0) {
            topMenu.removeAll();
        }
        if (null == (keySet = map.keySet())) {
            return;
        }
        ArrayList list = new ArrayList(keySet);
        Collections.sort(list);
        for (Object key : list) {
            String name = (String)key;
            Object val = map.get(key);
            boolean bval = (Boolean)val;
            Debug.addDebugToMenu(topMenu, name, name, bval);
            if (!debug) continue;
            System.out.println("Debug.constructMenu " + name);
        }
        topMenu.revalidate();
    }

    private static void addDebugToMenu(JMenu menu, String fullname, String name, boolean bval) {
        int pos = name.indexOf(46);
        if (pos >= 0) {
            String branchName = name.substring(0, pos);
            String leafName = name.substring(pos + 1);
            JMenu branch = Debug.findMenu(menu, branchName);
            if (null == branch) {
                branch = new JMenu(branchName);
                menu.add(branch);
            }
            Debug.addDebugToMenu(branch, fullname, leafName, bval);
        } else {
            menu.add(new DebugMenuItem(fullname, name, bval));
        }
    }

    private static JMenu findMenu(JMenu menu, String name) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenu m;
            JMenuItem item = menu.getItem(i);
            if (!(item instanceof JMenu) || !name.equals((m = (JMenu)item).getText())) continue;
            return m;
        }
        return null;
    }

    private static class DebugMenuItem
    extends JCheckBoxMenuItem {
        private String fullname;

        DebugMenuItem(String foolName, String menuName, boolean val) {
            super(menuName, val);
            this.fullname = foolName;
            this.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    map.put(fullname, new Boolean(this.getState()));
                }
            });
        }
    }
}

